function formatCurrency(amount) {
	var i = parseFloat(amount);
	if(isNaN(i)) {
		i = 0.00;
	}
	var minus = '';
	if(i < 0) {
		minus = '-';
	}
	i = Math.abs(i);
	i = parseInt((i + .005) * 100);
	i = i / 100;
	s = new String(i);
	if(s.indexOf('.') < 0) {
		s += '.00';
	}
	if(s.indexOf('.') == (s.length - 2)) {
		s += '0';
	}
	s = minus + s;
	return s;
}

function findHypot(sidea, sideb) {
	return (Math.sqrt(((sidea * 1) * (sidea * 1)) + ((sideb * 1) * (sideb * 1))));
}

function isNumber(v) {
	if(isNaN(v.val()) || v == null || v.val() == EMPTY) {
		return false;
	} else {
		return true;
	}
}

function convertDecimalFeetToFraction(dec){
	var wholeft = Math.floor(dec);
	var d = (dec % 1)*12;
	return wholeft + "\' " + convertDecimalInchToFraction(d);
}

function convertDecimalInchToFraction(dec) {
	var whole = Math.floor(dec);
	var d = dec % 1;
	var frac = null;

	if(d >= 0 && d < .03125) {
		frac = "";
	} else if(d >= .03125 && d < .09375) {
		frac = "-1/16";
	} else if(d >= .09375 && d < .15625) {
		frac = "-1/8";
	} else if(d >= .15625 && d < .21875) {
		frac = "-3/16";
	} else if(d >= .21875 && d < .28125) {
		frac = "-1/4";
	} else if(d >= .28125 && d < .34375) {
		frac = "-5/16";
	} else if(d >= .34375 && d < .40625) {
		frac = "-3/8";
	} else if(d >= .40625 && d < .46875) {
		frac = "-7/16";
	} else if(d >= .46875 && d < .53125) {
		frac = "-1/2";
	} else if(d >= .53125 && d < .59375) {
		frac = "-9/16";
	} else if(d >= .59375 && d < .65625) {
		frac = "-5/8";
	} else if(d >= .65625 && d < .71875) {
		frac = "-11/16";
	} else if(d >= .71875 && d < .78125) {
		frac = "-3/4";
	} else if(d >= .78125 && d < .84375) {
		frac = "-13/16";
	} else if(d >= .84375 && d < .90625) {
		frac = "-7/8";
	} else if(d >= .90625 && d < .96875) {
		frac = "-15/16";
	} else if(d >= .96875) {
		frac = "";
		whole = ((whole * 1) + (1 * 1));
	}
	return whole + frac + "\"";

}

function isInt(value){ 
  if((parseFloat(value) == parseInt(value)) && !isNaN(value)){
      return true;
  } else { 
      return false;
  } 
}