			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var widthVar = null;
			var widthInchVar = null;
			var widthFracVar = null;
			var lengthVar = null;
			var lengthInchVar = null;
			var lengthFracVar = null;
			var panelsVar = null;
			var costVar = null;
			var whatVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";
			
				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					widthVar = $('#width');
					widthInchVar = $('#widthinch');
					widthFracVar = $('#widthfrac');
					lengthVar = $('#length');
					lengthInchVar = $('#lengthinch');
					lengthFracVar = $('#lengthfrac');
					whatVar = $('#what');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					widthVar.Watermark("Feet");
					widthInchVar.Watermark("Inches");
					lengthVar.Watermark("Feet");
					lengthInchVar.Watermark("Inches");
					hideContentDialog();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content

					removeError();

					// Perform form validation
					if(widthVar == null || widthVar.val() == EMPTY || widthVar.val() == 'Feet') {
						widthVar.val(0);
					} else {
						if(isNaN(widthVar.val())) {
							$('#widthLabel').addClass(MISSING);
							err = true;
						}
					}
					if((widthInchVar == null) || (widthInchVar.val() == EMPTY) || widthInchVar.val() == 'Inches') {
						widthInchVar.val(0);
						//do nothing
					} else {
						if(isNaN(widthInchVar.val())) {
							$('#widthLabel').addClass(MISSING);
							err = true;
						}
					}

					if(lengthVar == null || lengthVar.val() == EMPTY || lengthVar.val() == 'Feet') {
						lengthVar.val(0);
					} else {
						if(isNaN(lengthVar.val())) {
							$('#lengthLabel').addClass(MISSING);
							err = true;
						}
					}
					if((lengthInchVar == null) || (lengthInchVar.val() == EMPTY) || lengthInchVar.val() == 'Inches') {
						lengthInchVar.val(0);
						//do nothing
					} else {
						if(isNaN(lengthInchVar.val())) {
							$('#lengthLabel').addClass(MISSING);
							err = true;
						}
					}

					if(isNaN(widthVar.val() + widthInchVar.val())) {
						err = true;
						$('#widthLabel').addClass(MISSING);
					}

					if(isNaN(lengthVar.val() + lengthInchVar.val())) {
						err = true;
						$('#lengthLabel').addClass(MISSING);
					}

					// If validation fails, show Dialog content
					if(err == true) {
						hideMain();
						showContentDialog();
						return false;
					}

					var width = widthVar.val() * 1;
					if(!isNaN(widthInchVar.val())) {
						width += (((widthInchVar.val() * 1) + ($('#widthfrac option:selected').val() * 1)) / 12);
					}
					
					var length = lengthVar.val() * 1;
					if(!isNaN(lengthInchVar.val())) {
						length += (((lengthInchVar.val() * 1) + ($('#lengthfrac option:selected').val() * 1)) / 12);
					}
					
					var hypot = findHypot(length, width);

					$('#answerUL').html("<li>Diagonal:  <span class='answer'>" + convertDecimalFeetToFraction(hypot) + "</span></li>");

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					$('#widthLabel').removeClass(MISSING);
					$('#lengthLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}