			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var heightFtVar = null;
			var heightInVar = null;
			var heightFracVar = null;
			var riseInVar = null;
			var riseFracVar = null;
			var treadInVar = null;
			var treadFracVar = null;
			var angleVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";

			
							$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					heightFtVar = $('#heightft');
					heightInVar = $('#heightin');
					heightFracVar = $('#heightfrac');
					riseInVar = $('#risein');
					riseFracVar = $('#risefrac');
					treadInVar = $('#treadin');
					treadFracVar = $('#treadfrac');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					heightFtVar.Watermark("Feet");
					heightInVar.Watermark("Inches");
					treadInVar.Watermark("Inches");
					riseInVar.Watermark("Inches");
					$('#heightLabel').removeClass('required');
					$('#runLabel').addClass('required');
					$('#angleLabel').addClass('required');

					hideContentDialog();
					//hideContentTransition();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content
					removeError();

					if((isNaN(heightFtVar.val()) && heightFtVar.val() != 'Feet') || (isNaN(heightInVar.val()) && heightInVar.val() != 'Inches')) {
						hideMain();
						showContentDialog();
						return false;
					}
					if(heightFtVar.val() == "Feet") {
						heightFtVar.val(0);
					}
					if(heightInVar.val() == "Inches") {
						heightInVar.val(0);
					}
					if(riseInVar.val() == "Inches") {
						riseInVar.val(0);
					}
					if(treadInVar.val() == "Inches") {
						treadInVar.val(0);
					}

					var totalHeight = ((((heightFtVar.val() * 1)*12) + ((heightInVar.val() * 1) + ($('#heightfrac option:selected').val() * 1))));

					var totalRisers = Math.ceil((totalHeight * 1) / (((riseInVar.val() * 1) + ($('#risefrac option:selected').val() * 1))));


					var riserHeight = (totalHeight * 1) / (totalRisers * 1);
					var treadRun = (treadInVar.val() * 1) + ($('#treadfrac option:selected').val() * 1);
					var totalTreads = (totalRisers * 1) - 1;
					var totalRun = ((treadRun * 1) * (totalTreads * 1));


					var brdLength = findHypot(totalHeight, totalRun);
					var angle = (Math.atan(totalHeight / totalRun) * (180 / Math.PI));

					var a = "<li>Riser height - <span class='answer'>" + convertDecimalInchToFraction(riserHeight) + "</span></li>";
					a += "<li>Total Risers - <span class='answer'>" + formatCurrency(totalRisers) + "</span></li>";
					a += "<li>Tread Run - <span class='answer'>" + convertDecimalInchToFraction(treadRun) + "</span></li>";
					a += "<li>Total Treads - <span class='answer'>" + formatCurrency(totalTreads) + "</span></li>";
					a += "<li>Total Run - <span class='answer'>" + convertDecimalFeetToFraction(totalRun / 12) + "</span></li>";
					a += "<li>Stringer Board Length - <span class='answer'>" + convertDecimalFeetToFraction((brdLength / 12) * 1.025) + "</span></li>";
					a += "<li>Angle - <span class='answer'>" + formatCurrency(angle) + "</span></li>";
					$('#answerUL').html(a);

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {/*
					 $('#heightLabel').removeClass(MISSING);
					 $('#widthLabel').removeClass(MISSING);
					 $('#costLabel').removeClass(MISSING);
					 */
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}