			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var widthFtVar = null;
			var widthInVar = null;
			var widthFracVar = null;
			var lengthFtVar = null;
			var lengthInVar = null;
			var lengthFracVar = null;
			var tilewidthInVar = null;
			var tilewidthFracVar = null;
			var tileLengthInVar = null;
			var tileLengthFracVar = null;
			var wasteVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";

				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					widthFtVar = $('#widthft');
					widthInVar = $('#widthin');
					widthFracVar = $('#widthfrac');
					lengthFtVar = $('#lengthft');
					lengthInVar = $('#lengthin');
					lengthFracVar = $('#lengthfrac');
					tilewidthInVar = $('#tilewidthin');
					tilewidthFracVar = $('#tilewidthfrac');
					tileLengthInVar = $('#tileLengthin');
					tileLengthFracVar = $('#tileLengthfrac');
					wasteVar = $('#waste');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					widthFtVar.Watermark("Feet");
					widthInVar.Watermark("Inches");
					lengthFtVar.Watermark("Feet");
					lengthInVar.Watermark("Inches");
					tilewidthInVar.Watermark("Inches");
					tileLengthInVar.Watermark("Inches");

					hideContentDialog();
					//hideContentTransition();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content
					removeError();

					if((isNaN(widthFtVar.val()) && widthFtVar.val() != 'Feet') || (isNaN(widthInVar.val()) && widthInVar.val() != 'Inches')) {
						$('#widthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(widthFtVar.val() == "Feet") {
						widthFtVar.val(0);
					}
					if(widthInVar.val() == "Inches") {
						widthInVar.val(0);
					}
					if((isNaN(lengthFtVar.val()) && lengthFtVar.val() != 'Feet') || (isNaN(lengthInVar.val()) && lengthInVar.val() != 'Inches')) {
						$('#lengthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(lengthFtVar.val() == "Feet") {
						lengthFtVar.val(0);
					}
					if(lengthInVar.val() == "Inches") {
						lengthInVar.val(0);
					}

					if((isNaN(tilewidthInVar.val()) && tilewidthInVar.val() != 'Inches')) {
						$('#tilewidthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(tilewidthInVar.val() == "Inches") {
						tilewidthInVar.val(0);
					}
					if((isNaN(tileLengthInVar.val()) && tileLengthInVar.val() != 'Inches')) {
						$('#tileLengthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(tileLengthInVar.val() == "Inches") {
						tileLengthInVar.val(0);
					}
					if(isNaN(wasteVar.val())) {
						wasteVar.val(0);
					}

					var width = (((widthFtVar.val() * 1) + (((widthInVar.val() * 1) + ($('#widthfrac option:selected').val() * 1)) / 12)));
					var length = (((lengthFtVar.val() * 1) + (((lengthInVar.val() * 1) + ($('#lengthfrac option:selected').val() * 1)) / 12)));
					var tilewidth = (((((tilewidthInVar.val() * 1) + ($('#tilewidthfrac option:selected').val() * 1)) / 12)));
					var tileLength = (((((tileLengthInVar.val() * 1) + ($('#tileLengthfrac option:selected').val() * 1)) / 12)));
					var waste = wasteVar.val();

					var area = width * length;
					var areaWaste = 0;
					if(waste != 0){
						areaWaste = area * (1 + (waste/100));
					}else{
						areaWaste = area;
					}
					
					var tileArea = tilewidth * tileLength;
					
					var tilesRequired = Math.ceil(areaWaste/tileArea);
					
					var a = "<li>Tiles Required - <span class='answer'>" + Math.ceil(tilesRequired) + "</span></li>";
					
					$('#answerUL').html(a);

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					 $('#widthLabel').removeClass(MISSING);
					 $('#lengthLabel').removeClass(MISSING);
					 $('#tilewidthLabel').removeClass(MISSING);
					 $('#tileLengthLabel').removeClass(MISSING);
					 $('#wasteLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}