var inputContext = null;
var keyboardElement;
var specialKeys = {
    'shift': KeyEvent.DOM_VK_CAPS_LOCK,
    'backspace': KeyEvent.DOM_VK_BACK_SPACE,
    'space': KeyboardEvent.DOM_VK_SPACE,
    'return': KeyEvent.DOM_VK_RETURN,
    'layoutChange': 'layoutChange'
};
var shiftState = 0;
function init() {
    keyboardElement = document.getElementById('keyboard-container');

    window.navigator.mozInputMethod.oninputcontextchange = function () {
        inputContext = navigator.mozInputMethod.inputcontext;
        resizeWindow();
    };

    window.addEventListener('resize', resizeWindow);

    keyboardElement.addEventListener('mousedown', function onMouseDown(evt) {
        // Prevent losing focus to the currently focused app
        // Otherwise, right after mousedown event, the app will receive a focus event.
        evt.preventDefault();
    });

    var keys = document.getElementsByClassName('key');
    for (var i in keys) {
        var key = keys[i];
        if (key.hasOwnProperty('dataset') && key.dataset.hasOwnProperty('functionKey')) {
            continue;
        }

        key.addEventListener('touchstart', function () {
            this.classList.add('touched');
        });
        key.addEventListener('touchend', function () {

            if (this.dataset.hasOwnProperty("specialId")) {
                console.log(specialKeys);
                var specialId = this.dataset.specialId;
                handleKey(specialKeys[specialId]);
            } else {
                var str = this.innerHTML;
                if(shiftState > 0){
                    str = str.toUpperCase();
                }
                for (var i = 0; i < str.length; i++) {
                    handleKey(str.charCodeAt(i));
                }
            }
            this.classList.remove('touched');
        });
    }

    var switchElement = keyboardElement.getElementById('switchLayout');
    switchElement.removeEventListener("click");
    switchElement.addEventListener('click', function switchHandler() {
        var mgmt = navigator.mozInputMethod.mgmt;
        mgmt.next();
    });

    // TODO: finish the long press for triggering the IME menu
    var menuTimeout = 0;
    switchElement.addEventListener('touchstart', function longHandler() {
        menuTimeout = window.setTimeout(function menuTimeout() {
            var mgmt = navigator.mozInputMethod.mgmt;
            mgmt.showAll();
        }, 700);
    });

    switchElement.addEventListener('touchend', function longHandler() {
        clearTimeout(menuTimeout);
    });
}

function resizeWindow() {
    window.resizeTo(window.innerWidth, keyboardElement.clientHeight);
}

function handleKey(keyCode) {
    var page = document.getElementsByClassName('page')[0];


    switch (keyCode) {
        case 'layoutChange':
            var mgmt = navigator.mozInputMethod.mgmt;
            mgmt.next();
            break;
        case KeyEvent.DOM_VK_CAPS_LOCK:
            console.log(shiftState);
            shiftState++;// = (shiftState + 1) % 3; // TODO: fix this so it has Caps
            if (shiftState == 1) { // Shift
                page.classList.add('shifted');
            }else if(shiftState == 2){ // Caps
                page.classList.add('shifted');
            } else {
                page.classList.remove('shifted');
                shiftState = 0;
            }
            break;
        case KeyEvent.DOM_VK_BACK_SPACE:
        case KeyEvent.DOM_VK_RETURN:
            if (shiftState == 1) {
                page.classList.remove('shifted');
                shiftState = 0;
            }
            if (inputContext) {
                inputContext.sendKey(keyCode, 0, 0);
            }
            break;

        default:
            if (shiftState == 1) {
                page.classList.remove('shifted');
                shiftState = 0;
            }
            if (inputContext) {
                inputContext.sendKey(0, keyCode, 0);
            }
            break;
    }
}

// window.addEventListener('load', init);


// DOMContentLoaded is fired once the document has been loaded and parsed,
// but without waiting for other external resources to load (css/images/etc)
// That makes the app more responsive and perceived as faster.
// https://developer.mozilla.org/Web/Reference/Events/DOMContentLoaded
window.addEventListener('DOMContentLoaded', function () {

    // We'll ask the browser to use strict code to help us catch errors earlier.
    // https://developer.mozilla.org/Web/JavaScript/Reference/Functions_and_function_scope/Strict_mode
    'use strict';

    init();

});
