/*
 IDBWrapper - A cross-browser wrapper for IndexedDB
 Copyright (c) 2011 - 2015 Jens Arps
 http://jensarps.de/

 Licensed under the MIT (X11) license
*/
(function(h,i,l){"function"===typeof define?define(i):"undefined"!==typeof module&&module.exports?module.exports=i():l[h]=i()})("IDBStore",function(){var h=function(a){throw a;},i=function(){},l={storeName:"Store",storePrefix:"IDBWrapper-",dbVersion:1,keyPath:"id",autoIncrement:!0,onStoreReady:function(){},onError:h,indexes:[]},j=function(a,c){"undefined"==typeof c&&"function"==typeof a&&(c=a);"[object Object]"!=Object.prototype.toString.call(a)&&(a={});for(var b in l)this[b]="undefined"!=typeof a[b]?
a[b]:l[b];this.dbName=this.storePrefix+this.storeName;this.dbVersion=parseInt(this.dbVersion,10)||1;c&&(this.onStoreReady=c);b="object"==typeof window?window:self;this.idb=b.indexedDB||b.webkitIndexedDB||b.mozIndexedDB||b.shimIndexedDB;this.keyRange=b.IDBKeyRange||b.webkitIDBKeyRange||b.mozIDBKeyRange;this.features={hasAutoIncrement:!b.mozIndexedDB};this.consts={READ_ONLY:"readonly",READ_WRITE:"readwrite",VERSION_CHANGE:"versionchange",NEXT:"next",NEXT_NO_DUPLICATE:"nextunique",PREV:"prev",PREV_NO_DUPLICATE:"prevunique"};
this.openDB()};j.prototype={constructor:j,version:"1.5",db:null,dbName:null,dbVersion:null,store:null,storeName:null,storePrefix:null,keyPath:null,autoIncrement:null,indexes:null,features:null,onStoreReady:null,onError:null,_insertIdCount:0,openDB:function(){var a=this.idb.open(this.dbName,this.dbVersion),c=!1;a.onerror=function(b){var a=!1;"error"in b.target?a="VersionError"==b.target.error.name:"errorCode"in b.target&&(a=12==b.target.errorCode);if(a)this.onError(Error("The version number provided is lower than the existing one."));
else this.onError(b)}.bind(this);a.onsuccess=function(b){if(!c)if(this.db)this.onStoreReady();else if(this.db=b.target.result,"string"==typeof this.db.version)this.onError(Error("The IndexedDB implementation in this browser is outdated. Please upgrade your browser."));else if(this.db.objectStoreNames.contains(this.storeName)){this.store=this.db.transaction([this.storeName],this.consts.READ_ONLY).objectStore(this.storeName);var a=Array.prototype.slice.call(this.getIndexList());this.indexes.forEach(function(b){var f=
b.name;f?(this.normalizeIndexData(b),this.hasIndex(f)?(this.indexComplies(this.store.index(f),b)||(c=!0,this.onError(Error('Cannot modify index "'+f+'" for current version. Please bump version number to '+(this.dbVersion+1)+"."))),a.splice(a.indexOf(f),1)):(c=!0,this.onError(Error('Cannot create new index "'+f+'" for current version. Please bump version number to '+(this.dbVersion+1)+".")))):(c=!0,this.onError(Error("Cannot create index: No index name given.")))},this);a.length&&(c=!0,this.onError(Error('Cannot delete index(es) "'+
a.toString()+'" for current version. Please bump version number to '+(this.dbVersion+1)+".")));c||this.onStoreReady()}else this.onError(Error("Something is wrong with the IndexedDB implementation in this browser. Please upgrade your browser."))}.bind(this);a.onupgradeneeded=function(a){this.db=a.target.result;if(this.db.objectStoreNames.contains(this.storeName))this.store=a.target.transaction.objectStore(this.storeName);else{a={autoIncrement:this.autoIncrement};if(null!==this.keyPath)a.keyPath=this.keyPath;
this.store=this.db.createObjectStore(this.storeName,a)}var d=Array.prototype.slice.call(this.getIndexList());this.indexes.forEach(function(a){var b=a.name;b||(c=!0,this.onError(Error("Cannot create index: No index name given.")));this.normalizeIndexData(a);this.hasIndex(b)?(this.indexComplies(this.store.index(b),a)||(this.store.deleteIndex(b),this.store.createIndex(b,a.keyPath,{unique:a.unique,multiEntry:a.multiEntry})),d.splice(d.indexOf(b),1)):this.store.createIndex(b,a.keyPath,{unique:a.unique,
multiEntry:a.multiEntry})},this);d.length&&d.forEach(function(a){this.store.deleteIndex(a)},this)}.bind(this)},deleteDatabase:function(a,c){if(this.idb.deleteDatabase){this.db.close();var b=this.idb.deleteDatabase(this.dbName);b.onsuccess=a;b.onerror=c}else c(Error("Browser does not support IndexedDB deleteDatabase!"))},put:function(a,c,b,d){null!==this.keyPath&&(d=b,b=c,c=a);d||(d=h);b||(b=i);var e=!1,f=null,g=this.db.transaction([this.storeName],this.consts.READ_WRITE);g.oncomplete=function(){(e?
b:d)(f)};g.onabort=d;g.onerror=d;null!==this.keyPath?(this._addIdPropertyIfNeeded(c),a=g.objectStore(this.storeName).put(c)):a=g.objectStore(this.storeName).put(c,a);a.onsuccess=function(a){e=!0;f=a.target.result};a.onerror=d;return g},get:function(a,c,b){b||(b=h);c||(c=i);var d=!1,e=null,f=this.db.transaction([this.storeName],this.consts.READ_ONLY);f.oncomplete=function(){(d?c:b)(e)};f.onabort=b;f.onerror=b;a=f.objectStore(this.storeName).get(a);a.onsuccess=function(a){d=!0;e=a.target.result};a.onerror=
b;return f},remove:function(a,c,b){b||(b=h);c||(c=i);var d=!1,e=null,f=this.db.transaction([this.storeName],this.consts.READ_WRITE);f.oncomplete=function(){(d?c:b)(e)};f.onabort=b;f.onerror=b;a=f.objectStore(this.storeName)["delete"](a);a.onsuccess=function(a){d=!0;e=a.target.result};a.onerror=b;return f},batch:function(a,c,b){b||(b=h);c||(c=i);if("[object Array]"!=Object.prototype.toString.call(a))b(Error("dataArray argument must be of type Array."));else if(0===a.length)return c(!0);var d=this.db.transaction([this.storeName],
this.consts.READ_WRITE);d.oncomplete=function(){(g?c:b)(g)};d.onabort=b;d.onerror=b;var e=a.length,f=!1,g=!1,k=function(){e--;0===e&&!f&&(g=f=!0)};a.forEach(function(a){var c=a.type,e=a.key,g=a.value,a=function(a){d.abort();f||(f=!0,b(a,c,e))};if("remove"==c)g=d.objectStore(this.storeName)["delete"](e),g.onsuccess=k,g.onerror=a;else if("put"==c)null!==this.keyPath?(this._addIdPropertyIfNeeded(g),g=d.objectStore(this.storeName).put(g)):g=d.objectStore(this.storeName).put(g,e),g.onsuccess=k,g.onerror=
a},this);return d},putBatch:function(a,c,b){return this.batch(a.map(function(a){return{type:"put",value:a}}),c,b)},upsertBatch:function(a,c,b,d){"function"==typeof c&&(d=b=c,c={});d||(d=h);b||(b=i);c||(c={});"[object Array]"!=Object.prototype.toString.call(a)&&d(Error("dataArray argument must be of type Array."));var e=this.db.transaction([this.storeName],this.consts.READ_WRITE);e.oncomplete=function(){m?b(a):d(!1)};e.onabort=d;e.onerror=d;var f=c.keyField||this.keyPath,g=a.length,k=!1,m=!1,j=0,o=
function(b){a[j++][f]=b.target.result;g--;0===g&&!k&&(m=k=!0)};a.forEach(function(a){var b=a.key;null!==this.keyPath?(this._addIdPropertyIfNeeded(a),a=e.objectStore(this.storeName).put(a)):a=e.objectStore(this.storeName).put(a,b);a.onsuccess=o;a.onerror=function(a){e.abort();k||(k=!0,d(a))}},this);return e},removeBatch:function(a,c,b){return this.batch(a.map(function(a){return{type:"remove",key:a}}),c,b)},getBatch:function(a,c,b,d){b||(b=h);c||(c=i);d||(d="sparse");if("[object Array]"!=Object.prototype.toString.call(a))b(Error("keyArray argument must be of type Array."));
else if(0===a.length)return c([]);var e=this.db.transaction([this.storeName],this.consts.READ_ONLY);e.oncomplete=function(){(k?c:b)(j)};e.onabort=b;e.onerror=b;var f=[],g=a.length,k=!1,j=null,l=function(a){a.target.result||"dense"==d?f.push(a.target.result):"sparse"==d&&f.length++;g--;0===g&&(k=!0,j=f)};a.forEach(function(a){a=e.objectStore(this.storeName).get(a);a.onsuccess=l;a.onerror=function(a){j=a;b(a);e.abort()}},this);return e},getAll:function(a,c){c||(c=h);a||(a=i);var b=this.db.transaction([this.storeName],
this.consts.READ_ONLY),d=b.objectStore(this.storeName);d.getAll?this._getAllNative(b,d,a,c):this._getAllCursor(b,d,a,c);return b},_getAllNative:function(a,c,b,d){var e=!1,f=null;a.oncomplete=function(){(e?b:d)(f)};a.onabort=d;a.onerror=d;a=c.getAll();a.onsuccess=function(a){e=!0;f=a.target.result};a.onerror=d},_getAllCursor:function(a,c,b,d){var e=[],f=!1,g=null;a.oncomplete=function(){(f?b:d)(g)};a.onabort=d;a.onerror=d;a=c.openCursor();a.onsuccess=function(a){(a=a.target.result)?(e.push(a.value),
a["continue"]()):(f=!0,g=e)};a.onError=d},clear:function(a,c){c||(c=h);a||(a=i);var b=!1,d=null,e=this.db.transaction([this.storeName],this.consts.READ_WRITE);e.oncomplete=function(){(b?a:c)(d)};e.onabort=c;e.onerror=c;var f=e.objectStore(this.storeName).clear();f.onsuccess=function(a){b=!0;d=a.target.result};f.onerror=c;return e},_addIdPropertyIfNeeded:function(a){!this.features.hasAutoIncrement&&"undefined"==typeof a[this.keyPath]&&(a[this.keyPath]=this._insertIdCount++ +Date.now())},getIndexList:function(){return this.store.indexNames},
hasIndex:function(a){return this.store.indexNames.contains(a)},normalizeIndexData:function(a){a.keyPath=a.keyPath||a.name;a.unique=!!a.unique;a.multiEntry=!!a.multiEntry},indexComplies:function(a,c){return["keyPath","unique","multiEntry"].every(function(b){if("multiEntry"==b&&void 0===a[b]&&!1===c[b])return!0;if("keyPath"==b&&"[object Array]"==Object.prototype.toString.call(c[b])){var b=c.keyPath,d=a.keyPath;if("string"==typeof d)return b.toString()==d;if(!("function"==typeof d.contains||"function"==
typeof d.indexOf)||d.length!==b.length)return!1;for(var e=0,f=b.length;e<f;e++)if(!(d.contains&&d.contains(b[e])||d.indexOf(-1!==b[e])))return!1;return!0}return c[b]==a[b]})},iterate:function(a,c){var c=n({index:null,order:"ASC",autoContinue:!0,filterDuplicates:!1,keyRange:null,writeAccess:!1,onEnd:null,onError:h,limit:Infinity,offset:0},c||{}),b="desc"==c.order.toLowerCase()?"PREV":"NEXT";c.filterDuplicates&&(b+="_NO_DUPLICATE");var d=!1,e=this.db.transaction([this.storeName],this.consts[c.writeAccess?
"READ_WRITE":"READ_ONLY"]),f=e.objectStore(this.storeName);c.index&&(f=f.index(c.index));var g=0;e.oncomplete=function(){if(d)if(c.onEnd)c.onEnd();else a(null);else c.onError(null)};e.onabort=c.onError;e.onerror=c.onError;b=f.openCursor(c.keyRange,this.consts[b]);b.onerror=c.onError;b.onsuccess=function(b){if(b=b.target.result)if(c.offset)b.advance(c.offset),c.offset=0;else{if(a(b.value,b,e),g++,c.autoContinue)if(g+c.offset<c.limit)b["continue"]();else d=!0}else d=!0};return e},query:function(a,c){var b=
[],c=c||{};c.autoContinue=!0;c.writeAccess=!1;c.onEnd=function(){a(b)};return this.iterate(function(a){b.push(a)},c)},count:function(a,c){var c=n({index:null,keyRange:null},c||{}),b=c.onError||h,d=!1,e=null,f=this.db.transaction([this.storeName],this.consts.READ_ONLY);f.oncomplete=function(){(d?a:b)(e)};f.onabort=b;f.onerror=b;var g=f.objectStore(this.storeName);c.index&&(g=g.index(c.index));g=g.count(c.keyRange);g.onsuccess=function(a){d=!0;e=a.target.result};g.onError=b;return f},makeKeyRange:function(a){var c=
"undefined"!=typeof a.lower,b="undefined"!=typeof a.upper,d="undefined"!=typeof a.only;switch(!0){case d:a=this.keyRange.only(a.only);break;case c&&b:a=this.keyRange.bound(a.lower,a.upper,a.excludeLower,a.excludeUpper);break;case c:a=this.keyRange.lowerBound(a.lower,a.excludeLower);break;case b:a=this.keyRange.upperBound(a.upper,a.excludeUpper);break;default:throw Error('Cannot create KeyRange. Provide one or both of "lower" or "upper" value, or an "only" value.');}return a}};var p={},n=function(a,
c){var b,d;for(b in c)d=c[b],d!==p[b]&&d!==a[b]&&(a[b]=d);return a};j.version=j.prototype.version;return j},this);
