$(document).ready(function(){
	
	var i;
	//Script da Splash Screen
	var cl = new CanvasLoader('div-loader');
	cl.setDensity(41); // default  40
	cl.setRange(1); // default  1.3
	cl.show(); // default  Hidden
	
	// Este bit  somente para posicionamento - No  necessrio
	var loaderObj = document.getElementById("canvasLoader");
	loaderObj.style.position = "absolute";
	loaderObj.style["top"] = cl.getDiameter() * -0.5 + "px";
	loaderObj.style["left"] = cl.getDiameter() * -0.5 + "px";
	
	$('#splash').ready(function(){
		setTimeout(function(){
			$.mobile.changePage("#inicio", "fade");
			$('#rodape-home').text("Danilo Alves 2013-" + new Date().getFullYear() + "  Todos os Direitos Reservados");
		}, 5000);
	});
	//Fim do Script da Splash Screen
	 
	//Tabs
	$("a[data-role=tab]").each(function () {
		var anchor = $(this);
		anchor.bind("click", function () {
			$.mobile.changePage(anchor.attr("href"), {
				transition: "none",
				changeHash: false
			});
			return false;
		});
	});
	   
	//Alternando Pginas
	$("#btnLinhas").click(function(){
		//Mudar para linhas-view
		$.mobile.changePage ($("#linhas"));
		carregaLinhas();
	});
	
	function carregaLinha(JSONObject){
		
		//Carrega JSON principal
		var json = $.parseJSON(JSONObject);
		
		carregaJSON_Horarios(json[0].linha, json[0].nome, json[0].saindo_bairro, "bairro");
		carregaItinerarios(json[0].saindo_bairro, "bairro");
		carregaJSON_Horarios(json[0].linha, json[0].nome, json[0].saindo_terminal, "terminal");
		carregaItinerarios(json[0].saindo_terminal, "terminal");
	}
	
	//Lendo JSON e carregando os horrios
	function carregaJSON_Horarios(linha, nome, json, tipo){
		
		document.getElementById("linha-header-" + tipo).innerHTML = linha + " - " + nome;
		document.getElementById("linha-title-" + tipo).innerHTML = nome;
		
		var container_dia_util = document.getElementById("horarios-dia-util-" + tipo);
		var container_sabado = document.getElementById("horarios-sabado-" + tipo);
		var container_domingo = document.getElementById("horarios-domingo-feriado-" + tipo);
		
		//Esconde todos os colapsible
		$("#colapsible-dia-util-" + tipo).hide();
		$("#colapsible-sabado-" + tipo).hide();
		$("#colapsible-domingo-feriado-" + tipo).hide();
		
		//joga o retorno para o elemento que vai exibi-lo
		if (json.horarios.dia_util != undefined){
			var hr_dia_util = json.horarios.dia_util.split("|");
			$("#colapsible-dia-util-" + tipo).show();
		}
		
		if (json.horarios.sabado != undefined){
			var hr_sabado = json.horarios.sabado.split("|");
			$("#colapsible-sabado-" + tipo).show();
		}
		
		if (json.horarios.domingo_feriado != undefined){
			var hr_domingo = json.horarios.domingo_feriado.split("|");
			$("#colapsible-domingo-feriado-" + tipo).show();
		}
		
		//Dia til
		container_dia_util.innerHTML = "";
		if(hr_dia_util != undefined){
			for(i = 0; i < hr_dia_util.length; i++){
				container_dia_util.innerHTML += "<label class='horarios-linha'>"+ hr_dia_util[i] + "<img src='images/simbolo_deficiente.png' width='18px'></img></label>";
			}
		}
		
		//Sabado
		container_sabado.innerHTML = "";		
		if(hr_sabado != undefined){
			for(i = 0; i < hr_sabado.length; i++){			
				container_sabado.innerHTML += "<label class='horarios-linha'>"+ hr_sabado[i] + "<img src='images/simbolo_deficiente.png' width='18px'></img></label>";
			}
		}
		
		//Domingo
		container_domingo.innerHTML = "";
		if (hr_domingo != undefined) {
			for(i = 0; i < hr_domingo.length; i++){
				container_domingo.innerHTML += "<label class='horarios-linha'>"+ hr_domingo[i] + "<img src='images/simbolo_deficiente.png' width='18px'></img></label>";
			}
		}
	}
	
	function carregaItinerarios(json, tipo){
		
		var container_itinerarios = document.getElementById("itinerarios-" + tipo);
		
		//joga o retorno para o elemento que vai exibi-lo
		var itinerarios = json.itinerarios.split("|");
		
		container_itinerarios.innerHTML = "";
		
		for(i = 0; i < itinerarios.length; i++){
			if(i == 0){
				container_itinerarios.innerHTML += "<img src='images/list.png' style=\"width:25px;float:left;margin-right:1.5em;\"></img><p style=\"overflow:hidden;\">" + itinerarios[i] + "</p>";
			} else {
				container_itinerarios.innerHTML += "<img src='images/list.png' style=\"width:25px;float:left;margin-right:1.5em;margin-top:-5px;\"></img><p style=\"overflow:hidden;\">" + itinerarios[i] + "</p>";
			}
		}
	}
	
	function carregaLinhas(){
		
		//Carrega JSON principal
		var json = $.parseJSON(linhas);
		
		var container_linhas = document.getElementById("lista-linhas");
		
		//joga o retorno para o elemento que vai exibi-lo
		var linhas_json = json[0].linhas.split("|");
		
		//container_linhas.innerHTML = "";
		
		for(i = 0; i < linhas_json.length; i+=2){			
			$("#lista-linhas").append("<li><a href='#' id='linha" + linhas_json[i] + "' class='list-linhas'>" + linhas_json[i+1] + "</a></li>")/			
			$("#lista-linhas").listview("refresh");
		}
		
		$(".list-linhas").click(function(){
			$.mobile.showPageLoadingMsg("a", "Aguarde...");
			$.mobile.changePage ($("#linhas-view"));
			
			carregaLinha(window[$(this).attr("id")]);
			
		});
	}
	
	/*Desabilitando Animao - Loading enquanto carrega o ChangePage
	$("#linhas-view").live('pagebeforecreate', function () {
		$.mobile.loading('show');
	});*/
	
	$("#linhas-view").live('pageshow', function () {
		$.mobile.hidePageLoadingMsg();
	});
});

