function detailsPresenter(options) {
  'use strict';
  var el = options.el;
  var model = options.model;

  function detailsTemplate (opt){
    var wrapper = document.createElement('div');
    var lineNumber = document.createElement('p');
    lineNumber.textContent = "Linea " + opt.n + " - " + opt.t;
    var nextTransit = document.createElement('p');
    var time = document.createElement('time');
    time.datetime = opt.time;
    time.textContent = opt.time.getHours() + ':' + opt.time.getMinutes();
    wrapper.appendChild(lineNumber);
    nextTransit.textContent = "Prossimo arrivo alle ";
    nextTransit.appendChild(time);
    wrapper.appendChild(nextTransit);
    return wrapper;
    
  }
  
  function listTransit(data) {
    document.querySelector('#resultInfo').innerHTML = '';
    console.log('Received list of transit: ' + data.length + ' items');
    if (data) {
      var a = document.getElementById('resultInfo');
      var frag = document.createDocumentFragment();
      data.forEach(function (transitData) {
        var today = new Date();
        var fix = today.dst() ? 2 * 60 * 60 *1000 : 60 * 60 * 1000;
        //se the clock to 00:00:00.0 and add the number of millisecond returned
        today.setHours(0, 0, 0, +transitData.d + fix);

        transitData.time = today;
        var li = document.createElement('li');
        li.appendChild(detailsTemplate(transitData));
        frag.appendChild(li);
      });
      
      a.appendChild(frag);
    } else {
    }
  }


  model.on('schedule', listTransit);
}