window.addEventListener('DOMContentLoaded', function () {
  'use strict';
  (function ($) {
    var bus = new BusModel();
    listPresenter({
      el: 'section#search',
      model: bus,
    });
    
    var back = document.querySelector('.back');
    back.addEventListener('click', function (e) {
      e.preventDefault();
      window.close();
    });

    navigator.mozSetMessageHandler('activity', function (activityRequest) {
      var option = activityRequest.source;
      console.log(option);
      bus.info(sanitize(option.data.url));
    });

    //var searchText = window.localStorage.getItem('searchText');

    //bus.info(sanitize(searchText));

    function sanitize (str) {
      return str.replace(/à/, 'a\'').replace(/è/, 'e\'').replace(/ì/, 'i\'').replace(/ò/, 'o\'').replace(/ù/, 'u\'');
    }
  })(jQuery);
});
