var App = {
    alert: function($message) {
        jQuery('body').addClass('blur');
        jQuery('#alert p').html($message);
        jQuery('#alert button').unbind('click').click(function() {
            jQuery('body').removeClass('blur');
        });
    },
    Home: {},
    Busca_Rapida: {},
    Localizar_Paradas: {},
    Favoritos: {},
    Sobre: {}
};
App.Home = {
    get_container: function() {
        return jQuery('main#home');
    },
    to_left: function() {
        App.Home.get_container().removeClass().addClass('main_to_left');
    },
    to_main: function() {
        App.Home.get_container().removeClass().addClass('left_to_main');
    },
    logo_to_center: function() {
        var $container = App.Home.get_container().find('#logo');
        var $space = $container.height() - $container.find('img').height();
        $container.css({
            'padding-top': $space
        });
    },
    init: function() {
        var $main = App.Home.get_container();
        App.Home.logo_to_center();
        $main.find('#open-busca-rapida').click(function() {
            App.Busca_Rapida.init();
        });
        $main.find('#open-localizar-paradas').click(function() {
            App.Localizar_Paradas.init();
        });
        $main.find('#open-favoritos').click(function() {
            App.Favoritos.init();
        });
        $main.find('#open-sobre').click(function() {
            App.Sobre.init();
        });
    }
};
App.Busca_Rapida = {
    Detalhes: {},
    get_container: function() {
        return jQuery('main#busca-rapida');
    },
    loading: function($display) {
        if ($display === true) {
            jQuery('#busca-rapida-header-button-loading').show();
        } else {
            jQuery('#busca-rapida-header-button-loading').hide();
        }
    },
    to_main: function() {
        var $class = App.Busca_Rapida.get_container().hasClass('main_to_left') ? 'left_to_main' : 'right_to_main';
        App.Busca_Rapida.get_container().removeClass().addClass($class);
    },
    to_left: function() {
        App.Busca_Rapida.get_container().removeClass().addClass('main_to_left');
    },
    to_right: function() {
        App.Busca_Rapida.get_container().removeClass().addClass('main_to_right');
    },
    get_routes: function() {
        jQuery.ajax({
            url: 'bd/routes.json',
            dataType: 'json',
            beforeSend: function() {
//                App.Busca_Rapida.loading(true);
            },
            error: function($jqXHR, $textStatus, $errorThrown) {
                App.alert('Ocorreu um erro ao localizar as rotas');
            },
            success: function($routes) {
                var $list_routes = App.Busca_Rapida.get_container().find('#routes');
                $list_routes.empty();
                for (var $key in $routes) {
                    var $route = $routes[$key];
                    jQuery("<option/>", {
                        value: $route.id
                    }).text($route.short_name + ' - ' + $route.long_name).appendTo($list_routes);
                }
            },
            complete: function() {
//                App.Busca_Rapida.loading(false);
                App.Home.init();
            }
        });
    },
    init: function() {
        App.Busca_Rapida.loading(false);
        App.Home.to_left();
        App.Busca_Rapida.to_main();
        App.Busca_Rapida.get_container().find('#busca-rapida-header-button-back').unbind('click').click(function() {
            App.Home.to_main();
            App.Busca_Rapida.to_right();
        });
        App.Busca_Rapida.get_container().find('#busca-rapida-form').submit(function() {
            App.Busca_Rapida.Detalhes.init();
            return false;
        });
    }
};
App.Busca_Rapida.Detalhes = {
    get_container: function() {
        return jQuery('main#busca-rapida-detalhes');
    },
    to_main: function() {
        App.Busca_Rapida.Detalhes.get_container().removeClass().addClass('right_to_main');
    },
    to_right: function() {
        App.Busca_Rapida.Detalhes.get_container().removeClass().addClass('main_to_right');
    },
    remove: function() {
        App.Busca_Rapida.Detalhes.get_container().find('#busca-rapida-detalhes-article-star-save').show();
        App.Busca_Rapida.Detalhes.get_container().find('#busca-rapida-detalhes-article-star-remove').hide();
    },
    save: function() {
        App.Busca_Rapida.Detalhes.get_container().find('#busca-rapida-detalhes-article-star-save').hide();
        App.Busca_Rapida.Detalhes.get_container().find('#busca-rapida-detalhes-article-star-remove').show();
    },
    open: function($json) {
        var $linha = $json.codigo;
        var $nome_linha = $json.nome;
        var $consorcio = $json.consorcio;
        var $rota = App.Busca_Rapida.get_container().find('input[type=radio]:checked').val();
        var $list_horarios = {
            1: {
                1: 0,
                2: 1,
                3: 2
            },
            2: {
                1: 3,
                2: 4,
                3: 5
            }
        };
        var $horario1 = jQuery.isPlainObject($json.horarios[ $list_horarios[$rota][1] ]) ? $json.horarios[ $list_horarios[$rota][1] ].divisoes : {};
        var $horario2 = jQuery.isPlainObject($json.horarios[ $list_horarios[$rota][2] ]) ? $json.horarios[ $list_horarios[$rota][2] ].divisoes : {};
        var $horario3 = jQuery.isPlainObject($json.horarios[ $list_horarios[$rota][3] ]) ? $json.horarios[ $list_horarios[$rota][3] ].divisoes : {};
        $list_horarios = [$horario1, $horario2, $horario3];

        App.Busca_Rapida.Detalhes.get_container().find('#busca-rapida-detalhes-linha').text($linha);
        App.Busca_Rapida.Detalhes.get_container().find('#busca-rapida-detalhes-nome-linha').html($nome_linha);
        App.Busca_Rapida.Detalhes.get_container().find('#busca-rapida-detalhes-consorcio').html($consorcio);
        App.Busca_Rapida.to_left();
        App.Busca_Rapida.Detalhes.to_main();
        App.Busca_Rapida.Detalhes.get_container().find('#busca-rapida-detalhes-header-button-back').unbind('click').click(function() {
            App.Busca_Rapida.to_main();
            App.Busca_Rapida.Detalhes.to_right();
        });
        App.Busca_Rapida.Detalhes.get_container().find('#busca-rapida-detalhes-article-star-save').unbind('click').click(function() {
            App.Busca_Rapida.Detalhes.save();
        });
        App.Busca_Rapida.Detalhes.get_container().find('#busca-rapida-detalhes-article-star-remove').unbind('click').click(function() {
            App.Busca_Rapida.Detalhes.remove();
        }).hide();
        App.Busca_Rapida.Detalhes.get_container().find('.button-bar a').unbind('click').click(function() {
            App.Busca_Rapida.Detalhes.get_container().find('.button-bar a.active').removeClass('active');
            jQuery(this).addClass('active');
            var $index = jQuery(this).index();
            var $horarios = $list_horarios[$index];
            App.Busca_Rapida.Detalhes.get_container().find('#list-horarios').empty();

            var $count = 0;
            var $append_horarios = '';
            if ($horarios.length > 0) {
                for (var $key in $horarios) {
                    var $horario = $horarios[$key];

                    var $cabecalho = $count === 0 ? '<div class="row text-center">' : '';
                    var $rodape = $count === 2 ? '</div>' : '';

                    $append_horarios += $cabecalho + '<div class="col">' + $horario + '</div>' + $rodape;

                    $count++;
                    if ($count === 3) {
                        $count = 0;
                    }
                }
            } else {
                $append_horarios = '<div class="row text-center"><div class="col">Nenhum horário localizado</div></div>';
            }

            App.Busca_Rapida.Detalhes.get_container().find('#list-horarios').append($append_horarios).height(App.Busca_Rapida.Detalhes.get_container().height() - 216);

        });
        App.Busca_Rapida.loading(false);
        App.Busca_Rapida.Detalhes.get_container().find('.button-bar a:first').click();
    },
    init: function() {
        App.Busca_Rapida.loading(true);
        var $route = (App.Busca_Rapida.get_container().find('#routes').val()).split(' - ');
        var req = new XMLHttpRequest({mozSystem: true});
        req.open('GET', 'http://www.thinkinovacao.com.br/busnow/teste-json.php?code=' + $route[0], true);
        req.onreadystatechange = function() {
            console.log(req.status);
            console.log(req.readyState);
            if (req.status === 200 && req.readyState === 4) {
                App.Busca_Rapida.Detalhes.open(JSON.parse(req.response));
            }
        };
        req.send(null);
    }
};
App.Localizar_Paradas = {
    id_geolocation: null,
    map: {},
    loading: function($display) {
        if ($display === true) {
            jQuery('#localizar-paradas-header-button-loading').show();
        } else {
            jQuery('#localizar-paradas-header-button-loading').hide();
        }
    },
    get_container: function() {
        return jQuery('main#localizar-paradas');
    },
    to_main: function() {
        App.Localizar_Paradas.get_container().removeClass().addClass('right_to_main');
    },
    to_right: function() {
        App.Localizar_Paradas.get_container().removeClass().addClass('main_to_right');
    },
    start_map: function() {
            App.Localizar_Paradas.map = new OpenLayers.Map({
                div: "localizar-paradas-map",
                layers: [new OpenLayers.Layer.OSM()],
                center: new OpenLayers.LonLat(-51.22067189, -30.06074719).transform("EPSG:4326", "EPSG:900913"),
                zoom: 12
            });
    },
    get_geolocation: function() {
        if ("geolocation" in navigator) {
            App.Localizar_Paradas.loading(true);
            App.Localizar_Paradas.id_geolocation = navigator.geolocation.watchPosition(function($position) {
                App.Localizar_Paradas.geolocation = {
                    latitude: -30.14296222668432, //$position.coords.latitude,
                    longitude: -51.87917968750003// $position.coords.longitude
                };
                var $LonLat = new OpenLayers.LonLat(App.Localizar_Paradas.geolocation.longitude, App.Localizar_Paradas.geolocation.latitude).transform(new OpenLayers.Projection("EPSG:4326"), App.Localizar_Paradas.map.getProjectionObject());
                App.Localizar_Paradas.map.setCenter($LonLat, 15);
//                App.Localizar_Paradas.show_geolocation = true;
//                var $Layer_Marker = new OpenLayers.Layer.Markers("Markers");
//                var $Marker = new OpenLayers.Marker($LonLat);
//                $Layer_Marker.addMarker($Marker);
//                App.Localizar_Paradas.map.addLayer($Layer_Marker);
                App.Localizar_Paradas.loading(false);
                navigator.geolocation.clearWatch(App.id_geolocation);
            }, function($error) {
                navigator.geolocation.clearWatch(App.id_geolocation);
                App.alert($error.message);
                App.Localizar_Paradas.loading(false);
            }, {
                enableHighAccuracy: true,
                maximumAge: 30000,
                timeout: 30000
            });
        } else {
            App.Localizar_Paradas.loading(false);
            App.alert('Seu dispositivo não possui geolocalização');
        }
    },
    init: function() {
        App.Localizar_Paradas.loading(false);
        App.Home.to_left();
        App.Localizar_Paradas.to_main();
        App.Localizar_Paradas.get_container().find('#localizar-paradas-header-button-back').unbind('click').click(function() {
            App.Home.to_main();
            App.Localizar_Paradas.to_right();
        });
        if (!jQuery.trim(App.Localizar_Paradas.get_container().data('opened'))) {
            App.Localizar_Paradas.get_geolocation();
        }
        App.Localizar_Paradas.get_container().data('opened', true);
    }
};
App.Favoritos = {
    get_container: function() {
        return jQuery('main#favoritos');
    },
    to_main: function() {
        App.Favoritos.get_container().removeClass().addClass('right_to_main');
    },
    to_right: function() {
        App.Favoritos.get_container().removeClass().addClass('main_to_right');
    },
    init: function() {
        App.Home.to_left();
        App.Favoritos.to_main();
        App.Favoritos.get_container().find('#favoritos-header-button-back').unbind('click').click(function() {
            App.Home.to_main();
            App.Favoritos.to_right();
        });
    }
};
App.Sobre = {
    get_container: function() {
        return jQuery('main#sobre');
    },
    to_main: function() {
        App.Sobre.get_container().removeClass().addClass('right_to_main');
    },
    to_right: function() {
        App.Sobre.get_container().removeClass().addClass('main_to_right');
    },
    init: function() {
        App.Home.to_left();
        App.Sobre.to_main();
        App.Sobre.get_container().find('#sobre-header-button-back').unbind('click').click(function() {
            App.Home.to_main();
            App.Sobre.to_right();
        });
    }
};
jQuery(document).ready(function() {
    jQuery.ajaxSetup({
        xhrFields: {
            mozSystem: true
        }
    });
//    navigator.geolocation.clearWatch(App.id_geolocation);
    App.Localizar_Paradas.start_map();
    App.Busca_Rapida.get_routes();
});