/*
 * For animated scrolling, from https://github.com/suprMax/ZeptoScroll
 *
 * Modified to scroll #exerciseSelection horizontally
 */
 
 /* Author:
    Max Degterev @suprMax
*/

;(function($) {
  var divTarget = '#exerciseSelection';

  var interpolate = function (source, target, shift) {
    return (source + (target - source) * shift);
  };

  var easing = function (pos) {
    return (-Math.cos(pos * Math.PI) / 2) + .5;
  };

  var scroll = function(endX, duration, callback) {
    endX = (typeof endX !== 'undefined') ? endX : ($.os.android ? 1 : 0);
    duration = (typeof duration !== 'undefined') ? duration : 200;

    if (duration === 0) {
      $(divTarget)[0].scrollLeft = endX;
      if (typeof callback === 'function') callback();
      return;
    }

    var startX = $(divTarget)[0].scrollLeft,
        startT = Date.now(),
        finishT = startT + duration;

    var animate = function() {
      var now = Date.now(),
          shift = (now > finishT) ? 1 : (now - startT) / duration;

      $(divTarget)[0].scrollLeft = interpolate(startX, endX, easing(shift));

      if (now < finishT) {
        setTimeout(animate, 15);
      }
      else {
        if (typeof callback === 'function') callback();
      }
    };
  
    animate();
  };

  var scrollNode = function(endX, duration, callback) {
    endY = (typeof endX !== 'undefined') ? endX : 0;
    duration = (typeof duration !== 'undefined') ? duration : 200;

    if (duration === 0) {
      this.scrollTop = endX;
      if (typeof callback === 'function') callback();
      return;
    }

    var start = this.scrollLeft,
        startT = Date.now(),
        finishT = startT + duration,
        _this = this;

    var animate = function() {
      var now = Date.now(),
          shift = (now > finishT) ? 1 : (now - startT) / duration;

      _this.scrollTop = interpolate(startX, endX, easing(shift));

      if (now < finishT) {
        setTimeout(animate, 15);
      }
      else {
        if (typeof callback === 'function') callback();
      }
    };
  
	console.log('Starting to scroll!');
  
    animate();
  };

  $.scrollTo = scroll;

  $.fn.scrollTo = function() {
    if (this.length) {
      var args = arguments;
      this.forEach(function(elem, index) {
        scrollNode.apply(elem, args);
      });
    }
  };
}(Zepto));


/* 
 * This function makes a div scrollable with android and iphone 
 * From http://www.seabreezecomputers.com/tips/scroll-div.htm
 */

function isTouchDevice(){
	/* Added Android 3.0 honeycomb detection because touchscroll.js breaks
		the built in div scrolling of android 3.0 mobile safari browser */
	if((navigator.userAgent.match(/android 3/i)) ||
		(navigator.userAgent.match(/honeycomb/i)))
		return false;
	try{
		document.createEvent("TouchEvent");
		return true;
	}catch(e){
		return false;
	}
}

var snapTimeout;

function touchScroll(id){
	if(isTouchDevice()){ //if touch events exist...
		var el=document.getElementById(id);
		var scrollStartPosY=0;
		var scrollStartPosX=0;

		document.getElementById(id).addEventListener("touchstart", function(event) {
			scrollStartPosY=this.scrollTop+event.touches[0].pageY;
			scrollStartPosX=this.scrollLeft+event.touches[0].pageX;
			//event.preventDefault(); // Keep this remarked so you can click on buttons and links in the div
		},false);
		
		document.getElementById(id).addEventListener("touchend", function(event) {
			// If there has been no scrolling for 500ms, snap to the nearest exercise 
			clearTimeout(snapTimeout);
			snapTimeout = setTimeout(function() { selectNearestExercise(true); }, 1000);
		},false);

		document.getElementById(id).addEventListener("touchmove", function(event) {
			// These if statements allow the full page to scroll (not just the div) if they are
			// at the top of the div scroll or the bottom of the div scroll
			// The -5 and +5 below are in case they are trying to scroll the page sideways
			// but their finger moves a few pixels down or up.  The event.preventDefault() function
			// will not be called in that case so that the whole page can scroll.
			if ((this.scrollTop < this.scrollHeight-this.offsetHeight &&
				this.scrollTop+event.touches[0].pageY < scrollStartPosY-5) ||
				(this.scrollTop != 0 && this.scrollTop+event.touches[0].pageY > scrollStartPosY+5))
					event.preventDefault();	
			if ((this.scrollLeft < this.scrollWidth-this.offsetWidth &&
				this.scrollLeft+event.touches[0].pageX < scrollStartPosX-5) ||
				(this.scrollLeft != 0 && this.scrollLeft+event.touches[0].pageX > scrollStartPosX+5))
					event.preventDefault();
			this.scrollTop=scrollStartPosY-event.touches[0].pageY;
			this.scrollLeft=scrollStartPosX-event.touches[0].pageX;
			
			selectNearestExercise(false);
		},false);
	}
}