// Jean Luc Biellmann - contact@alsatux.com - 20160101 - v0.7

"use strict";

var version = 'v0.7';

Date.prototype.to_yyyymmdd = function () {
	var spacer = arguments.length ? arguments[0] : '';
	var day = _Fmt.two_digits(this.getDate());
	var month = _Fmt.two_digits(this.getMonth() + 1);
	return this.getFullYear() + spacer + month + spacer + day;
}
Date.prototype.to_yyyymmddhhiiss = function () {
	var yyyy = this.getFullYear();
	var mm = _Fmt.two_digits(this.getMonth() + 1);
	var dd = _Fmt.two_digits(this.getDate());
	var hh = _Fmt.two_digits(this.getHours());
	var ii = _Fmt.two_digits(this.getMinutes());
	var ss = _Fmt.two_digits(this.getSeconds());
	return yyyy + mm + dd + hh + ii + ss;
}

String.prototype.escapeHTML = function() {
  return this.replace(/&(?!amp;)/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#039;');
}

window.onload = function () {
	_TabSettings.set_wkst(_TabCal.settings['wkst']);
	_TabSettings.set_lang(_Lang.current);
	_Log.info(tr('Please report any bug to') + ' contact@alsatux.com !');
	// add default category "None"
	var cat = _CatDB.add();
	_CatDB.upd({
		'seq': cat['seq'],
		'name': tr('None')
	});
	// GUI inits
	_TabCal.init();
	_TabCat.init();
	_TabCatEditor.init();
	_TabCatManage.init();
	_TabColors.init();
	_TabDialer.init();
	_TabEvent.init();
	_TabLog.init();
	_TabMain.init();
	_TabMonth.init();
	_TabRepeat.init();
	_TabSettings.init();
	_TabSpinner.init();
	// delete default input when getting focus
	var input_nums = document.querySelectorAll('input[type="number"]');
	for (var i=0;i<input_nums.length;i++) {
		input_nums[i].addEventListener('click', function () {
			this.setAttribute('data-oldvalue', this.value);
			this.value = '';
		});
		input_nums[i].addEventListener('blur', function () {
			if (this.value==null || !this.value.length) {
				this.value = this.getAttribute('data-oldvalue');
			}
		});
	}
	// draw current year with no events (fast)
	_TabCal.redraw_current_year();
	// show spinner
	_TabSpinner.show();
	// Get last backup
	if (_SDStorage.allowed()) {
		// FFOS device
		_DOM.hide('main_import');
		_DOM.hide('main_export');
		_Log.info(tr('SD storage available') + '... ' + tr('Searching for the last backup file') + '...');
		_SD.recall_last_backup();
	} else {
		if (_LocalStorage.allowed()) {
			// Web navigator
			_Log.info(tr('Local storage available') + '... ');
			_Local.recall_last_backup();
			// add uploader
			var _Uploader1 = new Uploader();
			_Uploader1.init('main_import', function (file) {
				_TabCal.redraw_current_year();
				var reader = new FileReader();
				reader.onload = function (e) {
					try {
						var parser = new DOMParser();
						// sanitize XML using two ways...
						var xml_doc = parser.parseFromString(e.target.result, "text/xml");
						xml_doc.normalize();
						var blobdata = (new XMLSerializer()).serializeToString(xml_doc);
						_XML.read(blobdata);
					} catch (err) {
						alert(err.message);
					}
				}
				reader.onerror = function (e) {
					alert(tr('Error while uploading file') + ' !');
				}
				reader.readAsText(file, "UTF-8");
			});
		} else {
			alert(tr('No storage API found') + ' !');
			_TabMain.scroll_today();
			_TabSpinner.hide();
		}
	}
}
