// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _CatDB = {
	counter: 0,
	db: {},
	maxlength: {
		'name': 30
	},
	add: function () {
		var seq = 'cat_seq_' + _CatDB.counter++;
		return _CatDB.db[seq] = {
			'seq': seq,
			'name': '',
			'color': '#000000',
			'bg_type': 'transparent', // or color or gradient
			'bg_from': '#68EE66',
			'bg_to': '#00AA2E',
			'bg_angle': '90', // -180 to 180 (deg) - top is 0
			'styles': '' // space separated values : "italic bold underline"
		};
	},
	chk: function (cat) {
		if (typeof(cat)!='object')
			throw tr('A category object is missing') + '.';
		// seq
		if (typeof(cat.seq)!='string')
			throw tr('The field') + ' "' + tr('sequence') + '" ' + tr('is missing') + '.';
		if (cat.seq.match(/^cat_seq_\d{1,10}$/)==null)
			throw tr('The field') + ' "' + tr('sequence') + '" ' + tr('is bad formatted') + '.';
		if (cat.seq=='cat_seq_0')
			throw tr('Unable to change default category !');
		// name
		if (typeof(cat.name)!='string')
			throw tr('The field') + ' "' + tr('name') + '" ' + tr('is missing') + '.';
		cat.name = cat.name.replace('<','').replace('>','').replace('#','').substr(0,_CatDB.maxlength['name']);
		if (!cat.name.length)
			throw tr('The field') + ' "' + tr('name') + '" ' + tr('is empty') + '.';
		// color
		if (typeof(cat.color)!='string')
			throw tr('The field') + ' "' + tr('text color') + '" ' + tr('is missing') + '.';
		cat.color = cat.color.substr(0,7);
		if (cat.color.match(/^#[0-9A-F]{6}$/i)==null)
			throw tr('The field') + ' "' + tr('text color') + '" ' + tr('is bad formatted') + '.';
		// bg_type
		if (typeof(cat.bg_type)!='string')
			throw tr('The field') + ' "' + tr('background type') + '" ' + tr('is missing') + '.';
		if (cat.bg_type.match(/^(transparent|color|gradient)$/)==null)
			throw tr('The field') + ' "' + tr('background type') + '" ' + tr('is bad formatted') + '.';
		// bg_from
		if (typeof(cat.bg_from)!='string')
			throw tr('The field') + ' "' + tr('gradient color 1') + '" ' + tr('is missing') + '.';
		cat.bg_from = cat.bg_from.substr(0,7);
		if (cat.bg_from.match(/^#[0-9A-F]{6}$/i)==null)
			throw tr('The field') + ' "' + tr('gradient color 1') + '" ' + tr('is bad formatted') + '.';
		// bg_to
		if (typeof(cat.bg_to)!='string')
			throw tr('The field') + ' "' + tr('gradient color 2') + '" ' + tr('is missing') + '.';
		cat.bg_to = cat.bg_to.substr(0,7);
		if (cat.bg_to.match(/^#[0-9A-F]{6}$/i)==null)
			throw tr('The field') + ' "' + tr('gradient color 2') + '" ' + tr('is bad formatted') + '.';
		// bg_angle
		if (typeof(cat.bg_angle)!='string' && typeof(cat.bg_to)!='number')
			throw tr('The field') + ' "' + tr('gradient angle') + '" ' + tr('is missing') + '.';
		cat.bg_angle = _Fmt.to_uint(cat.bg_angle);
		// styles
		if (typeof(cat.styles)!='string')
			if (cat.styles.length) {
				var arr = cat.styles.split(' ');
				for (var i=0;i<arr.length;i++)
					if (arr[i].match(/^(bold|italic|underline)$/)==null)
						throw tr('Unknown style') + '.';
			}
	},
	del: function (cat_seq) {
		if (cat_seq!='cat_seq_0') {
			for (var seq in _EventDB.db) {
				if (_EventDB.db[seq]['cat_seq']==cat_seq) {
					_EventDB.db[seq]['cat_seq'] = 'cat_seq_0';
				}
			}
			delete _CatDB.db[cat_seq];
		}
	},
	upd: function (obj) {
		if (!('seq' in obj)) {
			_Log.error(tr('No sequence given') + '.');
			return false;
		}
		var seq = obj['seq'];
		if (!(seq in _CatDB.db)) {
			_Log.error(tr('Unknow sequence') + '.');
			return false;
		}
		// We need to allow cat_seq_0 (None) at startup...
		for (var i in obj)
			_CatDB.db[seq][i] = obj[i];
		return true;
	},
	upd_style: function () {
		var s = _DOM.id('cats_styles');
		var rules = '';
		for (var seq in _CatDB.db) {
			var cat = _CatDB.db[seq];
			rules += '.' + cat.seq + '{ color: ' + cat.color + '; background: ' + _TabCat.get_css_background(cat) + '; ';
			if (cat.styles.indexOf('italic')!=-1)
				rules += ' font-style: italic;';
			if (cat.styles.indexOf('bold')!=-1)
				rules += ' font-weight: bold;';
			if (cat.styles.indexOf('underline')!=-1)
				rules += ' text-decoration: underline;';
			rules += ' } ';
		}
		//alert(rules);
		s.innerHTML = rules;
	}
};

