// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _EventDB = {
	counter: 0,
	db: {},
	maxlength: {
		'title': 100,
		'description': 5000
	},
	add: function () {
		var seq = 'seq_' + _EventDB.counter++;
		var now = new Date();
		return _EventDB.db[seq] = {
			'seq': seq,
			'start_date': now.to_yyyymmdd('-'),
			'start_hour': now.getHours(),
			'start_minute': now.getMinutes(),
			'duration_hour': 1,
			'duration_minute': 0,
			'title': '',
			'description': '',
			'rrule': {
				'freq': '',
				'count': 0,
				'interval': 1,
				'until': ''
			},
			'cat_seq': 'cat_seq_0'
		};
	},
	chk: function (event) {
		if (typeof(event)!='object')
			throw tr('An event object is missing' + '.');
		// seq
		if (typeof(event.seq)!='string')
			throw tr('The field') + ' "' + tr('sequence') + '" ' + tr('is missing') + '.';
		if (event.seq.match(/^seq_\d{1,10}$/)==null)
			throw tr('The field') + ' "' + tr('sequence') + '" ' + tr('is bad formatted') + '.';
		// start date
		if (typeof(event.start_date)!='string')
			throw tr('The field') + ' "' + tr('event start date') + '" ' + tr('is missing') + '.';
		if (!_Check.is_valid_date(event.start_date))
			throw tr('Invalid start date') + '.';
		// start hour
		if (typeof(event.start_hour)!='string' && typeof(event.start_hour)!='number')
			throw tr('The field') + ' "' + tr('event start hour') + '" ' + tr('is missing') + '.';
		if (event.start_hour.match(/^\d\d$/)==null)
			throw tr('The field') + ' "' + tr('event start hour') + '" ' + tr('is bad formatted') + '.';
		event.start_hour = _Fmt.modulo(event.start_hour, 24);
		// start minute
		if (typeof(event.start_minute)!='string' && typeof(event.start_minute)!='number')
			throw tr('The field') + ' "' + tr('event start minute') + '" ' + tr('is missing') + '.';
		if (event.start_minute.match(/^\d\d$/)==null)
			throw tr('The field') + ' "' + tr('event start minute') + '" ' + tr('is bad formatted') + '.';
		event.start_minute = _Fmt.modulo(event.start_minute, 60);
		// duration hour
		if (typeof(event.duration_hour)!='string' && typeof(event.duration_hour)!='number')
			throw tr('The field') + ' "' + tr('event duration hour') + '" ' + tr('is missing') + '.';
		if (event.duration_hour.match(/^\d\d\d?\d?$/)==null)
			throw tr('The field') + ' "' + tr('event duration hour') + '" ' + tr('is bad formatted') + '.';
		event.duration_hour = _Fmt.modulo(event.duration_hour, 24*365);
		// duration minute
		if (typeof(event.duration_minute)!='string' && typeof(event.duration_minute)!='number')
			throw tr('The field') + ' "' + tr('event duration minute') + '" ' + tr('is missing') + '.';
		if (event.duration_minute.match(/^\d\d$/)==null)
			throw tr('The field') + ' "' + tr('event duration minute') + '" ' + tr('is bad formatted') + '.';
		event.duration_minute = _Fmt.modulo(event.duration_minute, 60);
		// title
		if (typeof(event.title)!='string')
			throw tr('The field') + ' "' + tr('event title') + '" ' + tr('is missing') + '.';
		event.title = event.title.substr(0,_EventDB.maxlength['title']);
		// description
		if (typeof(event.description)!='string')
			throw tr('The field') + ' "' + tr('event description') + '" ' + tr('is missing') + '.';
		event.description = event.description.substr(0,_EventDB.maxlength['description']);
		// rrule
		if (typeof(event.rrule)=='object') {
			if (typeof(event.rrule.freq)!='string' || (typeof(event.rrule.freq)=='string' && !event.rrule.freq.length)) {
				event.rrule.freq = '';
				event.rrule.count = 0;
				event.rrule.interval = 1;
			} else {
				if (event.rrule.freq.match(/^(yearly|monthly|weekly|daily)$/)==null)
					throw tr('Invalid rrule frequency') + '.';
				if (typeof(event.rrule.count)!='string' && typeof(event.rrule.count)!='number')
					throw tr('The field') + ' "' + tr('event count') + '" ' + tr('is missing') + '.';
				event.rrule.count = _Fmt.modulo(event.rrule.count, 99);
				if (typeof(event.rrule.interval)!='string' && typeof(event.rrule.count)!='number')
					throw tr('The field') + ' "' + tr('event interval') + '" ' + tr('is missing') + '.';
				event.rrule.interval = _Fmt.modulo(event.rrule.interval, 99);
				if (event.rrule.interval<1)
					event.rrule.interval = 1;
			}
			if (typeof(event.rrule.until)!='string') {
				event.rrule.until = '';
			} else {
				if (event.rrule.until.length && !_Check.is_valid_date(event.rrule.until))
					throw tr('Invalid until date') + '.';
			}
		}
		// cat_seq
		if (typeof(event.cat_seq)!='string') {
			event.cat_seq = 'cat_seq_0';
		} else {
			if (event.cat_seq.match(/^cat_seq_\d{1,10}$/)==null)
				throw tr('The field') + ' "' + tr('sequence') + '" ' + tr('is bad formatted') + '.';
				// N.B.: we don't check here if the category really exists...
		}
	},
	del: function (seq) {
		delete _EventDB.db[seq];
	},
	upd: function (obj) {
		if (!('seq' in obj)) {
			_Log.error(tr('No sequence given') + '.');
			return false;
		}
		var seq = obj['seq'];
		if (!(seq in _EventDB.db)) {
			_Log.error(tr('Unknow sequence') + '.');
			return false;
		}
		if ('start_date' in obj) {
			var start_date = obj['start_date'];
			if (!_Check.is_valid_date(start_date)) {
				_Log.error(tr('Invalid start date') + '.');
				return false;
			}
		}
		if ('start_hour' in obj)
			obj['start_hour'] = _Fmt.modulo(obj['start_hour'], 24);
		if ('start_minute' in obj)
			obj['start_minute'] = _Fmt.modulo(obj['start_minute'], 60);
		if ('duration_hour' in obj)
			obj['duration_hour'] = _Fmt.modulo(obj['duration_hour'], 24*365);
		if ('duration_minute' in obj)
			obj['duration_minute'] = _Fmt.modulo(obj['duration_minute'], 60);
		if ('rrule' in obj) {
			if ('freq' in obj['rrule'] && obj['rrule']['freq'].match(/^(|yearly|monthly|weekly|daily)$/)==null) {
				_Log.error(tr('Invalid rrule frequency') + '.');
				return false;
			}
			if ('count' in obj['rrule'])
				obj['rrule']['count'] = _Fmt.modulo(obj['rrule']['count'], 99);
			if ('interval' in obj['rrule'])
				obj['rrule']['interval'] = _Fmt.modulo(obj['rrule']['interval'], 99);
			if ('until' in obj['rrule']) {
				var until = obj['rrule']['until'];
				if (until.length && !_Check.is_valid_date(until)) {
					_Log.error(tr('Invalid until date') + '.');
					return false;
				}
			}
		}
		for (var key in obj) {
			if (key=='rrule') {
				for (var key2 in obj['rrule'])
					_EventDB.db[seq]['rrule'][key2] = obj['rrule'][key2];
			} else {
				//_Log.info('_EventDB.db[' + seq + '][' + key + '] = ' + obj[key]);
				_EventDB.db[seq][key] = obj[key];
			}
		}
		return true;
	},
	save: function () {
		// we could abort here when _SDStorage.allowed() is false...
		// but it easier to let these part for debugging !
		var filename = 'cactus/default/' + (new Date()).to_yyyymmddhhiiss() + '.xml';
		var xml_string = _XML.write();
		if (_SDStorage.allowed())
			_SDStorage.write('sdcard', filename, xml_string, 'text/plain');
		if (_LocalStorage.allowed())
			_LocalStorage.write(xml_string);
	}
};

