// Jean Luc Biellmann - contact@alsatux.com

"use strict";

function tr (txt) {
	var pos = _Lang.dict.indexOf(txt);
	return _Lang.dict[pos + _Lang.current];
}

var _Lang = {
	current: 0,
	available: ['English', 'Français'],
	dict: [
// cactus.js
'Thanks to use','Merci d\'utiliser',
'Please report any bug to','Veuillez signaler tout bug à',
'SD storage available','Stockage SD disponible',
'Local storage available','Stockage local disponible',
'No storage API found','Aucune méthode de stockage disponible',
'None','Aucune',
'Pending action','Action en cours',
'Searching for the last backup file','Recherche de la dernière sauvegarde',
'Error while uploading file','Erreur durant le chargement du fichier',
// calgui.js
'Monday','Lundi',
'January,February,March,April,May,June,July,August,September,October,November,December','Janvier,Février,Mars,Avril,Mai,Juin,Juillet,Août,Septembre,Octobre,Novembre,Décembre',
'S,M,T,W,T,F,S','D,L,M,M,J,V,S',
// catdb.js
'The field','Le champ',
'is missing','est manquant',
'is empty','est vide',
'is bad formatted','est mal formaté',
'Unknown style','Style inconnu',
'sequence','séquence',
'name','nom',
'text color','couleur du texte',
'background type','type de fond',
'gradient color 1','couleur de dégradé 1',
'gradient color 2','couleur de dégradé 2',
'gradient angle','angle du dégradé',
// catgui.js
'Category choosed','Catégorie choisie : ',
// catmanage.js
'Editing category','Edition de la catégorie',
// cateditorgui.js
'Category not found','Catégorie introuvable',
'Unable to delete default category !','Impossible d\'enlever la catégorie par défaut !',
'Delete this category ?','Effacer cette catégorie ?',
'Unable to change default category !','Impossible de modifier la catégorie par défaut !',
'Field "name" is empty !','Le champ "nom" est vide !',
// eventdb.js
'An event object is missing','Un objet événement est manquant',
'A category object is missing','Un objet catégorie est manquant',
'event start date','date de l\'événement',
'event start hour','heure du début de l\'événement',
'event start minute','minute de fin de l\'événement',
'event duration hour','nombre d\'heures',
'event duration minute','nombre de minutes',
'event title','titre de l\'événement',
'event description','description de l\'événement',
'event count','nombre de répétitions',
'event interval','intervalle de répétition',
'No sequence given','Pas de séquence donnée',
'Unknow sequence','Séquence inconnue',
'Invalid start date','Date de départ invalide',
'Invalid rrule frequency','Fréquence de répétition invalide',
'Invalid until date','Date de fin de répétition invalide',
// eventgui.js
'Category has been reset','La catégorie a été réinitialisée',
'Nothing to paste','Rien à coller',
'Recording','Enregistrement en cours',
// lang.js
'Lang is now','Langue courante',
'Object','L\'objet',
'has no translation','n\'a pas été traduit',
// local.js
'Reading backup from local session','Lecture de la sauvegarde depuis le cache local',
// sd.js
' files found',' fichiers disponibles',
'Last backup','Dernière sauvegarde',
'File','Fichier',
'succesfully readed','lu avec succès',
'Unable to read the file','Impossible de lire le fichier',
'Unable to read the last backup','Impossible de lire la dernière sauvegarde',
// local.js + sd.js
'No backup found','Aucune sauvegarde n\'a été trouvée',
'Records found','Engistrements trouvés',
// settingsgui.js
'Week start is now','Le premier jour de la semaine est maintenant',
'monday','lundi',
'sunday','dimanche',
// storage.js
'Local storage API not available','API de stockage local non disponible',
'SD storage API not available','API de stockage sur carte SD non disponible',
'SD card','Carte SD',
'not found','introuvable',
'Unable to write the file','Impossible d\'écrire le fichier',
'The file','Le fichier',
'has been written','a été écrit',
'Unable to write','Impossible d\'écrire',
'Unable to read the directory','Impossible de lire le répertoire',
'Reading directory','Lecture du répertoire',
'Adding a file','Ajout d\'un fichier',
'Continue','Continu',
'Finished','Terminé',
'RegExp ok','RegExp ok',
'USB not unplugged','cordon USB non débranché',
// tab_cal.js
'events viewed','événements affichés',
// tab_main.js
'Warning: your browser doesn\'t support XML file creation on the fly ! Please use Mozilla Firefox !','Attention : votre navigateur ne supporte pas la création de fichier XML à la volée ! Merci d\'utiliser Mozilla Firefox !',
// uploader.js
'Drag and drop your Cactus XML file on this button !','Glissez/déposez votre fichier Cactus sur ce bouton',
// xml.js
'Parsing XML failed','L\'analyse XML a échoué',
'Reading settings failed','La lecture des préférences a échoué',
'Reading category failed','La lecture de la catégorie a échoué',
'Creating new event','Création d\'un nouvel événement',
'Bad frequency value','La valeur de la fréquence de répétition est erronée',
'Bad start date value','La date de l\'événement est erronée',
'Unknown category','Catégorie inconnue',
'Reading event failed','La lecture de l\'événement a échoué',
'Recording settings failed','L\'enregistrement des préférences a échoué',
'Recording category failed','L\'enregistrement  d\'une catégorie a échoué',
'Recording event failed','L\'enregistrement de l\'événement a échoué'
	],
	gui: [ // for index.html
// tab_main
//'main_goto_settings','S','P',
//'main_goto_today','T','A',
//'main_goto_month','M','M',
//'main_import','I','I',
//'main_export','E','E',
// tab_settings
'label_settings','Settings','Préférences',
'button_settings_close','X','X',
'label_lang','Language ?','Langue ?',
'label_wkst','Week start ?','Début de la semaine ?',
'cal_settings_wkst',['Monday,Sunday'],['Lundi,Dimanche'],
// tab_goto_month
'label_go_to_month','Go to month ?','Aller au mois ?',
'ul_months_abrv',['Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec'],['Jan,Fév,Mar,Avr,Mai,Jui,Jul,Aoû,Sep,Oct,Nov,Déc'],
// tab_event_start_hour
'label_event_start_hour','Hour ?','Heure ?',
// tab_event_start_minute
'label_event_start_minute','Minute ?','Minute ?',
'label_event_start_minute_ok','OK','OK',
// tab_event_duration_hour
'label_event_duration_hour','Hour ?','Heure ?',
'label_event_duration_hour_ok','OK','OK',
// tab_event_duration_minute
'label_event_duration_minute','Minute ?','Minute ?',
'label_event_duration_minute_ok','OK','OK',
'button_event_delete','Delete','Effacer',
'button_event_submit','Submit','Envoyer',
'button_event_paste','Paste','Coller',
'event_start_date','Start date','Date de début',
'label_event_start_time','Start time:','Début :',
'button_event_allday','Allday','Jour entier',
'label_event_duration','Duration:','Durée : ',
'button_event_repeat','Repeat','Répéter',
'event_title','Title ?','Titre ?',
'event_description','Description ?','Description ?',
'label_event_cat','Category:','Catégorie :',
'button_event_cat','None','Aucune',
// tab_cat
'label_cat_category','Category ?','Catégorie ?',
'button_cat_manage_open','&gt;','&gt;',
// tab_cat_manage
'label_cat_manage','Manage categories','Gestion des catégories',
'button_cat_editor_add','+','+',
'button_cat_manage_close','&lt;','&lt;',
// tab_cat_editor
'button_cat_editor_delete','Delete','Effacer',
'button_cat_editor_submit','Submit','Envoyer',
'cat_editor_name','Category name ?','Nom catégorie ?',
'cat_editor_fg_label','Text','Texte',
'label_cat_editor_color','Color:','Couleur : ',
'cat_editor_italic','I','I',
'cat_editor_bold','B','G',
'cat_editor_underline','U','S',
'cat_editor_bg_label','Background','Fond',
'label_cat_editor_bg_from','Color 1: ','Couleur 1 : ',
'label_cat_editor_bg_to','Color 2: ','Couleur 2 : ',
'label_cat_editor_bg_angle','Angle: ','Angle : ',
'cat_editor_bg_transparent','Transparent','Transparent',
'cat_editor_bg_color','Color','Aplat',
'cat_editor_bg_gradient','Gradient','Dégradé',
// tab_log
'button_log_close','Close log','Fermer le journal',
// tab_menu
// tab_repeat
'button_repeat_close','Close','Fermer',
'event_rrule_freq_radio',['Yearly,Monthly,Weekly,Daily'],['An,Mois,Semaine,Jour'],
'event_rrule_label_interval','Interval ?','Intervalle ?',
'event_rrule_label_count','Count','Nombre',
'event_rrule_label_count_no_limit','(0=no limit)','(0=sans fin)',
'event_rrule_until','End date ?','Date de fin ?',
'event_rrule_until_reset','Reset','Effacer',
	],
	chg_to: function (index) {
		var pos = _Fmt.to_uint(index);
		if (pos>=0 && pos<_Lang.available.length && pos!=_Lang.current) {
			_Lang.current = pos;
			_Log.info(tr('Lang is now') + ' : ' + _Lang.available[_Lang.current]);
			for (var i=0;i<_Lang.gui.length;i+=3) {
				var obj = _DOM.id(_Lang.gui[i]);
				if (obj==null) {
					alert(tr('Object') + ' "' + _Lang.gui[i] + '" has no translation' + ' !');
				} else {
					var value = _Lang.gui[i+1+_Lang.current];
					// object is a placeholder
					if (obj.hasAttribute('placeholder')) {
						obj.setAttribute('placeholder',value);
						continue;
					}
					// value is an array
					if (typeof value == 'object') {
						var v = String(value[0]).split(',');
						// obj is an ul
						var nodes = obj.querySelectorAll('li');
						if (nodes.length) {
							for (var j=0;j<v.length;j++)
								nodes[j].innerHTML = v[j];
							continue;
						}
						// obj is a span
						var nodes = obj.querySelectorAll('span');
						if (nodes.length) {
							for (var j=0;j<v.length;j++)
								nodes[j].innerHTML = v[j];
							continue;
						}
					}
					// value is a node
					obj.innerHTML = value;
				}
			}
		}
	}
};
