// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _LocalStorage = {
	debug: false,
	allowed: function () {
		return Storage!==undefined;
	},
	read: function () {
		if (!_LocalStorage.allowed()) {
			_Log.warn(tr('Local storage API not available') + '.');
			return null;
		}
		return localStorage.getItem('cactus');
	},
	write: function (xml_string) {
		if (!_LocalStorage.allowed()) {
			_Log.warn(tr('Local storage API not available') + '.');
			return null;
		}
		try {
			// backup last file
			var old_xml_string = localStorage.getItem('cactus');
			if (old_xml_string!=null)
				localStorage.setItem('cactus_bak', old_xml_string);
			// record the new one
			localStorage.setItem('cactus', xml_string);
		} catch (err) {
			alert(err.message);
		}
	}
};

