// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _SD = {
	recall_last_backup: function () {
		_SDStorage.get_last_backup('sdcard', 'cactus/default', function (filename) {
			if (filename.length) {
				_Log.info(tr('Last backup') + ': ' + filename + '.');
				_TabSpinner.log(tr('Last backup') + ':');
				_TabSpinner.log(filename);
				_SD.read(filename);
			} else {
				_Log.info(tr('No backup found') + '.');
				_TabSpinner.hide();
			}
		});
	},
	read: function (filename) {
		_SDStorage.read('sdcard', filename, function (req) {
			var reader = new FileReader();
			reader.onload = function(e) {
				_Log.info(tr('File') + ' "' + filename + '" ' + tr('succesfully readed') + ' !');
				_XML.read(reader.result);
				_Log.info(tr('Records found') + ': ' + Object.keys(_EventDB.db).length);
				_TabSpinner.hide();
			}
			reader.readAsText(req.result, 'UTF-8');
		}, function (req) {
			_Log.error(tr('Unable to read the file') + ' : ' + req.error);
			_TabSpinner.hide();
			alert(tr('Unable to read the last backup') + ' ?!');
		});
	}
};

