// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _SDStorage = {
	debug: false,
	allowed: function () {
		return navigator.getDeviceStorage!==undefined;
	},
	read: function (device, filename, callback_onsuccess, callback_onerror) {
		if (!_SDStorage.allowed()) {
			_Log.warn(tr('SD storage API not available') + '. ' + tr('Unable to read the file') + ' "' + device + ':' + filename + '".');
			return;
		}
		var storage = navigator.getDeviceStorage(device);
		if (storage==null) {
			_Log.warn(tr('SD card') + ' "' + device + '" ' + tr('not found') + '.  ' + tr('Unable to read the file') + ' "' + filename + '".');
			return;
		}
		var req = storage.get(filename);
		req.onsuccess = function () {
			callback_onsuccess(this);
		}
		req.onerror = function () {
			callback_onerror(this);
		}
	},
	write: function (device, filename, blobdata, blobtype) {
		if (!_SDStorage.allowed()) {
			_Log.warn(tr('SD storage API not available') + '. ' + tr('Unable to write the file') + ' "' + device + ':' + filename + '".');
			return;
		}
		var blob = new Blob([blobdata], {type: blobtype});
		var storage = navigator.getDeviceStorage(device);
		if (storage==null) {
			_Log.warn(tr('SD card') + ' "' + device + '" ' + tr('not found') + '. ' + tr('Unable to write the file') + ' "' + filename + '".');
			return;
		}
		var req = storage.addNamed(blob, filename);
		req.onsuccess = function () {
			_Log.info(tr('The file') + ' "' + device + ':' + filename + '" ' + tr('has been written') + ' !');
		}
		req.onerror = function () {
			var extra = (device=='sdcard' ? ' ' + tr('USB not unplugged') + ' ?' : '');
			_Log.error(tr('Unable to write') + ' "' + device + ':' +  filename + '"' + extra);
		}
	},
	ls: function (device, dir, callback) {
		var files = [];
		if (!_SDStorage.allowed()) {
			_Log.warn(tr('SD storage API not available') + '. ' + tr('Unable to read the directory') + ' "' + dir + '".');
			return callback(files);
		}
		var storage = navigator.getDeviceStorage(device);
		if (storage==null) {
			_Log.warn(tr('SD card') + ' "' + device + '" ' + tr('not found') + '. ' + tr('Unable to read the directory') + ' "' + dir + '".');
			return callback(files);
		}
		_Log.info(tr('Reading directory') + ' "' + device + ':' + dir + '"...');
		var cursor = storage.enumerate(dir);
		cursor.onsuccess = function () {
			var file = cursor.result;
			if (file != null) {
				if (_SDStorage.debug)
					_Log.info(tr('Adding a file') + ' "' + file.name + '"...');
				files.push(file);
				if (_SDStorage.debug)
					_Log.info(tr('Continue') + '...');
				cursor.continue();
			} else {
				if (_SDStorage.debug)
					_Log.info(tr('Finished') + '...');
				callback(files);
			}
		}
		cursor.onerror = function () {
			var extra = (device=='sdcard' ? ' ' + tr('USB not unplugged') + ' ?' : '');
			_Log.warn(tr('Unable to read the directory') + ' "' + device + ':' + dir + '".' + extra);
			callback(files);
		}
	},
	get_last_backup: function (device, dir, callback) {
		var filename = '';
		var last = null;
		var re = new RegExp('^.*' + dir + '/([0-9]{14}).xml$','');
		if (!_SDStorage.allowed()) {
			_Log.warn(tr('SD storage API not available') + '. ' + tr('Unable to read the directory') + ' "' + dir + '".');
			return callback(filename);
		}
		var storage = navigator.getDeviceStorage(device);
		if (storage==null) {
			_Log.warn(tr('SD card') + ' "' + device + '" ' + tr('not found') + '. ' + tr('Unable to read the directory') + ' "' + dir + '".');
			return callback(filename);
		}
		_Log.info(tr('Reading directory') + ' "' + device + ':' + dir + '"...');
		var cursor = storage.enumerate(dir);
		cursor.onsuccess = function () {
			var file = cursor.result;
			if (file != null) {
				var m = (file.name).match(re);
				if (m!=null) {
					if (_SDStorage.debug)
						_Log.info(tr('RegExp ok') + ' "' + file.name + '"...');
					file.re = _Fmt.to_uint(m[1]);
					if (last==null) {
						last = file;
					} else {
						if (file.re>last.re) {
							last = file;
						}
					}
					if (_SDStorage.debug)
						_Log.info(tr('Continue') + '...');
				}
				cursor.continue();
			} else {
				if (last!=null) {
					filename = dir + '/' + last.re + '.xml';
					_Log.info(tr('Last file') + ' "' + last.name + '"...');
				}
				if (_SDStorage.debug)
					_Log.info(tr('Finished') + '...');
				callback(filename);
			}
		}
		cursor.onerror = function () {
			var extra = (device=='sdcard' ? ' ' + tr('USB not unplugged') + ' ?' : '');
			_Log.warn(tr('Unable to read the directory') + ' "' + device + ':' + dir + '".' + extra);
			callback(filename);
		}
	}
};

