// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabCal = {
	debug: false,
	force_redraw_flag: false,
	counter: 0,
	current_year: 2015,
	settings: {
		wkst: 'monday' // internal - no translation - value is monday or sunday
	},
	init: function () {
		// fix current year by default
		var now = new Date();
		_TabCal.current_year = now.getFullYear();
		_DOM.listen('cal', 'click', _TabCal.slot.click_on_day);
	},
	slot: {
		click_on_day: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				while (o && o.classList && !o.classList.contains('day') && !o.classList.contains('event'))
					o = o.parentNode;
				if (o.nodeName && o.nodeName=='DIV') {
					if (o.classList.contains('day')) {
						// create a new event
						var day = o.id.replace('day_','');
						var new_event = _EventDB.add();
						new_event.start_date = day;
						_TabEvent.edit(new_event);
					}
					if (o.classList.contains('event')) {
						// edit existing event
						var seq = o.getAttribute('data-event');
						_TabEvent.edit(_EventDB.db[seq]);
					}
				}
			});
		}
	},
	redraw_current_year: function () {
		var y = _TabCal.current_year;
		_DOM.id('main_current_year').innerHTML = y;
		var months = tr('January,February,March,April,May,June,July,August,September,October,November,December').split(',');
		var days = tr('S,M,T,W,T,F,S').split(',');
		var d = new Date(y,0,1); // 1st january
		var dn = d.getDay();
		var oldm = -1;
		var cal = '';
		while (d.getFullYear()==y) {
			if (d.getMonth()!=oldm) {
				cal += '<h3 class="month">' + months[d.getMonth()]+ '</h3>';
				oldm = d.getMonth();
			}
			var day = d.getDate();
			var yyyymmdd = d.to_yyyymmdd('-');
			var now = new Date();
			var today = now.to_yyyymmdd('-');
			cal += '<div class="day' + (dn==0 ? ' sunday' : '') + (today==yyyymmdd ? ' today' : '') + '" id="day_' + yyyymmdd + '">' + (day<10 ? '0' : '') + day + ' ' + days[dn] + '</div>';
			// <div class="events"></div>
			dn = ++dn%7;
			d = new Date(d.getFullYear(),d.getMonth(),day + 1);
		}
		var div_cal = _DOM.id('cal');
		div_cal.innerHTML = cal;
	},
	add: function (event, reorder) {
		// future repeat events should be filtered here
		// and should create new events for the current year only
		var repeat_events_start_dates = _RRule.filter(_TabCal.current_year, event);
		//var single_event = JSON.parse(JSON.stringify(event));
		for (var i=0;i<repeat_events_start_dates.length;i++) {
			var start_date = repeat_events_start_dates[i];
			var div_day = _DOM.id('day_' + start_date);
			if (div_day!=null) {
				var line1 = '';
				var infos = [];
				var order = _Fmt.two_digits(event.start_hour) + _Fmt.two_digits(event.start_minute);
				var cat = event.cat_seq.length ? _CatDB.db[event.cat_seq] : null;
				if (event.start_hour==0 && event.start_minute==0 && event.duration_hour==24 && event.duration_minute==0) {
					// force spacers to avoid empty cells (cell height will be too small)
					line1 = '<span class="allday">-&nbsp;' + event.title.escapeHTML() + '&nbsp;-</span>';
					if (cat!=null && cat.seq!='cat_seq_0')
						infos.push('<span class="cat">' + cat.name.escapeHTML() +'</span>');
				} else {
					line1 = _Fmt.two_digits(event.start_hour) + ':' + _Fmt.two_digits(event.start_minute) + ' ' + event.title.escapeHTML();
					infos.push('<span class="duration">' + _Fmt.two_digits(event.duration_hour) + ':' +  _Fmt.two_digits(event.duration_minute) + '</span>');
					if (cat!=null && cat.seq!='cat_seq_0')
						infos.push('<span class="cat">' + cat.name.escapeHTML() +'</span>');
				}
				if (_TabCal.debug)
					line1 += ' {' + event.rrule.freq + ',' + event.rrule.count + ',' + event.rrule.interval + ',' + event.rrule.until + '}';

				var html = '\
				<div class="event ' + cat.seq + '" id="cal_event_' + _TabCal.counter + '" data-event="' + event.seq + '" data-order="' + order + '">\
					 <p>' + line1 + '</p>\
					<p class="infos">' + (infos.length ? '[' + infos.join('/') + ']' : '') + '</p>\
				</div>';
				div_day.insertAdjacentHTML('beforeend',html);
				_TabCal.counter++;
				if (reorder)
					_TabCal.reorder_day(div_day);
			}
		}
	},
	del: function (seq) {
		var divs = document.querySelectorAll('div[data-event="'+seq+'"]');
		for (var i=divs.length-1;i>=0;i--) {
			var div = divs[i];
			div.parentNode.removeChild(div);
		}
	},
	reorder_day: function (div_day) {
		// reorder the events
		var events = Array.prototype.slice.call(div_day.querySelectorAll('div.event[data-order]'));
		if (events.length>1) {
			events.sort(function (a,b) {
				return a.getAttribute('data-order')-b.getAttribute('data-order');
			});
			for (var k=0;k<events.length;k++)
				div_day.appendChild(events[k]);
		}
	},
	reorder_events: function () {
		var div_day = _DOM.id('cal').querySelectorAll('div.day');
		for (var i=0;i<div_day.length;i++)
			_TabCal.reorder_day(div_day[i]);
	},
	redraw: function () {
		var scrollTop = _DOM.id('cal').scrollTop;
		_TabCal.redraw_current_year();
		_TabCal.refresh_events();
		_DOM.id('cal').scrollTop = scrollTop;
		_TabCal.force_redraw_flag = false;
	},
	refresh_events: function () {
		_DOM.hide('cal');
		_CatDB.upd_style();
		for (var seq in _EventDB.db)
			_TabCal.add(_EventDB.db[seq], 0);
		var nb_events_total = Array.prototype.slice.call(_DOM.id('cal').querySelectorAll('div.event')).length;
		_Log.info(_TabCal.current_year + ': ' + nb_events_total + ' ' + tr('events viewed') + '.');
		_TabCal.reorder_events();
		_DOM.show('cal');
	},
	chg_wkst: function (value) {
		if (value.match(/^(monday|sunday)$/)!=null && value!=_TabCal.settings['wkst']) {
			_TabCal.settings['wkst'] = value;
			_TabSettings.set_wkst(value);
		}
	},
	chg_lang: function (value) {
		if (_Lang.available.indexOf(value)!=-1 && value!=_Lang.current) {
			var index = _Lang.available.indexOf(value);
			_Lang.chg_to(index);
			_TabSettings.set_lang(index);
		}
	}
};

