// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabCat = {
	init: function () {
		// opener
		_DOM.listen('button_event_cat', 'click', _TabCat.slot.show);
		// GUI objects
		_DOM.listen('div_event_cat_radio', 'click', _TabCat.slot.click_cat);
	},
	slot: {
		show: function (e) {
			return _Lock.action(e, function (e) {
				_TabCat.show();
			});
		},
		click_cat: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='DIV') {
					var divs = o.parentNode.querySelectorAll('div');
					_Fmt.resetClassName(divs);
					o.classList.add('selected');
					_DOM.id('event_cat_seq').value = o.id;
					_Log.info(tr('Category choosed') + ' : ' + _CatDB.db[o.id].name);
				}
				_TabCat.hide();
				_CatDB.upd_style();
			});
		}
	},
	show: function () {
		_DOM.show('tab_cat');
		_DOM.id('div_event_cat_radio').innerHTML = '';
		var cat_seq =	_DOM.id('event_cat_seq').value;
		var div_event_cat_radio = _DOM.id('div_event_cat_radio');
		for (var seq in _CatDB.db) {
			var cat = _CatDB.db[seq];
			var div = document.createElement('div');
			div.id = seq;
			div.style.color = cat.color;
			div.style.background = _TabCat.get_css_background(cat);
			div.className = cat.styles;
			if (seq==cat_seq)
				div.classList.add('selected');
			div.innerHTML = cat.name;
			div_event_cat_radio.appendChild(div)
		}
	},
	hide: function () {
		_DOM.hide('tab_cat');
		_TabEvent.upd_cat_button();
	},
	get_css_background: function (cat) {
		if (cat.bg_type.toLowerCase()=='transparent')
			return 'transparent';
		if (cat.bg_type.toLowerCase()=='color')
			return cat.bg_from;
		return 'linear-gradient(' + cat.bg_angle +'deg, ' + cat.bg_from + ' 0%, ' + cat.bg_to + ' 100%)';
	}
};
