// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabCatEditor = {
	mouse: {
		drag: false
	},
	init: function () {
		// opener
		_DOM.listen('button_cat_editor_add', 'click', _TabCatEditor.slot.add);
		// GUI objects
		_DOM.listen('button_cat_editor_delete', 'click', _TabCatEditor.slot.del);
		_DOM.listen('button_cat_editor_submit', 'click', _TabCatEditor.slot.submit);
		_DOM.listen('cat_editor_styles', 'click', _TabCatEditor.slot.click_style);
		_DOM.listen('cat_editor_bg_type_radio', 'click', _TabCatEditor.slot.click_bg_type);
		_DOM.listen('cat_editor_color', 'click', _TabCatEditor.slot.set_color);
		_DOM.listen('cat_editor_bg_from', 'click', _TabCatEditor.slot.set_color);
		_DOM.listen('cat_editor_bg_to', 'click', _TabCatEditor.slot.set_color);
		// touch events for angle
		_DOM.listen('cat_editor_circle_black','touchstart', _TabCatEditor.slot.angle_down);
		_DOM.listen('tab_cat_editor','touchend', _TabCatEditor.slot.angle_up);
		_DOM.listen('cat_editor_circle_black','touchmove', _TabCatEditor.slot.angle_move);
		// mouse events for angle
		_DOM.listen('cat_editor_circle_black','mousedown', _TabCatEditor.slot.angle_down);
		_DOM.listen('tab_cat_editor','mouseup', _TabCatEditor.slot.angle_up);
		_DOM.listen('cat_editor_circle_black','mousemove', _TabCatEditor.slot.angle_move);
	},
	slot: {
		add: function (e) {
			return _Lock.action(e, function (e) {
				_TabCatEditor.show();
				var cat = _CatDB.add();
				_TabCatEditor.edit(cat.seq);
				_TabCal.force_redraw_flag = true;
			});
		},
		del: function (e) {
			return _Lock.action(e, function (e) {
				var cat_seq = _DOM.id('cat_editor_seq').value;
				if (cat_seq=='cat_seq_0') {
					alert(tr('Unable to delete default category !'));
				} else {
					if (confirm(tr('Delete this category ?'))) {
						_CatDB.del(cat_seq);
						_EventDB.save();
					}
				}
				_TabCatEditor.hide();
				_TabCal.force_redraw_flag = true;
			});
		},
		submit: function (e) {
			return _Lock.action(e, function (e) {
				var cat_seq = _DOM.id('cat_editor_seq').value;
				if (cat_seq=='cat_seq_0') {
					alert(tr('Unable to change default category !'));
					_TabCatEditor.hide();
				} else {
					var styles = [];
					if (_DOM.id('cat_editor_italic').classList.contains('selected'))
						styles.push('italic');
					if (_DOM.id('cat_editor_bold').classList.contains('selected'))
						styles.push('bold');
					if (_DOM.id('cat_editor_underline').classList.contains('selected'))
						styles.push('underline');
					var cat = {
						'seq': _DOM.id('cat_editor_seq').value,
						'name': _DOM.id('cat_editor_name').value,
						'color': _DOM.id('cat_editor_color').innerHTML,
						'bg_type': _DOM.id('cat_editor_bg_type').value,
						'bg_from': _DOM.id('cat_editor_bg_from').innerHTML,
						'bg_to': _DOM.id('cat_editor_bg_to').innerHTML,
						'bg_angle': _DOM.id('cat_editor_bg_angle').innerHTML,
						'styles': styles.join(' ')
					}
					_CatDB.chk(cat);
					_CatDB.upd(cat);
					_TabCatEditor.hide();
					_EventDB.save();
					// we need to update all objects name
					var objs = document.querySelectorAll('div.event.' + cat_seq + ' span.cat');
					for (var i=0;i<objs.length;i++)
						objs[i].innerHTML = cat.name;
					_TabCal.force_redraw_flag = true;
				}
			});
		},
		click_style: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='SPAN') {
					// flip flop button style
					var cn = o.getAttribute('data-value');
					_TabCatEditor.set_button(cn, !o.classList.contains('selected'));
					_TabCatEditor.upd_preview();
				}
			});
		},
		click_bg_type: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='SPAN') {
					_TabCatEditor.set_bg_type(o.getAttribute('data-value').toLowerCase());
					_TabCatEditor.upd_preview();
				}
			});
		},
		set_color: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				_TabColors.show(o.innerHTML, function (value) {
					o.innerHTML = value;
					_TabCatEditor.upd_preview();
				});
			});
		},
		angle_down: function (e) {
			return _Lock.action(e, function (e) {
				_TabCatEditor.mouse.drag = true;
			});
		},
		angle_up: function (e) {
			return _Lock.action(e, function (e) {
				_TabCatEditor.mouse.drag = false;
			});
		},
		angle_move: function (e) {
			return _Lock.action(e, function (e) {
				var mousex, mousey;
				var theta = 0;
				var cb = _DOM.id('cat_editor_circle_black');
				var pos = _TabCatEditor.angle_position(cb);
				//console.log(e.touches[0].clientX+','+e.touches[0].clientY);
				//console.log('e.clientX='+e.touches[0].clientX+' e.clientY='+e.touches[0].clientY+' pos.x='+pos.x+'pos.y='+pos.y);
				if (e.touches !== undefined) {
					mousex = e.touches[0].clientX - pos.x;
					mousey = e.touches[0].clientY - pos.y;
				} else {
					mousex = e.clientX - pos.x;
					mousey = e.clientY - pos.y;
				}
				//console.log('mousex='+mousex+' mousey='+mousey);
				if (_TabCatEditor.mouse.drag) {
					var xc = cb.offsetWidth/2;
					var yc = cb.offsetHeight/2;
					var mx = mousex - xc;
					var my = yc - mousey;
					//console.log('xc='+xc+' yc='+yc+' mx='+mx+' my='+my);
					if (mx==0) {
						if (my>0)
							theta = Math.PI/2;
						if (my<0)
							theta = -Math.PI/2;
					} else {
						if (mx>0)
							theta = Math.atan(my/mx);
						if (mx<0) {
							if (my>0)
								theta = Math.PI+Math.atan(my/mx);
							if (my<0)
								theta = -Math.PI+Math.atan(my/mx);
						}
					}
					_TabCatEditor.angle_set(theta);
				}
			});
		}
	},
	angle_position: function (el) {
		var x = 0;
		var y = 0;
		while (el) {
			x += (el.offsetLeft - el.scrollLeft + el.clientLeft);
			y += (el.offsetTop - el.scrollTop + el.clientTop);
			el = el.offsetParent;
		}
		return { x: x, y: y };
	},
	angle_set: function (theta) {
		var cb = _DOM.id('cat_editor_circle_black');
		var cw = _DOM.id('cat_editor_circle_white');
		var d = cb.offsetWidth/2-cw.offsetWidth/2-3;
		var xc = cb.offsetWidth/2;
		var yc = cb.offsetHeight/2;
		var deg = 5*Math.round((theta*180/Math.PI)/5);
		_DOM.id('cat_editor_bg_angle').innerHTML = deg;
		theta = deg*Math.PI/180;
		cw.style.left = parseInt(xc + d*Math.cos(theta) - cw.offsetWidth/2,10)+'px';
		cw.style.top = parseInt(yc - d*Math.sin(theta) - cw.offsetHeight/2,10)+'px';
		_TabCatEditor.upd_preview();
	},
	show: function () {
		_DOM.show('tab_cat_editor');
	},
	hide: function () {
		_TabCatEditor.mouse.drag = false;
		_DOM.hide('tab_cat_editor');
		_TabCatManage.show();
	},
	edit: function (seq) {
		if (!(seq in _CatDB.db))
			return _Log.error(tr('Category not found') + ' ! ');
		_TabCatEditor.show();
		var cat = _CatDB.db[seq];
		_DOM.id('cat_editor_seq').value = seq;
		_DOM.id('cat_editor_name').value = cat.name.escapeHTML();
		_DOM.id('cat_editor_color').innerHTML = cat.color;
		_DOM.id('cat_editor_bg_from').innerHTML = cat.bg_from;
		_DOM.id('cat_editor_bg_to').innerHTML = cat.bg_to;
		_DOM.id('cat_editor_bg_angle').innerHTML = cat.bg_angle;
		_TabCatEditor.angle_set(parseInt(cat.bg_angle,10)*Math.PI/180);
		// bold, italic, underline
		_TabCatEditor.set_button('italic', cat.styles.indexOf('italic')!=-1);
		_TabCatEditor.set_button('bold', cat.styles.indexOf('bold')!=-1);
		_TabCatEditor.set_button('underline', cat.styles.indexOf('underline')!=-1);
		// background type
		_TabCatEditor.set_bg_type(cat.bg_type);
		// fg after bg...
		_TabCatEditor.upd_preview();
	},
	set_button: function (id, selected) {
		var o = _DOM.id('cat_editor_' + id);
		if (selected) {
			if (!o.classList.contains('selected'))
				o.classList.add('selected');
		} else {
			if (o.classList.contains('selected'))
				o.classList.remove('selected');
		}
	},
	upd_preview: function () {
		// update name field
		var f = _DOM.id('cat_editor_name');
		f.style.color = _DOM.id('cat_editor_color').innerHTML;
		var bg =  _TabCat.get_css_background({
			'bg_type': _DOM.id('cat_editor_bg_type').value,
			'bg_from': _DOM.id('cat_editor_bg_from').innerHTML,
			'bg_to': _DOM.id('cat_editor_bg_to').innerHTML,
			'bg_angle': _DOM.id('cat_editor_bg_angle').innerHTML
		});
		f.style.background = bg;
		// set styles
		var cstyle = document.querySelectorAll('span.cstyle');
		for (var i=0;i<cstyle.length;i++) {
			var cn = cstyle[i].getAttribute('data-value');
			if (_DOM.id('cat_editor_' + cn).classList.contains('selected')) {
				if (!f.classList.contains(cn))
					f.classList.add(cn);
			} else {
				if (f.classList.contains(cn))
					f.classList.remove(cn);
			}
		}
	},
	set_bg_type: function (value) {
		var ul = _DOM.id('cat_editor_bg_type_radio');
		var lis = ul.querySelectorAll('li');
		// unselect all
		_Fmt.resetClassName(lis);
		// select by value
		for (var i=0;i<lis.length;i++) {
			if (lis[i].getAttribute('data-value').toLowerCase()==value.toLowerCase())
				lis[i].className = 'selected';
		}
		// update colors and angle
		_DOM.id('cat_editor_bg_type').value = value.toLowerCase();
		if (value.toLowerCase()=='transparent') {
			_DOM.hide('cat_editor_block_from');
			_DOM.hide('cat_editor_block_to');
			_DOM.hide('cat_editor_block_angle');
		}
		else if (value.toLowerCase()=='color') {
			_DOM.show('cat_editor_block_from');
			_DOM.hide('cat_editor_block_to');
			_DOM.hide('cat_editor_block_angle');
		}
		else { // gradient
			_DOM.show('cat_editor_block_from');
			_DOM.show('cat_editor_block_to');
			_DOM.show('cat_editor_block_angle');
		}
	}
};
