// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabCatManage = {
	init: function () {
		// opener
		_DOM.listen('button_cat_manage_open', 'click', _TabCatManage.slot.show);
		// GUI objects
		_DOM.listen('button_cat_manage_close', 'click', _TabCatManage.slot.hide);
		_DOM.listen('cat_manage_radio', 'click', _TabCatManage.slot.click_cat);
	},
	slot: {
		show: function (e) {
			return _Lock.action(e, function (e) {
				_TabCatManage.show();
			});
		},
		hide: function (e) {
			return _Lock.action(e, function (e) {
				_TabCatManage.hide();
			});
		},
		click_cat: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='DIV') {
					var divs = o.parentNode.querySelectorAll('li');
					_Fmt.resetClassName(divs);
					_Log.info(tr('Editing category') + ' : ' + _CatDB.db[o.id].name);
					_TabCatEditor.edit(o.id)
				}
			});
		}
	},
	show: function () {
		_DOM.show('tab_cat_manage');
		_DOM.id('cat_manage_radio').innerHTML = '';
		var cat_manage_radio = _DOM.id('cat_manage_radio');
		for (var seq in _CatDB.db) {
			var cat = _CatDB.db[seq];
			var div = document.createElement('div');
			div.id = seq;
			div.style.color = cat.color;
			div.style.background = _TabCat.get_css_background(cat);
			div.className = cat.styles;
			div.innerHTML = cat.name;
			cat_manage_radio.appendChild(div);
		}
	},
	hide: function () {
		_DOM.hide('tab_cat_manage');
		_TabCat.show();
	}
};
