// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabDialer = {
	input_target: null,
	init: function () {
		// show dialer
		_DOM.listen('event_start_hour', 'click', _TabDialer.slot.show);
		_DOM.listen('event_start_minute', 'click', _TabDialer.slot.show);
		_DOM.listen('event_duration_hour', 'click', _TabDialer.slot.show);
		_DOM.listen('event_duration_minute', 'click', _TabDialer.slot.show);
		// hide dialer
		_DOM.listen('tab_event_start_hour', 'click', _TabDialer.slot.hide);
		_DOM.listen('tab_event_start_minute', 'click', _TabDialer.slot.hide);
		_DOM.listen('tab_event_duration_hour', 'click', _TabDialer.slot.hide);
		_DOM.listen('tab_event_duration_minute', 'click', _TabDialer.slot.hide);
	},
	slot: {
		show: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				var div = _DOM.id('tab_' + o.id);
				div.style.display = 'block';
				// search for a text field inside the fix
				if (div.getElementsByTagName('input').length) {
					div.getElementsByTagName('input')[0].value = o.innerHTML;
				}
				// select current li
				var lis = div.querySelectorAll('li');
				for (var i=0;i<lis.length;i++) {
					if (lis[i].innerHTML==o.innerHTML) {
						lis[i].className = 'selected';
						break;
					}
				}
				_TabDialer.input_target = o;
				e.stopPropagation();
			});
		},
		hide: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				var close_panel = false;
				var div = _DOM.id('tab_' + _TabDialer.input_target.id);
				if (o.nodeName && o.nodeName=='LI') {
					// user choose a value
					_TabDialer.input_target.innerHTML = _Fmt.two_digits(o.innerHTML);
					close_panel = true;
				}
				if (o.nodeName && o.nodeName=='BUTTON') {
					// user enter a value then press OK
					var value = _Fmt.to_uint(div.getElementsByTagName('input')[0].value);
					if (_TabDialer.input_target.classList.contains('hour')) {
						// we allow durations from 0h to 99h for compatibility
						// don't forget that 24h is allowed by default for allday events
						_TabDialer.input_target.innerHTML = _Fmt.two_digits(value%100);
					} else { // minute
						_TabDialer.input_target.innerHTML = _Fmt.two_digits(value%60);
					}
					close_panel = true;
				}
				// unselect selected li
				_Fmt.resetClassName(div.querySelectorAll('li'));
				if (close_panel) {
					// user press OK or a value
					while (o && o.className.match(/fixed/)==null)
						// search for the parent "card" div
						o = o.parentNode;
					if (o)
						o.style.display = 'none';
				}
				_TabEvent.upd_allday_button();
				e.stopPropagation();
			});
		}
	}
};

