// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabEvent = {
	event_buffer: null,
	init: function () {
		// all day button
		_DOM.listen('button_event_allday', 'click', _TabEvent.slot.allday);
		// event buttons
		_DOM.listen('button_event_submit', 'click', _TabEvent.slot.submit);
		_DOM.listen('button_event_paste', 'click', _TabEvent.slot.paste);
		_DOM.listen('button_event_delete', 'click', _TabEvent.slot.del);
	},
	slot: {
		allday: function (e) {
			return _Lock.action(e, function (e) {
			_DOM.id('event_start_hour').innerHTML = _Fmt.two_digits(0);
			_DOM.id('event_start_minute').innerHTML = _Fmt.two_digits(0);
			_DOM.id('event_duration_hour').innerHTML = _Fmt.two_digits(24);
			_DOM.id('event_duration_minute').innerHTML = _Fmt.two_digits(0);
			_TabEvent.upd_allday_button();
			});
		},
		submit: function (e) {
			return _Lock.action_with_spinner(e, function (e) {
			_TabSpinner.log(tr('Recording')+'...');
				var event = {
					'seq': _DOM.id('event_seq').value,
					'start_date': _DOM.id('event_start_date').value,
					'start_hour': _DOM.id('event_start_hour').innerHTML,
					'start_minute': _DOM.id('event_start_minute').innerHTML,
					'duration_hour': _DOM.id('event_duration_hour').innerHTML,
					'duration_minute': _DOM.id('event_duration_minute').innerHTML,
					'title': _DOM.id('event_title').value,
					'description': _DOM.id('event_description').value,
					'rrule': {
						'freq': _DOM.id('event_rrule_freq').value,
						'until': _DOM.id('event_rrule_until').value,
						'count': _DOM.id('event_rrule_count').value,
						'interval': _DOM.id('event_rrule_interval').value,
					},
					'cat_seq': _DOM.id('event_cat_seq').value,
				};
				_EventDB.chk(event);
				_EventDB.upd(event);
				_EventDB.save();
				// copy event to buffer for paste()
				_TabEvent.event_buffer = event;
				_TabEvent.hide();
				if (_TabCal.force_redraw_flag) {
					_TabCal.redraw();
				} else {
					_TabCal.del(event.seq);
					//_TabCal.add(_EventDB.db[event.seq]);
					_TabCal.add(event, 1);
				}
			});
		},
		paste: function (e) {
			return _Lock.action(e, function (e) {
				if (_TabEvent.event_buffer==null) {
					alert(tr('Nothing to paste') + ' !');
				} else {
					_TabEvent.event_buffer['seq'] = _DOM.id('event_seq').value;
					_TabEvent.event_buffer['start_date'] = _DOM.id('event_start_date').value;
					var cat_seq = _TabEvent.event_buffer['cat_seq'];
					if (!(_TabEvent.event_buffer['cat_seq'] in _CatDB.db)) {
						_TabEvent.event_buffer['cat_seq'] = 'cat_seq_0';
						alert(tr('Category has been reset') + ' !');
					}
					_TabEvent.edit(_TabEvent.event_buffer);
				}
			});
		},
		del: function (e) {
			return _Lock.action(e, function (e) {
				var seq = _DOM.id('event_seq').value;
				_TabEvent.hide();
				_TabCal.del(seq);
				_EventDB.del(seq);
				_EventDB.save();
			});
		}
	},
	edit: function (event) {
		_DOM.show('tab_edit_event');
		_DOM.id('event_seq').value = event.seq;
		_DOM.id('event_start_date').value = event.start_date;
		_DOM.id('event_start_hour').innerHTML = _Fmt.two_digits(event.start_hour);
		_DOM.id('event_start_minute').innerHTML = _Fmt.two_digits(event.start_minute);
		_DOM.id('event_duration_hour').innerHTML = _Fmt.two_digits(event.duration_hour);
		_DOM.id('event_duration_minute').innerHTML = _Fmt.two_digits(event.duration_minute);
		_DOM.id('event_title').value = event.title;
		_DOM.id('event_description').value = event.description;
		// rrule
		_DOM.id('event_rrule_freq').innerHTML = event.rrule.freq;
		_DOM.id('event_rrule_count').value = event.rrule.count;
		_DOM.id('event_rrule_interval').value = event.rrule.interval;
		_DOM.id('event_rrule_until').value = event.rrule.until;
		_TabRepeat.select_freq(event.rrule.freq);
		// cat seq
		_DOM.id('event_cat_seq').value = event.cat_seq;
		// update all buttons
		_TabEvent.upd_repeat_button();
		_TabEvent.upd_allday_button();
		_TabEvent.upd_cat_button();
	},
	hide: function () {
		_DOM.hide('tab_edit_event');
	},
	upd_repeat_button: function () {
		// update repeat button according to parameters
		var button = _DOM.id('button_event_repeat');
		var repeated = _DOM.id('event_rrule_until').value.length || _DOM.id('event_rrule_freq_radio').querySelectorAll('li.selected').length;
		if (repeated) {
			if (!button.classList.contains('selected'))
				button.classList.add('selected');
		} else {
			if (button.classList.contains('selected'))
				button.classList.remove('selected');
		}
	},
	upd_allday_button: function () {
		// update allday button
		var allday = _DOM.id('event_start_hour').innerHTML=='00' && _DOM.id('event_start_minute').innerHTML=='00' && _DOM.id('event_duration_hour').innerHTML=='24' && _DOM.id('event_duration_minute').innerHTML=='00';
		var button = _DOM.id('button_event_allday');
		if (allday) {
			if (!button.classList.contains('selected'))
				button.classList.add('selected');
		} else {
			if (button.classList.contains('selected'))
				button.classList.remove('selected');
		}
	},
	upd_cat_button: function () {
		var seq = _DOM.id('event_cat_seq').value;
		var obj = _DOM.id('button_event_cat');
		if (seq.length) {
			var cat = _CatDB.db[seq];
			obj.style.color = cat.color;
			obj.style.background = _TabCat.get_css_background(cat);
			obj.className = 'rounded ' + cat.styles;
			obj.innerHTML = cat.name;
		} else {
			obj.style.color = '';
			obj.style.background = '';
			obj.className = 'rounded';
			obj.innerHTML = tr('None');
		}
	}
};

