// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabLog = {
	counter: 1,
	init: function () {
		_DOM.listen('main_current_year', 'click', _TabLog.slot.show);
		_DOM.listen('button_log_close', 'click', _TabLog.slot.hide);
	},
	slot: {
		show: function (e) {
			return _Lock.action(e, function (e) {
				_DOM.show('tab_log');
			});
		},
		hide: function (e) {
			return _Lock.action(e, function (e) {
				_DOM.hide('tab_log');
			});
		}
	},
	clear: function () {
		_DOM.id('tab_log_events').innerHTML = '';
	},
	push: function (mess, className) {
		var index = _Fmt.four_digits(_TabLog.counter++ % 10000) + ' : ';
		var p = document.createElement('p');
		p.className = 'log_' + className;
		p.innerHTML = index + mess;
		var parent = _DOM.id('tab_log_events');
		parent.insertBefore(p, parent.firstChild);
	}
};

