// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabMain = {
	init: function () {
		_DOM.listen('main_prev_year', 'click', _TabMain.slot.click_prev_year);
		_DOM.listen('main_next_year', 'click', _TabMain.slot.click_next_year);
		_DOM.listen('main_goto_today', 'click', _TabMain.slot.click_today);
		_DOM.listen('main_export', 'click', _TabMain.slot.click_export);
	},
	slot: {
		click_prev_year: function (e) {
			return _Lock.action_with_spinner(e, function (e) {
				_TabCal.current_year--;
				_TabCal.redraw();
			});
		},
		click_next_year: function (e) {
			return _Lock.action_with_spinner(e, function (e) {
				_TabCal.current_year++;
				_TabCal.redraw();
			});
		},
		click_today: function (e) {
			var now = new Date();
			if (_TabCal.current_year!=now.getFullYear()) {
				return _Lock.action_with_spinner(e, function (e) {
					_TabMain.scroll_today();
				});
			} else {
				return _Lock.action(e, function (e) {
					_TabMain.scroll_today();
				});
			}
		},
		click_export: function (e) {
			return _Lock.action(e, function (e) {
				_TabMain.export();
			});
		}
	},
	scroll_today: function () {
		var now = new Date();
		if (_TabCal.current_year!=now.getFullYear()) {
			_TabCal.current_year = now.getFullYear();
			_TabCal.redraw();
		} else {
			var div_today = document.querySelectorAll('div.today')[0];
			if (div_today.id!='day_' + now.to_yyyymmdd('-'))
				div_today.classList.remove('today');
		}
		var div_now = _DOM.id('day_' + now.to_yyyymmdd('-'));
		_DOM.id('cal').scrollTop = div_now.offsetTop;
		if (!div_now.classList.contains('today'))
			div_now.classList.add('today');
	},
	export: function () {
		var xml_string = _XML.write();
		if (!window.URL || !window.URL.createObjectURL)
			return alert(tr('Warning: your browser doesn\'t support XML file creation on the fly ! Please use Mozilla Firefox !'));
		var blob = new Blob([xml_string], {type:'text/plain;charset=utf-8'});
		var a = document.createElementNS("http://www.w3.org/1999/xhtml", "a");
		a.href = window.URL.createObjectURL(blob);
		a.download = (new Date()).to_yyyymmddhhiiss() + '.xml';
		var event = document.createEvent("MouseEvents");
		event.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
		a.dispatchEvent(event);
	}
};

