// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabRepeat = {
	init: function () {
		// opener
		_DOM.listen('button_event_repeat', 'click', _TabRepeat.slot.show);
		// GUI objects
		_DOM.listen('button_repeat_close', 'click', _TabRepeat.slot.hide);
		_DOM.listen('event_rrule_freq_radio', 'click', _TabRepeat.slot.click_freq);
		_DOM.listen('event_rrule_until_reset', 'click', _TabRepeat.slot.click_reset_until);
	},
	slot: {
		show: function (e) {
			return _Lock.action(e, function (e) {
				_DOM.show('tab_repeat');
			});
		},
		hide: function (e) {
			return _Lock.action(e, function (e) {
				_DOM.hide('tab_repeat');
				_TabEvent.upd_repeat_button();
			});
		},
		click_freq: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='LI') {
					if (o.classList.contains('selected')) {
						// unselect
						_TabRepeat.select_freq('');
					} else {
						// select
						_TabRepeat.select_freq(o.getAttribute('data-value'));
					}
				}
			});
		},
		click_reset_until: function (e) {
			return _Lock.action(e, function (e) {
				_DOM.id('event_rrule_until').value = '';
			});
		}
	},
	select_freq: function (value) {
		var ul = _DOM.id('event_rrule_freq_radio');
		var lis = ul.querySelectorAll('li');
		// unselect all
		_Fmt.resetClassName(lis);
		// select by value
		for (var i=0;i<lis.length;i++) {
			if (lis[i].getAttribute('data-value').toLowerCase()==value.toLowerCase())
				lis[i].className = 'selected';
		}
		_DOM.id('event_rrule_freq').value = value.toLowerCase();
	}
};
