// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabSettings = {
	init: function () {
		_DOM.listen('main_goto_settings', 'click', _TabSettings.slot.show);
		_DOM.listen('cal_settings_lang', 'click', _TabSettings.slot.click_lang);
		_DOM.listen('cal_settings_wkst', 'click', _TabSettings.slot.click_wkst);
		_DOM.listen('button_settings_close', 'click', _TabSettings.slot.hide);
	},
	slot: {
		show: function (e) {
			return _Lock.action(e, function (e) {
				_DOM.show('tab_settings');
			});
		},
		hide: function (e) {
			return _Lock.action(e, function (e) {
				_DOM.hide('tab_settings');
			});
		},
		click_lang: function (e) {
			return _Lock.action_with_spinner(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='SPAN') {
					_TabSettings.set_lang(o.getAttribute('data-value'));
					_Lang.chg_to(o.getAttribute('data-value'));
					_CatDB.upd({
						'seq': 'cat_seq_0',
						'name': tr('None')
					});
				}
				_EventDB.save();
				_TabCal.redraw();
			});
		},
		click_wkst: function (e) {
			return _Lock.action(e, function (e) {
				var o = e.target;
				if (o.nodeName && o.nodeName=='SPAN') {
					_TabSettings.set_wkst(o.getAttribute('data-value'));
					_TabCal.settings['wkst'] = o.getAttribute('data-value').toLowerCase();
					_Log.info(tr('Week start is now') + ' : ' + tr(_TabCal.settings['wkst']));
				}
				_EventDB.save();
				_TabCal.redraw();
			});
		}
	},
	set_wkst: function (value) {
		var lis = _DOM.id('cal_settings_wkst').querySelectorAll('span');
		for (var i=0;i<lis.length;i++)
			if (lis[i].getAttribute('data-value')!=value)
				lis[i].classList.remove('selected');
			else
				if (!lis[i].classList.contains('selected'))
					lis[i].classList.add('selected');
	},
	set_lang: function (value) {
		var lis = _DOM.id('cal_settings_lang').querySelectorAll('span');
		for (var i=0;i<lis.length;i++)
			if (lis[i].getAttribute('data-value')!=value)
				lis[i].classList.remove('selected');
			else
				if (!lis[i].classList.contains('selected'))
					lis[i].classList.add('selected');
	}
};

