// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _TabSpinner = {
	init: function () {
		_DOM.listen('tab_spinner_bg', 'click', _TabSpinner.slot.stop_propagation);
		_DOM.listen('tab_spinner_bg', 'touchstart', _TabSpinner.slot.stop_propagation);
		_DOM.listen('tab_spinner_bg', 'touchend', _TabSpinner.slot.stop_propagation);
		_DOM.listen('tab_spinner_bg', 'touchmove', _TabSpinner.slot.stop_propagation);
		_DOM.listen('tab_spinner', 'click', _TabSpinner.slot.stop_propagation);
		_DOM.listen('tab_spinner', 'touchstart', _TabSpinner.slot.stop_propagation);
		_DOM.listen('tab_spinner', 'touchend', _TabSpinner.slot.stop_propagation);
		_DOM.listen('tab_spinner', 'touchmove', _TabSpinner.slot.stop_propagation);
	},
	slot: {
		stop_propagation: function (e) {
			e.preventDefault();
			e.stopPropagation();
			return false;
		}
	},
	show: function () {
		_DOM.show('tab_spinner_bg');
		_DOM.show('tab_spinner');
	},
	hide: function () {
		_TabSpinner.clear();
		_DOM.hide('tab_spinner_bg');
		_DOM.hide('tab_spinner');
	},
	clear: function () {
		_DOM.hide('spinner_welcome');
		_DOM.id('spinner_txt').innerHTML = '';
	},
	log: function (mess) {
		var p = document.createElement('P');
		p.innerHTML = mess.escapeHTML();
		_DOM.id('spinner_txt').appendChild(p);
	}
};
