// Jean Luc Biellmann - contact@alsatux.com

"use strict";

function Uploader () {
}
Uploader.prototype = {
	init: function (id, callback) {
		var obj = document.getElementById(id);
		obj.addEventListener('click', function(e) {
			alert(tr('Drag and drop your Cactus XML file on this button !'));
		});
		obj.addEventListener('dragleave', function(e) {
			e.preventDefault();
			e.stopPropagation();
			return false;
		});
		obj.addEventListener('dragover', function(e){
			e.preventDefault();
			e.stopPropagation();
			return false;
		});
		obj.addEventListener('dragenter', function() {
			return false;
		});
		obj.addEventListener('drop', function(e) {
			e.preventDefault();
			e.stopPropagation();
			var event = e.originalEvent || e;
			if (!event || !event.dataTransfer || !event.dataTransfer.files || !event.dataTransfer.files.length)
				return false;
			for (var i=0;i<event.dataTransfer.files.length;i++)
				callback(event.dataTransfer.files[i]);
			return false;
		});
	}
};

