// Jean Luc Biellmann - contact@alsatux.com

"use strict";

var _XML = {
	debug: false,
	read: function (text) {
		var xml_doc;
		try {
			var str = text.replace('<?xml version="1.0" encoding="UTF-8"?>','');
			var parser = new DOMParser();
			xml_doc = parser.parseFromString(str, 'text/xml');
		} catch (err) {
			return _Log.error(tr('Parsing XML failed') + ' : ' + err);
		}
		// read settings
		try {
			if (xml_doc.getElementsByTagName("settings").length) {
				var xml_settings = xml_doc.getElementsByTagName("settings")[0];
				// lang
				if (xml_settings.getElementsByTagName("lang").length)
					_TabCal.chg_lang(xml_settings.getElementsByTagName('lang')[0].childNodes[0].nodeValue);
				// wkst
				if (xml_settings.getElementsByTagName("wkst").length)
					_TabCal.chg_wkst(xml_settings.getElementsByTagName('wkst')[0].childNodes[0].nodeValue);
			}
		} catch (err) {
			_Log.error(tr('Reading settings failed') + ' : ' + err);
			// continue (non fatal errors)
		}
		// read cats
		if (xml_doc.getElementsByTagName("cat").length) {
			var xml_cats = xml_doc.getElementsByTagName("cat");
			for (var i=0;i<xml_cats.length;i++) {
				try {
					var xml_cat = xml_cats[i];
					// all fields
					var cat = {
						'seq': xml_cat.getElementsByTagName('seq')[0].childNodes[0].nodeValue,
						'name': xml_cat.getElementsByTagName('name')[0].childNodes[0].nodeValue,
						'color': xml_cat.getElementsByTagName('color')[0].childNodes[0].nodeValue,
						'bg_type': xml_cat.getElementsByTagName('bg_type')[0].childNodes[0].nodeValue,
						'bg_from': xml_cat.getElementsByTagName('bg_from')[0].childNodes[0].nodeValue,
						'bg_to': xml_cat.getElementsByTagName('bg_to')[0].childNodes[0].nodeValue,
						'bg_angle': xml_cat.getElementsByTagName('bg_angle')[0].childNodes[0].nodeValue,
						'styles': ''
					};
					if (xml_cat.getElementsByTagName('styles')[0].childNodes.length)
						cat.styles = xml_cat.getElementsByTagName('styles')[0].childNodes[0].nodeValue;
					if (cat.seq!='cat_seq_0') {
						try {
							_CatDB.chk(cat);
							var j = _Fmt.to_uint(cat.seq.replace('cat_seq_',''));
							if (j>=_CatDB.counter)
								_CatDB.counter = j+1;
							_CatDB.db[cat.seq] = cat;
						} catch (err) {
							throw err;
						}
					}
				} catch (err) {
					_Log.error(tr('Reading category failed') + ' : ' + err);
					// continue (ignore errors)
				}
			}
		}
		// read events
		if (xml_doc.getElementsByTagName("event").length) {
			var value, m;
			var xml_events = xml_doc.getElementsByTagName("event");
			//_Log.info('nbevents=' + xml_events.length);
			for (var i=0;i<xml_events.length;i++) {
				try {
					var obj_event = {
						'seq': '',
						'start_date': '',
						'start_hour': 0,
						'start_minute': 0,
						'duration_hour': 0,
						'duration_minute': 0,
						'title': '',
						'description': '',
						'cat_seq': 'cat_seq_0',
					};
					var xml_event = xml_events[i];
					// date (mandatory)
					value = xml_event.getElementsByTagName('date')[0].childNodes[0].nodeValue;
					m = value.match(/^(\d\d\d\d)-(\d\d)-(\d\d)$/);
					if (m==null || !_Check.is_valid_date(m[0])) {
						throw tr('Bad start date value') + '...';
						continue; // fatal !
					}
					obj_event['start_date'] = m[0];
					// time (mandatory)
					value = xml_event.getElementsByTagName('time')[0].childNodes[0].nodeValue;
					m = value.match(/^(\d\d):(\d\d)$/);
					if (m!=null) {
						obj_event['start_hour'] = m[1];
						obj_event['start_minute'] = m[2];
					}
					//duration (mandatory)
					value = xml_event.getElementsByTagName('duration')[0].childNodes[0].nodeValue;
					m = value.match(/^(\d\d):(\d\d)$/);
					if (m!=null) {
						obj_event['duration_hour'] = m[1];
						obj_event['duration_minute'] = m[2];
					}
					// title (optional)
					if (xml_event.getElementsByTagName('title').length) {
						if (xml_event.getElementsByTagName('title')[0].childNodes.length)
							obj_event['title'] = xml_event.getElementsByTagName('title')[0].childNodes[0].nodeValue.substr(0,_EventDB.maxlength['title']);
					}
					// description (optional)
					if (xml_event.getElementsByTagName('description').length) {
						if (xml_event.getElementsByTagName('description')[0].childNodes.length)
							obj_event['description'] = xml_event.getElementsByTagName('description')[0].childNodes[0].nodeValue.substr(0,_EventDB.maxlength['description']);
					}
					if (_XML.debug)
						_Log.info(tr('Creating new event') + '...');
					var new_event = _EventDB.add();
					obj_event['seq'] = new_event.seq;
					// add repeat rule (optional)
					var rrule = {
						'freq': '',
						'count': 0,
						'interval': 1,
						'until': ''
					};
					if (xml_event.getElementsByTagName('rrule').length) {
						var xml_rrule = xml_event.getElementsByTagName('rrule')[0];
						if (xml_rrule.getElementsByTagName('freq').length) {
							// freq (mandatory)
							rrule['freq'] = xml_rrule.getElementsByTagName('freq')[0].childNodes[0].nodeValue;
							if (rrule['freq'].match(/^(yearly|monthly|weekly|daily)$/)==null)
								throw tr('Bad frequency value') + '...';
							// interval (mandatory)
							rrule['interval'] = _Fmt.modulo(xml_rrule.getElementsByTagName('interval')[0].childNodes[0].nodeValue, 99);
							// optional count
							if (xml_rrule.getElementsByTagName('count').length)
								rrule['count'] = _Fmt.modulo(xml_rrule.getElementsByTagName('count')[0].childNodes[0].nodeValue, 99);
						}
						// optional until
						if (xml_rrule.getElementsByTagName('until').length)
							rrule['until'] = xml_rrule.getElementsByTagName('until')[0].childNodes[0].nodeValue;
					}
					obj_event['rrule'] = rrule;
					// cat_seq
					obj_event['cat_seq'] = 'cat_seq_0';
					if (xml_event.getElementsByTagName('cat_seq').length) {
						var cat_seq = xml_event.getElementsByTagName('cat_seq')[0].childNodes[0].nodeValue;
						if (cat_seq in _CatDB.db)
							obj_event['cat_seq'] = cat_seq;
						else
							throw tr('Unknown category') + '...';
					}
					if (_XML.debug) {
						for (var key in obj_event) {
							if (key=='rrule') {
								for (var key2 in obj_event['rrule'])
									_Log.info('   ' + key2 + ': ' + obj_event['rrule'][key2]);
							} else {
								_Log.info(key + ': ' + obj_event[key]);
							}
						}
					}
					_EventDB.chk(obj_event);
					_EventDB.upd(obj_event);
				} catch (err) {
					_Log.error(tr('Reading event failed') + ' : ' + err);
					// continue (ignore errors)
				}
			}
		}
		// we need to redraw all because the lang and others settings can changed
		_TabCal.redraw_current_year();
		_TabCal.refresh_events();
		_TabMain.scroll_today();
	},
	write: function () {
		var event, markup, xml_doc, xml_settings, xml_events, xml_element, xml_textnode, xml_node, xml_rrule, xml_cats, xml_cat;
		markup = '<?xml version="1.0" encoding="UTF-8"?><calendar name="default"><settings></settings><cats></cats><events></events></calendar>';
		xml_doc = (new DOMParser()).parseFromString(markup, 'application/xml');
		// record settings
		try {
			xml_settings = xml_doc.getElementsByTagName("settings")[0];
			// lang
			xml_element = xml_doc.createElement('lang');
			xml_settings.appendChild(xml_element);
			xml_textnode = xml_doc.createTextNode(_Lang.available[_Lang.current]);
			xml_element.appendChild(xml_textnode);
			// wkst
			for (var key in _TabCal.settings) {
				xml_element = xml_doc.createElement(key);
				xml_settings.appendChild(xml_element);
				xml_textnode = xml_doc.createTextNode(_TabCal.settings[key]);
				xml_element.appendChild(xml_textnode);
			}
		} catch (err) {
			_Log.error(tr('Recording settings failed') + ' : ' + err);
		}
		// record cats
		xml_cats = xml_doc.getElementsByTagName("cats")[0];
		for (var cat in _CatDB.db) {
			try {
				xml_cat = xml_doc.createElement('cat');
				xml_cats.appendChild(xml_cat);
				for (var key in _CatDB.db[cat]) {
					xml_element = xml_doc.createElement(key);
					xml_cat.appendChild(xml_element);
					xml_textnode = xml_doc.createTextNode(_CatDB.db[cat][key]);
					xml_element.appendChild(xml_textnode);
				}
			} catch (err) {
				_Log.error(tr('Recording category failed') + ' : ' + err);
			}
		}
		// record events
		xml_events = xml_doc.getElementsByTagName("events")[0];
		for (var seq in _EventDB.db) {
			event = _EventDB.db[seq];
			try {
				xml_node = xml_doc.createElement('event');
				xml_events.appendChild(xml_node);
				// date
				xml_element = xml_doc.createElement('date');
				xml_node.appendChild(xml_element);
				xml_textnode = xml_doc.createTextNode(event.start_date);
				xml_element.appendChild(xml_textnode);
				// time
				xml_element = xml_doc.createElement('time');
				xml_node.appendChild(xml_element);
				xml_textnode = xml_doc.createTextNode(_Fmt.two_digits(event.start_hour) + ':' + _Fmt.two_digits(event.start_minute));
				xml_element.appendChild(xml_textnode);
				// duration
				xml_element = xml_doc.createElement('duration');
				xml_node.appendChild(xml_element);
				xml_textnode = xml_doc.createTextNode(_Fmt.two_digits(event.duration_hour) + ':' + _Fmt.two_digits(event.duration_minute));
				xml_element.appendChild(xml_textnode);
				// title
				if (event.title.length) {
					xml_element = xml_doc.createElement('title');
					xml_node.appendChild(xml_element);
					xml_textnode = xml_doc.createTextNode(event.title);
					xml_element.appendChild(xml_textnode);
				}
				// description
				if (event.description.length) {
					xml_element = xml_doc.createElement('description');
					xml_node.appendChild(xml_element);
					xml_textnode = xml_doc.createTextNode(event.description);
					xml_element.appendChild(xml_textnode);
				}
				// rrule
				if (Object.keys(event.rrule).length) {
					xml_rrule = xml_doc.createElement('rrule');
					if ('freq' in event.rrule && event.rrule['freq'].length) {
						xml_element = xml_doc.createElement('freq');
						xml_rrule.appendChild(xml_element);
						xml_textnode = xml_doc.createTextNode(event.rrule['freq']);
						xml_element.appendChild(xml_textnode);
						xml_element = xml_doc.createElement('count');
						xml_rrule.appendChild(xml_element);
						xml_textnode = xml_doc.createTextNode(event.rrule['count']);
						xml_element.appendChild(xml_textnode);
						xml_element = xml_doc.createElement('interval');
						xml_rrule.appendChild(xml_element);
						xml_textnode = xml_doc.createTextNode(event.rrule['interval']);
						xml_element.appendChild(xml_textnode);
					}
					if ('until' in event.rrule && event.rrule['until'].length) {
						xml_element = xml_doc.createElement('until');
						xml_rrule.appendChild(xml_element);
						xml_textnode = xml_doc.createTextNode(event.rrule['until']);
						xml_element.appendChild(xml_textnode);
					}
					if (xml_rrule.childNodes.length)
						xml_node.appendChild(xml_rrule);
				}
				// cat_seq
				xml_element = xml_doc.createElement('cat_seq');
				xml_node.appendChild(xml_element);
				xml_textnode = xml_doc.createTextNode(event.cat_seq);
				xml_element.appendChild(xml_textnode);
			} catch (err) {
				_Log.error(tr('Recording event failed') + ' : ' + err);
			}
		}
		return (new XMLSerializer()).serializeToString(xml_doc);
	}
};

