var Calculator = function Calculator () {
  this._operationDone = false;
  this._screen = document.getElementById('screen');
  this._lastType = 'empty';
  this.bindEvents();
};

Calculator.prototype.bindEvents = function() {
  var self = this;
  this._numbers = document.getElementsByClassName('number');
  for (var i = 0, l = this._numbers.length; i < l; i++) {
    this._numbers[i].addEventListener(
      'click', function(e) { self.onValue(e, this); }
    );
  }
  this._operators = document.getElementsByClassName('operator');
  for (i = 0, l = this._operators.length; i < l; i++) {
    this._operators[i].addEventListener(
      'click', function(e) { self.onValue(e, this); }
    );
  }
  this._dot = document.getElementById('dot');
  this._dot.addEventListener(
    'click', function(e) { self.onValue(e, this); }
  );
  this._clearButton = document.getElementById('clear');
  this._clearButton.addEventListener(
    'click', function() { self.onClear(); }
  );
  this._backButton = document.getElementById('back');
  this._backButton.addEventListener(
    'click', function() { self.onBack(); }
  );
  this._form = document.getElementById('calculator');
  this._form.addEventListener(
    'submit', function(e) { self.onValidate(e); }
  );
};

Calculator.prototype.onValue = function(event, el) {
  var added = el.innerHTML;
  var type = el.className;
  if (this._operationDone) {
    if (type === 'number' || this._screen.classList.contains('error')) {
      this._screen.classList.remove('error');
      this.onClear();
    } else if (this._screen.value.length) {
      added = ' ' + added;
    }
  } else if (
    (this._lastType === 'number' && type === 'operator') ||
    (this._lastType === 'operator' && type === 'number') ||
      (this._lastType === 'operator' && type === 'operator')
  ) {
    added = ' ' + added;

  }
  this._lastType = type;
  this._screen.value = this._screen.value + added;
  this._operationDone = false;
};

Calculator.prototype.onBack = function() {
  var screenText = this._screen.value;
  this._screen.value = screenText.substr(0, screenText.length - 1);
  this._operationDone = false;
};

Calculator.prototype.onClear = function() {
  this._screen.value = '';
  this._operationDone = false;
};

Calculator.prototype.onValidate = function(event) {
  event.preventDefault();
  this._screen.value = this._screen.value
    .replace(/\s/g , '')
    .replace(/[x]/g, '*')
  if (this._screen.value.length > 0
  &&  this._screen.value !== 'Error') {
    try {
      this._screen.value = eval(
        this._screen.value
      );
    }
    catch(err) {
      if('vibrate' in navigator) {
        navigator.vibrate(100);
      }
      this._screen.classList.add('error');
      this._screen.value = 'Error';
    }
  }
  this._operationDone = true;
  return false;
};