(function(w) {

    var DIVIDE_BY_ZERO = "Erro ao dividir por zero";
    if( navigator.language.indexOf("en") == 0 ) DIVIDE_BY_ZERO = "Cannot divide by zero";
    if( navigator.language.indexOf("es") == 0 ) DIVIDE_BY_ZERO = "No puedes dividir por cero";
    
    function Calc() {

        this.main = "0";
        this.secondary = "0";
        this.symbol = "";
        this.isNumberEntered = true;
        
        
        function num(v) {
            var n = 0;
            if( typeof v == "string" ){
                v = v.replace(".", "").replace(",",".");
                n = +v;
            }
            return n;
        }

        function str(n) {
            return (+(+n).toFixed(9)).toString().replace(".", ",");
        }

        this.onupdate = function() {

        };

        this.memory = 0;

        var operation = {
            times: {
                fn: function() {
                    var value = num(this.secondary) * num(this.main);
                    return value;
                },
                symbol: "\u00D7	",
                unary: false,
                triggerClear: true
            },
            divide: {
                fn: function() {
                    if (this.main == 0) {
                        var value = 0;
                        this.msg = DIVIDE_BY_ZERO;
                    } else {
                        var value = num(this.secondary) / num(this.main);
                    }
                    return value;
                },
                symbol: "\u00F7",
                unary: false,
                triggerClear: true
            },
            plus: {
                fn: function() {
                    var value = num(this.secondary) + num(this.main);
                    return value;
                },
                symbol: "+",
                unary: false,
                triggerClear: true
            },
            minus: {
                fn: function() {
                    var value = num(this.secondary) - num(this.main);
                    return value;
                },
                symbol: "-",
                unary: false,
                triggerClear: true
            },
            invertsign: {
            	fn: function () {
            		this.main = str(-num(this.main));
            	},
            	symbol: "\u00B1",
				unary: true,
                triggerClear: false
            },
            solve: {
                fn: null,
                symbol: "=",
                unary: false,
                triggerClear: false
            }
        }

        this.lastExec = "";
        this.curExec = "";
        this.msg = null;
        
        var action = {
            clear: function() {
                this.main = "0";
                this.secondary = "0";
                this.symbol = "";
                this.toExec = null;
                return true;
            },
            percent: function(){
              
                var pct = (num(this.main) / 100) * num(this.secondary);
                this.main = str(pct);
                if(this.mathOp == "times"){  //if is times
                
                    this.toExec = function(){ return pct; };
                    this.secondary = str(pct);
                    
                }
                this.execTypes["operation"].call(this, "solve");
                return true;
            },
            cancel: function() {
                this.main = "0";
                if (this.secondary == "0") {
                    this.symbol = "";
                }
                return true;
            },
            backspace: function() {
                if (this.main.length > 1 && this.isNumberEntered) {
                    this.main = this.main.substr(0, this.main.length - 1);
                } else {
                    this.main = "0";
                }
                return true;
            },
            mr: function(){
            	this.main = str(this.memory);
                return true;
            },
            mc: function () {
            	this.memory = 0;
                return true;
            },
            mplus: function () {
            	this.memory += num(this.main);
            	var self = this;
            	this.numberAfter = function () {
            		self.main = "0";
            	}
                return true;
            }
        }

        this.execTypes = {
            operation: function(value) {
                
               
                if (operation[value].unary) {
                	operation[value].fn.call(this);
                } else {
                    if (this.curExec == this.lastExec) return;
                     
                    var val = num(this.main);
                    if (this.toExec && this.isNumberEntered) {
                        var val = this.toExec.call(this);
                    }
                    
                    if(this.isNumberEntered) this.secondary = str(val);

                    this.toExec = operation[value].fn;
                    this.symbol = operation[value].symbol;
                    this.mathOp = value;
                    this.main = str(0);

                }
                
                this.isNumberEntered = !operation[value].triggerClear;
                

                if (value == "solve") {
                    this.main = this.secondary;
                    this.secondary = "0";
                }
            },
            number: function(value) {
             this.isNumberEntered = true;
              if (this.numberAfter) {
            		this.numberAfter();
            		this.numberAfter = null;
            	}

                var old = this.main;
                if (value == ",") {
                    if (!~this.main.indexOf(",")) {
                        this.main += ",";
                    }
                } else {
                    this.main += value;
                    this.main = str(num(this.main));
                    if (!num(this.main)) {
                        this.main = old;
                    }
                }


            },
            action: function(value) {

                this.isNumberEntered = !!action[value].call(this);
                
            }
        }

        this.exec = function (type, value) {

        	this.curExec = type + "-" + value;
            this.msg = "";
            if (type != "refresh") {
            	this.execTypes[type].call(this, value);
				
            }
            this.lastExec = this.curExec;
            this.onupdate(this.main, this.secondary, this.symbol, !!this.memory, this.msg);

        };




    };

    w.Calc = Calc;

}(window));