function isTouchDevice() {
    var el = document.createElement('div');
    el.setAttribute('ongesturestart', 'return;'); // or try "ontouchstart"
    return typeof el.ongesturestart === "function";
}

function isMozillaNav() {
    return~ navigator.userAgent.toLowerCase().indexOf("gecko");
}

var themes = ["black","orange","natural"];

function nextTheme(to){
    
    if( !to ){
        var index = themes.indexOf(document.body.getAttribute("class"));
        to = themes[(index + 1 ) % themes.length]; 
    }

    document.body.setAttribute("class", "");
    document.body.classList.add(to);
    localStorage.setItem("skin", to);
}

window.addEventListener("load", function () {
    window.caudio = document.createElement("audio");
    window.caudio.volume = 0;
    window.caudio.src = "sound/click.mp3";
    
    
    window.caudio.autoplay = true;
    //document.body.appendChild(window.caudio);
    


    window.playSound = function(){
        if( !window.caudio.autoplay ) return;
        
        window.caudio.currentTime = 0;
        window.caudio.play();  
        //
        
    }

    var skin = localStorage.getItem("skin") || "black";

    window.caudio.pause();
    window.caudio.volume = 0.2;
   
    nextTheme(skin);

    var btnSkin = document.querySelector(".btn-skin");

    btnSkin.addEventListener("click", function(){
        
        nextTheme();

    });




    try {
        screen.lockOrientation('portrait');
    } catch (e) {}
    var isMozilla = isMozillaNav();
    var isTouch = isTouchDevice();
    var eventToHandle = "click";



    var calc = new Calc();
    var secValue = document.querySelector(".visor .secondary");
    var secOp = document.querySelector(".visor .big");
    var main = document.querySelector(".visor .main");
    var memory = document.querySelector(".visor .memory");

    calc.onupdate = function(mainNumber, secNumber, operation, hasMemory, msg) {
        
        if (secNumber == "0") secNumber = '\u00A0';

        secValue.textContent = secNumber;
        secOp.textContent =  (operation || '\u00A0') ;
        main.textContent = msg || mainNumber.replace(".", ",");
        if( main.textContent.length > 9 ) main.classList.add("small");
        else main.classList.remove("small");

        if (hasMemory) {
            memory.classList.add("show");
        } else {
            memory.classList.remove("show");
        }
    };

    calc.exec("refresh");

    if (isTouch) {
        eventToHandle = "touchend";
    }


    var buttons = [].slice.call(document.querySelectorAll(".keyboard-container button"));

    var muteBtn = document.querySelector(".btn-mute");
    var i = document.querySelector(".btn-mute i");

    if( localStorage.getItem("isMuted") ==  "true" ){
        i.classList.add("fa-volume-off");
        window.caudio.autoplay = false;
        i.classList.remove("fa-volume-up");
        
    }

    muteBtn.onclick =function(){
        localStorage.setItem("isMuted", window.caudio.autoplay ? "true" : "false    ");
        if( window.caudio.autoplay ){
            i.classList.add("fa-volume-off");
            window.caudio.autoplay = false;
            i.classList.remove("fa-volume-up");
        }else{

            i.classList.remove("fa-volume-off");
            window.caudio.autoplay = true;
            i.classList.add("fa-volume-up");
        }

    };

    buttons.forEach(function(button) {

        var classes = button.getAttribute("class");

        button.addEventListener(eventToHandle, function() {
        
            var button = this;
            window.playSound();

            var type = "";
            var value = "";


            if (~classes.indexOf("operation")) {
                type = "operation";
                value = button.getAttribute("data-operation");
            } else if (~classes.indexOf("action")) {
                type = "action";
                value = button.getAttribute("data-action");
            } else if (~classes.indexOf("number")) {
                type = "number";
                value = button.getAttribute("data-number");
            }

            
            calc.exec(type, value);
            

        });

    });



});