

/**
 *
 * METODOS
 * REVISADOS
 *
 * OK
 *
 */
/*******************************************
 * FUNCIONES BÁISCAS DE LA APP
 *******************************************
 */
/**
 * Obtención de la hora local para saber si actualizar el contenido o no según haya pasado cierto tiempo
 * @type {Date}
 */
var ahora = new Date();
sessionStorage.setItem('hora_actual',ahora);

/**
 * mensaje_consola()
 * Función para sacar mensajes por pantalla si estamos en el modo depuración
 * @param mensaje
 */
function mensaje_consola(mensaje){
    if(sessionStorage.getItem("depuracion") == "true"){
        console.log(mensaje);
    }
}

/**
 * calcular_fecha(f_actual, f_guardada)
 * Función para calcular la direfencia de la fecha y hora actual con la que tenga almacenada
 * @param f_actual La fecha y hora actual
 * @param f_guardada La fecha y hora que se tenga guardada en localStorage
 * @retun true false dependiendo de si la fecha es mayor a 15 minutos o no
 */
function calcular_fecha(f_actual, f_guardada){
    f_act = Date.parse(f_actual);
    f_ant = Date.parse(f_guardada);
    diferencia = f_act - f_ant;
    //15 minutos de recarga 900000
    if(diferencia > 900000){
        return true;
    }else{
        return false;
    }
}
/**
 * Fecha_Hoy()
 * Método para sacar la fecha de hoy con un formato determinado
 * @returns date Variable con la fecha
 */
function Fecha_Hoy(){
    var d = new Date();
    var day = d.getDate();
    var month = d.getMonth() + 1;
    var year = d.getFullYear();
    if (day < 10) {
        day = "0" + day;
    }
    if (month < 10) {
        month = "0" + month;
    }
    var date = year + "-" + month + "-" + day;
    return date;
}

/**
 * Generar_Firma()
 * Método para generar la firma con un código junto con la fecha diaria
 * @returns aux Variable con el resultado del md5 de nuestro codigo y fecha.
 */
function Generar_Firma(cadena) {
    var hoy =new Date();
    var clave = "OENC67hfdg34KJyHG5749U";
    var aux = Fecha_Hoy();
    aux = aux + cadena + clave;
    aux = $.md5(aux);
    return aux;
}

/**
 * alerta_texto(texto)
 * Método para lanzar un alert de sistema
 * @param texto Variable con el texto a mostrar
 */
function alerta_texto(titulo,texto) {
    navigator.notification.alert(texto,null,titulo,'Aceptar');
}

/**
 * navegacion_inicio_portada()
 * función para cargar un index dependiendo de si es móvil o tablet
 */
function navegacion_inicio_portada() {
	$.mobile.changePage( compruebaInicio(), {transition: "none",reverse: false,changeHash: true,reloadPage: false});
}

/**
 * pagina_actual(capa)
 * Método para crear la cadena de acceso a las capas de los botones del catálogo según la página que se encuentre cargada en el momento
 * @param capa Variable con el id de la capa cargadora dónde queremos inyectar html
 * @returns aux Devuelve la cadena de acceso
 */
function pagina_actual(capa){
	var aux = "#" + $.mobile.activePage.attr('id') + " " + capa;
	return aux;
}

/**
 * errores_conexion(contenedorlistado)
 * metodo para mostrar por pantalla el error de que no hay noticias sin conexion
 * @param contenedorlistado
 */
function errores_conexion(contenedorlistado){
    $('.capa_anima_carga').css("display","none");
    $('.contenedor_alerta').css("display","inherit");
    $(contenedorlistado).css("display","none");
    $('.contenedor_alerta').append("<div style='width:100%; text-align:center; margin-top:150px;'><img src='./imagenes/alerta.png' /><br />No tiene datos en memoria.<br />Necesita Internet para cargarlos.</div>");
    $('.contenedor_alerta').animate({"opacity": 1}, 200);
}

/**
 * mostrar_contenido(contenedorlistado)
 * Método para mostrar el contenido de un listado, ocultando el cargando
 * @param contenedorlistado
 */
function mostrar_contenido(contenedorlistado){
    $('.capa_anima_carga').css("display","none");
    $(contenedorlistado).animate({"opacity": 1}, 0);
}




/**
 * actualizar_scrollpanel(contenedor)
 * @param contenedor variable con el contenedor a refrescar para el scroll del panel
 */
function actualiza_scroll(contenedor){
    scrollcontenido = new IScroll(contenedor, {
        scrollX: false,
        scrollY: true,
        click:true, // open click event
        scrollbars: false,
        useTransform: true,
        useTransition: false,
        probeType:1
    });

    setTimeout(function () {
        scrollcontenido.refresh();
    }, 500);
}
/**
 * actualizar_scrollpanel(contenedor)
 * @param contenedor variable con el contenedor a refrescar para el scroll del panel
 */
function actualiza_scrollpanel(contenedor){

    scrollpanel = new IScroll(contenedor, {
        scrollX: false,
        scrollY: true,
        click:true, // open click event
        scrollbars: false,
        useTransform: true,
        useTransition: false,
        probeType:1
    });

    setTimeout(function () {
        scrollpanel.refresh();
    }, 500);
}
/********************************************************************/









/**
 *
 * METODOS
 * REVISADOS
 *
 * OK
 *
 */
/*******************************************
 * ACCIONES DE ESTADO DE LA APP
 *******************************************
 */
/**
 * onOffline()
 * Acciones cuando no hay conexion
 */
function onOffline() {
    sessionStorage.setItem("estado_conexion","no");
    mensaje_consola("sin conexion");
    /*var idPagina = $.mobile.activePage.attr( "id" );

    switch(idPagina)
    {
        case 'secportada':
            //acciones portada
        break;
        case 'empresa':
            //acciones azgenda
        break;
        case 'noticias':
            //acciones contacto
        break;
        case 'actividades':
            //acciones contacto
        break;
        case 'galeria':
            //acciones contacto
        break;
        case 'documentos':
            //acciones contacto
        break;
        case 'sociales':
            //acciones contacto
        break;
    }*/
}
/**
 * onOnline()
 * Acciones cuando hay conexion
 */
function onOnline() {
	sessionStorage.setItem("estado_conexion","si");
    mensaje_consola("con conexion");

    /*var idPagina = $.mobile.activePage.attr( "id" );
    switch(idPagina)
    {
        case 'secportada':
            //acciones portada
        break;
        case 'empresa':
            //acciones azgenda
        break;
        case 'noticias':
            //acciones contacto
        break;
        case 'actividades':
            //acciones contacto
        break;
        case 'galeria':
            //acciones contacto
        break;
        case 'documentos':
            //acciones contacto
        break;
        case 'sociales':
            //acciones contacto
        break;
    }*/
}
/**
 * tipo_conexion()
 * Método que devuelve el tipo de conexion
 * @returns states estado de la conexion
 */
function tipo_conexion() {
    var networkState = navigator.connection && navigator.connection.type;
    //con un pequeño delay para que coja las conexiones
    setTimeout(function(){
        networkState = navigator.connection && navigator.connection.type;

        var states = {};
        states[Connection.UNKNOWN]  = 'Unknown connection';
        states[Connection.ETHERNET] = 'Ethernet connection';
        states[Connection.WIFI]     = 'WiFi connection';
        states[Connection.CELL_2G]  = 'Cell 2G connection';
        states[Connection.CELL_3G]  = 'Cell 3G connection';
        states[Connection.CELL_4G]  = 'Cell 4G connection';
        states[Connection.NONE]     = 'No network connection';

        return states[networkState];
    }, 300);
}
/**
 * comprobar_conexion()
 * Método que actualiza el valor del estado de la sesion en el sessionStorage
 */
function comprobar_conexion(){
    var conexion = tipo_conexion();
    if((conexion == "None")||(conexion == "Unknown connection")){
        sessionStorage.setItem("estado_conexion","no");
    }else{
        sessionStorage.setItem("estado_conexion","si");
    }
}
/**
 * salir_app()
 * Método para salir de la app
 */
function salir_app(){

    var mensaje_salida = traduccion_salir;
    var botones_salida = traduccion_boton_salir_cancelar;

    $("#p_salir").css("background","inherit");
    navigator.notification.confirm(mensaje_salida, onConfirmQuit, nombreapp, botones_salida);
}
function onConfirmQuit(button){
    if(button == "1"){
        sessionStorage.clear();
        navigator.app.exitApp();
    }
}



function traduccion_avisos(){
    //traducciones de los avisos
    switch(localStorage.getItem("idioma")){
        case 'es':
            traduccion_salir = "¿Desea salir de la App?";
            traduccion_boton_salir = "Salir";
            traduccion_boton_cancelar = "Cancelar";
            traduccion_boton_salir_cancelar = "Salir,Cancelar";
            traduccion_boton_aceptar = "Aceptar";
            traduccion_fallo_lectura = "Fallo en la lectura de datos. Inténtelo más tarde.";
        break;
        case 'en':
            traduccion_salir = "Do you want to exit the app?";
            traduccion_boton_salir = "Exit";
            traduccion_boton_cancelar = "Cancel";
            traduccion_boton_salir_cancelar = "Exit,Cancel";
            traduccion_boton_aceptar = "Ok";
            traduccion_fallo_lectura = "Failure reading data. Try again later.";
        break;
        case 'fr':
            traduccion_salir = "Voulez-vous quitter l'application?";
            traduccion_boton_salir = "Quitter";
            traduccion_boton_cancelar = "Annuler";
            traduccion_boton_salir_cancelar = "Quitter,Annuler";
            traduccion_boton_aceptar = "accepter";
            traduccion_fallo_lectura = "Données échec de lecture. Réessayez plus tard.";
        break;
        default:
            traduccion_salir = "¿Desea salir de la App?";
            traduccion_boton_salir = "Salir";
            traduccion_boton_cancelar = "Cancelar";
            traduccion_boton_salir_cancelar = "Salir,Cancelar";
            traduccion_boton_aceptar = "Aceptar";
            traduccion_fallo_lectura = "Fallo en la lectura de datos. Inténtelo más tarde.";
        break;
    }
}
/********************************************************************/




/**
 * abrir_linkedin()
 * función para abrir una ventana con twitter
 */
function abrir_linked(url) {
    window.open(url, '_system', 'location=yes');
}






/**
 *
 * METODOS
 * REVISADOS
 *
 * OK
 *
 */
/*******************************************
 * ACCIONES DE NAVEGACIÓN DE LA APP
 *******************************************
 */

/**
 * compruebaInicio()
 * Método para comprobar que tipo de inicio tenemos, si es de móvil o de tablet
 */
function compruebaInicio(){
    var url;
    if(sessionStorage.getItem("dispositivo") == "tablet"){
        url = "index-tablet.html";
    }else{
        url = "index.html";
    }
    return url;
}
/**
 * botonVolver()
 * Método con las acciones a realizar cuando pulsamos el botón de Android volver según la página en la que nos encontramos
 */
function botonVolver() {
    var idPagina = $.mobile.activePage.attr( "id" );
    // si estamos en portada
    if ((idPagina == 'secportada') || (idPagina == 'secportadatablet') || (idPagina == 'secportadaidioma') || (idPagina == 'secportadaidiomatablet')) {
        salir_app();
    } else {

        switch(idPagina)
        {
            case 'productos':
            case 'noticias':
            case 'rsociales':
            case 'localizacion':
            case 'calconut':
            case 'packaging':
            case 'live_productos':
                mensaje_consola("volvemmos a la portada");
                navegacion_inicio_portada();
            break;
            case 'live_quotation':
                $.mobile.changePage("live_productos.html", { transition: "none", reverse: true, changeHash: true, reloadPage: false });
            break;
            case 'configuracion':
                history.back(1);
                break;
            //PRODUCTOS
            case 'almendra':
            case 'pistacho':
            case 'nuez':
            case 'almendra_industrializada':
            case 'avellana':
            case 'cacahuete':
            case 'anacardo':
                $.mobile.changePage("productos.html", { transition: "none", reverse: true, changeHash: true, reloadPage: false });
            break;
            //DETALLE NOTICIA
            case 'detalle_noticia':
                $.mobile.changePage( "noticias.html", {transition: "none",reverse: true,changeHash: true,reloadPage: false});
            break;
            case 'detalle_galeria_noticia':
                if(sessionStorage.getItem("galeria_abierta") == "no"){
                    mensaje_consola("codigo para volver atras");
                    history.back(1);
                }else{
                    mensaje_consola("codigo para cerrar la foto y volver atras");
                    window.Code.PhotoSwipe.activeInstances[0].instance.hide();
                }
            break;
        }
    }
}

/**
 * cambio_pagina()
 * Método para cargar una página pasada por parámetro
 * aux: variable con el nombre de la nueva página a cargar, según el id del botón del que extraemos la cadena del nombre final
 */
function cambio_pagina(){
    final = sessionStorage.getItem("pagina_navegar");
    final = final + ".html";

    var transicion;


        transicion = "slidedown";



    if(($.mobile.activePage.attr( "id" ) == ("secportadaidioma"))||($.mobile.activePage.attr( "id" ) == ("secportadaidiomatablet"))){
        $.mobile.changePage( final, {
            transition: transicion,
            reverse: false,
            changeHash: true,
            reloadPage: false
        });
    }else{
        $.mobile.changePage( final, {
            transition: transicion,
            reverse: false,
            changeHash: true,
            reloadPage: false
        });
    }
}


/**
 * cambio_noticias()
 * Método para ir al detalle noticia
 */
function cambio_noticias(){
    var transicion;


        transicion = "slidedown";


    $.mobile.changePage( "detalle_noticia.html", {
    transition: transicion,
    reverse: false,
    changeHash: true,
    reloadPage: false
    });
}

/********************************************************************/









/**
 *
 * METODOS
 * REVISADOS
 *
 * OK
 *
 */
/*******************************************
 * BOTONES Y PANELES DE LA APP
 *******************************************
 */
function reestablecer_cabecera(boton){
    $(boton).css("background-color","inherit")
}
function vaciar_cabecera_portada(){
    //vaciamos menú portada para evitar aperturas del panel
    $('.capa_titulo_portada').empty();
}
function vaciar_cabecera(){
    //vaciamos menú portada para evitar aperturas del panel
    $('.capa_titulo_seccion').empty();
}

/**
 * function detalle_galeria(()
 * Método con las acciones de los botones que vamos a tener en la cabecera de la app
 */
function botones_cabecera(tipo) {

    switch(tipo) {
        case 'portada':
            $('.capa_titulo_portada').empty();
            $('.capa_titulo_portada').append('' +
                '<div class="boton_menu_cebecera izquierda_cabecera"><i class="fa fa-bars"></i></div>');
        break;
        case 'normal':
            $('.capa_titulo_seccion').append('' +
                '<div class="boton_menu_cebecera izquierda_cabecera"><i class="fa fa-bars"></i></div>' +
                '<div class="boton_volver_cebecera derecha_cabecera"><i class="fa fa-angle-left"></i></div>');
        break;
        case 'detalle_noticia':
            $('.capa_titulo_seccion').append('' +
                '<div class="boton_menu_cebecera izquierda_cabecera"><i class="fa fa-bars"></i></div>' +
                //'<div class="boton_compartir_cebecera secundario_cabecera" id="b_compartir_noticia" rel=""><i class="fa fa-share-alt"></i></div>' +
                '<div class="boton_volver_cebecera derecha_cabecera"><i class="fa fa-angle-left"></i></div>');

            //COMPARTIR CABECERA
            //Este evento sólo lo añadimos en un detalle de noticia, ya que este botón sólo existe ahí.
            /*$(document).on('vmousedown', ".boton_compartir_cebecera", function (event) {
                event.preventDefault();event.stopImmediatePropagation();
                $(this).css("background-color",color_boton_menucabecera);
                window.setTimeout('reestablecer_cabecera(".boton_compartir_cebecera")',respuestaboton);
            });
            $(document).on('vmouseup', ".boton_compartir_cebecera", function (event) {
                event.preventDefault();event.stopImmediatePropagation();
                $(this).css("background-color","inherit");

                var enlace = $(this).attr("rel");
                mensaje_consola("el enlace es -> " + enlace);
                window.plugins.socialsharing.share('Visita esta noticia de Indalweb, puede ser de tu interés.', null, null, enlace);
            });*/
        break;
    }

    //MENU CABECERA
    $(document).on('vmousedown', ".boton_menu_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background-color",color_boton_menucabecera);

        mySlidebars.slidebars.toggle('left');

        //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        //IMPORTANTE REFRESCAR EL SCROLL AL ABRIR, SINO NO FUNCIONA
        scrollpanel.refresh();
        //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

        window.setTimeout('reestablecer_cabecera(".boton_menu_cebecera")',respuestaboton);
    });
    $(document).on('vmouseup', ".boton_menu_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background-color","inherit");
    });

    //VOLVER CABECERA
    $(document).on('vmousedown', ".boton_volver_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background-color",color_boton_menucabecera);
        window.setTimeout('reestablecer_cabecera(".boton_volver_cebecera")',respuestaboton);
    });
    $(document).on('vmouseup', ".boton_volver_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background-color","inherit");
        botonVolver();
    });
}

/**
 * slidebars_app()
 * Método para crear el objeto slidebars, para los paneles. Una vez hecho, se refrescan los paneles.
 */
function slidebars_app(){
   mySlidebars = new $.slidebars();
    /*$('.sb-slidebar').on('click', function() {
        mySlidebars.slidebars.open('left');
    });*/
    setTimeout(function () {
            //scrollcontenido.refresh();
            //scrollpanel.refresh();
    }, 500);
}


/**
 * acciones_botones_panel()
 * Método para aplicar las acciones de pulsado al panel de la izquierda
 */
function acciones_botones_panel(){
   //eventos al pulsar en un boton del panel
    $(document).on('tap taphold', ".boton_panel", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();

        valor = $(this).attr("id");
        valor = valor.substring(2,valor.length);

        if(valor != ($.mobile.activePage.attr('id'))){
            $(this).css("background-color",color_boton_panel).css("color",color_texto_panel);

            if (valor == "salir") {
                window.setTimeout('salir_app()',respuestaboton);
            }else{
                if((valor == "index")||(valor == "secportada")||(valor == "secportadatablet")){
                    mySlidebars.slidebars.close();
                    //volvemos a activar el swiper de portada en caso de estar en ella
                    $('.sb-slidebar').on();
                    window.setTimeout("navegacion_inicio_portada()",respuestaboton);
                }else{
                    mySlidebars.slidebars.close();
                    $('.sb-slidebar').on();
                    sessionStorage.setItem("pagina_navegar", valor);
                    window.setTimeout("cambio_pagina()",respuestaboton);
                }
            }
        }
    });
}


/**
 * panel_izquierda(panel)
 * Método para añadir el contenido y activar las acciones en el panel de la izquierda de la App
 * @param panel Variable con el id del contenedor de carga del panel, que varia según la sección apra evitar errores en la carga
 * @param tipo Variable con el tipo de panel a cargar, público o privado.
 * Añadimos acciones sobre el boton Inicio del pie de la App
 */
function panel_izquierda(contenedor,tipo) {
    rutaslider = "#" + contenedor;
    var botones = contenedor + "_botones";
    var inyectabotones = "#" + botones;


    $("#slidebar_izquierda").empty().append('<div id="'+
        contenedor +'" class="deslizante_panel"><div class="scroller" id="'+
        botones+'"></div></div>');

    //tenemos un switch tipo para que si tenemos paneles no publicos se puedan añadir en tiempo de ejecución
    switch(tipo) {
        case 'productos':
            switch(localStorage.getItem("idioma")){
                case 'es':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">INICIO</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NOTICIAS</li>' +
                        '<li class="cabecera_panel" id="p_productos">PRODUCTOS</li>' +
                        '<li class="boton_panel sub" id="p_almendra">ALMENDRA</li>' +
                        '<li class="boton_panel sub" id="p_pistacho">PISTACHO</li>' +
                        '<li class="boton_panel sub" id="p_nuez">NUEZ</li>' +
                        '<li class="boton_panel sub" id="p_avellana">AVELLANA</li>' +
                        '<li class="boton_panel sub" id="p_cacahuete">CACAHUETE</li>' +
                        '<li class="boton_panel sub" id="p_almendra_industrializada">ALMENDRA INDUS.</li>' +
                        '<li class="boton_panel sub" id="p_anacardo">ANACARDO</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">LOCALIZACIÓN</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">CONFIGURACIÓN</li>' +
                    '</ul>');
                break;
                case 'en':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">HOME</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NEWS</li>' +
                        '<li class="cabecera_panel" id="p_productos">PRODUCTS</li>' +
                        '<li class="boton_panel sub" id="p_almendra">ALMOND</li>' +
                        '<li class="boton_panel sub" id="p_pistacho">PISTACHIO</li>' +
                        '<li class="boton_panel sub" id="p_nuez">WALNUT</li>' +
                        '<li class="boton_panel sub" id="p_avellana">HAZELNUT</li>' +
                        '<li class="boton_panel sub" id="p_cacahuete">PEANUT</li>' +
                        '<li class="boton_panel sub" id="p_almendra_industrializada">PROCESSED ALMOND</li>' +
                        '<li class="boton_panel sub" id="p_anacardo">CASHEW</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">LOCATION</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">SETTINGS</li>' +
                    '</ul>');
                break;
                case 'fr':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">ACCUEIL</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NOUVELLES</li>' +
                        '<li class="cabecera_panel" id="p_productos">PRODUITS</li>' +
                        '<li class="boton_panel sub" id="p_almendra">AMANDE</li>' +
                        '<li class="boton_panel sub" id="p_pistacho">PISTACHE</li>' +
                        '<li class="boton_panel sub" id="p_nuez">NOIX</li>' +
                        '<li class="boton_panel sub" id="p_avellana">NOISETTE</li>' +
                        '<li class="boton_panel sub" id="p_cacahuete">CACAHUÈTE</li>' +
                        '<li class="boton_panel sub" id="p_almendra_industrializada">AMANDE INDUS.</li>' +
                        '<li class="boton_panel sub" id="p_anacardo">CASHEW</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">SITUATION</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">PARAMÈTRES</li>' +
                    '</ul>');
                break;
            }
	        break;

	    case 'normal':
            switch(localStorage.getItem("idioma")){
                case 'es':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">INICIO</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NOTICIAS</li>' +
                        '<li class="boton_panel" id="p_productos">PRODUCTOS</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">LOCALIZACIÓN</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">CONFIGURACIÓN</li>' +
                    '</ul>');
                break;
                case 'en':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">HOME</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NEWS</li>' +
                        '<li class="boton_panel" id="p_productos">PRODUCTS</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">LOCATION</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">SETTINGS</li>' +
                    '</ul>');
                break;
                case 'fr':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">ACCUEIL</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NOUVELLES</li>' +
                        '<li class="boton_panel" id="p_productos">PRODUITS</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">SITUATION</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">PARAMÈTRES</li>' +
                    '</ul>');
                break;
            }
        break;

    }

    //acciones al pulsar en los botones del menu
    acciones_botones_panel();
    //este actualiza scroll es para crear el objeto SCROLL que luego actualizamos al abrir el panel
    actualiza_scrollpanel(rutaslider);

    //marcamos como activa la opción en el menú del panel
    var boton_panel = inyectabotones + " #p_" + ($.mobile.activePage.attr('id'));
    $(boton_panel).css("background-color","#FE9428").css("color","#fff");
}
/********************************************************************/
















/**
 *
 * METODOS
 * REVISADOS
 *
 *
 *
 */
/********************************************************************/
/** METODOS PAR ALA ORIENTACION **/
/********************************************************************/
/**
 * compruebaseccion(aux)
 * Método para según la orientación que le pasamos por parámetro, active u oculte capas según pa sección en la que esta.
 * @param aux Variable con la orientación a calcular
 */
function compruebaseccion(aux){
    var idPagina = $.mobile.activePage.attr( "id" );
    var orientacion = aux;

    if(sessionStorage.getItem("dispositivo") == "movil"){
        orientacion = "vertical";
    }else{
        mensaje_consola("es tablet");

        if(orientacion == "vertical"){
            //EN CASO DE QUE LA APP SOPORTARA CAMBIO DE ORIENTACIÓN EN TABLET, HABRÍA QUE MODIFICAR
            //LAS DISTINTAS PROPIEDADES DE CADA SECCIÓN EN VERTICAL
            //EN ESTE CASE DEL IF
            mensaje_consola("orientacion vertical");
            $(".full").css("background-color","#ececec");
            $("#sb-site, .sb-site-container").css("background-size","100% 100%");
        }
        if(orientacion == "horizontal"){
            mensaje_consola("orientación horizontal");

            //$(".contenedor_seccion").css("background","url(./imagenes/fondonosotros.jpg) top left no-repeat");
            //$(".contenedor_seccion").css("background-size","70%");

            $("#sb-site, .sb-site-container").css("background-repeat","no-repeat");
            $("#sb-site, .sb-site-container").css("background-size","70% 100%");

            //Por defecto reducimos el ancho, y ponemos un fondo lateral de una imagen
            $(".contenedor_seccion").css("background-image","url(../imagenes/fondo-pistachos.jpg) top left");
            $(".contenedor_seccion").css("background-size","70% 100%");
            //$("body").css("background-color", "#000");


            switch(idPagina) {
                case 'calconut':
                    $("#contenedor_detalle_calconut").css("width","70%");
                    $("#contenedor_adjuntos_calconut").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-nueces.jpg) top right #fff");
                    $("body").css("background-size","cover");
                    $("body").css("background-repeat","no-repeat");
                break;
                case 'live_quotation':
                    $("#contenedor_detalle_live_quotation").css("width","70%");
                    $("#contenedor_adjuntos_live_quotation").css("width","30%");
                    $("body").css("background", "url(../imagenes/fondo-pistachos.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;
                case 'noticias':
                    $("#contenedor_detalle_noticias").css("width","70%");
                    $("#contenedor_adjuntos_noticias").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-portada.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");

                    $(".signo_mas").removeClass("boton_mas_listado");
                    $(".signo_mas").addClass("boton_mas_listado_hor");

                break;
                case 'detalle_noticia':
                    $("#contenedor_detalle_detalle_noticia").css("width","70%");
                    $("#contenedor_adjuntos_detalle_noticia").css("width","30%").css("padding-top","50px");

                    $("body").css("background", "url(../imagenes/fondo-portada.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");

                break;

                case 'live_productos':
                    $("#contenedor_detalle_live_productos").css("width","70%");
                    $("#contenedor_adjuntos_live_productos").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-pistachos.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;
                case 'productos':
                    $("#contenedor_detalle_productos").css("width","70%");
                    $("#contenedor_adjuntos_productos").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-productos.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;

                case 'almendra':
                case 'pistacho':
                case 'nuez':
                case 'avellana':
                case 'cacahuete':
                case 'almendra_industrializada':
                case 'anacardo':
                    $("#sb-site, .sb-site-container").css("background-repeat","no-repeat");
                    $("#sb-site, .sb-site-container").css("background-size","100% 100%");
                break;




                case 'packaging':
                    $("#contenedor_detalle_packaging").css("width","70%");
                    $("#contenedor_adjuntos_packaging").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-cacahuetes.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;
                case 'localizacion':
                    $("#contenedor_detalle_localizacion").css("width","70%");
                    $("#contenedor_adjuntos_localizacion").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-productos.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;
                case 'rsociales':
                    $("#contenedor_detalle_rsociales").css("width","70%");
                    $("#contenedor_adjuntos_rsociales").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-portada.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;
                case 'configuracion':
                    $("#contenedor_detalle_configuracion").css("width","70%");
                    $("#contenedor_adjuntos_configuracion").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-portada.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;

            }
        }
    }
}
/**
 * cambioOrientacion()
 * Método para recalcular la orientación, destinado cada vez que se recarga una pagina que necesita de este cálculo, y que llama al método compruebaseccion() para hacer los cambios
 */
function cambioOrientacion(){

    //Como bloqueamos el giro, directamente ponemos los valores según tablet o movil
	if(sessionStorage.getItem("dispositivo") != "movil"){
        compruebaseccion("horizontal");
		/*switch(window.orientation)
		{
			case 180:
				compruebaseccion("horizontal");
				sessionStorage.setItem("orientacion","horizontal");
			break;
			case 0:
				compruebaseccion("horizontal");
				sessionStorage.setItem("orientacion","horizontal");
			break;
			case -90:
				compruebaseccion("vertical");
				sessionStorage.setItem("orientacion","vertical");
			break;
			case 90:
				compruebaseccion("vertical");
				sessionStorage.setItem("orientacion","vertical");
			break;
			case 270:
				compruebaseccion("vertical");
				sessionStorage.setItem("orientacion","vertical");
			break;
		}*/
	}else{
        compruebaseccion("vertical");
    }
}
/********************************************************************/









/**
 *
 * METODOS
 * REVISADOS
 *
 * OK
 *
 */
/********************************************************************/
/** PORTADA IDOMAS **/
/********************************************************************/


/**
 * comprobar_local()
 * método para comprobar si hay que cargar las banderas de la entrada o redireccionamos a un idioma porque lo tengamos en memoria
 */
function comprobar_local(){

    if ((localStorage.getItem("idioma") == null)||(localStorage.getItem("idioma") == "")) {
        inyectar_banderas_portada();
    }else{
        var ruta;
        if($.mobile.activePage.attr( "id" ) == ("secportadaidioma")){
            ruta = "./" + localStorage.getItem("idioma") + "/index.html";
        }else if($.mobile.activePage.attr( "id" ) == ("secportadaidiomatablet")){
            ruta = "./" + localStorage.getItem("idioma") + "/index-tablet.html";
        }

        $.mobile.changePage( ruta, {
            transition: "none",
            reverse: false,
            changeHash: true,
            reloadPage: false
        });
    }
}


/**
 * inyectar_banderas_portada()
 * método para inyectar las banderas en la portada
 */
function inyectar_banderas_portada() {
    $("#capa-cargadora-banderas").empty().append('' +
        '<div id="capa-banderas" class="capa-banderas-vertical">' +
        'Language<br />Idioma<br />Langue<br />' +
        '<div class="capa-bandera" id="bandera-en">' +
                '<img src="imagenes/svg/ban-en.svg" />' +
            '</div>' +
            '<div class="capa-bandera" id="bandera-es">' +
                '<img src="imagenes/svg/ban-es.svg" />' +
            '</div>' +
            '<div class="capa-bandera" id="bandera-fr">' +
                '<img src="imagenes/svg/ban-fr.svg" />' +
            '</div>' +
        '</div>');

    //activamos los scrolls y las acciones
    if($.mobile.activePage.attr( "id" ) == ("secportadaidioma")){
        actualiza_scroll("#deslizante_portada_idioma_movil");
    }else if($.mobile.activePage.attr( "id" ) == ("secportadaidiomatablet")){
        actualiza_scroll("#deslizante_portada_idioma_tablet");
    }
    botones_banderas_portada();
}

/**
 * redirigir_idioma(ruta)
 * en caso de que tengamos en memoria ya la entrada de un idioma, redirigimos directamente a ese
 * @param ruta
 */
function redirigir_idioma(ruta) {
    if (sessionStorage.getItem("dispositivo") == "tablet") {
        sessionStorage.setItem("pagina_navegar", ruta + localStorage.getItem("idioma") + "/index-tablet");
    }
    else {
        sessionStorage.setItem("pagina_navegar", ruta + localStorage.getItem("idioma") + "/index");
    }
    mensaje_consola(ruta + localStorage.getItem("idioma") + "/index");
    //Cargamos la pagina con un poco de retardo para simular el pulsado de botón
    cambio_pagina();
}


/**
 * botones_banderas_portada()
 * Metodo para entrar en un idioma al puldar en las banderas de la entrada de la app
 */
function botones_banderas_portada() {

    $(document).on('tap taphold', '.capa-bandera', function (event) {
        event.preventDefault();event.stopImmediatePropagation();

        idioma = $(this).attr("id");
        idioma = idioma.replace("bandera-", "");
        localStorage.setItem("idioma", idioma);
        mensaje_consola("El valor de idioma en portada es: " + idioma);

        redirigir_idioma("./");
    });
}


/**
 * botones_banderas()
 * método para cambiar el idioma si pulsamos en las banderas de la configuracion
 */
function botones_banderas() {

    $(document).on('tap taphold', '.capa-bandera-interior', function (event) {
        event.preventDefault();event.stopImmediatePropagation();

        idioma = $(this).attr("id");
        idioma = idioma.replace("bandera-", "");
        localStorage.setItem("idioma", idioma);
        mensaje_consola("El valor de idioma dentro es: " + idioma);
        redirigir_idioma("../");
    });
}
/********************************************************************/