/***** ACCIONES DE CARGA DE NOTICIAS ******/
/******************************************/

/****** funciones de carga del listado de noticias ******/
/**
 * insertar_noticias_dinamicas(contenedorlistado)
 * método para cargar las noticias desde el json haciendo llamada al servidor
 * @param contenedorlistado
 */
function insertar_noticias_dinamicas(contenedorlistado) {
    clase_aux='';
    if ((sessionStorage.getItem("dispositivo")=='tablet')&&(sessionStorage.getItem("orientacion")=='horizontal')){
        clase_aux='_hor';
    }

    $(contenedorlistado).animate({"opacity": 0}, 0);
    $.each(datos_en_memoria.noticias, function(i,noticia){
        var str= noticia.entradilla;
        str = str.substring(0,300) + "...";
        $(contenedorlistado).append('<div class="noticia_listado" id="not_' +
        noticia.idnoticia + '"><div class="signo_mas boton_mas_listado' + clase_aux + '">+</div><div class="contenido_noticia_listado">' +
        noticia.fecha +'<br/><span class="titular_listado">'+
        noticia.titulo +'</span><br/><br/>'+
        str +'</div></div>');
    });
}
/**
 * insertar_noticias_sinconexion(contenedorlistado)
 * método para cargar las noticias desde la memoria
 * @param contenedorlistado
 */
function insertar_noticias_sinconexion(contenedorlistado) {
    clase_aux = '';
    if ((sessionStorage.getItem("dispositivo") == 'tablet') && (sessionStorage.getItem("orientacion") == 'horizontal')) {
        clase_aux = '_hor';
    }
    $(contenedorlistado).animate({"opacity": 0}, 0);
    $.each(datos_en_memoria.noticias, function(i,noticia){
        $(contenedorlistado).append('<div class="noticia_listado" id="not_' +
        noticia.idnoticia + '"><div class="signo_mas boton_mas_listado' + clase_aux + '"><img src="./imagenes/boton_mas.png" alt=""/></div><div class="contenido_noticia_listado">' +
        noticia.fecha +'<br/><span class="titular_listado">'+
        noticia.titulo +'</span><br/><br/>'+
        noticia.entradilla +'</div></div>');
    });
}
/**
 * obtener_datos_noticias_locales()
 * metodo para guardar en la variable de datos_en_memoria las noticias del tipo elegido desde la memoria
 */
function obtener_datos_noticias_locales(){
    datos_en_memoria = JSON.parse(localStorage.getItem('info_noticias'));
}
/**
 * mostrar_contenido(contenedorlistado)
 * método para mostrar el contenido oculto desde un principio
 * @param contenedorlistado
 */
function mostrar_contenido(contenedorlistado){
    $('.capa_anima_carga').css("display","none");
    $(contenedorlistado).animate({"opacity": 1}, 0);
}
/**
 * cargar_noticias()
 * Método para cargar las noticias, crearlas e inyectarlas
 */
function cargar_noticias(){
	var noticia_memoria = sessionStorage.getItem('tipo_de_noticia_memoria');
	var noticia_actual = sessionStorage.getItem('tipo_de_noticia');
	var contenedorlistado = "#contenedor_detalle_listado_noticias";

    //5 - 9 - 10
	var url = ruta_aplicacion + 'noticias.ashx?idioma=' + localStorage.getItem("idioma");
    datos_recarga = localStorage.getItem('ultima_actualizacion_noticias');
    if ((datos_recarga == null)||(datos_recarga == "")) {
        mensaje_consola("datos_recarga vacio");
        datos_recarga = 0;
    }else{
        mensaje_consola("datos_recarga con datos");
    }


    //reseteo de la hora actual a la hora en la que se carga una noticia
    var ahora = new Date();
    sessionStorage.setItem('hora_actual',ahora);


        //HAY CONEXION, PERO NO HAY DATOS
        if((datos_en_memoria == null)||(calcular_fecha(sessionStorage.getItem('hora_actual'), datos_recarga) == true)||(noticia_actual != noticia_memoria)){
			//actualizamos el tipo de noticia en memoria
			sessionStorage.setItem('tipo_de_noticia_memoria',noticia_actual);
            mensaje_consola("entrada carga noticias nuevas");
            $.ajax({
				url: url,
                dataType: 'jsonp',
                data: {},
                global: false,
                cache: false,
                crossDomain: true,
                success: function(data){
                    //salvamos los datos en local con datos nuevos
					localStorage.setItem('info_noticias', JSON.stringify(data));
					datos_en_memoria = JSON.parse(localStorage.getItem('info_noticias'));
                    //Recorremos los datos para crear dinámicamente las noticias
                    insertar_noticias_dinamicas(contenedorlistado);
                    mostrar_contenido(contenedorlistado);

                    cambioOrientacion();
                    actualiza_scroll("#deslizante_noticias");

	                //$("#contenedor_carga_noticias").iscrollview().iscrollview("refresh");

                    //reseteo de la ultima actualizacion
                    var nueva_carga = new Date();
                    localStorage.setItem('ultima_actualizacion_noticias',nueva_carga);
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    alerta_texto('Calconut', traduccion_fallo_lectura);
                }
            });
        //HAY CONEXION Y HAY DATOS
        }else{
            mensaje_consola("hay conecion y datos");
            datos_en_memoria = JSON.parse(localStorage.getItem('info_noticias'));
			obtener_datos_noticias_locales();
            insertar_noticias_dinamicas(contenedorlistado);
            mostrar_contenido(contenedorlistado);

            cambioOrientacion();
            actualiza_scroll("#deslizante_noticias");
	        //$("#contenedor_carga_noticias").iscrollview().iscrollview("refresh");
        }

}
/**
 * botones_noticias()
 * Método con las acciones a realizar al pulsar en una noticia del listado
 */
function botones_noticias() {
    $(document).on('tap', ".noticia_listado", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background", "#666");
        $(this).css("color","#fff");
        var numero_noticia = $(this).attr("id");
        var numero_noticia = numero_noticia.substring(4,numero_noticia.length);
        sessionStorage.setItem("id_noticia",numero_noticia);
        window.setTimeout('cambio_noticias()',respuestaboton);
    });
}

/****** funciones de carga del listado de noticias ******/
/**
 * ver_galeria_noticia()
 * función de evento para ver una galería de una determinada noticia
 */
function ver_galeria_noticia(){
    $(document).on('tap', ".boton_ver_galeria", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","url(../imagenes/enlacegaleria.png) top left no-repeat #666").css("background-position","0 35%");
        sessionStorage.setItem("pagina_navegar", "detalle_galeria_noticia");
        window.setTimeout("cambio_pagina()",respuestaboton);
    });
}
/**
 * abrir_documento()
 * función para abrir una ventana con la url del documento
 */
function abrir_documento() {
	$(".boton_descargar_documento").css("background","url(../imagenes/enlacedocumento.png) top left no-repeat #f2f2f2");
	$(".boton_descargar_documento").css("color","#666");
	var url = sessionStorage.getItem("valor_documento");
	window.open(url, '_system', 'location=yes');
}
/**
 * descargar_documento_noticia()
 * función de evento para controlar el pulsado de la descarga de un documento en una noticia
 */
function descargar_documento_noticia(){
    $(document).on('tap', ".boton_descargar_documento", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","url(../imagenes/enlacedocumento.png) top left no-repeat #666");
        $(this).css("color","#fff");
        var aux = $(this).attr("rel");
        sessionStorage.setItem("valor_documento",aux);
        window.setTimeout("abrir_documento()",respuestaboton);
    });
}

function descargar_pdf() {
    window.open('http://www.calconut.com/pdf/brochure_2015.pdf', '_system', 'location=yes');
}

/**
 * detalle_noticia()
 * Método para cargar las noticias, crearlas e inyectarlas
 */
function detalle_noticia(){
    //titulo seccion de las noticias
    //$(".titulo_pagina h2").append("DETALLE NOTICIA");

	var contenedorinfo = pagina_actual("#contenedor_detalle_detalle_noticia");
	var contenedoradjuntos = pagina_actual("#contenedor_adjuntos_detalle_noticia");
	var traduccion_galeria;
    //Recuperamos los datos locales para tratarlos después
    datos_en_memoria = localStorage.getItem('detalle_noticia');


    var url = ruta_aplicacion + 'noticia.ashx?idioma=' + localStorage.getItem("idioma") + '&idnoticia=' + sessionStorage.getItem('id_noticia');
    mensaje_consola(url);
    //SI HAY CONEXION

        $.ajax({
            url: url,
            dataType: 'jsonp',
            data: {},
            global: false,
            cache: false,
            crossDomain: true,
            success: function(data){

                switch(localStorage.getItem("idioma")){
                    case 'es':
                        traduccion_galeria = "DETALLE GALERÍA";
                    break;
                    case 'en':
                        traduccion_galeria = "GALLERY DETAIL";
                    break;
                    case 'fr':
                        traduccion_galeria = "GALERIE DETAIL";
                    break;
                }

                //salvamos los datos en local
                localStorage.setItem('detalle_noticia', JSON.stringify(data));
                datos_en_memoria = JSON.parse(localStorage.getItem('detalle_noticia'));
                $(contenedorinfo).animate({"opacity": 0}, 0);
				//CARGA DE INFORMACION DE LA NOTICIA
                $.each(datos_en_memoria.noticia, function (i, noticia) {
                    $(".titulo_pagina h2").append(noticia.titulo);
                    $(contenedorinfo).append('<div class="contenido_detalle_noticia" style="width:100%; float:left;" id="noti_' +
                    noticia.idnoticia +'"><div style="width:94%; float:left; padding:15px 3%;"><span class="fecha_detalle_noticia">'+
                    noticia.fecha +'</span><br/><span class="titular_detalle_noticia">'+
                    noticia.titulo +'</span><br/><br/><span class="entradilla_detalle_noticia"><div class="foto_producto_catalogo"><img src="../imagenes/trans.png" style="background:url('+ noticia.zoomimagen +') top center no-repeat;background-size:cover;"></div>'+
                    noticia.entradilla +'</span><br/><br/><span class="detalle_detalle_noticia">'+
					noticia.detalle +'</span></div></div>');
					if (noticia.imagen == "") {$(".foto_producto_catalogo").css("display","none");}
                });

				//CARGA DE LA GALERIA DE LA NOTICIA
				if (datos_en_memoria.galeria.length != 0) {
                    mensaje_consola("SI TIENE GALERÍA");
				    $(contenedoradjuntos).append('<div class="boton_ver_galeria"><div style="color:#fff;">' + traduccion_galeria + '</div></div>');
					ver_galeria_noticia();
				}
				//CARGA DE LOS DOCUMENTOS DE LA NOTICIA
				if (datos_en_memoria.documentos.length != 0) {
                    mensaje_consola("SI TIENE DOCUMENTOS");
					$.each(datos_en_memoria.documentos, function(i,documento){
						$(contenedoradjuntos).append("<div class='boton_descargar_documento' rel='"+ documento.enlace +"'><div class='nombre_documento_noticia'>"+ documento.descripcion +"</div><br/></div>");
					});
					descargar_documento_noticia();
				}
                mostrar_contenido(contenedorinfo);

                actualiza_scroll("#deslizante_detalle_noticia");
                //$("#contenedor_carga_detalle_noticia").iscrollview().iscrollview("refresh");
             },
             error: function(XMLHttpRequest, textStatus, errorThrown) {
                 alerta_texto('Calconut', traduccion_fallo_lectura);
            }
        });

}

function enlaces_noticia() {
    $(document).on('tap taphold', ".entradilla_detalle_noticia a", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();
        aux = $(this).attr("rel");
        aux = aux.replace("\"", "");
        aux = aux.replace("\"", "");
        window.open(aux, '_system', 'location=yes');
    });
    $(document).on('tap taphold', ".detalle_detalle_noticia a", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();
        aux = $(this).attr("rel");
        aux = aux.replace("\"", "");
        aux = aux.replace("\"", "");
        window.open(aux, '_system', 'location=yes');
    });
}

