/*******************************************
 * DECLARACIÓN DE VARIABLES O CONSTANTES
 *******************************************
 */
sessionStorage.setItem("pagina_navegar","index");
sessionStorage.setItem("estado_conexion","si");

sessionStorage.setItem("id_noticia_actual","");
sessionStorage.setItem("id_galeria_actual","");

sessionStorage.setItem("detalle_noticia","");
sessionStorage.setItem("galeria_abierta","no");

sessionStorage.setItem("orientacion", "vertical");



//Otras variables
var scrollcontenido;
var scrollpanel;

var rutaslider;
var mySlidebars;

var respuestaboton = 150;//tiempo de retardo en hacer los timeout de los tap de los botones

var datos_en_memoria;
var datos_recarga;

var precios_en_memoria;


const ruta_aplicacion = "http://www.calconut.com/app/";
const codigo_analytics = "UA-23821002-11";
const nombreapp = "Calconut";

var traduccion_salir;
var traduccion_boton_salir;
var traduccion_boton_cancelar;
var traduccion_boton_salir_cancelar;
var traduccion_boton_aceptar;
var traduccion_fallo_lectura;


//DIRECCIONES REDES SOCIALES
const direccion_facebook = "https://www.facebook.com/Calconut/timeline/";
const direccion_twitter = "https://twitter.com/Calconut";
const direccion_linkedin = "https://www.linkedin.com/company/calconut";
const direccion_youtube = "http://www.youtube.com/user/Calconut";


//VARIABLES DE COLORES PREESTABLECIDAS
//cabecera
var color_boton_menucabecera = "#C9C9C9";
//panel
var color_boton_panel = "#FE9428";
//botones panel
var color_texto_panel = "#FFF";
var color_boton_portada = "#13487A";
//botones fichas
var color_ficha_botones = "#FE9428";
var color_resstablecer_ficha = "#FFF";


/********************************************************************/



/*******************************************
 * INICIALIZACIÓN DE LA APP
 *******************************************
 */
var app = {
    initialize: function() {
        this.bindEvents();
    },
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
    },
    onDeviceReady: function() {
        app.receivedEvent('deviceready');

        screen.lockOrientation('portrait-primary');

        sessionStorage.setItem("iddispositivo",device.uuid);
		sessionStorage.setItem("plataforma",device.platform);
    },
    // Update DOM on a Received Event
    receivedEvent: function(id) {
        mensaje_consola('Received Event: ' + id);
    },
    // result contains any message sent from the plugin call
    successHandler: function(result) {
        mensaje_consola('Callback Success! Result = '+result);
    },
    errorHandler:function(error) {
        mensaje_consola(error);
    }
};

app.initialize();
/********************************************************************/



/**
 *
 * METODOS
 * REVISADOS
 *
 * OK
 *
 */
/*******************************************
 * FUNCIONES BÁISCAS DE LA APP
 *******************************************
 */
/**
 * Obtención de la hora local para saber si actualizar el contenido o no según haya pasado cierto tiempo
 * @type {Date}
 */
var ahora = new Date();
sessionStorage.setItem('hora_actual',ahora);

/**
 * mensaje_consola()
 * Función para sacar mensajes por pantalla si estamos en el modo depuración
 * @param mensaje
 */
function mensaje_consola(mensaje){
    if(sessionStorage.getItem("depuracion") == "true"){
        console.log(mensaje);
    }
}

/**
 * calcular_fecha(f_actual, f_guardada)
 * Función para calcular la direfencia de la fecha y hora actual con la que tenga almacenada
 * @param f_actual La fecha y hora actual
 * @param f_guardada La fecha y hora que se tenga guardada en localStorage
 * @retun true false dependiendo de si la fecha es mayor a 15 minutos o no
 */
function calcular_fecha(f_actual, f_guardada){
    f_act = Date.parse(f_actual);
    f_ant = Date.parse(f_guardada);
    diferencia = f_act - f_ant;
    //15 minutos de recarga 900000
    if(diferencia > 900000){
        return true;
    }else{
        return false;
    }
}
/**
 * Fecha_Hoy()
 * Método para sacar la fecha de hoy con un formato determinado
 * @returns date Variable con la fecha
 */
function Fecha_Hoy(){
    var d = new Date();
    var day = d.getDate();
    var month = d.getMonth() + 1;
    var year = d.getFullYear();
    if (day < 10) {
        day = "0" + day;
    }
    if (month < 10) {
        month = "0" + month;
    }
    var date = year + "-" + month + "-" + day;
    return date;
}

/**
 * Generar_Firma()
 * Método para generar la firma con un código junto con la fecha diaria
 * @returns aux Variable con el resultado del md5 de nuestro codigo y fecha.
 */
function Generar_Firma(cadena) {
    var hoy =new Date();
    var clave = "OENC67hfdg34KJyHG5749U";
    var aux = Fecha_Hoy();
    aux = aux + cadena + clave;
    aux = $.md5(aux);
    return aux;
}

/**
 * alerta_texto(texto)
 * Método para lanzar un alert de sistema
 * @param texto Variable con el texto a mostrar
 */
function alerta_texto(titulo,texto) {
    navigator.notification.alert(texto,null,titulo,'Aceptar');
}

/**
 * navegacion_inicio_portada()
 * función para cargar un index dependiendo de si es móvil o tablet
 */
function navegacion_inicio_portada() {
	$.mobile.changePage( compruebaInicio(), {transition: "none",reverse: false,changeHash: true,reloadPage: false});
}

/**
 * pagina_actual(capa)
 * Método para crear la cadena de acceso a las capas de los botones del catálogo según la página que se encuentre cargada en el momento
 * @param capa Variable con el id de la capa cargadora dónde queremos inyectar html
 * @returns aux Devuelve la cadena de acceso
 */
function pagina_actual(capa){
	var aux = "#" + $.mobile.activePage.attr('id') + " " + capa;
	return aux;
}

/**
 * errores_conexion(contenedorlistado)
 * metodo para mostrar por pantalla el error de que no hay noticias sin conexion
 * @param contenedorlistado
 */
function errores_conexion(contenedorlistado){
    $('.capa_anima_carga').css("display","none");
    $('.contenedor_alerta').css("display","inherit");
    $(contenedorlistado).css("display","none");
    $('.contenedor_alerta').append("<div style='width:100%; text-align:center; margin-top:150px;'><img src='./imagenes/alerta.png' /><br />No tiene datos en memoria.<br />Necesita Internet para cargarlos.</div>");
    $('.contenedor_alerta').animate({"opacity": 1}, 200);
}

/**
 * mostrar_contenido(contenedorlistado)
 * Método para mostrar el contenido de un listado, ocultando el cargando
 * @param contenedorlistado
 */
function mostrar_contenido(contenedorlistado){
    $('.capa_anima_carga').css("display","none");
    $(contenedorlistado).animate({"opacity": 1}, 0);
}




/**
 * actualizar_scrollpanel(contenedor)
 * @param contenedor variable con el contenedor a refrescar para el scroll del panel
 */
function actualiza_scroll(contenedor){
    scrollcontenido = new IScroll(contenedor, {
        scrollX: false,
        scrollY: true,
        click:true, // open click event
        scrollbars: false,
        useTransform: true,
        useTransition: false,
        probeType:1
    });

    setTimeout(function () {
        scrollcontenido.refresh();
    }, 500);
}
/**
 * actualizar_scrollpanel(contenedor)
 * @param contenedor variable con el contenedor a refrescar para el scroll del panel
 */
function actualiza_scrollpanel(contenedor){

    scrollpanel = new IScroll(contenedor, {
        scrollX: false,
        scrollY: true,
        click:true, // open click event
        scrollbars: false,
        useTransform: true,
        useTransition: false,
        probeType:1
    });

    setTimeout(function () {
        scrollpanel.refresh();
    }, 500);
}
/********************************************************************/









/**
 *
 * METODOS
 * REVISADOS
 *
 * OK
 *
 */
/*******************************************
 * ACCIONES DE ESTADO DE LA APP
 *******************************************
 */
/**
 * onOffline()
 * Acciones cuando no hay conexion
 */
function onOffline() {
    sessionStorage.setItem("estado_conexion","no");
    mensaje_consola("sin conexion");
    /*var idPagina = $.mobile.activePage.attr( "id" );

    switch(idPagina)
    {
        case 'secportada':
            //acciones portada
        break;
        case 'empresa':
            //acciones azgenda
        break;
        case 'noticias':
            //acciones contacto
        break;
        case 'actividades':
            //acciones contacto
        break;
        case 'galeria':
            //acciones contacto
        break;
        case 'documentos':
            //acciones contacto
        break;
        case 'sociales':
            //acciones contacto
        break;
    }*/
}
/**
 * onOnline()
 * Acciones cuando hay conexion
 */
function onOnline() {
	sessionStorage.setItem("estado_conexion","si");
    mensaje_consola("con conexion");

    /*var idPagina = $.mobile.activePage.attr( "id" );
    switch(idPagina)
    {
        case 'secportada':
            //acciones portada
        break;
        case 'empresa':
            //acciones azgenda
        break;
        case 'noticias':
            //acciones contacto
        break;
        case 'actividades':
            //acciones contacto
        break;
        case 'galeria':
            //acciones contacto
        break;
        case 'documentos':
            //acciones contacto
        break;
        case 'sociales':
            //acciones contacto
        break;
    }*/
}
/**
 * tipo_conexion()
 * Método que devuelve el tipo de conexion
 * @returns states estado de la conexion
 */
function tipo_conexion() {
    var networkState = navigator.connection && navigator.connection.type;
    //con un pequeño delay para que coja las conexiones
    setTimeout(function(){
        networkState = navigator.connection && navigator.connection.type;

        var states = {};
        states[Connection.UNKNOWN]  = 'Unknown connection';
        states[Connection.ETHERNET] = 'Ethernet connection';
        states[Connection.WIFI]     = 'WiFi connection';
        states[Connection.CELL_2G]  = 'Cell 2G connection';
        states[Connection.CELL_3G]  = 'Cell 3G connection';
        states[Connection.CELL_4G]  = 'Cell 4G connection';
        states[Connection.NONE]     = 'No network connection';

        return states[networkState];
    }, 300);
}
/**
 * comprobar_conexion()
 * Método que actualiza el valor del estado de la sesion en el sessionStorage
 */
function comprobar_conexion(){
    var conexion = tipo_conexion();
    if((conexion == "None")||(conexion == "Unknown connection")){
        sessionStorage.setItem("estado_conexion","no");
    }else{
        sessionStorage.setItem("estado_conexion","si");
    }
}
/**
 * salir_app()
 * Método para salir de la app
 */
function salir_app(){

    var mensaje_salida = traduccion_salir;
    var botones_salida = traduccion_boton_salir_cancelar;

    $("#p_salir").css("background","inherit");
    navigator.notification.confirm(mensaje_salida, onConfirmQuit, nombreapp, botones_salida);
}
function onConfirmQuit(button){
    if(button == "1"){
        sessionStorage.clear();
        navigator.app.exitApp();
    }
}



function traduccion_avisos(){
    //traducciones de los avisos
    switch(localStorage.getItem("idioma")){
        case 'es':
            traduccion_salir = "¿Desea salir de la App?";
            traduccion_boton_salir = "Salir";
            traduccion_boton_cancelar = "Cancelar";
            traduccion_boton_salir_cancelar = "Salir,Cancelar";
            traduccion_boton_aceptar = "Aceptar";
            traduccion_fallo_lectura = "Fallo en la lectura de datos. Inténtelo más tarde.";
        break;
        case 'en':
            traduccion_salir = "Do you want to exit the app?";
            traduccion_boton_salir = "Exit";
            traduccion_boton_cancelar = "Cancel";
            traduccion_boton_salir_cancelar = "Exit,Cancel";
            traduccion_boton_aceptar = "Ok";
            traduccion_fallo_lectura = "Failure reading data. Try again later.";
        break;
        case 'fr':
            traduccion_salir = "Voulez-vous quitter l'application?";
            traduccion_boton_salir = "Quitter";
            traduccion_boton_cancelar = "Annuler";
            traduccion_boton_salir_cancelar = "Quitter,Annuler";
            traduccion_boton_aceptar = "accepter";
            traduccion_fallo_lectura = "Données échec de lecture. Réessayez plus tard.";
        break;
        default:
            traduccion_salir = "¿Desea salir de la App?";
            traduccion_boton_salir = "Salir";
            traduccion_boton_cancelar = "Cancelar";
            traduccion_boton_salir_cancelar = "Salir,Cancelar";
            traduccion_boton_aceptar = "Aceptar";
            traduccion_fallo_lectura = "Fallo en la lectura de datos. Inténtelo más tarde.";
        break;
    }
}
/********************************************************************/




/**
 * abrir_linkedin()
 * función para abrir una ventana con twitter
 */
function abrir_linked(url) {
    window.open(url, '_system', 'location=yes');
}






/**
 *
 * METODOS
 * REVISADOS
 *
 * OK
 *
 */
/*******************************************
 * ACCIONES DE NAVEGACIÓN DE LA APP
 *******************************************
 */

/**
 * compruebaInicio()
 * Método para comprobar que tipo de inicio tenemos, si es de móvil o de tablet
 */
function compruebaInicio(){
    var url;
    if(sessionStorage.getItem("dispositivo") == "tablet"){
        url = "index-tablet.html";
    }else{
        url = "index.html";
    }
    return url;
}
/**
 * botonVolver()
 * Método con las acciones a realizar cuando pulsamos el botón de Android volver según la página en la que nos encontramos
 */
function botonVolver() {
    var idPagina = $.mobile.activePage.attr( "id" );
    // si estamos en portada
    if ((idPagina == 'secportada') || (idPagina == 'secportadatablet') || (idPagina == 'secportadaidioma') || (idPagina == 'secportadaidiomatablet')) {
        salir_app();
    } else {

        switch(idPagina)
        {
            case 'productos':
            case 'noticias':
            case 'rsociales':
            case 'localizacion':
            case 'calconut':
            case 'packaging':
            case 'live_productos':
                mensaje_consola("volvemmos a la portada");
                navegacion_inicio_portada();
            break;
            case 'live_quotation':
                $.mobile.changePage("live_productos.html", { transition: "none", reverse: true, changeHash: true, reloadPage: false });
            break;
            case 'configuracion':
                history.back(1);
                break;
            //PRODUCTOS
            case 'almendra':
            case 'pistacho':
            case 'nuez':
            case 'almendra_industrializada':
            case 'avellana':
            case 'cacahuete':
            case 'anacardo':
                $.mobile.changePage("productos.html", { transition: "none", reverse: true, changeHash: true, reloadPage: false });
            break;
            //DETALLE NOTICIA
            case 'detalle_noticia':
                $.mobile.changePage( "noticias.html", {transition: "none",reverse: true,changeHash: true,reloadPage: false});
            break;
            case 'detalle_galeria_noticia':
                if(sessionStorage.getItem("galeria_abierta") == "no"){
                    mensaje_consola("codigo para volver atras");
                    history.back(1);
                }else{
                    mensaje_consola("codigo para cerrar la foto y volver atras");
                    window.Code.PhotoSwipe.activeInstances[0].instance.hide();
                }
            break;
        }
    }
}

/**
 * cambio_pagina()
 * Método para cargar una página pasada por parámetro
 * aux: variable con el nombre de la nueva página a cargar, según el id del botón del que extraemos la cadena del nombre final
 */
function cambio_pagina(){
    final = sessionStorage.getItem("pagina_navegar");
    final = final + ".html";

    var transicion;

    if(device.platform == "iOS"){
        transicion = "slidedown";
        mensaje_consola("transición de IOS");
    }else{
        transicion = "none";
    }

    if(($.mobile.activePage.attr( "id" ) == ("secportadaidioma"))||($.mobile.activePage.attr( "id" ) == ("secportadaidiomatablet"))){
        $.mobile.changePage( final, {
            transition: transicion,
            reverse: false,
            changeHash: true,
            reloadPage: false
        });
    }else{
        $.mobile.changePage( final, {
            transition: transicion,
            reverse: false,
            changeHash: true,
            reloadPage: false
        });
    }
}


/**
 * cambio_noticias()
 * Método para ir al detalle noticia
 */
function cambio_noticias(){
    var transicion;

    if(device.platform == "iOS"){
        transicion = "slidedown";
    }else{
        transicion = "none";
    }

    $.mobile.changePage( "detalle_noticia.html", {
    transition: transicion,
    reverse: false,
    changeHash: true,
    reloadPage: false
    });
}

/********************************************************************/









/**
 *
 * METODOS
 * REVISADOS
 *
 * OK
 *
 */
/*******************************************
 * BOTONES Y PANELES DE LA APP
 *******************************************
 */
function reestablecer_cabecera(boton){
    $(boton).css("background-color","inherit")
}
function vaciar_cabecera_portada(){
    //vaciamos menú portada para evitar aperturas del panel
    $('.capa_titulo_portada').empty();
}
function vaciar_cabecera(){
    //vaciamos menú portada para evitar aperturas del panel
    $('.capa_titulo_seccion').empty();
}

/**
 * function detalle_galeria(()
 * Método con las acciones de los botones que vamos a tener en la cabecera de la app
 */
function botones_cabecera(tipo) {

    switch(tipo) {
        case 'portada':
            $('.capa_titulo_portada').empty();
            $('.capa_titulo_portada').append('' +
                '<div class="boton_menu_cebecera izquierda_cabecera"><i class="fa fa-bars"></i></div>');
        break;
        case 'normal':
            $('.capa_titulo_seccion').append('' +
                '<div class="boton_menu_cebecera izquierda_cabecera"><i class="fa fa-bars"></i></div>' +
                '<div class="boton_volver_cebecera derecha_cabecera"><i class="fa fa-angle-left"></i></div>');
        break;
        case 'detalle_noticia':
            $('.capa_titulo_seccion').append('' +
                '<div class="boton_menu_cebecera izquierda_cabecera"><i class="fa fa-bars"></i></div>' +
                //'<div class="boton_compartir_cebecera secundario_cabecera" id="b_compartir_noticia" rel=""><i class="fa fa-share-alt"></i></div>' +
                '<div class="boton_volver_cebecera derecha_cabecera"><i class="fa fa-angle-left"></i></div>');

            //COMPARTIR CABECERA
            //Este evento sólo lo añadimos en un detalle de noticia, ya que este botón sólo existe ahí.
            /*$(document).on('vmousedown', ".boton_compartir_cebecera", function (event) {
                event.preventDefault();event.stopImmediatePropagation();
                $(this).css("background-color",color_boton_menucabecera);
                window.setTimeout('reestablecer_cabecera(".boton_compartir_cebecera")',respuestaboton);
            });
            $(document).on('vmouseup', ".boton_compartir_cebecera", function (event) {
                event.preventDefault();event.stopImmediatePropagation();
                $(this).css("background-color","inherit");

                var enlace = $(this).attr("rel");
                mensaje_consola("el enlace es -> " + enlace);
                window.plugins.socialsharing.share('Visita esta noticia de Indalweb, puede ser de tu interés.', null, null, enlace);
            });*/
        break;
    }

    //MENU CABECERA
    $(document).on('vmousedown', ".boton_menu_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background-color",color_boton_menucabecera);

        mySlidebars.slidebars.toggle('left');

        //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        //IMPORTANTE REFRESCAR EL SCROLL AL ABRIR, SINO NO FUNCIONA
        scrollpanel.refresh();
        //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

        window.setTimeout('reestablecer_cabecera(".boton_menu_cebecera")',respuestaboton);
    });
    $(document).on('vmouseup', ".boton_menu_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background-color","inherit");
    });

    //VOLVER CABECERA
    $(document).on('vmousedown', ".boton_volver_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background-color",color_boton_menucabecera);
        window.setTimeout('reestablecer_cabecera(".boton_volver_cebecera")',respuestaboton);
    });
    $(document).on('vmouseup', ".boton_volver_cebecera", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background-color","inherit");
        botonVolver();
    });
}

/**
 * slidebars_app()
 * Método para crear el objeto slidebars, para los paneles. Una vez hecho, se refrescan los paneles.
 */
function slidebars_app(){
   mySlidebars = new $.slidebars();
    /*$('.sb-slidebar').on('click', function() {
        mySlidebars.slidebars.open('left');
    });*/
    setTimeout(function () {
            //scrollcontenido.refresh();
            //scrollpanel.refresh();
    }, 500);
}


/**
 * acciones_botones_panel()
 * Método para aplicar las acciones de pulsado al panel de la izquierda
 */
function acciones_botones_panel(){
   //eventos al pulsar en un boton del panel
    $(document).on('tap taphold', ".boton_panel", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();

        valor = $(this).attr("id");
        valor = valor.substring(2,valor.length);

        if(valor != ($.mobile.activePage.attr('id'))){
            $(this).css("background-color",color_boton_panel).css("color",color_texto_panel);

            if (valor == "salir") {
                window.setTimeout('salir_app()',respuestaboton);
            }else{
                if((valor == "index")||(valor == "secportada")||(valor == "secportadatablet")){
                    mySlidebars.slidebars.close();
                    //volvemos a activar el swiper de portada en caso de estar en ella
                    $('.sb-slidebar').on();
                    window.setTimeout("navegacion_inicio_portada()",respuestaboton);
                }else{
                    mySlidebars.slidebars.close();
                    $('.sb-slidebar').on();
                    sessionStorage.setItem("pagina_navegar", valor);
                    window.setTimeout("cambio_pagina()",respuestaboton);
                }
            }
        }
    });
}


/**
 * panel_izquierda(panel)
 * Método para añadir el contenido y activar las acciones en el panel de la izquierda de la App
 * @param panel Variable con el id del contenedor de carga del panel, que varia según la sección apra evitar errores en la carga
 * @param tipo Variable con el tipo de panel a cargar, público o privado.
 * Añadimos acciones sobre el boton Inicio del pie de la App
 */
function panel_izquierda(contenedor,tipo) {
    rutaslider = "#" + contenedor;
    var botones = contenedor + "_botones";
    var inyectabotones = "#" + botones;


    $("#slidebar_izquierda").empty().append('<div id="'+
        contenedor +'" class="deslizante_panel"><div class="scroller" id="'+
        botones+'"></div></div>');

    //tenemos un switch tipo para que si tenemos paneles no publicos se puedan añadir en tiempo de ejecución
    switch(tipo) {
        case 'productos':
            switch(localStorage.getItem("idioma")){
                case 'es':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">INICIO</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NOTICIAS</li>' +
                        '<li class="cabecera_panel" id="p_productos">PRODUCTOS</li>' +
                        '<li class="boton_panel sub" id="p_almendra">ALMENDRA</li>' +
                        '<li class="boton_panel sub" id="p_pistacho">PISTACHO</li>' +
                        '<li class="boton_panel sub" id="p_nuez">NUEZ</li>' +
                        '<li class="boton_panel sub" id="p_avellana">AVELLANA</li>' +
                        '<li class="boton_panel sub" id="p_cacahuete">CACAHUETE</li>' +
                        '<li class="boton_panel sub" id="p_almendra_industrializada">ALMENDRA INDUS.</li>' +
                        '<li class="boton_panel sub" id="p_anacardo">ANACARDO</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">LOCALIZACIÓN</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">CONFIGURACIÓN</li>' +
                    '</ul>');
                break;
                case 'en':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">HOME</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NEWS</li>' +
                        '<li class="cabecera_panel" id="p_productos">PRODUCTS</li>' +
                        '<li class="boton_panel sub" id="p_almendra">ALMOND</li>' +
                        '<li class="boton_panel sub" id="p_pistacho">PISTACHIO</li>' +
                        '<li class="boton_panel sub" id="p_nuez">WALNUT</li>' +
                        '<li class="boton_panel sub" id="p_avellana">HAZELNUT</li>' +
                        '<li class="boton_panel sub" id="p_cacahuete">PEANUT</li>' +
                        '<li class="boton_panel sub" id="p_almendra_industrializada">PROCESSED ALMOND</li>' +
                        '<li class="boton_panel sub" id="p_anacardo">CASHEW</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">LOCATION</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">SETTINGS</li>' +
                    '</ul>');
                break;
                case 'fr':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">ACCUEIL</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NOUVELLES</li>' +
                        '<li class="cabecera_panel" id="p_productos">PRODUITS</li>' +
                        '<li class="boton_panel sub" id="p_almendra">AMANDE</li>' +
                        '<li class="boton_panel sub" id="p_pistacho">PISTACHE</li>' +
                        '<li class="boton_panel sub" id="p_nuez">NOIX</li>' +
                        '<li class="boton_panel sub" id="p_avellana">NOISETTE</li>' +
                        '<li class="boton_panel sub" id="p_cacahuete">CACAHUÈTE</li>' +
                        '<li class="boton_panel sub" id="p_almendra_industrializada">AMANDE INDUS.</li>' +
                        '<li class="boton_panel sub" id="p_anacardo">CASHEW</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">SITUATION</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">PARAMÈTRES</li>' +
                    '</ul>');
                break;
            }
	        break;

	    case 'normal':
            switch(localStorage.getItem("idioma")){
                case 'es':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">INICIO</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NOTICIAS</li>' +
                        '<li class="boton_panel" id="p_productos">PRODUCTOS</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">LOCALIZACIÓN</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">CONFIGURACIÓN</li>' +
                    '</ul>');
                break;
                case 'en':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">HOME</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NEWS</li>' +
                        '<li class="boton_panel" id="p_productos">PRODUCTS</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">LOCATION</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">SETTINGS</li>' +
                    '</ul>');
                break;
                case 'fr':
                    $(inyectabotones).append('' +
                    '<ul>' +
                        '<li class="cabecera_panel">MENU</li>' +
                        '<li class="boton_panel" id="p_index">ACCUEIL</li>' +
                        '<li class="boton_panel" id="p_calconut">CALCONUT</li>' +
                        '<li class="boton_panel" id="p_live_productos">LIVE QUOTATION</li>' +
                        '<li class="boton_panel" id="p_noticias">NOUVELLES</li>' +
                        '<li class="boton_panel" id="p_productos">PRODUITS</li>' +
                        '<li class="boton_panel" id="p_packaging">PACKAGING</li>' +
                        '<li class="boton_panel" id="p_localizacion">SITUATION</li>' +
                        '<li class="boton_panel" id="p_rsociales">SOCIAL MEDIA</li>' +
                        '<li class="boton_panel" id="p_configuracion">PARAMÈTRES</li>' +
                    '</ul>');
                break;
            }
        break;

    }

    //acciones al pulsar en los botones del menu
    acciones_botones_panel();
    //este actualiza scroll es para crear el objeto SCROLL que luego actualizamos al abrir el panel
    actualiza_scrollpanel(rutaslider);

    //marcamos como activa la opción en el menú del panel
    var boton_panel = inyectabotones + " #p_" + ($.mobile.activePage.attr('id'));
    $(boton_panel).css("background-color","#FE9428").css("color","#fff");
}
/********************************************************************/
















/**
 *
 * METODOS
 * REVISADOS
 *
 *
 *
 */
/********************************************************************/
/** METODOS PAR ALA ORIENTACION **/
/********************************************************************/
/**
 * compruebaseccion(aux)
 * Método para según la orientación que le pasamos por parámetro, active u oculte capas según pa sección en la que esta.
 * @param aux Variable con la orientación a calcular
 */
function compruebaseccion(aux){
    var idPagina = $.mobile.activePage.attr( "id" );
    var orientacion = aux;

    if(sessionStorage.getItem("dispositivo") == "movil"){
        orientacion = "vertical";
    }else{
        mensaje_consola("es tablet");

        if(orientacion == "vertical"){
            //EN CASO DE QUE LA APP SOPORTARA CAMBIO DE ORIENTACIÓN EN TABLET, HABRÍA QUE MODIFICAR
            //LAS DISTINTAS PROPIEDADES DE CADA SECCIÓN EN VERTICAL
            //EN ESTE CASE DEL IF
            mensaje_consola("orientacion vertical");
            $(".full").css("background-color","#ececec");
            $("#sb-site, .sb-site-container").css("background-size","100% 100%");
        }
        if(orientacion == "horizontal"){
            mensaje_consola("orientación horizontal");

            //$(".contenedor_seccion").css("background","url(./imagenes/fondonosotros.jpg) top left no-repeat");
            //$(".contenedor_seccion").css("background-size","70%");

            $("#sb-site, .sb-site-container").css("background-repeat","no-repeat");
            $("#sb-site, .sb-site-container").css("background-size","70% 100%");

            //Por defecto reducimos el ancho, y ponemos un fondo lateral de una imagen
            $(".contenedor_seccion").css("background-image","url(../imagenes/fondo-pistachos.jpg) top left");
            $(".contenedor_seccion").css("background-size","70% 100%");
            //$("body").css("background-color", "#000");


            switch(idPagina) {
                case 'calconut':
                    $("#contenedor_detalle_calconut").css("width","70%");
                    $("#contenedor_adjuntos_calconut").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-nueces.jpg) top right #fff");
                    $("body").css("background-size","cover");
                    $("body").css("background-repeat","no-repeat");
                break;
                case 'live_quotation':
                    $("#contenedor_detalle_live_quotation").css("width","70%");
                    $("#contenedor_adjuntos_live_quotation").css("width","30%");
                    $("body").css("background", "url(../imagenes/fondo-pistachos.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;
                case 'noticias':
                    $("#contenedor_detalle_noticias").css("width","70%");
                    $("#contenedor_adjuntos_noticias").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-portada.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");

                    $(".signo_mas").removeClass("boton_mas_listado");
                    $(".signo_mas").addClass("boton_mas_listado_hor");

                break;
                case 'detalle_noticia':
                    $("#contenedor_detalle_detalle_noticia").css("width","70%");
                    $("#contenedor_adjuntos_detalle_noticia").css("width","30%").css("padding-top","50px");

                    $("body").css("background", "url(../imagenes/fondo-portada.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");

                break;

                case 'live_productos':
                    $("#contenedor_detalle_live_productos").css("width","70%");
                    $("#contenedor_adjuntos_live_productos").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-pistachos.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;
                case 'productos':
                    $("#contenedor_detalle_productos").css("width","70%");
                    $("#contenedor_adjuntos_productos").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-productos.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;

                case 'almendra':
                case 'pistacho':
                case 'nuez':
                case 'avellana':
                case 'cacahuete':
                case 'almendra_industrializada':
                case 'anacardo':
                    $("#sb-site, .sb-site-container").css("background-repeat","no-repeat");
                    $("#sb-site, .sb-site-container").css("background-size","100% 100%");
                break;




                case 'packaging':
                    $("#contenedor_detalle_packaging").css("width","70%");
                    $("#contenedor_adjuntos_packaging").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-cacahuetes.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;
                case 'localizacion':
                    $("#contenedor_detalle_localizacion").css("width","70%");
                    $("#contenedor_adjuntos_localizacion").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-productos.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;
                case 'rsociales':
                    $("#contenedor_detalle_rsociales").css("width","70%");
                    $("#contenedor_adjuntos_rsociales").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-portada.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;
                case 'configuracion':
                    $("#contenedor_detalle_configuracion").css("width","70%");
                    $("#contenedor_adjuntos_configuracion").css("width","30%");

                    $("body").css("background", "url(../imagenes/fondo-portada.jpg) top right #fff");
                    $("body").css("background-size", "cover");
                    $("body").css("background-repeat", "no-repeat");
                break;

            }
        }
    }
}
/**
 * cambioOrientacion()
 * Método para recalcular la orientación, destinado cada vez que se recarga una pagina que necesita de este cálculo, y que llama al método compruebaseccion() para hacer los cambios
 */
function cambioOrientacion(){

    //Como bloqueamos el giro, directamente ponemos los valores según tablet o movil
	if(sessionStorage.getItem("dispositivo") != "movil"){
        compruebaseccion("horizontal");
		/*switch(window.orientation)
		{
			case 180:
				compruebaseccion("horizontal");
				sessionStorage.setItem("orientacion","horizontal");
			break;
			case 0:
				compruebaseccion("horizontal");
				sessionStorage.setItem("orientacion","horizontal");
			break;
			case -90:
				compruebaseccion("vertical");
				sessionStorage.setItem("orientacion","vertical");
			break;
			case 90:
				compruebaseccion("vertical");
				sessionStorage.setItem("orientacion","vertical");
			break;
			case 270:
				compruebaseccion("vertical");
				sessionStorage.setItem("orientacion","vertical");
			break;
		}*/
	}else{
        compruebaseccion("vertical");
    }
}
/********************************************************************/









/**
 *
 * METODOS
 * REVISADOS
 *
 * OK
 *
 */
/********************************************************************/
/** PORTADA IDOMAS **/
/********************************************************************/


/**
 * comprobar_local()
 * método para comprobar si hay que cargar las banderas de la entrada o redireccionamos a un idioma porque lo tengamos en memoria
 */
function comprobar_local(){

    if ((localStorage.getItem("idioma") == null)||(localStorage.getItem("idioma") == "")) {
        inyectar_banderas_portada();
    }else{
        var ruta;
        if($.mobile.activePage.attr( "id" ) == ("secportadaidioma")){
            ruta = "./" + localStorage.getItem("idioma") + "/index.html";
        }else if($.mobile.activePage.attr( "id" ) == ("secportadaidiomatablet")){
            ruta = "./" + localStorage.getItem("idioma") + "/index-tablet.html";
        }

        $.mobile.changePage( ruta, {
            transition: "none",
            reverse: false,
            changeHash: true,
            reloadPage: false
        });
    }
}


/**
 * inyectar_banderas_portada()
 * método para inyectar las banderas en la portada
 */
function inyectar_banderas_portada() {
    $("#capa-cargadora-banderas").empty().append('' +
        '<div id="capa-banderas" class="capa-banderas-vertical">' +
        'Language<br />Idioma<br />Langue<br />' +
        '<div class="capa-bandera" id="bandera-en">' +
                '<img src="imagenes/svg/ban-en.svg" />' +
            '</div>' +
            '<div class="capa-bandera" id="bandera-es">' +
                '<img src="imagenes/svg/ban-es.svg" />' +
            '</div>' +
            '<div class="capa-bandera" id="bandera-fr">' +
                '<img src="imagenes/svg/ban-fr.svg" />' +
            '</div>' +
        '</div>');

    //activamos los scrolls y las acciones
    if($.mobile.activePage.attr( "id" ) == ("secportadaidioma")){
        actualiza_scroll("#deslizante_portada_idioma_movil");
    }else if($.mobile.activePage.attr( "id" ) == ("secportadaidiomatablet")){
        actualiza_scroll("#deslizante_portada_idioma_tablet");
    }
    botones_banderas_portada();
}

/**
 * redirigir_idioma(ruta)
 * en caso de que tengamos en memoria ya la entrada de un idioma, redirigimos directamente a ese
 * @param ruta
 */
function redirigir_idioma(ruta) {
    if (sessionStorage.getItem("dispositivo") == "tablet") {
        sessionStorage.setItem("pagina_navegar", ruta + localStorage.getItem("idioma") + "/index-tablet");
    }
    else {
        sessionStorage.setItem("pagina_navegar", ruta + localStorage.getItem("idioma") + "/index");
    }
    mensaje_consola(ruta + localStorage.getItem("idioma") + "/index");
    //Cargamos la pagina con un poco de retardo para simular el pulsado de botón
    cambio_pagina();
}


/**
 * botones_banderas_portada()
 * Metodo para entrar en un idioma al puldar en las banderas de la entrada de la app
 */
function botones_banderas_portada() {

    $(document).on('tap taphold', '.capa-bandera', function (event) {
        event.preventDefault();event.stopImmediatePropagation();

        idioma = $(this).attr("id");
        idioma = idioma.replace("bandera-", "");
        localStorage.setItem("idioma", idioma);
        mensaje_consola("El valor de idioma en portada es: " + idioma);

        redirigir_idioma("./");
    });
}


/**
 * botones_banderas()
 * método para cambiar el idioma si pulsamos en las banderas de la configuracion
 */
function botones_banderas() {

    $(document).on('tap taphold', '.capa-bandera-interior', function (event) {
        event.preventDefault();event.stopImmediatePropagation();

        idioma = $(this).attr("id");
        idioma = idioma.replace("bandera-", "");
        localStorage.setItem("idioma", idioma);
        mensaje_consola("El valor de idioma dentro es: " + idioma);
        redirigir_idioma("../");
    });
}
/********************************************************************/

/**
 *
 * METODOS
 * REVISADOS
 *
 * OK
 *
 */
/********************************************************************/
/** INYECCION DE LOS BOTONES DEL INICIO (SECCION HOME) DE LA APP **/
/********************************************************************/
/**
 * inyectar_botones_portada()
 * Método para inyectar los botones a la portada de la app
 */
function inyectar_botones_portada() {

    switch(localStorage.getItem("idioma")){
        case 'es':
            $("#capa-botonera").empty().append('<div class="boton-menu-inicio" id="boton-calconut">CALCONUT</div>' +
            '<div class="boton-menu-inicio" id="boton-live_productos">LIVE QUOTATION</div>' +
            '<div class="boton-menu-inicio" id="boton-noticias">NOTICIAS</div>' +
            '<div class="boton-menu-inicio" id="boton-productos">PRODUCTOS</div>' +
            '<div class="boton-menu-inicio" id="boton-packaging">PACKAGING</div>' +
            '<div class="boton-menu-inicio" id="boton-localizacion">LOCALIZACIÓN</div>' +
            '<div class="boton-menu-inicio" id="boton-rsociales">SOCIAL MEDIA</div>');
        break;
        case 'en':
            $("#capa-botonera").empty().append('<div class="boton-menu-inicio" id="boton-calconut">CALCONUT</div>' +
            '<div class="boton-menu-inicio" id="boton-live_productos">LIVE QUOTATION</div>' +
            '<div class="boton-menu-inicio" id="boton-noticias">NEWS</div>' +
            '<div class="boton-menu-inicio" id="boton-productos">PRODUCTS</div>' +
            '<div class="boton-menu-inicio" id="boton-packaging">PACKAGING</div>' +
            '<div class="boton-menu-inicio" id="boton-localizacion">LOCATION</div>' +
            '<div class="boton-menu-inicio" id="boton-rsociales">SOCIAL MEDIA</div>');
        break;
        case 'fr':
            $("#capa-botonera").empty().append('<div class="boton-menu-inicio" id="boton-calconut">CALCONUT</div>' +
            '<div class="boton-menu-inicio" id="boton-live_productos">LIVE QUOTATION</div>' +
            '<div class="boton-menu-inicio" id="boton-noticias">NOUVELLES</div>' +
            '<div class="boton-menu-inicio" id="boton-productos">PRODUITS</div>' +
            '<div class="boton-menu-inicio" id="boton-packaging">PACKAGING</div>' +
            '<div class="boton-menu-inicio" id="boton-localizacion">SITUATION</div>' +
            '<div class="boton-menu-inicio" id="boton-rsociales">SOCIAL MEDIA</div>');
        break;
    }

    //activamos los scrolls
    if($.mobile.activePage.attr( "id" ) == ("secportada")){
        actualiza_scroll("#deslizante_portada");
        botones_inicio();
    }else if($.mobile.activePage.attr( "id" ) == ("secportadatablet")){
        actualiza_scroll("#deslizante_portada_tablet");
        botones_inicio();
    }
}


/**
 * botones_inicio()
 * metodo para el pulsado de los botones del inicio de la app
 */
function botones_inicio() {
    $(document).on('tap taphold', '.boton-menu-inicio', function (event) {
        event.preventDefault();event.stopImmediatePropagation();

        valor = $(this).attr("id");
        valor = valor.replace("boton-", "");
        sessionStorage.setItem("pagina_navegar", valor);

        $(this).removeClass('boton-menu-inicio');
        $(this).addClass('boton-menu-inicio-on');

        window.setTimeout('cambio_pagina()',respuestaboton);
    });
}
/********************************************************************/

/***** ACCIONES DE CARGA DE NOTICIAS ******/
/******************************************/

/****** funciones de carga del listado de noticias ******/
/**
 * insertar_noticias_dinamicas(contenedorlistado)
 * método para cargar las noticias desde el json haciendo llamada al servidor
 * @param contenedorlistado
 */
function insertar_noticias_dinamicas(contenedorlistado) {
    clase_aux='';
    if ((sessionStorage.getItem("dispositivo")=='tablet')&&(sessionStorage.getItem("orientacion")=='horizontal')){
        clase_aux='_hor';
    }

    $(contenedorlistado).animate({"opacity": 0}, 0);
    $.each(datos_en_memoria.noticias, function(i,noticia){
        var str= noticia.entradilla;
        str = str.substring(0,300) + "...";
        $(contenedorlistado).append('<div class="noticia_listado" id="not_' +
        noticia.idnoticia + '"><div class="signo_mas boton_mas_listado' + clase_aux + '">+</div><div class="contenido_noticia_listado">' +
        noticia.fecha +'<br/><span class="titular_listado">'+
        noticia.titulo +'</span><br/><br/>'+
        str +'</div></div>');
    });
}
/**
 * insertar_noticias_sinconexion(contenedorlistado)
 * método para cargar las noticias desde la memoria
 * @param contenedorlistado
 */
function insertar_noticias_sinconexion(contenedorlistado) {
    clase_aux = '';
    if ((sessionStorage.getItem("dispositivo") == 'tablet') && (sessionStorage.getItem("orientacion") == 'horizontal')) {
        clase_aux = '_hor';
    }
    $(contenedorlistado).animate({"opacity": 0}, 0);
    $.each(datos_en_memoria.noticias, function(i,noticia){
        $(contenedorlistado).append('<div class="noticia_listado" id="not_' +
        noticia.idnoticia + '"><div class="signo_mas boton_mas_listado' + clase_aux + '"><img src="./imagenes/boton_mas.png" alt=""/></div><div class="contenido_noticia_listado">' +
        noticia.fecha +'<br/><span class="titular_listado">'+
        noticia.titulo +'</span><br/><br/>'+
        noticia.entradilla +'</div></div>');
    });
}
/**
 * obtener_datos_noticias_locales()
 * metodo para guardar en la variable de datos_en_memoria las noticias del tipo elegido desde la memoria
 */
function obtener_datos_noticias_locales(){
    datos_en_memoria = JSON.parse(localStorage.getItem('info_noticias'));
}
/**
 * mostrar_contenido(contenedorlistado)
 * método para mostrar el contenido oculto desde un principio
 * @param contenedorlistado
 */
function mostrar_contenido(contenedorlistado){
    $('.capa_anima_carga').css("display","none");
    $(contenedorlistado).animate({"opacity": 1}, 0);
}
/**
 * cargar_noticias()
 * Método para cargar las noticias, crearlas e inyectarlas
 */
function cargar_noticias(){
	var noticia_memoria = sessionStorage.getItem('tipo_de_noticia_memoria');
	var noticia_actual = sessionStorage.getItem('tipo_de_noticia');
	var contenedorlistado = "#contenedor_detalle_listado_noticias";

    //5 - 9 - 10
	var url = ruta_aplicacion + 'noticias.ashx?idioma=' + localStorage.getItem("idioma");
    datos_recarga = localStorage.getItem('ultima_actualizacion_noticias');
    if ((datos_recarga == null)||(datos_recarga == "")) {
        mensaje_consola("datos_recarga vacio");
        datos_recarga = 0;
    }else{
        mensaje_consola("datos_recarga con datos");
    }


    //reseteo de la hora actual a la hora en la que se carga una noticia
    var ahora = new Date();
    sessionStorage.setItem('hora_actual',ahora);


        //HAY CONEXION, PERO NO HAY DATOS
        if((datos_en_memoria == null)||(calcular_fecha(sessionStorage.getItem('hora_actual'), datos_recarga) == true)||(noticia_actual != noticia_memoria)){
			//actualizamos el tipo de noticia en memoria
			sessionStorage.setItem('tipo_de_noticia_memoria',noticia_actual);
            mensaje_consola("entrada carga noticias nuevas");
            $.ajax({
				url: url,
                dataType: 'jsonp',
                data: {},
                global: false,
                cache: false,
                crossDomain: true,
                success: function(data){
                    //salvamos los datos en local con datos nuevos
					localStorage.setItem('info_noticias', JSON.stringify(data));
					datos_en_memoria = JSON.parse(localStorage.getItem('info_noticias'));
                    //Recorremos los datos para crear dinámicamente las noticias
                    insertar_noticias_dinamicas(contenedorlistado);
                    mostrar_contenido(contenedorlistado);

                    cambioOrientacion();
                    actualiza_scroll("#deslizante_noticias");

	                //$("#contenedor_carga_noticias").iscrollview().iscrollview("refresh");

                    //reseteo de la ultima actualizacion
                    var nueva_carga = new Date();
                    localStorage.setItem('ultima_actualizacion_noticias',nueva_carga);
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    alerta_texto('Calconut', traduccion_fallo_lectura);
                }
            });
        //HAY CONEXION Y HAY DATOS
        }else{
            mensaje_consola("hay conecion y datos");
            datos_en_memoria = JSON.parse(localStorage.getItem('info_noticias'));
			obtener_datos_noticias_locales();
            insertar_noticias_dinamicas(contenedorlistado);
            mostrar_contenido(contenedorlistado);

            cambioOrientacion();
            actualiza_scroll("#deslizante_noticias");
	        //$("#contenedor_carga_noticias").iscrollview().iscrollview("refresh");
        }

}
/**
 * botones_noticias()
 * Método con las acciones a realizar al pulsar en una noticia del listado
 */
function botones_noticias() {
    $(document).on('tap', ".noticia_listado", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background", "#666");
        $(this).css("color","#fff");
        var numero_noticia = $(this).attr("id");
        var numero_noticia = numero_noticia.substring(4,numero_noticia.length);
        sessionStorage.setItem("id_noticia",numero_noticia);
        window.setTimeout('cambio_noticias()',respuestaboton);
    });
}

/****** funciones de carga del listado de noticias ******/
/**
 * ver_galeria_noticia()
 * función de evento para ver una galería de una determinada noticia
 */
function ver_galeria_noticia(){
    $(document).on('tap', ".boton_ver_galeria", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","url(../imagenes/enlacegaleria.png) top left no-repeat #666").css("background-position","0 35%");
        sessionStorage.setItem("pagina_navegar", "detalle_galeria_noticia");
        window.setTimeout("cambio_pagina()",respuestaboton);
    });
}
/**
 * abrir_documento()
 * función para abrir una ventana con la url del documento
 */
function abrir_documento() {
	$(".boton_descargar_documento").css("background","url(../imagenes/enlacedocumento.png) top left no-repeat #f2f2f2");
	$(".boton_descargar_documento").css("color","#666");
	var url = sessionStorage.getItem("valor_documento");
	window.open(url, '_system', 'location=yes');
}
/**
 * descargar_documento_noticia()
 * función de evento para controlar el pulsado de la descarga de un documento en una noticia
 */
function descargar_documento_noticia(){
    $(document).on('tap', ".boton_descargar_documento", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background","url(../imagenes/enlacedocumento.png) top left no-repeat #666");
        $(this).css("color","#fff");
        var aux = $(this).attr("rel");
        sessionStorage.setItem("valor_documento",aux);
        window.setTimeout("abrir_documento()",respuestaboton);
    });
}

function descargar_pdf() {
    window.open('http://www.calconut.com/pdf/brochure_2015.pdf', '_system', 'location=yes');
}

/**
 * detalle_noticia()
 * Método para cargar las noticias, crearlas e inyectarlas
 */
function detalle_noticia(){
    //titulo seccion de las noticias
    //$(".titulo_pagina h2").append("DETALLE NOTICIA");

	var contenedorinfo = pagina_actual("#contenedor_detalle_detalle_noticia");
	var contenedoradjuntos = pagina_actual("#contenedor_adjuntos_detalle_noticia");
	var traduccion_galeria;
    //Recuperamos los datos locales para tratarlos después
    datos_en_memoria = localStorage.getItem('detalle_noticia');


    var url = ruta_aplicacion + 'noticia.ashx?idioma=' + localStorage.getItem("idioma") + '&idnoticia=' + sessionStorage.getItem('id_noticia');
    mensaje_consola(url);
    //SI HAY CONEXION

        $.ajax({
            url: url,
            dataType: 'jsonp',
            data: {},
            global: false,
            cache: false,
            crossDomain: true,
            success: function(data){

                switch(localStorage.getItem("idioma")){
                    case 'es':
                        traduccion_galeria = "DETALLE GALERÍA";
                    break;
                    case 'en':
                        traduccion_galeria = "GALLERY DETAIL";
                    break;
                    case 'fr':
                        traduccion_galeria = "GALERIE DETAIL";
                    break;
                }

                //salvamos los datos en local
                localStorage.setItem('detalle_noticia', JSON.stringify(data));
                datos_en_memoria = JSON.parse(localStorage.getItem('detalle_noticia'));
                $(contenedorinfo).animate({"opacity": 0}, 0);
				//CARGA DE INFORMACION DE LA NOTICIA
                $.each(datos_en_memoria.noticia, function (i, noticia) {
                    $(".titulo_pagina h2").append(noticia.titulo);
                    $(contenedorinfo).append('<div class="contenido_detalle_noticia" style="width:100%; float:left;" id="noti_' +
                    noticia.idnoticia +'"><div style="width:94%; float:left; padding:15px 3%;"><span class="fecha_detalle_noticia">'+
                    noticia.fecha +'</span><br/><span class="titular_detalle_noticia">'+
                    noticia.titulo +'</span><br/><br/><span class="entradilla_detalle_noticia"><div class="foto_producto_catalogo"><img src="../imagenes/trans.png" style="background:url('+ noticia.zoomimagen +') top center no-repeat;background-size:cover;"></div>'+
                    noticia.entradilla +'</span><br/><br/><span class="detalle_detalle_noticia">'+
					noticia.detalle +'</span></div></div>');
					if (noticia.imagen == "") {$(".foto_producto_catalogo").css("display","none");}
                });

				//CARGA DE LA GALERIA DE LA NOTICIA
				if (datos_en_memoria.galeria.length != 0) {
                    mensaje_consola("SI TIENE GALERÍA");
				    $(contenedoradjuntos).append('<div class="boton_ver_galeria"><div style="color:#fff;">' + traduccion_galeria + '</div></div>');
					ver_galeria_noticia();
				}
				//CARGA DE LOS DOCUMENTOS DE LA NOTICIA
				if (datos_en_memoria.documentos.length != 0) {
                    mensaje_consola("SI TIENE DOCUMENTOS");
					$.each(datos_en_memoria.documentos, function(i,documento){
						$(contenedoradjuntos).append("<div class='boton_descargar_documento' rel='"+ documento.enlace +"'><div class='nombre_documento_noticia'>"+ documento.descripcion +"</div><br/></div>");
					});
					descargar_documento_noticia();
				}
                mostrar_contenido(contenedorinfo);

                actualiza_scroll("#deslizante_detalle_noticia");
                //$("#contenedor_carga_detalle_noticia").iscrollview().iscrollview("refresh");
             },
             error: function(XMLHttpRequest, textStatus, errorThrown) {
                 alerta_texto('Calconut', traduccion_fallo_lectura);
            }
        });

}

function enlaces_noticia() {
    $(document).on('tap taphold', ".entradilla_detalle_noticia a", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();
        aux = $(this).attr("rel");
        aux = aux.replace("\"", "");
        aux = aux.replace("\"", "");
        window.open(aux, '_system', 'location=yes');
    });
    $(document).on('tap taphold', ".detalle_detalle_noticia a", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();
        aux = $(this).attr("rel");
        aux = aux.replace("\"", "");
        aux = aux.replace("\"", "");
        window.open(aux, '_system', 'location=yes');
    });
}



/***** MÉTODOS DE CARGA DE LAS GALERIAS EN LAS NOTICIAS ******/
/**
 * detalle_galeria(contenedor,tipo_galeria,contenedor_detalle)
 * método universal para cargar el detalle de una galeria, ya sea de noticias, productos o de las propias galerias
 * @param contenedor
 * @param tipo_galeria
 * @param contenedor_detalle
 * @returns {boolean}
 */
function detalle_galeria(contenedor,tipo_galeria,contenedor_detalle){
    var contenedorinfo = pagina_actual(contenedor);

    var traduccion_fotos;
    var total = 0;


		datos_en_memoria = JSON.parse(localStorage.getItem(tipo_galeria));



        switch(localStorage.getItem("idioma")){
            case 'es':
                traduccion_fotos = "fotos";
            break;
            case 'en':
                traduccion_fotos = "photos";
            break;
            case 'fr':
                traduccion_fotos = "photos";
            break;
        }

		//CARGA DE LA GALERIA DE LA NOTICIA
		if (datos_en_memoria.galeria.length != 0) {
            mensaje_consola("con fotos");
			$.each(datos_en_memoria.galeria, function(i,galeria){
				$(contenedorinfo).append("<div class='contenedor_info_galerias'><div class='imagen_fondo_galerias' style='background:url("+
					galeria.imagen + ") center center no-repeat #fcc794; background-size:auto 100%;'><a href='" + galeria.zoomimagen + "' rel='external'><img src='../imagenes/trans.png'/></a></div></div>");
                total = total + 1;
			});
		}
		$('#num_fotos_galeria').append(total +" "+ traduccion_fotos);
		$('.capa_anima_carga').css("display","none");

        actualiza_scroll("#contenedor_detalle_galeria_noticia");
        //$('#contenedor_carga_galeria_noticia').iscrollview().iscrollview("refresh");
		var
			currentPage = $(contenedor_detalle),
			options = {},
			photoSwipeInstance = $(".imagen_fondo_galerias a",contenedor_detalle).photoSwipe();
			sessionStorage.setItem("galeria_actual",photoSwipeInstance.id);
		return true;

	return true;
}

/********************************************************************/


/*******************************************
 * SECCIÓN REDES SOCIALES
 *******************************************
 */
/**
 * botones_sociales()
 * función de evento para controlar el pulsado de los botones de apertura de redes sociales
 */
function botones_sociales(){
    $(document).on('tap', ".ficha_rsocial", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();

        $(this).css("background-color",color_ficha_botones);
        var boton = $(this).attr("id");

        boton = boton.substring(4,boton.length);

        mensaje_consola(boton);

        window.setTimeout('abrir_red("'+boton+'")',respuestaboton);
    });
}
/**
 * abrir_red()
 * método para según el boton de la red social que hayamos pulsado, abra una u otra, además reestablece el color del boton
 * @param red Variable que contiene la red a abrir pasada por parámetro
 */
function abrir_red(red){
    var boton = "#bot_" + red;

    switch(red){
        case 'facebook':
            window.open(direccion_facebook, '_system', 'location=yes');
            color_resstablecer_ficha = "#3A5795";
        break;
        case 'twitter':
            window.open(direccion_twitter, '_system', 'location=yes');
            color_resstablecer_ficha = "#55ACEE";
        break;
        case 'linkedin':
            window.open(direccion_linkedin, '_system', 'location=yes');
            color_resstablecer_ficha = "#0077B5";
        break;
        case 'youtube':
            window.open(direccion_youtube, '_system', 'location=yes');
            color_resstablecer_ficha = "#DE2D2E";
        break;
    }
    $(boton).css("background-color",color_resstablecer_ficha);
}

/***** ACCIONES PARA LOS PRODUCTOS ******/
/****************************************/
/**
 * botones_productos()
 * Método para inyectar los distintos botones de los productos de la sección productos
 */
function botones_live_productos(){

    actualiza_scroll("#deslizante_live_productos");
    botones_live_listadoproductos();
}

/**
 * botones_listadoproductos()
 * Métodos para las acciones de los botones de inicio
 */
function botones_live_listadoproductos() {
    $(document).on('tap taphold', '.b_live_productos', function (event) {
        event.preventDefault();event.stopImmediatePropagation();

        var ruta = $(this).attr("id");
        $("#" + ruta + " .foto_producto img").css('display', 'none;');
        var ruta = "#"+ruta + " .mas_producto > div";
        $(ruta).css("background","#E28E0A");



        valorfamilia = $(this).attr("id");
        valorfamilia = valorfamilia.substring(4,valorfamilia.length);

        var valorfamilia;



        sessionStorage.setItem("tipo_familia", valorfamilia);
        sessionStorage.setItem("pagina_navegar", "live_quotation");

        //Cargamos la pagina con un poco de retardo para simular el pulsado de botón
        window.setTimeout('cambio_pagina()',respuestaboton);
    });
}








/**
 *
 * METODOS
 * REVISADOS
 *
 * ON
 *
 */

/****** funciones de carga de precios ******/
/**
 * insertar_precios(contenedorlistado)
 * método para cargar las noticias desde el json haciendo llamada al servidor
 * @param contenedorlistado
 */
function insertar_precios(contenedorlistado) {


    var traduccion_origen;
    var traduccion_calibre;

    switch(localStorage.getItem("idioma")){
        case 'es':
            traduccion_origen = "Origen";
            traduccion_calibre = "Calibre";
        break;
        case 'en':
            traduccion_origen = "Origin";
            traduccion_calibre = "Size";
        break;
        case 'fr':
            traduccion_origen = "Origine";
            traduccion_calibre = "Calibre";
        break;
    }

    var total = false;

    $(contenedorlistado).animate({ "opacity": 0 }, 0);

    $(contenedorlistado).empty();

    $.each(precios_en_memoria.cotizaciones, function (i, cotizacion) {
        // Para una sola columna de duty unpaid
        if (i == 0) {
            $(".fecha-live").empty().append('<strong>' + precios_en_memoria.fecha+'</strong>');
        }
        cotizacion.foto_familia = cotizacion.foto_familia.toLowerCase().replace(" ","-");

        if (cotizacion.dutypaid_exw_dolartm == "0,00") {
            $(contenedorlistado).append('<div class="ficha-live" id="precio_' +
            cotizacion.id + '"><div class="imagen-producto"><img src="http://www.calconut.com/imagenes/productos/'+cotizacion.foto+'" class="imagen_cargando" /></div><h3>' + cotizacion.familia + '<br /><span>' + cotizacion.producto + '</span></h3><div class="tipos-live"><div class="origen"><div>' + traduccion_origen + ': <span>' +
            cotizacion.origen + '</span></div></div><div class="calibre"><div>' + traduccion_calibre + ': <span>' +
            cotizacion.calibre + '</span></div></div></div><div class="una-columna"><div><div class="titulo-precio">duty unpaid</div><div class="precios"><div><strong>'+
            cotizacion.dutyunpaid_exw_dolartm+'</strong> $/TM</div><div><strong>'+
            cotizacion.dutyunpaid_exw_eurokg + '</strong> €/Kg</div></div></div></div></div>');
        }
        else{
            if (cotizacion.dutyunpaid_exw_dolartm == "0,00") {
                $(contenedorlistado).append('<div class="ficha-live" id="precio_' +
                cotizacion.id + '"><div class="imagen-producto"><img src="http://www.calconut.com/imagenes/productos/'+cotizacion.foto+'" class="imagen_cargando" /></div><h3>' + cotizacion.familia + '<br /><span>' + cotizacion.producto + '</span></h3><div class="tipos-live"><div class="origen"><div>' + traduccion_origen + ': <span>' +
                cotizacion.origen + '</span></div></div><div class="calibre"><div>' + traduccion_calibre + ': <span>' +
                cotizacion.calibre + '</span></div></div></div><div class="una-columna paid"><div><div class="titulo-precio">duty paid</div><div class="precios"><div><strong>' +
                cotizacion.dutypaid_exw_dolartm + '</strong> $/TM</div><div><strong>' +
                cotizacion.dutypaid_exw_eurokg + '</strong> €/Kg</div></div></div></div></div>');
            }// Para dos columnas de duty unpaid
            else{
                $(contenedorlistado).append('<div class="ficha-live" id="precio_' +
                cotizacion.id + '"><div class="imagen-producto"><img src="http://www.calconut.com/imagenes/productos/'+cotizacion.foto+'" class="imagen_cargando" /></div><h3>' + cotizacion.familia + '<br /><span>' + cotizacion.producto + '</span></h3><div class="tipos-live"><div class="origen"><div>' + traduccion_origen + ': <span>' +
                cotizacion.origen + '</span></div></div><div class="calibre"><div>' + traduccion_calibre + ': <span>' +
                cotizacion.calibre + '</span></div></div></div><div class="dos-columnas"><div><div class="titulo-precio">duty paid</div><div class="precios"><div><strong>' +
                cotizacion.dutypaid_exw_dolartm + '</strong> $/TM</div><div><strong>' +
                cotizacion.dutypaid_exw_eurokg + '</strong> €/Kg</div></div></div><div><div class="titulo-precio">duty unpaid</div><div class="precios"><div><strong>' +
                cotizacion.dutyunpaid_exw_dolartm + '</strong> $/TM</div><div><strong>' +
                cotizacion.dutyunpaid_exw_eurokg + '</strong> €/Kg</div></div></div></div></div>');
            }
        }

        //comprobamos para mostrar sin productos o no
        if((cotizacion.id == null)||(cotizacion.id == "")){
            total = false;
        }else{
            total = true;
        }
    });

    if(total == false){
        $(contenedorlistado).append('<div style="width:100%; float:left; text-align:center; margin-top: 25px;"><strong style="color:#ff0000;">No products.</strong></div>');
    }else{
        $(contenedorlistado).append('<div style="text-align:center;"><strong style="color:#ff0000;">Offers subject to final confirmation</strong></div>');
    }

}


/**
 * obtener_datos_precios_locales()
 * metodo para guardar en la variable de datos_en_memoria las noticias del tipo elegido desde la memoria
 */
function obtener_datos_precios_locales() {
    precios_en_memoria = JSON.parse(localStorage.getItem('info_precios'));
}

/**
 * cargar_precios()
 * Método para cargar las noticias, crearlas e inyectarlas
 */
function cargar_precios() {
    var precios_memoria = sessionStorage.getItem('tipo_de_precios_memoria');
    var precios_actual = sessionStorage.getItem('tipo_de_precios');
    var contenedorlistado = ".informacion_interna_ampliada";

    //5 - 9 - 10
    var url = ruta_aplicacion + 'cotizaciones.ashx?idioma=' + localStorage.getItem("idioma") + "&tipo=" + sessionStorage.getItem("tipo_familia");

    mensaje_consola(url);
    //alerta_texto("ruta",url);


    //COMO AHORA FILTRAMOS POR FAMILIA DE PRODUCTOS NO ALMACENAMOS DATOS EN LA CACHÉ, SINO QUE SIEMPRE CARGAMOS DE NUEVO
    /*datos_recarga = localStorage.getItem('ultima_actualizacion_precios');
    if ((datos_recarga == null) || (datos_recarga == "")) {
        mensaje_consola("datos_recarga vacio");
        datos_recarga = 0;
    } else {
        mensaje_consola("datos_recarga con datos");
    }*/
    datos_recarga = 0;



    //reseteo de la hora actual a la hora en la que se carga los precios
    var ahora = new Date();
    sessionStorage.setItem('hora_actual', ahora);


        //HAY CONEXION, PERO NO HAY DATOS
        if ((precios_en_memoria == null) || (calcular_fecha(sessionStorage.getItem('hora_actual'), datos_recarga) == true) || (precios_actual != precios_memoria)) {
            //actualizamos el tipo de precios en memoria
            sessionStorage.setItem('tipo_de_precios_memoria', precios_actual);
            mensaje_consola("entrada carga precios nuevos");
            $.ajax({
                url: url,
                dataType: 'jsonp',
                data: {},
                global: false,
                cache: false,
                crossDomain: true,
                success: function (data) {
                    //salvamos los datos en local con datos nuevos
                    localStorage.setItem('info_precios', JSON.stringify(data));
                    precios_en_memoria = JSON.parse(localStorage.getItem('info_precios'));
                    //Recorremos los datos para crear dinámicamente los precios

                    insertar_precios(contenedorlistado);
                    mostrar_contenido(contenedorlistado);


                    actualiza_scroll("#deslizante_live_quotation");



                    //reseteo de la ultima actualizacion
                    //var nueva_carga = new Date();
                    //localStorage.setItem('ultima_actualizacion_precios', nueva_carga);
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    alerta_texto('Calconut', traduccion_fallo_lectura);
                }


            });

            //HAY CONEXION Y HAY DATOS
        } else {
            mensaje_consola("hay conecion y datos");
            precios_en_memoria = JSON.parse(localStorage.getItem('info_precios'));
            obtener_datos_precios_locales();
            insertar_precios(contenedorlistado);
            mostrar_contenido(contenedorlistado);


            actualiza_scroll("#deslizante_live_quotation");


        }

}



/***** ACCIONES PARA LOS PRODUCTOS ******/
/****************************************/
/**
 * botones_productos()
 * Método para inyectar los distintos botones de los productos de la sección productos
 */
function botones_productos(){
    //var capa_cargadora = "#capa_cargadora_productos";
    //$(capa_cargadora).animate({"opacity": 0}, 0);

    //cargamos el menú desde un archivo externo
    //$.get("menu_productos.html", function (data) {
       // $(capa_cargadora).append(data);
   // });

    //mostrar_contenido(capa_cargadora);
    actualiza_scroll("#deslizante_productos");
    botones_listadoproductos();
}

/**
 * botones_listadoproductos()
 * Métodos para las acciones de los botones de inicio
 */
function botones_listadoproductos() {
    $(document).on('tap taphold', '.contenedor_producto', function (event) {
        event.preventDefault();event.stopImmediatePropagation();

        var ruta = $(this).attr("id");
        $("#" + ruta + " .foto_producto img").css('display', 'none;');
        var ruta = "#"+ruta + " .mas_producto > div";
        $(ruta).css("background","#E28E0A");

        valor = $(this).attr("id");
        valor = valor.substring(4,valor.length);
        sessionStorage.setItem("pagina_navegar", valor);

        //Cargamos la pagina con un poco de retardo para simular el pulsado de botón
        window.setTimeout('cambio_pagina()',respuestaboton);
    });
}

/**
 * cargar_mapa()
 * Método para cargar los puntos del json hacia el mapa en la sección localizacion
 * el json se encuentra en la misma carpeta de los js
 */
function cargar_mapa(){

        $.getJSON('calconut.json', function (data) {
            $.each(data.markers, function (i, marker) {
                $('#map').gmap('addMarker', {
                    'position': new google.maps.LatLng(marker.latitude, marker.longitude),
                    'bounds': true
                }).click(function() {
                    $('#map').gmap('openInfoWindow', { 'content': '<div id="info-bocadillo">'+marker.content+'</div>' }, this);
                });
                //aunque esté en un bucle esto sólo funciona para una marca, asi que CUIDADO
                $(document).on('vmouseup', "#ver_googlemap", function (event) {
                    event.preventDefault(); event.stopImmediatePropagation();
                    window.open("http://maps.google.es/maps?daddr=" + marker.latitude + "," + marker.longitude + "&hl=es&sll=" + marker.latitude + "," + marker.longitude + "&t=h&mra=ls", '_system', 'location=yes');
                });

            });
        });

}

/** EVENTOS DE CARGA DE LAS PAGINAS **/
/********************************************************************/

/***************************************************************************************/

//PORTADA IDIOMA MOVIL
$(document).on('pagebeforecreate', '#secportadaidioma', function (e) {
    sessionStorage.setItem("pagina_navegar", "index");
    sessionStorage.setItem("dispositivo", "movil");
    sessionStorage.setItem("depuracion", "true");
    traduccion_avisos();
});
$(document).on("pagebeforeshow", "#secportadaidioma", function (e) {
    comprobar_local();
    compruebaseccion("vertical");
});
$(document).on("pageshow", "#secportadaidioma", function (e) {
    //window.setTimeout('enviar_analytics("Portada Idioma Movil IOS")',1000);
});



/***************************************************************************************/

///PORTADAS EN LOS DISTINTOS IDIOMAS
//PORTADA MOVIL
$(document).on("pagebeforeshow", "#secportada", function(e) {
    cambioOrientacion();
    inyectar_botones_portada();
    slidebars_app();
});
$(document).on("pageshow", "#secportada", function(e) {
    //window.setTimeout('enviar_analytics("Portada Movil IOS")',1000);
});

/***************************************************************************************/





/***************************************************************************************
 * LIVE QUOTATION
 ***************************************************************************************/
//PRODUCTOS
$(document).on("pagebeforeshow", "#live_productos", function (e) {
    panel_izquierda("deslizante_panel_live_productos","normal");
    cambioOrientacion();
});
$(document).on("pageshow", "#live_productos", function (e) {
    botones_cabecera('normal');
    botones_live_productos();
    //window.setTimeout('enviar_analytics("Productos IOS")',1000);
});

$(document).on("pagebeforeshow", "#live_quotation", function (e) {
    panel_izquierda("deslizante_panel_live_quotation","normal");
    cambioOrientacion();
});
$(document).on("pageshow", "#live_quotation", function (e) {
    botones_cabecera('normal');
    cargar_precios();
    //window.setTimeout('enviar_analytics("Live Quotation IOS")',1000);
});
/***************************************************************************************/




/***************************************************************************************
 * SECCIONES ESTATICAS
 ***************************************************************************************/

//PRODUCTOS
$(document).on("pagebeforeshow", "#productos", function (e) {
    panel_izquierda("deslizante_panel_productos","productos");
    cambioOrientacion();
});
$(document).on("pageshow", "#productos", function (e) {
    botones_cabecera('normal');
    botones_productos();
    //window.setTimeout('enviar_analytics("Productos IOS")',1000);
});

//DETALLE PRODUCTO
$(document).on("pagebeforeshow", ".detalle_producto", function (e) {
    panel_izquierda("deslizante_panel_detalle_producto","productos");
    cambioOrientacion();
});
$(document).on("pageshow", ".detalle_producto", function (e) {
    botones_cabecera('normal');
    actualiza_scroll("#deslizante_detalle_producto");
    //window.setTimeout('enviar_analytics("Detalle productos IOS")',1000);
});




/***************************************************************************************/




/***************************************************************************************
 * SECCIONES ESTATICAS
 ***************************************************************************************/

//CALCONUT
$(document).on("pagebeforeshow", "#calconut", function (e) {
    panel_izquierda("deslizante_panel_calconut","normal");
    cambioOrientacion();
});
$(document).on("pageshow", "#calconut", function (e) {
    botones_cabecera('normal');
    actualiza_scroll("#deslizante_calconut");
    //window.setTimeout('enviar_analytics("Sobre nosotros IOS")',1000);
});

//CONFIGURACIÓN
$(document).on("pagebeforeshow", "#configuracion", function (e) {
    panel_izquierda("deslizante_panel_configuracion","normal");
    cambioOrientacion();
});
$(document).on("pageshow", "#configuracion", function (e) {
    botones_cabecera('normal');
    botones_banderas();
    actualiza_scroll("#deslizante_configuracion");
    //window.setTimeout('enviar_analytics("Configuración IOS")',1000);
});

//PACKAGING
$(document).on("pagebeforeshow", "#packaging", function (e) {
    panel_izquierda("deslizante_panel_packaging","normal");
    cambioOrientacion();
});
$(document).on("pageshow", "#packaging", function (e) {
    botones_cabecera('normal');
    actualiza_scroll("#deslizante_packaging");
    //window.setTimeout('enviar_analytics("Packaging IOS")',1000);
});

//LOCALIZACIÓN
$(document).on("pagebeforeshow", "#localizacion", function (e) {
    panel_izquierda("deslizante_panel_localizacion","normal");
    cambioOrientacion();
});
$(document).on("pageshow", "#localizacion", function (e) {
    botones_cabecera('normal');
    cargar_mapa();
    actualiza_scroll("#deslizante_localizacion");
    //window.setTimeout('enviar_analytics("Localización IOS")',1000);
});

//REDES SOCIALES
$(document).on("pagebeforeshow", "#rsociales", function (e) {
    panel_izquierda("deslizante_panel_rsociales","normal");
    cambioOrientacion();
});
$(document).on("pageshow", "#rsociales", function (e) {
    botones_cabecera('normal');
    botones_sociales();
    actualiza_scroll("#deslizante_rsociales");
    //window.setTimeout('enviar_analytics("Redes Sociales IOS")',1000);
});

/***************************************************************************************/


















//----------------------------------------------------------------------
//NOTICIAS
$(document).on("pagebeforeshow", "#noticias", function(e) {
    panel_izquierda("deslizante_panel_noticias","normal");
    cambioOrientacion();
});
$(document).on("pageshow", "#noticias", function(e) {
    window.setTimeout('botones_cabecera("normal")',300);
    cargar_noticias();
    botones_noticias();

    //window.setTimeout('enviar_analytics("Noticias IOS")',1000);
});



//DETALLE NOTICIA
$(document).on("pagebeforeshow", "#detalle_noticia", function(e) {
	panel_izquierda("deslizante_panel_detalle_noticia","normal");
    cambioOrientacion();
});
$(document).on("pageshow", "#detalle_noticia", function(e) {
    botones_cabecera('detalle_noticia');
    detalle_noticia();
    enlaces_noticia();
});
$(document).on("pagehide","#detalle_noticia", function(e){
    vaciar_cabecera();
});


//DETALLE DE UNA GALERIA NOTICIA
$(document).on("pagebeforeshow", "#detalle_galeria_noticia", function(e) {
	panel_izquierda("deslizante_panel_galeria_noticia","normal");
});
$(document).on("pageshow", "#detalle_galeria_noticia", function(e) {
    botones_cabecera('normal');
    detalle_galeria('#contenedor_galeria_noticia','detalle_noticia','#detalle_galeria_noticia','#deslizante_galeria_noticia');
});
$(document).on("pagehide","#detalle_galeria_noticia",function(e){
    vaciar_cabecera();
    var aux = sessionStorage.getItem("galeria_actual");
    if (typeof aux != "undefined" && aux != null) {
        mensaje_consola("entrada a borrar la galeria actual de la noticia");
        $(aux).remove();
        sessionStorage.removeItem("galeria_actual");
    }
    return true;
});
//----------------------------------------------------------------------



