$(document).ready(function () {

    var inputText = $("#editText");

    var intRegex = /^\d+$/;
    var floatRegex = /^((\d+(\.\d *)?)|((\d*\.)?\d+))$/;
    var operators = "+-*/";
    var specialChars = ")(⇐&lArr;CM=";
    var comma = ".";


    function countString(str, search){
        var count=0;
        var index=str.indexOf(search);
        while(index!=-1){
            count++;
            index=str.indexOf(search,index+1);
        }
        return count;
    }

    function appendCharOnInputText(char) {
        inputText.val(inputText.val() + char);
    }

    function addNumber(char){
        var lenghtStr = inputText.val().length;
        var lastchar = inputText.val().charAt(lenghtStr - 1);
        if(")" !== lastchar){
            inputText.val(inputText.val() + char);
        }
        
    }
    
    function appendDotOnInputText() {
        var exp = inputText.val();
        var lenghtStr = exp.length;
        if (lenghtStr === 0) {
            inputText.val("0" + comma);
        } else {
            var lastchar = inputText.val().charAt(lenghtStr - 1);
            if (lastchar !== comma 
                    && operators.indexOf(lastchar) < 0 
                    && specialChars.indexOf(lastchar) < 0) {
                
                var number = "";
                for ( var i = exp.length-1; i >= 0; i--){
                    char = exp.charAt(i);
                    if(operators.indexOf(char) > 0 
                       || specialChars.indexOf(char) > 0){
                     break;   
                    }
                    number = char+number;
                }
                
                if(number.indexOf(comma)<0){
                    appendCharOnInputText(comma);
                }
            }
        }
    }

    function appendOperatorOnInputText(char) {
        var lenghtStr = inputText.val().length;
        if (lenghtStr === 0) {
            if (char === "-") {
                appendCharOnInputText(char);
            }
        } else {
            var lastChar = inputText.val().charAt(lenghtStr - 1);

            if (operators.indexOf(lastChar) < 0 && lastChar !== comma) {
                appendCharOnInputText(char);
            }
        }
    }

    function appendSpecialCharOnInputText(char) {
        var lenghtStr = inputText.val().length;
        if (lenghtStr !== 0) {
            
            if (char === "=") {
                calculate();
                return;
            }

            if (char === "M") {
                //memorize();
                return;
            }

        }

        if (char === "(" || char == ")") {
            if (lenghtStr === 0 && char === "(") {
                appendCharOnInputText(char);
            } else {
                var exp = inputText.val();
                var lastChar = inputText.val().charAt(lenghtStr - 1);
                if (char === "(" && (lastChar !== ")"
                        && !intRegex.test(lastChar) && (lastChar !== comma))) {
                    appendCharOnInputText(char);
                }

                if (char === ")") {
                    var countOpenParenteses = countString(exp, "(");
                    var countCloseParenteses = countString(exp, ")");
                    
                    if (lastChar != comma && lastChar != "(" 
                            && operators.indexOf(lastChar) < 0
                            && countOpenParenteses > 0 
                            && countOpenParenteses > countCloseParenteses ) {
                        appendCharOnInputText(char);
                    }
                }

            }


        }



    }


    function calculate() {
        var expression = inputText.val();
        var math = mathjs();
        var ans = math.eval(expression);

        inputText.val(inputText.val() + " = " + ans);
    }

   $("#tableNumbers td").on('click', function () {
        var char = $(this).text();

        if (inputText.val().indexOf("=") >= 0) {
            inputText.val("");
        }

        if (intRegex.test(char)) {
            addNumber(char);
        } else {
            if (operators.indexOf(char) >= 0) {
                appendOperatorOnInputText(char);
            } else {
                if (specialChars.indexOf(char) >= 0) {
                    appendSpecialCharOnInputText(char);
                } else {
                    if ($(this).attr("id") !="delete"){
                        appendDotOnInputText();
                    }
                }
            }
        }

    });
    
    $("#calc .clear").on('click', function () {
        inputText.val("");
    });
    
    $("td#delete").on('click', function () {
        var lenghtStr = inputText.val().length;
        inputText.val(inputText.val().substr(0, lenghtStr - 1));
    });




});