/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 0.21.0
 * @date    2014-04-24
 *
 * @license
 * Copyright (C) 2013-2014 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
! function (e, r) {
    "object" == typeof exports && "object" == typeof module ? module.exports = r() : "function" == typeof define && define.amd ? define(r) : "object" == typeof exports ? exports.mathjs = r() : e.mathjs = r()
}(this, function () {
    return function (e) {
        function r(n) {
            if (t[n]) return t[n].exports;
            var i = t[n] = {
                exports: {},
                id: n,
                loaded: !1
            };
            return e[n].call(i.exports, i, i.exports, r), i.loaded = !0, i.exports
        }
        var t = {};
        return r.m = e, r.c = t, r.p = "", r(0)
    }([
        function (e, r, t) {
            e.exports = t(1)
        },
        function (e, r, t) {
            function n(e) {
                if ("function" != typeof Object.create) throw new Error("ES5 not supported by this JavaScript engine. Please load the es5-shim and es5-sham library for compatibility.");
                var r = {},
                    n = {
                        matrix: "matrix",
                        number: "number",
                        precision: 20,
                        epsilon: 1e-14
                    };
                r.config = function (e) {
                    if (e) {
                        if (i.deepExtend(n, e), e.precision && r.type.BigNumber.config({
                            precision: e.precision
                        }), e.number && e.number.defaultType) throw new Error("setting `number.defaultType` is deprecated. Use `number` instead.");
                        if (e.number && e.number.precision) throw new Error("setting `number.precision` is deprecated. Use `precision` instead.");
                        if (e.matrix && e.matrix.defaultType) throw new Error("setting `matrix.defaultType` is deprecated. Use `matrix` instead.");
                        if (e.matrix && e.matrix["default"]) throw new Error("setting `matrix.default` is deprecated. Use `matrix` instead.");
                        if (e.decimals) throw new Error("setting `decimals` is deprecated. Use `precision` instead.")
                    }
                    return i.clone(n)
                };
                var o = t(122).constructor();
                if ("function" != typeof o.prototype.clone && (o.prototype.clone = function () {
                    return new o(this)
                }), "function" == typeof o.convert) throw new Error("Cannot add function convert to BigNumber: function already exists");
                return o.convert = function (e) {
                    return digits(e) > 15 ? e : new o(e)
                }, r.error = t(4), r.type = {}, r.type.Complex = t(5), r.type.Range = t(6), r.type.Index = t(7), r.type.Matrix = t(8), r.type.Unit = t(9), r.type.Help = t(10), r.type.BigNumber = o, r.collection = t(11), r.expression = {}, r.expression.node = t(14), r.expression.parse = t(12), r.expression.Scope = function () {
                    throw new Error("Scope is deprecated. Use a regular Object instead")
                }, r.expression.Parser = t(13), r.expression.docs = t(15), t(17)(r, n), t(18)(r, n), t(19)(r, n), t(20)(r, n), t(21)(r, n), t(22)(r, n), t(23)(r, n), t(24)(r, n), t(25)(r, n), t(26)(r, n), t(27)(r, n), t(28)(r, n), t(29)(r, n), t(30)(r, n), t(31)(r, n), t(32)(r, n), t(33)(r, n), t(34)(r, n), t(35)(r, n), t(36)(r, n), t(37)(r, n), t(38)(r, n), t(39)(r, n), t(40)(r, n), t(41)(r, n), t(42)(r, n), t(43)(r, n), t(44)(r, n), t(45)(r, n), t(46)(r, n), t(47)(r, n), t(48)(r, n), t(49)(r, n), t(50)(r, n), t(51)(r, n), t(52)(r, n), t(53)(r, n), t(54)(r, n), t(55)(r, n), t(56)(r, n), t(57)(r, n), t(58)(r, n), t(59)(r, n), t(60)(r, n), t(61)(r, n), t(62)(r, n), t(63)(r, n), t(64)(r, n), t(65)(r, n), t(66)(r, n), t(67)(r, n), t(68)(r, n), t(69)(r, n), t(70)(r, n), t(71)(r, n), t(72)(r, n), t(73)(r, n), t(74)(r, n), t(75)(r, n), t(76)(r, n), t(77)(r, n), t(78)(r, n), t(79)(r, n), t(80)(r, n), t(81)(r, n), t(82)(r, n), t(83)(r, n), t(84)(r, n), t(85)(r, n), t(86)(r, n), t(87)(r, n), t(88)(r, n), t(89)(r, n), t(90)(r, n), t(91)(r, n), t(92)(r, n), t(93)(r, n), t(94)(r, n), t(95)(r, n), t(96)(r, n), t(97)(r, n), t(98)(r, n), t(99)(r, n), t(100)(r, n), t(101)(r, n), t(102)(r, n), t(103)(r, n), t(104)(r, n), t(105)(r, n), t(106)(r, n), t(107)(r, n), t(108)(r, n), t(109)(r, n), t(110)(r, n), t(111)(r, n), t(112)(r, n), t(113)(r, n), t(114)(r, n), t(115)(r, n), t(116)(r, n), t(117)(r, n), t(2)(r, n), r.chaining = {}, r.chaining.Selector = t(16)(r, n), r.config(e), r
            }
            var i = t(3);
            e.exports = n
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(5);
                e.pi = Math.PI, e.e = Math.E, e.tau = 2 * Math.PI, e.i = new r(0, 1), e.Infinity = 1 / 0, e.NaN = 0 / 0, e["true"] = !0, e["false"] = !1, e.E = Math.E, e.LN2 = Math.LN2, e.LN10 = Math.LN10, e.LOG2E = Math.LOG2E, e.LOG10E = Math.LOG10E, e.PI = Math.PI, e.SQRT1_2 = Math.SQRT1_2, e.SQRT2 = Math.SQRT2
            }
        },
        function (e, r) {
            r.clone = function t(e) {
                var r = typeof e;
                if ("number" === r || "string" === r || "boolean" === r || null === e || void 0 === e) return e;
                if ("function" == typeof e.clone) return e.clone();
                if (Array.isArray(e)) return e.map(function (e) {
                    return t(e)
                });
                if (e instanceof Number) return new Number(e.valueOf());
                if (e instanceof String) return new String(e.valueOf());
                if (e instanceof Boolean) return new Boolean(e.valueOf());
                if (e instanceof Date) return new Date(e.valueOf());
                if (e instanceof RegExp) throw new TypeError("Cannot clone " + e);
                var n = {};
                for (var i in e) e.hasOwnProperty(i) && (n[i] = t(e[i]));
                return n
            }, r.extend = function (e, r) {
                for (var t in r) r.hasOwnProperty(t) && (e[t] = r[t]);
                return e
            }, r.deepExtend = function n(e, r) {
                if (Array.isArray(r)) throw new TypeError("Arrays are not supported by deepExtend");
                for (var t in r)
                    if (r.hasOwnProperty(t))
                        if (r[t] && r[t].constructor === Object) void 0 === e[t] && (e[t] = {}), e[t].constructor === Object ? n(e[t], r[t]) : e[t] = r[t];
                        else {
                            if (Array.isArray(r[t])) throw new TypeError("Arrays are not supported by deepExtend");
                            e[t] = r[t]
                        }
                return e
            }, r.deepEqual = function (e, t) {
                var n, i, o;
                if (Array.isArray(e)) {
                    if (!Array.isArray(t)) return !1;
                    if (e.length != t.length) return !1;
                    for (i = 0, o = e.length; o > i; i++)
                        if (!r.deepEqual(e[i], t[i])) return !1;
                    return !0
                }
                if (e instanceof Object) {
                    if (Array.isArray(t) || !(t instanceof Object)) return !1;
                    for (n in e)
                        if (!r.deepEqual(e[n], t[n])) return !1;
                    for (n in t)
                        if (!r.deepEqual(e[n], t[n])) return !1;
                    return !0
                }
                return typeof e == typeof t && e == t
            }
        },
        function (e, r, t) {
            r.ArgumentsError = t(118), r.DimensionError = t(119), r.IndexError = t(120), r.UnsupportedTypeError = t(121)
        },
        function (e, r, t) {
            function n(e, r) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                switch (arguments.length) {
                case 0:
                    this.re = 0, this.im = 0;
                    break;
                case 1:
                    var t = arguments[0];
                    if ("object" == typeof t) {
                        if ("re" in t && "im" in t) {
                            var i = new n(t.re, t.im);
                            this.re = i.re, this.im = i.im;
                            break
                        }
                        if ("r" in t && "phi" in t) {
                            var i = n.fromPolar(t.r, t.phi);
                            this.re = i.re, this.im = i.im;
                            break
                        }
                    }
                    throw new SyntaxError("Object with the re and im or r and phi properties expected.");
                case 2:
                    if (!h(e) || !h(r)) throw new TypeError("Two numbers expected in Complex constructor");
                    this.re = e, this.im = r;
                    break;
                default:
                    throw new SyntaxError("One, two or three arguments expected in Complex constructor")
                }
            }

            function i() {
                for (;
                    " " == v || "	" == v;) s()
            }

            function o(e) {
                return e >= "0" && "9" >= e || "." == e
            }

            function a(e) {
                return e >= "0" && "9" >= e
            }

            function s() {
                w++, v = y.charAt(w)
            }

            function u(e) {
                w = e, v = y.charAt(w)
            }

            function f() {
                var e, r = "";
                if (e = w, "+" == v ? s() : "-" == v && (r += v, s()), !o(v)) return u(e), null;
                if ("." == v) {
                    if (r += v, s(), !a(v)) return u(e), null
                } else {
                    for (; a(v);) r += v, s();
                    "." == v && (r += v, s())
                }
                for (; a(v);) r += v, s();
                if ("E" == v || "e" == v) {
                    if (r += v, s(), ("+" == v || "-" == v) && (r += v, s()), !a(v)) return u(e), null;
                    for (; a(v);) r += v, s()
                }
                return r
            }

            function c() {
                var e = y.charAt(w + 1);
                if ("I" == v || "i" == v) return s(), "1";
                if (!("+" != v && "-" != v || "I" != e && "i" != e)) {
                    var r = "+" == v ? "1" : "-1";
                    return s(), s(), r
                }
                return null
            }
            var l = t(123),
                p = t(9),
                m = l.number,
                h = l.number.isNumber,
                g = p.isUnit,
                d = l.string.isString;
            n.isComplex = function (e) {
                return e instanceof n
            };
            var y, w, v;
            n.parse = function (e) {
                if (y = e, w = -1, v = "", !d(y)) return null;
                s(), i();
                var r = f();
                if (r) {
                    if ("I" == v || "i" == v) return s(), i(), v ? null : new n(0, Number(r));
                    i();
                    var t = v;
                    if ("+" != t && "-" != t) return i(), v ? null : new n(Number(r), 0);
                    s(), i();
                    var o = f();
                    if (o) {
                        if ("I" != v && "i" != v) return null;
                        s()
                    } else if (o = c(), !o) return null;
                    return "-" == t && (o = "-" == o[0] ? "+" + o.substring(1) : "-" + o), s(), i(), v ? null : new n(Number(r), Number(o))
                }
                return (r = c()) ? (i(), v ? null : new n(0, Number(r))) : null
            }, n.fromPolar = function () {
                switch (arguments.length) {
                case 1:
                    var e = arguments[0];
                    if ("object" == typeof e) return n.fromPolar(e.r, e.phi);
                    throw new TypeError("Input has to be an object with r and phi keys.");
                case 2:
                    var r = arguments[0],
                        t = arguments[1];
                    if (h(r)) {
                        if (g(t) && t.hasBase(p.BASE_UNITS.ANGLE) && (t = t.toNumber("rad")), h(t)) return new n(r * Math.cos(t), r * Math.sin(t));
                        throw new TypeError("Phi is not a number nor an angle unit.")
                    }
                    throw new TypeError("Radius r is not a number.");
                default:
                    throw new SyntaxError("Wrong number of arguments in function fromPolar")
                }
            }, n.prototype.toPolar = function () {
                return {
                    r: Math.sqrt(this.re * this.re + this.im * this.im),
                    phi: Math.atan2(this.im, this.re)
                }
            }, n.prototype.clone = function () {
                return new n(this.re, this.im)
            }, n.prototype.equals = function (e) {
                return this.re === e.re && this.im === e.im
            }, n.prototype.format = function (e) {
                var r = "",
                    t = m.format(this.re, e),
                    n = m.format(this.im, e);
                return r = 0 == this.im ? t : 0 == this.re ? 1 == this.im ? "i" : -1 == this.im ? "-i" : n + "i" : this.im > 0 ? 1 == this.im ? t + " + i" : t + " + " + n + "i" : -1 == this.im ? t + " - i" : t + " - " + n.substring(1) + "i"
            }, n.prototype.toString = function () {
                return this.format()
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r, t) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (null != e && !o.isNumber(e)) throw new TypeError("Parameter start must be a number");
                if (null != r && !o.isNumber(r)) throw new TypeError("Parameter end must be a number");
                if (null != t && !o.isNumber(t)) throw new TypeError("Parameter step must be a number");
                this.start = null != e ? parseFloat(e) : 0, this.end = null != r ? parseFloat(r) : 0, this.step = null != t ? parseFloat(t) : 1
            } {
                var i = t(123),
                    o = i.number,
                    a = i.string;
                i.array
            }
            n.parse = function (e) {
                if (!a.isString(e)) return null;
                var r = e.split(":"),
                    t = r.map(function (e) {
                        return parseFloat(e)
                    }),
                    i = t.some(function (e) {
                        return isNaN(e)
                    });
                if (i) return null;
                switch (t.length) {
                case 2:
                    return new n(t[0], t[1]);
                case 3:
                    return new n(t[0], t[2], t[1]);
                default:
                    return null
                }
            }, n.prototype.clone = function () {
                return new n(this.start, this.end, this.step)
            }, n.isRange = function (e) {
                return e instanceof n
            }, n.prototype.size = function () {
                var e = 0,
                    r = this.start,
                    t = this.step,
                    n = this.end,
                    i = n - r;
                return o.sign(t) == o.sign(i) ? e = Math.ceil(i / t) : 0 == i && (e = 0), isNaN(e) && (e = 0), [e]
            }, n.prototype.min = function () {
                var e = this.size()[0];
                return e > 0 ? this.step > 0 ? this.start : this.start + (e - 1) * this.step : void 0
            }, n.prototype.max = function () {
                var e = this.size()[0];
                return e > 0 ? this.step > 0 ? this.start + (e - 1) * this.step : this.start : void 0
            }, n.prototype.forEach = function (e) {
                var r = this.start,
                    t = this.step,
                    n = this.end,
                    i = 0;
                if (t > 0)
                    for (; n > r;) e(r, i, this), r += t, i++;
                else if (0 > t)
                    for (; r > n;) e(r, i, this), r += t, i++
            }, n.prototype.map = function (e) {
                var r = [];
                return this.forEach(function (t, n, i) {
                    r[n] = e(t, n, i)
                }), r
            }, n.prototype.toArray = function () {
                var e = [];
                return this.forEach(function (r, t) {
                    e[t] = r
                }), e
            }, n.prototype.valueOf = function () {
                return this.toArray()
            }, n.prototype.format = function (e) {
                var r = o.format(this.start, e);
                return 1 != this.step && (r += ":" + o.format(this.step, e)), r += ":" + o.format(this.end, e)
            }, n.prototype.toString = function () {
                return this.format()
            }, e.exports = n
        },
        function (e, r, t) {
            function n() {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                this._ranges = [];
                for (var e = 0, r = arguments.length; r > e; e++) {
                    var t = arguments[e];
                    if (t instanceof a) this._ranges.push(t);
                    else if (c(t)) this._ranges.push(i(t));
                    else {
                        if (!u(t)) throw new TypeError("Ranges must be an Array, Number, or Range");
                        this._ranges.push(i([t, t + 1]))
                    }
                }
            }

            function i(e) {
                for (var r = e.length, t = 0; r > t; t++)
                    if (!u(e[t]) || !f(e[t])) throw new TypeError("Index parameters must be integer numbers");
                switch (e.length) {
                case 2:
                    return new a(e[0], e[1]);
                case 3:
                    return new a(e[0], e[1], e[2]);
                default:
                    throw new SyntaxError("Wrong number of arguments in Index (2 or 3 expected)")
                }
            } {
                var o = t(123),
                    a = t(6),
                    s = o.number,
                    u = s.isNumber,
                    f = s.isInteger,
                    c = Array.isArray;
                o.array.validateIndex
            }
            n.prototype.clone = function () {
                var e = new n;
                return e._ranges = o.object.clone(this._ranges), e
            }, n.isIndex = function (e) {
                return e instanceof n
            }, n.create = function (e) {
                var r = new n;
                return n.apply(r, e), r
            }, n.prototype.size = function l() {
                for (var l = [], e = 0, r = this._ranges.length; r > e; e++) {
                    var t = this._ranges[e];
                    l[e] = t.size()[0]
                }
                return l
            }, n.prototype.max = function () {
                for (var e = [], r = 0, t = this._ranges.length; t > r; r++) {
                    var n = this._ranges[r];
                    e[r] = n.max()
                }
                return e
            }, n.prototype.min = function () {
                for (var e = [], r = 0, t = this._ranges.length; t > r; r++) {
                    var n = this._ranges[r];
                    e[r] = n.min()
                }
                return e
            }, n.prototype.forEach = function (e) {
                for (var r = 0, t = this._ranges.length; t > r; r++) e(this._ranges[r], r, this)
            }, n.prototype.range = function (e) {
                return this._ranges[e] || null
            }, n.prototype.isScalar = function () {
                for (var e = this.size(), r = 0, t = e.length; t > r; r++)
                    if (1 !== e[r]) return !1;
                return !0
            }, n.prototype.toArray = function () {
                for (var e = [], r = 0, t = this._ranges.length; t > r; r++) {
                    var n = this._ranges[r],
                        i = [],
                        o = n.start,
                        a = n.end,
                        s = n.step;
                    if (s > 0)
                        for (; a > o;) i.push(o), o += s;
                    else if (0 > s)
                        for (; o > a;) i.push(o), o += s;
                    e.push(i)
                }
                return e
            }, n.prototype.valueOf = n.prototype.toArray, n.prototype.toString = function () {
                for (var e = [], r = 0, t = this._ranges.length; t > r; r++) {
                    var n = this._ranges[r],
                        i = s.format(n.start);
                    1 != n.step && (i += ":" + s.format(n.step)), i += ":" + s.format(n.end), e.push(i)
                }
                return "[" + e.join(", ") + "]"
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (e instanceof n) this._data = e.clone()._data;
                else if (d(e)) this._data = f(e);
                else {
                    if (null != e) throw new TypeError("Unsupported type of data (" + c.types.type(e) + ")");
                    this._data = []
                }
                this._size = h.size(this._data)
            }

            function i(e, r) {
                if (!(r instanceof p)) throw new TypeError("Invalid index");
                var t = r.isScalar();
                if (t) return e.get(r.min());
                var i = r.size();
                if (i.length != e._size.length) throw new l(i.length, e._size.length);
                for (var a = new n(o(e._data, r, i.length, 0)); d(a._data) && 1 == a._data.length;) a._data = a._data[0], a._size.shift();
                return a
            }

            function o(e, r, t, n) {
                var i = n == t - 1,
                    a = r.range(n);
                return a.map(i ? function (r) {
                    return y(r, e.length), e[r]
                } : function (i) {
                    y(i, e.length);
                    var a = e[i];
                    return o(a, r, t, n + 1)
                })
            }

            function a(e, r, t, i) {
                if (!(r instanceof p)) throw new TypeError("Invalid index");
                var o, a = r.size(),
                    f = r.isScalar();
                if (t instanceof n ? (o = t.size(), t = t.valueOf()) : o = h.size(t), f) {
                    if (0 != o.length) throw new TypeError("Scalar expected");
                    e.set(r.min(), t, i)
                } else {
                    if (a.length < e._size.length) throw new l(a.length, e._size.length, "<");
                    for (var c = 0, m = a.length - o.length; m > c; c++) t = [t], o.unshift(1);
                    if (!g.deepEqual(a, o)) throw new l(a, o);
                    var d = r.max().map(function (e) {
                        return e + 1
                    });
                    u(e, d, i);
                    var y = a.length,
                        w = 0;
                    s(e._data, r, t, y, w)
                }
                return e
            }

            function s(e, r, t, n, i) {
                var o = i == n - 1,
                    a = r.range(i);
                a.forEach(o ? function (r, n) {
                    y(r), e[r] = t[n]
                } : function (o, a) {
                    y(o), s(e[o], r, t[a], n, i + 1)
                })
            }

            function u(e, r, t) {
                for (var n = g.clone(e._size), i = !1; n.length < r.length;) n.unshift(0), i = !0;
                for (var o = 0, a = r.length; a > o; o++) r[o] > n[o] && (n[o] = r[o], i = !0);
                i && e.resize(n, t)
            }

            function f(e) {
                for (var r = 0, t = e.length; t > r; r++) {
                    var i = e[r];
                    d(i) ? e[r] = f(i) : i instanceof n && (e[r] = f(i._data))
                }
                return e
            }
            var c = t(123),
                l = t(119),
                p = t(7),
                m = (c.number, c.string),
                h = c.array,
                g = c.object,
                d = Array.isArray,
                y = h.validateIndex;
            n.isMatrix = function (e) {
                return e instanceof n
            }, n.prototype.subset = function (e, r, t) {
                switch (arguments.length) {
                case 1:
                    return i(this, e);
                case 2:
                case 3:
                    return a(this, e, r, t);
                default:
                    throw new SyntaxError("Wrong number of arguments")
                }
            }, n.prototype.get = function (e) {
                if (!d(e)) throw new TypeError("Array expected");
                if (e.length != this._size.length) throw new l(e.length, this._size.length);
                for (var r = this._data, t = 0, n = e.length; n > t; t++) {
                    var i = e[t];
                    y(i, r.length), r = r[i]
                }
                return g.clone(r)
            }, n.prototype.set = function (e, r, t) {
                var n, i;
                if (!d(e)) throw new Error("Array expected");
                if (e.length < this._size.length) throw new l(e.length, this._size.length, "<");
                var o = e.map(function (e) {
                    return e + 1
                });
                u(this, o, t);
                var a = this._data;
                for (n = 0, i = e.length - 1; i > n; n++) {
                    var s = e[n];
                    y(s, a.length), a = a[s]
                }
                return s = e[e.length - 1], y(s, a.length), a[s] = r, this
            }, n.prototype.resize = function (e, r) {
                return this._size = g.clone(e), this._data = h.resize(this._data, this._size, r), this
            }, n.prototype.clone = function () {
                var e = new n;
                return e._data = g.clone(this._data), e._size = g.clone(this._size), e
            }, n.prototype.size = function () {
                return this._size
            }, n.prototype.map = function (e) {
                var r = this,
                    t = new n,
                    i = [],
                    o = function (t, n) {
                        return d(t) ? t.map(function (e, r) {
                            return i[n] = r, o(e, n + 1)
                        }) : e(t, i, r)
                    };
                return t._data = o(this._data, 0), t._size = g.clone(this._size), t
            }, n.prototype.forEach = function (e) {
                var r = this,
                    t = [],
                    n = function (i, o) {
                        d(i) ? i.forEach(function (e, r) {
                            t[o] = r, n(e, o + 1)
                        }) : e(i, t, r)
                    };
                n(this._data, 0)
            }, n.prototype.toArray = function () {
                return g.clone(this._data)
            }, n.prototype.valueOf = function () {
                return this._data
            }, n.prototype.format = function (e) {
                return m.format(this._data, e)
            }, n.prototype.toString = function () {
                return m.format(this._data)
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r) {
                if (!(this instanceof n)) throw new Error("Constructor must be called with the new operator");
                if (null != e && !w(e)) throw new TypeError("First parameter in Unit constructor must be a number");
                if (null != r && (!v(r) || "" == r)) throw new TypeError("Second parameter in Unit constructor must be a string");
                if (null != r) {
                    var t = l(r);
                    if (!t) throw new SyntaxError('Unknown unit "' + r + '"');
                    this.unit = t.unit, this.prefix = t.prefix
                } else this.unit = UNIT_NONE, this.prefix = b;
                null != e ? (this.value = this._normalize(e), this.fixPrefix = !1) : (this.value = null, this.fixPrefix = !0)
            }

            function i() {
                for (;
                    " " == h || "	" == h;) s()
            }

            function o(e) {
                return e >= "0" && "9" >= e || "." == e
            }

            function a(e) {
                return e >= "0" && "9" >= e
            }

            function s() {
                m++, h = p.charAt(m)
            }

            function u(e) {
                m = e, h = p.charAt(m)
            }

            function f() {
                var e, r = "";
                if (e = m, "+" == h ? s() : "-" == h && (r += h, s()), !o(h)) return u(e), null;
                if ("." == h) {
                    if (r += h, s(), !a(h)) return u(e), null
                } else {
                    for (; a(h);) r += h, s();
                    "." == h && (r += h, s())
                }
                for (; a(h);) r += h, s();
                if ("E" == h || "e" == h) {
                    if (r += h, s(), ("+" == h || "-" == h) && (r += h, s()), !a(h)) return u(e), null;
                    for (; a(h);) r += h, s()
                }
                return r
            }

            function c() {
                var e = "";
                for (i(); h && " " != h && "	" != h;) e += h, s();
                return e || null
            }

            function l(e) {
                for (var r in N)
                    if (N.hasOwnProperty(r) && y.endsWith(e, r)) {
                        var t = N[r],
                            n = e.length - r.length,
                            i = e.substring(0, n),
                            o = t.prefixes[i];
                        if (void 0 !== o) return {
                            unit: t,
                            prefix: o
                        }
                    }
                return null
            }
            var p, m, h, g = t(123),
                d = g.number,
                y = g.string,
                w = g.number.isNumber,
                v = g.string.isString;
            n.parse = function (e) {
                if (p = e, m = -1, h = "", !v(p)) return null;
                s(), i();
                var r, t = f();
                if (t) {
                    if (r = c(), s(), i(), h) return null;
                    if (t && r) try {
                        return new n(Number(t), r)
                    } catch (o) {}
                } else {
                    if (r = c(), s(), i(), h) return null;
                    if (r) try {
                        return new n(null, r)
                    } catch (o) {}
                }
                return null
            }, n.isUnit = function (e) {
                return e instanceof n
            }, n.prototype.clone = function () {
                var e = new n;
                for (var r in this) this.hasOwnProperty(r) && (e[r] = this[r]);
                return e
            }, n.prototype._normalize = function (e) {
                return (e + this.unit.offset) * this.unit.value * this.prefix.value
            }, n.prototype._unnormalize = function (e, r) {
                return void 0 == r ? e / this.unit.value / this.prefix.value - this.unit.offset : e / this.unit.value / r - this.unit.offset
            }, n.isValuelessUnit = function (e) {
                return null != l(e)
            }, n.prototype.hasBase = function (e) {
                return this.unit.base === e
            }, n.prototype.equalBase = function (e) {
                return this.unit.base === e.unit.base
            }, n.prototype.equals = function (e) {
                return this.equalBase(e) && this.value == e.value
            }, n.prototype.to = function (e) {
                var r;
                if (v(e)) {
                    if (r = new n(null, e), !this.equalBase(r)) throw new Error("Units do not match");
                    return r.value = this.value, r
                }
                if (e instanceof n) {
                    if (!this.equalBase(e)) throw new Error("Units do not match");
                    if (null != e.value) throw new Error("Cannot convert to a unit with a value");
                    return r = e.clone(), r.value = this.value, r.fixPrefix = !0, r
                }
                throw new Error("String or Unit expected as parameter")
            }, n.prototype.toNumber = function (e) {
                var r = this.to(e);
                return r._unnormalize(r.value, r.prefix.value)
            }, n.prototype.toString = function () {
                return this.format()
            }, n.prototype.format = function (e) {
                var r, t;
                if (this.fixPrefix) r = this._unnormalize(this.value), t = null != this.value ? d.format(r, e) + " " : "", t += this.prefix.name + this.unit.name;
                else {
                    var n = this._bestPrefix();
                    r = this._unnormalize(this.value, n.value), t = d.format(r, e) + " ", t += n.name + this.unit.name
                }
                return t
            }, n.prototype._bestPrefix = function () {
                var e = Math.abs(this.value / this.unit.value),
                    r = b,
                    t = Math.abs(Math.log(e / r.value) / Math.LN10 - 1.2),
                    n = this.unit.prefixes;
                for (var i in n)
                    if (n.hasOwnProperty(i)) {
                        var o = n[i];
                        if (o.scientific) {
                            var a = Math.abs(Math.log(e / o.value) / Math.LN10 - 1.2);
                            t > a && (r = o, t = a)
                        }
                    }
                return r
            };
            var x = {
                    NONE: {
                        "": {
                            name: "",
                            value: 1,
                            scientific: !0
                        }
                    },
                    SHORT: {
                        "": {
                            name: "",
                            value: 1,
                            scientific: !0
                        },
                        da: {
                            name: "da",
                            value: 10,
                            scientific: !1
                        },
                        h: {
                            name: "h",
                            value: 100,
                            scientific: !1
                        },
                        k: {
                            name: "k",
                            value: 1e3,
                            scientific: !0
                        },
                        M: {
                            name: "M",
                            value: 1e6,
                            scientific: !0
                        },
                        G: {
                            name: "G",
                            value: 1e9,
                            scientific: !0
                        },
                        T: {
                            name: "T",
                            value: 1e12,
                            scientific: !0
                        },
                        P: {
                            name: "P",
                            value: 1e15,
                            scientific: !0
                        },
                        E: {
                            name: "E",
                            value: 1e18,
                            scientific: !0
                        },
                        Z: {
                            name: "Z",
                            value: 1e21,
                            scientific: !0
                        },
                        Y: {
                            name: "Y",
                            value: 1e24,
                            scientific: !0
                        },
                        d: {
                            name: "d",
                            value: .1,
                            scientific: !1
                        },
                        c: {
                            name: "c",
                            value: .01,
                            scientific: !1
                        },
                        m: {
                            name: "m",
                            value: .001,
                            scientific: !0
                        },
                        u: {
                            name: "u",
                            value: 1e-6,
                            scientific: !0
                        },
                        n: {
                            name: "n",
                            value: 1e-9,
                            scientific: !0
                        },
                        p: {
                            name: "p",
                            value: 1e-12,
                            scientific: !0
                        },
                        f: {
                            name: "f",
                            value: 1e-15,
                            scientific: !0
                        },
                        a: {
                            name: "a",
                            value: 1e-18,
                            scientific: !0
                        },
                        z: {
                            name: "z",
                            value: 1e-21,
                            scientific: !0
                        },
                        y: {
                            name: "y",
                            value: 1e-24,
                            scientific: !0
                        }
                    },
                    LONG: {
                        "": {
                            name: "",
                            value: 1,
                            scientific: !0
                        },
                        deca: {
                            name: "deca",
                            value: 10,
                            scientific: !1
                        },
                        hecto: {
                            name: "hecto",
                            value: 100,
                            scientific: !1
                        },
                        kilo: {
                            name: "kilo",
                            value: 1e3,
                            scientific: !0
                        },
                        mega: {
                            name: "mega",
                            value: 1e6,
                            scientific: !0
                        },
                        giga: {
                            name: "giga",
                            value: 1e9,
                            scientific: !0
                        },
                        tera: {
                            name: "tera",
                            value: 1e12,
                            scientific: !0
                        },
                        peta: {
                            name: "peta",
                            value: 1e15,
                            scientific: !0
                        },
                        exa: {
                            name: "exa",
                            value: 1e18,
                            scientific: !0
                        },
                        zetta: {
                            name: "zetta",
                            value: 1e21,
                            scientific: !0
                        },
                        yotta: {
                            name: "yotta",
                            value: 1e24,
                            scientific: !0
                        },
                        deci: {
                            name: "deci",
                            value: .1,
                            scientific: !1
                        },
                        centi: {
                            name: "centi",
                            value: .01,
                            scientific: !1
                        },
                        milli: {
                            name: "milli",
                            value: .001,
                            scientific: !0
                        },
                        micro: {
                            name: "micro",
                            value: 1e-6,
                            scientific: !0
                        },
                        nano: {
                            name: "nano",
                            value: 1e-9,
                            scientific: !0
                        },
                        pico: {
                            name: "pico",
                            value: 1e-12,
                            scientific: !0
                        },
                        femto: {
                            name: "femto",
                            value: 1e-15,
                            scientific: !0
                        },
                        atto: {
                            name: "atto",
                            value: 1e-18,
                            scientific: !0
                        },
                        zepto: {
                            name: "zepto",
                            value: 1e-21,
                            scientific: !0
                        },
                        yocto: {
                            name: "yocto",
                            value: 1e-24,
                            scientific: !0
                        }
                    },
                    SQUARED: {
                        "": {
                            name: "",
                            value: 1,
                            scientific: !0
                        },
                        da: {
                            name: "da",
                            value: 100,
                            scientific: !1
                        },
                        h: {
                            name: "h",
                            value: 1e4,
                            scientific: !1
                        },
                        k: {
                            name: "k",
                            value: 1e6,
                            scientific: !0
                        },
                        M: {
                            name: "M",
                            value: 1e12,
                            scientific: !0
                        },
                        G: {
                            name: "G",
                            value: 1e18,
                            scientific: !0
                        },
                        T: {
                            name: "T",
                            value: 1e24,
                            scientific: !0
                        },
                        P: {
                            name: "P",
                            value: 1e30,
                            scientific: !0
                        },
                        E: {
                            name: "E",
                            value: 1e36,
                            scientific: !0
                        },
                        Z: {
                            name: "Z",
                            value: 1e42,
                            scientific: !0
                        },
                        Y: {
                            name: "Y",
                            value: 1e48,
                            scientific: !0
                        },
                        d: {
                            name: "d",
                            value: .01,
                            scientific: !1
                        },
                        c: {
                            name: "c",
                            value: 1e-4,
                            scientific: !1
                        },
                        m: {
                            name: "m",
                            value: 1e-6,
                            scientific: !0
                        },
                        u: {
                            name: "u",
                            value: 1e-12,
                            scientific: !0
                        },
                        n: {
                            name: "n",
                            value: 1e-18,
                            scientific: !0
                        },
                        p: {
                            name: "p",
                            value: 1e-24,
                            scientific: !0
                        },
                        f: {
                            name: "f",
                            value: 1e-30,
                            scientific: !0
                        },
                        a: {
                            name: "a",
                            value: 1e-36,
                            scientific: !0
                        },
                        z: {
                            name: "z",
                            value: 1e-42,
                            scientific: !0
                        },
                        y: {
                            name: "y",
                            value: 1e-42,
                            scientific: !0
                        }
                    },
                    CUBIC: {
                        "": {
                            name: "",
                            value: 1,
                            scientific: !0
                        },
                        da: {
                            name: "da",
                            value: 1e3,
                            scientific: !1
                        },
                        h: {
                            name: "h",
                            value: 1e6,
                            scientific: !1
                        },
                        k: {
                            name: "k",
                            value: 1e9,
                            scientific: !0
                        },
                        M: {
                            name: "M",
                            value: 1e18,
                            scientific: !0
                        },
                        G: {
                            name: "G",
                            value: 1e27,
                            scientific: !0
                        },
                        T: {
                            name: "T",
                            value: 1e36,
                            scientific: !0
                        },
                        P: {
                            name: "P",
                            value: 1e45,
                            scientific: !0
                        },
                        E: {
                            name: "E",
                            value: 1e54,
                            scientific: !0
                        },
                        Z: {
                            name: "Z",
                            value: 1e63,
                            scientific: !0
                        },
                        Y: {
                            name: "Y",
                            value: 1e72,
                            scientific: !0
                        },
                        d: {
                            name: "d",
                            value: .001,
                            scientific: !1
                        },
                        c: {
                            name: "c",
                            value: 1e-6,
                            scientific: !1
                        },
                        m: {
                            name: "m",
                            value: 1e-9,
                            scientific: !0
                        },
                        u: {
                            name: "u",
                            value: 1e-18,
                            scientific: !0
                        },
                        n: {
                            name: "n",
                            value: 1e-27,
                            scientific: !0
                        },
                        p: {
                            name: "p",
                            value: 1e-36,
                            scientific: !0
                        },
                        f: {
                            name: "f",
                            value: 1e-45,
                            scientific: !0
                        },
                        a: {
                            name: "a",
                            value: 1e-54,
                            scientific: !0
                        },
                        z: {
                            name: "z",
                            value: 1e-63,
                            scientific: !0
                        },
                        y: {
                            name: "y",
                            value: 1e-72,
                            scientific: !0
                        }
                    },
                    BINARY_SHORT: {
                        "": {
                            name: "",
                            value: 1,
                            scientific: !0
                        },
                        k: {
                            name: "k",
                            value: 1024,
                            scientific: !0
                        },
                        M: {
                            name: "M",
                            value: Math.pow(1024, 2),
                            scientific: !0
                        },
                        G: {
                            name: "G",
                            value: Math.pow(1024, 3),
                            scientific: !0
                        },
                        T: {
                            name: "T",
                            value: Math.pow(1024, 4),
                            scientific: !0
                        },
                        P: {
                            name: "P",
                            value: Math.pow(1024, 5),
                            scientific: !0
                        },
                        E: {
                            name: "E",
                            value: Math.pow(1024, 6),
                            scientific: !0
                        },
                        Z: {
                            name: "Z",
                            value: Math.pow(1024, 7),
                            scientific: !0
                        },
                        Y: {
                            name: "Y",
                            value: Math.pow(1024, 8),
                            scientific: !0
                        },
                        Ki: {
                            name: "Ki",
                            value: 1024,
                            scientific: !0
                        },
                        Mi: {
                            name: "Mi",
                            value: Math.pow(1024, 2),
                            scientific: !0
                        },
                        Gi: {
                            name: "Gi",
                            value: Math.pow(1024, 3),
                            scientific: !0
                        },
                        Ti: {
                            name: "Ti",
                            value: Math.pow(1024, 4),
                            scientific: !0
                        },
                        Pi: {
                            name: "Pi",
                            value: Math.pow(1024, 5),
                            scientific: !0
                        },
                        Ei: {
                            name: "Ei",
                            value: Math.pow(1024, 6),
                            scientific: !0
                        },
                        Zi: {
                            name: "Zi",
                            value: Math.pow(1024, 7),
                            scientific: !0
                        },
                        Yi: {
                            name: "Yi",
                            value: Math.pow(1024, 8),
                            scientific: !0
                        }
                    },
                    BINARY_LONG: {
                        "": {
                            name: "",
                            value: 1,
                            scientific: !0
                        },
                        kilo: {
                            name: "kilo",
                            value: 1024,
                            scientific: !0
                        },
                        mega: {
                            name: "mega",
                            value: Math.pow(1024, 2),
                            scientific: !0
                        },
                        giga: {
                            name: "giga",
                            value: Math.pow(1024, 3),
                            scientific: !0
                        },
                        tera: {
                            name: "tera",
                            value: Math.pow(1024, 4),
                            scientific: !0
                        },
                        peta: {
                            name: "peta",
                            value: Math.pow(1024, 5),
                            scientific: !0
                        },
                        exa: {
                            name: "exa",
                            value: Math.pow(1024, 6),
                            scientific: !0
                        },
                        zetta: {
                            name: "zetta",
                            value: Math.pow(1024, 7),
                            scientific: !0
                        },
                        yotta: {
                            name: "yotta",
                            value: Math.pow(1024, 8),
                            scientific: !0
                        },
                        kibi: {
                            name: "kibi",
                            value: 1024,
                            scientific: !0
                        },
                        mebi: {
                            name: "mebi",
                            value: Math.pow(1024, 2),
                            scientific: !0
                        },
                        gibi: {
                            name: "gibi",
                            value: Math.pow(1024, 3),
                            scientific: !0
                        },
                        tebi: {
                            name: "tebi",
                            value: Math.pow(1024, 4),
                            scientific: !0
                        },
                        pebi: {
                            name: "pebi",
                            value: Math.pow(1024, 5),
                            scientific: !0
                        },
                        exi: {
                            name: "exi",
                            value: Math.pow(1024, 6),
                            scientific: !0
                        },
                        zebi: {
                            name: "zebi",
                            value: Math.pow(1024, 7),
                            scientific: !0
                        },
                        yobi: {
                            name: "yobi",
                            value: Math.pow(1024, 8),
                            scientific: !0
                        }
                    }
                },
                b = {
                    name: "",
                    value: 1,
                    scientific: !0
                },
                E = {
                    NONE: {},
                    LENGTH: {},
                    MASS: {},
                    TIME: {},
                    CURRENT: {},
                    TEMPERATURE: {},
                    LUMINOUS_INTENSITY: {},
                    AMOUNT_OF_SUBSTANCE: {},
                    FORCE: {},
                    SURFACE: {},
                    VOLUME: {},
                    ANGLE: {},
                    BIT: {}
                };
            BASE_UNIT_NONE = {}, UNIT_NONE = {
                name: "",
                base: BASE_UNIT_NONE,
                value: 1,
                offset: 0
            };
            var N = {
                    meter: {
                        name: "meter",
                        base: E.LENGTH,
                        prefixes: x.LONG,
                        value: 1,
                        offset: 0
                    },
                    inch: {
                        name: "inch",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: .0254,
                        offset: 0
                    },
                    foot: {
                        name: "foot",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: .3048,
                        offset: 0
                    },
                    yard: {
                        name: "yard",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: .9144,
                        offset: 0
                    },
                    mile: {
                        name: "mile",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: 1609.344,
                        offset: 0
                    },
                    link: {
                        name: "link",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: .201168,
                        offset: 0
                    },
                    rod: {
                        name: "rod",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: 5.02921,
                        offset: 0
                    },
                    chain: {
                        name: "chain",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: 20.1168,
                        offset: 0
                    },
                    angstrom: {
                        name: "angstrom",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: 1e-10,
                        offset: 0
                    },
                    m: {
                        name: "m",
                        base: E.LENGTH,
                        prefixes: x.SHORT,
                        value: 1,
                        offset: 0
                    },
                    "in": {
                        name: "in",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: .0254,
                        offset: 0
                    },
                    ft: {
                        name: "ft",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: .3048,
                        offset: 0
                    },
                    yd: {
                        name: "yd",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: .9144,
                        offset: 0
                    },
                    mi: {
                        name: "mi",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: 1609.344,
                        offset: 0
                    },
                    li: {
                        name: "li",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: .201168,
                        offset: 0
                    },
                    rd: {
                        name: "rd",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: 5.02921,
                        offset: 0
                    },
                    ch: {
                        name: "ch",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: 20.1168,
                        offset: 0
                    },
                    mil: {
                        name: "mil",
                        base: E.LENGTH,
                        prefixes: x.NONE,
                        value: 254e-7,
                        offset: 0
                    },
                    m2: {
                        name: "m2",
                        base: E.SURFACE,
                        prefixes: x.SQUARED,
                        value: 1,
                        offset: 0
                    },
                    sqin: {
                        name: "sqin",
                        base: E.SURFACE,
                        prefixes: x.NONE,
                        value: 64516e-8,
                        offset: 0
                    },
                    sqft: {
                        name: "sqft",
                        base: E.SURFACE,
                        prefixes: x.NONE,
                        value: .09290304,
                        offset: 0
                    },
                    sqyd: {
                        name: "sqyd",
                        base: E.SURFACE,
                        prefixes: x.NONE,
                        value: .83612736,
                        offset: 0
                    },
                    sqmi: {
                        name: "sqmi",
                        base: E.SURFACE,
                        prefixes: x.NONE,
                        value: 2589988.110336,
                        offset: 0
                    },
                    sqrd: {
                        name: "sqrd",
                        base: E.SURFACE,
                        prefixes: x.NONE,
                        value: 25.29295,
                        offset: 0
                    },
                    sqch: {
                        name: "sqch",
                        base: E.SURFACE,
                        prefixes: x.NONE,
                        value: 404.6873,
                        offset: 0
                    },
                    sqmil: {
                        name: "sqmil",
                        base: E.SURFACE,
                        prefixes: x.NONE,
                        value: 6.4516e-10,
                        offset: 0
                    },
                    m3: {
                        name: "m3",
                        base: E.VOLUME,
                        prefixes: x.CUBIC,
                        value: 1,
                        offset: 0
                    },
                    L: {
                        name: "L",
                        base: E.VOLUME,
                        prefixes: x.SHORT,
                        value: .001,
                        offset: 0
                    },
                    l: {
                        name: "l",
                        base: E.VOLUME,
                        prefixes: x.SHORT,
                        value: .001,
                        offset: 0
                    },
                    litre: {
                        name: "litre",
                        base: E.VOLUME,
                        prefixes: x.LONG,
                        value: .001,
                        offset: 0
                    },
                    cuin: {
                        name: "cuin",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: 16387064e-12,
                        offset: 0
                    },
                    cuft: {
                        name: "cuft",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .028316846592,
                        offset: 0
                    },
                    cuyd: {
                        name: "cuyd",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .764554857984,
                        offset: 0
                    },
                    teaspoon: {
                        name: "teaspoon",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: 5e-6,
                        offset: 0
                    },
                    tablespoon: {
                        name: "tablespoon",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: 15e-6,
                        offset: 0
                    },
                    minim: {
                        name: "minim",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: 6.161152e-8,
                        offset: 0
                    },
                    fluiddram: {
                        name: "fluiddram",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: 36966911e-13,
                        offset: 0
                    },
                    fluidounce: {
                        name: "fluidounce",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: 2957353e-11,
                        offset: 0
                    },
                    gill: {
                        name: "gill",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .0001182941,
                        offset: 0
                    },
                    cc: {
                        name: "cc",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: 1e-6,
                        offset: 0
                    },
                    cup: {
                        name: "cup",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .0002365882,
                        offset: 0
                    },
                    pint: {
                        name: "pint",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .0004731765,
                        offset: 0
                    },
                    quart: {
                        name: "quart",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .0009463529,
                        offset: 0
                    },
                    gallon: {
                        name: "gallon",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .003785412,
                        offset: 0
                    },
                    beerbarrel: {
                        name: "beerbarrel",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .1173478,
                        offset: 0
                    },
                    oilbarrel: {
                        name: "oilbarrel",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .1589873,
                        offset: 0
                    },
                    hogshead: {
                        name: "hogshead",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .238481,
                        offset: 0
                    },
                    fldr: {
                        name: "fldr",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: 36966911e-13,
                        offset: 0
                    },
                    floz: {
                        name: "floz",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: 2957353e-11,
                        offset: 0
                    },
                    gi: {
                        name: "gi",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .0001182941,
                        offset: 0
                    },
                    cp: {
                        name: "cp",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .0002365882,
                        offset: 0
                    },
                    pt: {
                        name: "pt",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .0004731765,
                        offset: 0
                    },
                    qt: {
                        name: "qt",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .0009463529,
                        offset: 0
                    },
                    gal: {
                        name: "gal",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .003785412,
                        offset: 0
                    },
                    bbl: {
                        name: "bbl",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .1173478,
                        offset: 0
                    },
                    obl: {
                        name: "obl",
                        base: E.VOLUME,
                        prefixes: x.NONE,
                        value: .1589873,
                        offset: 0
                    },
                    g: {
                        name: "g",
                        base: E.MASS,
                        prefixes: x.SHORT,
                        value: .001,
                        offset: 0
                    },
                    gram: {
                        name: "gram",
                        base: E.MASS,
                        prefixes: x.LONG,
                        value: .001,
                        offset: 0
                    },
                    ton: {
                        name: "ton",
                        base: E.MASS,
                        prefixes: x.SHORT,
                        value: 907.18474,
                        offset: 0
                    },
                    tonne: {
                        name: "tonne",
                        base: E.MASS,
                        prefixes: x.SHORT,
                        value: 1e3,
                        offset: 0
                    },
                    grain: {
                        name: "grain",
                        base: E.MASS,
                        prefixes: x.NONE,
                        value: 6479891e-11,
                        offset: 0
                    },
                    dram: {
                        name: "dram",
                        base: E.MASS,
                        prefixes: x.NONE,
                        value: .0017718451953125,
                        offset: 0
                    },
                    ounce: {
                        name: "ounce",
                        base: E.MASS,
                        prefixes: x.NONE,
                        value: .028349523125,
                        offset: 0
                    },
                    poundmass: {
                        name: "poundmass",
                        base: E.MASS,
                        prefixes: x.NONE,
                        value: .45359237,
                        offset: 0
                    },
                    hundredweight: {
                        name: "hundredweight",
                        base: E.MASS,
                        prefixes: x.NONE,
                        value: 45.359237,
                        offset: 0
                    },
                    stick: {
                        name: "stick",
                        base: E.MASS,
                        prefixes: x.NONE,
                        value: .115,
                        offset: 0
                    },
                    gr: {
                        name: "gr",
                        base: E.MASS,
                        prefixes: x.NONE,
                        value: 6479891e-11,
                        offset: 0
                    },
                    dr: {
                        name: "dr",
                        base: E.MASS,
                        prefixes: x.NONE,
                        value: .0017718451953125,
                        offset: 0
                    },
                    oz: {
                        name: "oz",
                        base: E.MASS,
                        prefixes: x.NONE,
                        value: .028349523125,
                        offset: 0
                    },
                    lbm: {
                        name: "lbm",
                        base: E.MASS,
                        prefixes: x.NONE,
                        value: .45359237,
                        offset: 0
                    },
                    cwt: {
                        name: "cwt",
                        base: E.MASS,
                        prefixes: x.NONE,
                        value: 45.359237,
                        offset: 0
                    },
                    s: {
                        name: "s",
                        base: E.TIME,
                        prefixes: x.SHORT,
                        value: 1,
                        offset: 0
                    },
                    min: {
                        name: "min",
                        base: E.TIME,
                        prefixes: x.NONE,
                        value: 60,
                        offset: 0
                    },
                    h: {
                        name: "h",
                        base: E.TIME,
                        prefixes: x.NONE,
                        value: 3600,
                        offset: 0
                    },
                    second: {
                        name: "second",
                        base: E.TIME,
                        prefixes: x.LONG,
                        value: 1,
                        offset: 0
                    },
                    sec: {
                        name: "sec",
                        base: E.TIME,
                        prefixes: x.LONG,
                        value: 1,
                        offset: 0
                    },
                    minute: {
                        name: "minute",
                        base: E.TIME,
                        prefixes: x.NONE,
                        value: 60,
                        offset: 0
                    },
                    hour: {
                        name: "hour",
                        base: E.TIME,
                        prefixes: x.NONE,
                        value: 3600,
                        offset: 0
                    },
                    day: {
                        name: "day",
                        base: E.TIME,
                        prefixes: x.NONE,
                        value: 86400,
                        offset: 0
                    },
                    rad: {
                        name: "rad",
                        base: E.ANGLE,
                        prefixes: x.NONE,
                        value: 1,
                        offset: 0
                    },
                    deg: {
                        name: "deg",
                        base: E.ANGLE,
                        prefixes: x.NONE,
                        value: .017453292519943295,
                        offset: 0
                    },
                    grad: {
                        name: "grad",
                        base: E.ANGLE,
                        prefixes: x.NONE,
                        value: .015707963267948967,
                        offset: 0
                    },
                    cycle: {
                        name: "cycle",
                        base: E.ANGLE,
                        prefixes: x.NONE,
                        value: 6.283185307179586,
                        offset: 0
                    },
                    A: {
                        name: "A",
                        base: E.CURRENT,
                        prefixes: x.SHORT,
                        value: 1,
                        offset: 0
                    },
                    ampere: {
                        name: "ampere",
                        base: E.CURRENT,
                        prefixes: x.LONG,
                        value: 1,
                        offset: 0
                    },
                    K: {
                        name: "K",
                        base: E.TEMPERATURE,
                        prefixes: x.NONE,
                        value: 1,
                        offset: 0
                    },
                    degC: {
                        name: "degC",
                        base: E.TEMPERATURE,
                        prefixes: x.NONE,
                        value: 1,
                        offset: 273.15
                    },
                    degF: {
                        name: "degF",
                        base: E.TEMPERATURE,
                        prefixes: x.NONE,
                        value: 1 / 1.8,
                        offset: 459.67
                    },
                    degR: {
                        name: "degR",
                        base: E.TEMPERATURE,
                        prefixes: x.NONE,
                        value: 1 / 1.8,
                        offset: 0
                    },
                    kelvin: {
                        name: "kelvin",
                        base: E.TEMPERATURE,
                        prefixes: x.NONE,
                        value: 1,
                        offset: 0
                    },
                    celsius: {
                        name: "celsius",
                        base: E.TEMPERATURE,
                        prefixes: x.NONE,
                        value: 1,
                        offset: 273.15
                    },
                    fahrenheit: {
                        name: "fahrenheit",
                        base: E.TEMPERATURE,
                        prefixes: x.NONE,
                        value: 1 / 1.8,
                        offset: 459.67
                    },
                    rankine: {
                        name: "rankine",
                        base: E.TEMPERATURE,
                        prefixes: x.NONE,
                        value: 1 / 1.8,
                        offset: 0
                    },
                    mol: {
                        name: "mol",
                        base: E.AMOUNT_OF_SUBSTANCE,
                        prefixes: x.NONE,
                        value: 1,
                        offset: 0
                    },
                    mole: {
                        name: "mole",
                        base: E.AMOUNT_OF_SUBSTANCE,
                        prefixes: x.NONE,
                        value: 1,
                        offset: 0
                    },
                    cd: {
                        name: "cd",
                        base: E.LUMINOUS_INTENSITY,
                        prefixes: x.NONE,
                        value: 1,
                        offset: 0
                    },
                    candela: {
                        name: "candela",
                        base: E.LUMINOUS_INTENSITY,
                        prefixes: x.NONE,
                        value: 1,
                        offset: 0
                    },
                    N: {
                        name: "N",
                        base: E.FORCE,
                        prefixes: x.SHORT,
                        value: 1,
                        offset: 0
                    },
                    newton: {
                        name: "newton",
                        base: E.FORCE,
                        prefixes: x.LONG,
                        value: 1,
                        offset: 0
                    },
                    lbf: {
                        name: "lbf",
                        base: E.FORCE,
                        prefixes: x.NONE,
                        value: 4.4482216152605,
                        offset: 0
                    },
                    poundforce: {
                        name: "poundforce",
                        base: E.FORCE,
                        prefixes: x.NONE,
                        value: 4.4482216152605,
                        offset: 0
                    },
                    b: {
                        name: "b",
                        base: E.BIT,
                        prefixes: x.BINARY_SHORT,
                        value: 1,
                        offset: 0
                    },
                    bits: {
                        name: "bits",
                        base: E.BIT,
                        prefixes: x.BINARY_LONG,
                        value: 1,
                        offset: 0
                    },
                    B: {
                        name: "B",
                        base: E.BIT,
                        prefixes: x.BINARY_SHORT,
                        value: 8,
                        offset: 0
                    },
                    bytes: {
                        name: "bytes",
                        base: E.BIT,
                        prefixes: x.BINARY_LONG,
                        value: 8,
                        offset: 0
                    }
                },
                M = {
                    meters: "meter",
                    inches: "inch",
                    feet: "foot",
                    yards: "yard",
                    miles: "mile",
                    links: "link",
                    rods: "rod",
                    chains: "chain",
                    angstroms: "angstrom",
                    litres: "litre",
                    teaspoons: "teaspoon",
                    tablespoons: "tablespoon",
                    minims: "minim",
                    fluiddrams: "fluiddram",
                    fluidounces: "fluidounce",
                    gills: "gill",
                    cups: "cup",
                    pints: "pint",
                    quarts: "quart",
                    gallons: "gallon",
                    beerbarrels: "beerbarrel",
                    oilbarrels: "oilbarrel",
                    hogsheads: "hogshead",
                    grams: "gram",
                    tons: "ton",
                    tonnes: "tonne",
                    grains: "grain",
                    drams: "dram",
                    ounces: "ounce",
                    poundmasses: "poundmass",
                    hundredweights: "hundredweight",
                    sticks: "stick",
                    seconds: "second",
                    minutes: "minute",
                    hours: "hour",
                    days: "day",
                    radians: "rad",
                    degrees: "deg",
                    gradients: "grad",
                    cycles: "cycle",
                    amperes: "ampere",
                    moles: "mole"
                };
            for (var A in M)
                if (M.hasOwnProperty(A)) {
                    var S = N[M[A]],
                        T = Object.create(S);
                    T.name = A, N[A] = T
                }
            N.lt = N.l, N.liter = N.litre, N.liters = N.litres, N.lb = N.lbm, N.lbs = N.lbm, n.PREFIXES = x, n.BASE_UNITS = E, n.UNITS = N, e.exports = n
        },
        function (e, r, t) {
            function n(e, r) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                this.math = e, this.doc = r
            }
            var i = t(123),
                o = i.object,
                a = i.string;
            n.isHelp = function (e) {
                return e instanceof n
            }, n.prototype.toString = function () {
                var e = this.doc || {},
                    r = "\n";
                if (e.name && (r += "Name: " + e.name + "\n\n"), e.category && (r += "Category: " + e.category + "\n\n"), e.description && (r += "Description:\n    " + e.description + "\n\n"), e.syntax && (r += "Syntax:\n    " + e.syntax.join("\n    ") + "\n\n"), e.examples) {
                    var t = this.math.parser();
                    r += "Examples:\n";
                    for (var i = 0; i < e.examples.length; i++) {
                        var o, s = e.examples[i];
                        try {
                            o = t.eval(s)
                        } catch (u) {
                            o = u
                        }
                        r += "    " + s + "\n", !o || o instanceof n || (r += "        " + a.format(o) + "\n")
                    }
                    r += "\n"
                }
                return e.seealso && (r += "See also: " + e.seealso.join(", ") + "\n"), r
            }, n.prototype.toJSON = function () {
                return o.clone(this.doc)
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r, t) {
                var o, a, s, f;
                if (0 >= r) {
                    if (u(e[0])) {
                        for (f = i(e), a = [], o = 0; o < f.length; o++) a[o] = n(f[o], r - 1, t);
                        return a
                    }
                    for (s = e[0], o = 1; o < e.length; o++) s = t(s, e[o]);
                    return s
                }
                for (a = [], o = 0; o < e.length; o++) a[o] = n(e[o], r - 1, t);
                return a
            }

            function i(e) {
                var r, t, n = e.length,
                    i = e[0].length,
                    o = [];
                for (t = 0; i > t; t++) {
                    var a = [];
                    for (r = 0; n > r; r++) a.push(e[r][t]);
                    o.push(a)
                }
                return o
            } {
                var o = t(123),
                    a = t(119),
                    s = t(8),
                    u = o.array.isArray;
                o.string.isString
            }
            r.argsToArray = function (e) {
                var r;
                return 0 == e.length ? r = [] : 1 == e.length ? (r = e[0], r instanceof s && (r = r.valueOf()), u(r) || (r = [r])) : r = Array.prototype.slice.apply(e), r
            }, r.isCollection = function (e) {
                return u(e) || e instanceof s
            }, r.deepMap = function f(e, r) {
                return e && "function" == typeof e.map ? e.map(function (e) {
                    return f(e, r)
                }) : r(e)
            }, r.deepMap2 = function c(e, r, t) {
                var n, i, o;
                if (u(e))
                    if (u(r)) {
                        if (e.length != r.length) throw new a(e.length, r.length);
                        for (n = [], i = e.length, o = 0; i > o; o++) n[o] = c(e[o], r[o], t)
                    } else {
                        if (r instanceof s) return n = c(e, r.valueOf(), t), new s(n);
                        for (n = [], i = e.length, o = 0; i > o; o++) n[o] = c(e[o], r, t)
                    } else {
                    if (e instanceof s) return r instanceof s ? (n = c(e.valueOf(), r.valueOf(), t), new s(n)) : (n = c(e.valueOf(), r, t), new s(n));
                    if (u(r))
                        for (n = [], i = r.length, o = 0; i > o; o++) n[o] = c(e, r[o], t);
                    else {
                        if (r instanceof s) return n = c(e, r.valueOf(), t), new s(n);
                        n = t(e, r)
                    }
                }
                return n
            }, r.reduce = function (e, r, t) {
                return e instanceof s ? new s(n(e.valueOf(), r, t)) : n(e, r, t)
            }, r.deepForEach = function l(e, r) {
                e instanceof s && (e = e.valueOf());
                for (var t = 0, n = e.length; n > t; t++) {
                    var i = e[t];
                    u(i) ? l(i, r) : r(i)
                }
            }
        },
        function (e, r, t) {
            function n(e, r) {
                if (1 != arguments.length && 2 != arguments.length) throw new SyntaxError("Wrong number of arguments: 1 or 2 expected");
                if (fr = "object" === V(r) ? r : {}, D(e)) return cr = e, p();
                if (G(e) || e instanceof H) return W.deepMap(e, function (e) {
                    if (!D(e)) throw new TypeError("String expected");
                    return cr = e, p()
                });
                throw new TypeError("String or matrix expected")
            }

            function i() {
                lr = 0, pr = cr.charAt(0)
            }

            function o() {
                lr++, pr = cr.charAt(lr)
            }

            function a() {
                return cr.charAt(lr + 1)
            }

            function s() {
                for (hr = ar.NULL, mr = "";
                    " " == pr || "	" == pr;) o();
                if ("#" == pr)
                    for (;
                        "\n" != pr && "" != pr;) o();
                if ("" == pr) return void(hr = ar.DELIMITER);
                var e = pr + a();
                if (sr[e]) return hr = ar.DELIMITER, mr = e, o(), void o();
                if (sr[pr]) return hr = ar.DELIMITER, mr = pr, void o();
                if (!c(pr)) {
                    if (f(pr)) {
                        for (; f(pr) || l(pr);) mr += pr, o();
                        return void(hr = ur[mr] ? ar.DELIMITER : ar.SYMBOL)
                    }
                    for (hr = ar.UNKNOWN;
                        "" != pr;) mr += pr, o();
                    throw k('Syntax error in part "' + mr + '"')
                }
                if (hr = ar.NUMBER, "." == pr) mr += pr, o(), l(pr) || (hr = ar.UNKNOWN);
                else {
                    for (; l(pr);) mr += pr, o();
                    "." == pr && (mr += pr, o())
                }
                for (; l(pr);) mr += pr, o();
                if ("E" == pr || "e" == pr)
                    for (mr += pr, o(), ("+" == pr || "-" == pr) && (mr += pr, o()), l(pr) || (hr = ar.UNKNOWN); l(pr);) mr += pr, o()
            }

            function u() {
                for (;
                    "\n" == mr;) s()
            }

            function f(e) {
                return e >= "a" && "z" >= e || e >= "A" && "Z" >= e || "_" == e
            }

            function c(e) {
                return e >= "0" && "9" >= e || "." == e
            }

            function l(e) {
                return e >= "0" && "9" >= e
            }

            function p() {
                i(), s();
                var e = m();
                if ("" != mr) throw hr == ar.DELIMITER ? P("Unknown operator " + mr) : k('Unexpected part "' + mr + '"');
                return e
            }

            function m() {
                var e, r, t;
                if ("" == mr) return new Q("undefined", "undefined");
                for ("\n" != mr && ";" != mr && (e = h());
                    "\n" == mr || ";" == mr;) r || (r = new $, e && (t = ";" != mr, r.add(e, t))), s(), "\n" != mr && ";" != mr && "" != mr && (e = h(), t = ";" != mr, r.add(e, t));
                return r ? r : e
            }

            function h() {
                var e = g(),
                    r = "ans";
                return new Z(r, e)
            }

            function g() {
                if (hr == ar.SYMBOL && "function" == mr) throw new Error('Deprecated keyword "function". Functions can now be assigned without it, like "f(x) = x^2".');
                return d()
            }

            function d() {
                var e, r, t, n = y();
                if ("=" == mr) {
                    if (n instanceof tr) return e = n.name, s(), t = d(), new Z(e, t);
                    if (n instanceof K) return s(), t = d(), new or(n, t);
                    if (n instanceof er) {
                        var i = !0;
                        if (r = [], n.object instanceof tr ? (e = n.object.name, n.params.forEach(function (e, t) {
                            e instanceof tr ? r[t] = e.name : i = !1
                        })) : i = !1, i) return s(), t = d(), new J(e, r, t)
                    }
                    throw k("Invalid left hand side of assignment operator =")
                }
                return n
            }

            function y() {
                var e, r = [];
                if (e = ":" == mr ? new Q("number", "1") : w(), ":" == mr) {
                    for (r.push(e);
                        ":" == mr;) s(), r.push(")" == mr || "]" == mr || "," == mr || "" == mr ? new tr("end") : w());
                    if (3 == r.length) {
                        var t = r[2];
                        r[2] = r[1], r[1] = t
                    }
                    e = new rr(r)
                }
                return e
            }

            function w() {
                var e = v();
                return e
            }

            function v() {
                for (var e = x();
                    "?" == mr;) {
                    s();
                    var r = [e];
                    if (r.push(x()), ":" != mr) throw k("False part of conditional expression expected");
                    s(), r.push(v()), e = new nr(["?", ":"], "ifElse", r)
                }
                return e
            }

            function x() {
                var e, r, t, n, i;
                for (e = b(), r = {
                    "==": "equal",
                    "!=": "unequal",
                    "<": "smaller",
                    ">": "larger",
                    "<=": "smallereq",
                    ">=": "largereq"
                }; mr in r;) t = mr, n = r[t], s(), i = [e, b()], e = new X(t, n, i);
                return e
            }

            function b() {
                var e, r, t, n, i;
                for (e = E(), r = {
                    to: "to",
                    "in": "to"
                }; mr in r;) t = mr, n = r[t], s(), i = [e, E()], e = new X(t, n, i);
                return e
            }

            function E() {
                var e, r, t, n, i;
                for (e = N(), r = {
                    "+": "add",
                    "-": "subtract"
                }; mr in r;) t = mr, n = r[t], s(), i = [e, N()], e = new X(t, n, i);
                return e
            }

            function N() {
                var e, r, t, n, i;
                for (e = M(), r = {
                    "*": "multiply",
                    ".*": "emultiply",
                    "/": "divide",
                    "./": "edivide",
                    "%": "mod",
                    mod: "mod"
                }; mr in r;) t = mr, n = r[t], s(), i = [e, M()], e = new X(t, n, i);
                return e
            }

            function M() {
                var e, r;
                return e = A(), (hr == ar.SYMBOL || "in" == mr) && (r = mr, s(), e = new ir(e, r)), e
            }

            function A() {
                var e, r, t;
                return "-" == mr ? (e = mr, r = "unary", s(), t = [A()], new X(e, r, t)) : S()
            }

            function S() {
                var e, r, t, n;
                return e = T(), ("^" == mr || ".^" == mr) && (r = mr, t = "^" == r ? "pow" : "epow", s(), n = [e, S()], e = new X(r, t, n)), e
            }

            function T() {
                var e, r, t, n, i;
                for (e = O(), r = {
                    "!": "factorial",
                    "'": "transpose"
                }; mr in r;) t = mr, n = r[t], s(), i = [e], e = new X(t, n, i);
                return e
            }

            function O() {
                var e, r = [];
                if (hr == ar.SYMBOL && fr[mr]) {
                    if (e = fr[mr], s(), "(" == mr) {
                        if (r = [], s(), ")" != mr)
                            for (r.push(y());
                                "," == mr;) s(), r.push(y());
                        if (")" != mr) throw k("Parenthesis ) expected");
                        s()
                    }
                    return new e(r)
                }
                return C()
            }

            function C() {
                var e, r;
                return hr == ar.SYMBOL || hr == ar.DELIMITER && mr in ur ? (r = mr, s(), e = new tr(r), B(e)) : U()
            }

            function B(e) {
                for (var r, t;
                    "(" == mr || "[" == mr;) {
                    if (r = mr, t = [], s(), ")" != mr && "]" != mr)
                        for (t.push(y());
                            "," == mr;) s(), t.push(y());
                    if ("(" == r && ")" != mr) throw k("Parenthesis ) expected");
                    if ("[" == r && "]" != mr) throw k("Parenthesis ] expected");
                    s(), e = "(" == r ? new er(e, t) : new K(e, t)
                }
                return e
            }

            function U() {
                var e, r, t;
                if ('"' == mr) {
                    for (r = "", t = "";
                        "" != pr && ('"' != pr || "\\" == t);) r += pr, t = pr, o();
                    if (s(), '"' != mr) throw k('End of string " expected');
                    return s(), e = new Q("string", r), e = B(e)
                }
                return _()
            }

            function _() {
                var e, r, t, n;
                if ("[" == mr) {
                    if (s(), u(), "]" != mr) {
                        var i = I();
                        if (";" == mr) {
                            for (t = 1, r = [i];
                                ";" == mr;) s(), u(), r[t] = I(), t++, u();
                            if ("]" != mr) throw k("End of matrix ] expected");
                            s(), n = r[0].nodes.length;
                            for (var o = 1; t > o; o++)
                                if (r[o].nodes.length != n) throw P("Column dimensions mismatch (" + r[o].nodes.length + " != " + n + ")");
                            e = new Y(r)
                        } else {
                            if ("]" != mr) throw k("End of matrix ] expected");
                            s(), e = i
                        }
                    } else s(), e = new Y([]);
                    return e = B(e)
                }
                return z()
            }

            function I() {
                for (var e = [d()], r = 1;
                    "," == mr;) s(), u(), e[r] = d(), r++, u();
                return new Y(e)
            }

            function z() {
                var e, r;
                return hr == ar.NUMBER ? (r = mr, s(), "i" == mr || "I" == mr ? (s(), e = new Q("complex", r)) : e = new Q("number", r), e = B(e)) : q()
            }

            function q() {
                var e;
                if ("(" == mr) {
                    if (s(), e = d(), ")" != mr) throw k("Parenthesis ) expected");
                    return s(), e = B(e)
                }
                return L()
            }

            function L() {
                throw k("" == mr ? "Unexpected end of expression" : "Value expected")
            }

            function j() {
                return lr - mr.length + 1
            }

            function R(e) {
                return e + " (char " + j() + ")"
            }

            function k(e) {
                return new SyntaxError(R(e))
            }

            function P(e) {
                return new Error(R(e))
            }
            var F = t(123),
                D = F.string.isString,
                G = Array.isArray,
                V = F.types.type,
                H = (t(5), t(8)),
                W = (t(9), t(11)),
                Y = t(124),
                Z = t(125),
                $ = t(126),
                Q = t(127),
                J = t(128),
                K = t(129),
                X = t(130),
                er = t(131),
                rr = t(132),
                tr = t(133),
                nr = t(134),
                ir = t(135),
                or = t(136),
                ar = {
                    NULL: 0,
                    DELIMITER: 1,
                    NUMBER: 2,
                    SYMBOL: 3,
                    UNKNOWN: 4
                },
                sr = {
                    ",": !0,
                    "(": !0,
                    ")": !0,
                    "[": !0,
                    "]": !0,
                    '"': !0,
                    "\n": !0,
                    ";": !0,
                    "+": !0,
                    "-": !0,
                    "*": !0,
                    ".*": !0,
                    "/": !0,
                    "./": !0,
                    "%": !0,
                    "^": !0,
                    ".^": !0,
                    "!": !0,
                    "'": !0,
                    "=": !0,
                    ":": !0,
                    "?": !0,
                    "==": !0,
                    "!=": !0,
                    "<": !0,
                    ">": !0,
                    "<=": !0,
                    ">=": !0
                },
                ur = {
                    mod: !0,
                    to: !0,
                    "in": !0
                },
                fr = {},
                cr = "",
                lr = 0,
                pr = "",
                mr = "",
                hr = ar.NULL;
            e.exports = n
        },
        function (e, r, t) {
            function n(e) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if ("object" != typeof e) throw new TypeError("Object expected as parameter math");
                this.math = e, this.scope = {}
            }
            var i = t(12);
            n.prototype.parse = function (e) {
                return i(e)
            }, n.prototype.compile = function (e) {
                return i(e).compile(this.math)
            }, n.prototype.eval = function (e) {
                return i(e).compile(this.math).eval(this.scope)
            }, n.prototype.get = function (e) {
                return this.scope[e]
            }, n.prototype.set = function (e, r) {
                return this.scope[e] = r
            }, n.prototype.remove = function (e) {
                delete this.scope[e]
            }, n.prototype.clear = function () {
                for (var e in this.scope) this.scope.hasOwnProperty(e) && delete this.scope[e]
            }, e.exports = n
        },
        function (e, r, t) {
            r.ArrayNode = t(124), r.AssignmentNode = t(125), r.BlockNode = t(126), r.ConstantNode = t(127), r.IndexNode = t(129), r.FunctionNode = t(128), r.Node = t(137), r.OperatorNode = t(130), r.ParamsNode = t(131), r.RangeNode = t(132), r.SymbolNode = t(133), r.TernaryNode = t(134), r.UnitNode = t(135), r.UpdateNode = t(136)
        },
        function (e, r, t) {
            r.e = t(139), r.E = t(139), r["false"] = t(140), r.i = t(141), r.Infinity = t(142), r.LN2 = t(143), r.LN10 = t(144), r.LOG2E = t(145), r.LOG10E = t(146), r.NaN = t(147), r.pi = t(148), r.PI = t(148), r.SQRT1_2 = t(149), r.SQRT2 = t(150), r.tau = t(151), r["true"] = t(152), r.abs = t(157), r.add = t(158), r.ceil = t(159), r.compare = t(160), r.cube = t(161), r.divide = t(162), r.edivide = t(163), r.emultiply = t(164), r.epow = t(165), r.equal = t(166), r.exp = t(167), r.fix = t(168), r.floor = t(169), r.gcd = t(170), r.larger = t(171), r.largereq = t(172), r.lcm = t(173), r.log = t(174), r.log10 = t(175), r.mod = t(176), r.multiply = t(177), r.norm = t(178), r.pow = t(179), r.round = t(180), r.sign = t(181), r.smaller = t(182), r.smallereq = t(183), r.sqrt = t(184), r.square = t(185), r.subtract = t(186), r.unary = t(187), r.unequal = t(188), r.xgcd = t(189), r.arg = t(190), r.conj = t(191), r.re = t(192), r.im = t(193), r.bignumber = t(194), r["boolean"] = t(195), r.complex = t(196), r.index = t(197), r.matrix = t(198), r.number = t(199), r.string = t(200), r.unit = t(201), r.eval = t(202), r.help = t(203), r.concat = t(204), r.det = t(205), r.diag = t(206), r.eye = t(207), r.inv = t(208), r.ones = t(209), r.range = t(210), r.resize = t(211), r.size = t(212), r.squeeze = t(213), r.subset = t(214), r.transpose = t(215), r.zeros = t(216), r.combinations = t(217), r.distribution = t(218), r.factorial = t(219), r.permutations = t(220), r.pickRandom = t(221), r.random = t(222), r.randomInt = t(223), r.max = t(224), r.mean = t(225), r.median = t(226), r.min = t(227), r.prod = t(228), r.std = t(229), r.sum = t(230), r["var"] = t(231), r.acos = t(232), r.asin = t(233), r.atan = t(234), r.atan2 = t(235), r.cos = t(236), r.cosh = t(237), r.cot = t(238), r.coth = t(239), r.csc = t(240), r.csch = t(241), r.sec = t(242), r.sech = t(243), r.sin = t(244), r.sinh = t(245), r.tan = t(246), r.tanh = t(247), r.to = t(248), r.clone = t(249), r.map = t(250), r.forEach = t(251), r.format = t(252), r.ifElse = t(253), r["import"] = t(254), r["typeof"] = t(255)
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(e) {
                    if (!(this instanceof r)) throw new SyntaxError("Constructor must be called with the new operator");
                    this.value = e instanceof r ? e.value : e
                }

                function n(e, t) {
                    var n = Array.prototype.slice;
                    r.prototype[e] = "function" == typeof t ? function () {
                        var e = [this.value].concat(n.call(arguments, 0));
                        return new r(t.apply(this, e))
                    } : new r(t)
                }
                var i = t(138);
                r.prototype.done = function () {
                    return this.value
                }, r.prototype.valueOf = function () {
                    return this.value
                }, r.prototype.toString = function () {
                    return i.format(this.value)
                }, r.createProxy = n;
                for (var o in e) e.hasOwnProperty(o) && n(o, e[o]);
                return r
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = t(12),
                    i = t(11),
                    o = r.string.isString,
                    a = i.isCollection;
                e.compile = function (r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("compile", arguments.length, 1);
                    if (o(r)) return n(r).compile(e);
                    if (a(r)) return i.deepMap(r, function (r) {
                        return n(r).compile(e)
                    });
                    throw new TypeError("String, array, or matrix expected")
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = t(12),
                    i = t(11),
                    o = r.string.isString,
                    a = i.isCollection;
                e.eval = function (r, t) {
                    if (1 != arguments.length && 2 != arguments.length) throw new e.error.ArgumentsError("eval", arguments.length, 1, 2);
                    if (t = t || {}, o(r)) return n(r).compile(e).eval(t);
                    if (a(r)) return i.deepMap(r, function (r) {
                        return n(r).compile(e).eval(t)
                    });
                    throw new TypeError("String, array, or matrix expected")
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(10);
                e.help = function (t) {
                    if (1 != arguments.length) throw new SyntaxError("Wrong number of arguments in function help (" + arguments.length + " provided, 1 expected)");
                    var n = null;
                    if (t instanceof String || "string" == typeof t) n = t;
                    else {
                        var i;
                        for (i in e)
                            if (e.hasOwnProperty(i) && t === e[i]) {
                                n = i;
                                break
                            }
                    }
                    var o = e.expression.docs[n];
                    if (!n || !o) throw new Error('No documentation found on "' + n + '"');
                    return new r(e, o)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(12);
                e.parse = function () {
                    return r.apply(r, arguments)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = (t(8), t(11)),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.abs = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("abs", arguments.length, 1);
                    if (a(r)) return Math.abs(r);
                    if (u(r)) return Math.sqrt(r.re * r.re + r.im * r.im);
                    if (r instanceof n) return r.abs();
                    if (f(r)) return o.deepMap(r, c);
                    if (s(r)) return Math.abs(r);
                    throw new e.error.UnsupportedTypeError("abs", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = (t(8), t(9)),
                    a = t(11),
                    s = r["boolean"].isBoolean,
                    u = r.number.isNumber,
                    f = r.string.isString,
                    c = i.isComplex,
                    l = o.isUnit,
                    p = a.isCollection;
                e.add = function m(r, t) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("add", arguments.length, 2);
                    if (u(r)) {
                        if (u(t)) return r + t;
                        if (c(t)) return new i(r + t.re, t.im)
                    }
                    if (c(r)) {
                        if (c(t)) return new i(r.re + t.re, r.im + t.im);
                        if (u(t)) return new i(r.re + t, r.im)
                    }
                    if (l(r) && l(t)) {
                        if (null == r.value) throw new Error("Parameter x contains a unit with undefined value");
                        if (null == t.value) throw new Error("Parameter y contains a unit with undefined value");
                        if (!r.equalBase(t)) throw new Error("Units do not match");
                        var o = r.clone();
                        return o.value += t.value, o.fixPrefix = !1, o
                    }
                    if (r instanceof n) return u(t) ? t = n.convert(t) : s(t) && (t = new n(t ? 1 : 0)), t instanceof n ? r.plus(t) : m(r.toNumber(), t);
                    if (t instanceof n) return u(r) ? r = n.convert(r) : s(r) && (r = new n(r ? 1 : 0)), r instanceof n ? r.plus(t) : m(r, t.toNumber());
                    if (f(r) || f(t)) return r + t;
                    if (p(r) || p(t)) return a.deepMap2(r, t, m);
                    if (s(r)) return m(+r, t);
                    if (s(t)) return m(r, +t);
                    throw new e.error.UnsupportedTypeError("add", e["typeof"](r), e["typeof"](t))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = o.isCollection,
                    f = i.isComplex;
                e.ceil = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("ceil", arguments.length, 1);
                    if (a(r)) return Math.ceil(r);
                    if (f(r)) return new i(Math.ceil(r.re), Math.ceil(r.im));
                    if (r instanceof n) return r.ceil();
                    if (u(r)) return o.deepMap(r, c);
                    if (s(r)) return Math.ceil(r);
                    throw new e.error.UnsupportedTypeError("ceil", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(5),
                    a = t(9),
                    s = t(11),
                    u = n.number.isNumber,
                    f = n.number.nearlyEqual,
                    c = n["boolean"].isBoolean,
                    l = n.string.isString,
                    p = o.isComplex,
                    m = a.isUnit,
                    h = s.isCollection;
                e.compare = function g(t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("compare", arguments.length, 2);
                    if (u(t) && u(n)) return f(t, n, r.epsilon) ? 0 : t > n ? 1 : -1;
                    if (t instanceof i) return u(n) ? n = i.convert(n) : c(n) && (n = new i(n ? 1 : 0)), n instanceof i ? new i(t.cmp(n)) : g(t.toNumber(), n);
                    if (n instanceof i) return u(t) ? t = i.convert(t) : c(t) && (t = new i(t ? 1 : 0)), t instanceof i ? new i(t.cmp(n)) : g(t, n.toNumber());
                    if (m(t) && m(n)) {
                        if (!t.equalBase(n)) throw new Error("Cannot compare units with different base");
                        return t.value > n.value ? 1 : t.value < n.value ? -1 : 0
                    }
                    if (h(t) || h(n)) return s.deepMap2(t, n, g);
                    if (l(t) || l(n)) return t > n ? 1 : n > t ? -1 : 0;
                    if (c(t)) return g(+t, n);
                    if (c(n)) return g(t, +n);
                    if (p(t) || p(n)) throw new TypeError("No ordering relation is defined for complex numbers");
                    throw new e.error.UnsupportedTypeError("compare", e["typeof"](t), e["typeof"](n))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.cube = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("cube", arguments.length, 1);
                    if (a(r)) return r * r * r;
                    if (u(r)) return e.multiply(e.multiply(r, r), r);
                    if (r instanceof n) return r.times(r).times(r);
                    if (f(r)) return o.deepMap(r, c);
                    if (s(r)) return c(+r);
                    throw new e.error.UnsupportedTypeError("cube", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(e, r) {
                    var t = r.re * r.re + r.im * r.im;
                    return 0 != t ? new o((e.re * r.re + e.im * r.im) / t, (e.im * r.re - e.re * r.im) / t) : new o(0 != e.re ? e.re / 0 : 0, 0 != e.im ? e.im / 0 : 0)
                }
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(5),
                    a = (t(8), t(9)),
                    s = t(11),
                    u = n.number.isNumber,
                    f = n["boolean"].isBoolean,
                    c = o.isComplex,
                    l = a.isUnit,
                    p = s.isCollection;
                e.divide = function m(t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("divide", arguments.length, 2);
                    if (u(t)) {
                        if (u(n)) return t / n;
                        if (c(n)) return r(new o(t, 0), n)
                    }
                    if (c(t)) {
                        if (c(n)) return r(t, n);
                        if (u(n)) return r(t, new o(n, 0))
                    }
                    if (t instanceof i) return u(n) ? n = i.convert(n) : f(n) && (n = new i(n ? 1 : 0)), n instanceof i ? t.div(n) : m(t.toNumber(), n);
                    if (n instanceof i) return u(t) ? t = i.convert(t) : f(t) && (t = new i(t ? 1 : 0)), t instanceof i ? t.div(n) : m(t, n.toNumber());
                    if (l(t) && u(n)) {
                        var a = t.clone();
                        return a.value /= n, a
                    }
                    if (p(t)) return p(n) ? e.multiply(t, e.inv(n)) : s.deepMap2(t, n, m);
                    if (p(n)) return e.multiply(t, e.inv(n));
                    if (f(t)) return m(+t, n);
                    if (f(n)) return m(t, +n);
                    throw new e.error.UnsupportedTypeError("divide", e["typeof"](t), e["typeof"](n))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(11);
                e.edivide = function (t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("edivide", arguments.length, 2);
                    return r.deepMap2(t, n, e.divide)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = (t(123), t(11));
                e.emultiply = function (t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("emultiply", arguments.length, 2);
                    return r.deepMap2(t, n, e.multiply)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = (t(123), t(11));
                e.epow = function (t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("epow", arguments.length, 2);
                    return r.deepMap2(t, n, e.pow)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(5),
                    a = t(9),
                    s = t(11),
                    u = n.number.isNumber,
                    f = n.number.nearlyEqual,
                    c = n["boolean"].isBoolean,
                    l = n.string.isString,
                    p = o.isComplex,
                    m = a.isUnit,
                    h = s.isCollection;
                e.equal = function g(t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("equal", arguments.length, 2);
                    if (u(t)) {
                        if (u(n)) return f(t, n, r.epsilon);
                        if (p(n)) return f(t, n.re, r.epsilon) && f(n.im, 0, r.epsilon)
                    }
                    if (p(t)) {
                        if (u(n)) return f(t.re, n, r.epsilon) && f(t.im, 0, r.epsilon);
                        if (p(n)) return f(t.re, n.re, r.epsilon) && f(t.im, n.im, r.epsilon)
                    }
                    if (t instanceof i) return u(n) ? n = i.convert(n) : c(n) && (n = new i(n ? 1 : 0)), n instanceof i ? t.eq(n) : g(t.toNumber(), n);
                    if (n instanceof i) return u(t) ? t = i.convert(t) : c(t) && (t = new i(t ? 1 : 0)), t instanceof i ? t.eq(n) : g(t, n.toNumber());
                    if (m(t) && m(n)) {
                        if (!t.equalBase(n)) throw new Error("Cannot compare units with different base");
                        return t.value == n.value
                    }
                    if (h(t) || h(n)) return s.deepMap2(t, n, g);
                    if (l(t) || l(n)) return t == n;
                    if (c(t)) return g(+t, n);
                    if (c(n)) return g(t, +n);
                    throw new e.error.UnsupportedTypeError("equal", e["typeof"](t), e["typeof"](n))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = (t(8), t(11)),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.exp = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("exp", arguments.length, 1);
                    if (a(r)) return Math.exp(r);
                    if (u(r)) {
                        var t = Math.exp(r.re);
                        return new i(t * Math.cos(r.im), t * Math.sin(r.im))
                    }
                    if (r instanceof n) return r.exp();
                    if (f(r)) return o.deepMap(r, c);
                    if (s(r)) return Math.exp(r);
                    throw new e.error.UnsupportedTypeError("exp", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.fix = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("fix", arguments.length, 1);
                    if (a(r)) return r > 0 ? Math.floor(r) : Math.ceil(r);
                    if (u(r)) return new i(r.re > 0 ? Math.floor(r.re) : Math.ceil(r.re), r.im > 0 ? Math.floor(r.im) : Math.ceil(r.im));
                    if (r instanceof n) return r.isNegative() ? r.ceil() : r.floor();
                    if (f(r)) return o.deepMap(r, c);
                    if (s(r)) return c(+r);
                    throw new e.error.UnsupportedTypeError("fix", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.floor = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("floor", arguments.length, 1);
                    if (a(r)) return Math.floor(r);
                    if (u(r)) return new i(Math.floor(r.re), Math.floor(r.im));
                    if (r instanceof n) return r.floor();
                    if (f(r)) return o.deepMap(r, c);
                    if (s(r)) return c(+r);
                    throw new e.error.UnsupportedTypeError("floor", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(11),
                    o = r.number.isNumber,
                    a = r["boolean"].isBoolean,
                    s = r.number.isInteger,
                    u = i.isCollection;
                e.gcd = function f() {
                    var r, t = arguments[0],
                        c = arguments[1];
                    if (2 == arguments.length) {
                        if (o(t) && o(c)) {
                            if (!s(t) || !s(c)) throw new Error("Parameters in function gcd must be integer numbers");
                            for (; 0 != c;) r = t % c, t = c, c = r;
                            return 0 > t ? -t : t
                        }
                        if (u(t) || u(c)) return i.deepMap2(t, c, f);
                        if (t instanceof n) return f(t.toNumber(), c);
                        if (c instanceof n) return f(t, c.toNumber());
                        if (a(t)) return f(+t, c);
                        if (a(c)) return f(t, +c);
                        throw new e.error.UnsupportedTypeError("gcd", e["typeof"](t), e["typeof"](c))
                    }
                    if (arguments.length > 2) {
                        for (var l = 1; l < arguments.length; l++) t = f(t, arguments[l]);
                        return t
                    }
                    throw new SyntaxError("Function gcd expects two or more arguments")
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(5),
                    a = t(9),
                    s = t(11),
                    u = n.number.isNumber,
                    f = n.number.nearlyEqual,
                    c = n["boolean"].isBoolean,
                    l = n.string.isString,
                    p = o.isComplex,
                    m = a.isUnit,
                    h = s.isCollection;
                e.larger = function g(t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("larger", arguments.length, 2);
                    if (u(t) && u(n)) return !f(t, n, r.epsilon) && t > n;
                    if (t instanceof i) return u(n) ? n = i.convert(n) : c(n) && (n = new i(n ? 1 : 0)), n instanceof i ? t.gt(n) : g(t.toNumber(), n);
                    if (n instanceof i) return u(t) ? t = i.convert(t) : c(t) && (t = new i(t ? 1 : 0)), t instanceof i ? t.gt(n) : g(t, n.toNumber());
                    if (m(t) && m(n)) {
                        if (!t.equalBase(n)) throw new Error("Cannot compare units with different base");
                        return t.value > n.value
                    }
                    if (h(t) || h(n)) return s.deepMap2(t, n, g);
                    if (l(t) || l(n)) return t > n;
                    if (c(t)) return g(+t, n);
                    if (c(n)) return g(t, +n);
                    if (p(t) || p(n)) throw new TypeError("No ordering relation is defined for complex numbers");
                    throw new e.error.UnsupportedTypeError("larger", e["typeof"](t), e["typeof"](n))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(5),
                    a = t(9),
                    s = t(11),
                    u = n.number.isNumber,
                    f = n.number.nearlyEqual,
                    c = n["boolean"].isBoolean,
                    l = n.string.isString,
                    p = o.isComplex,
                    m = a.isUnit,
                    h = s.isCollection;
                e.largereq = function g(t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("largereq", arguments.length, 2);
                    if (u(t) && u(n)) return f(t, n, r.epsilon) || t > n;
                    if (t instanceof i) return u(n) ? n = i.convert(n) : c(n) && (n = new i(n ? 1 : 0)), n instanceof i ? t.gte(n) : g(t.toNumber(), n);
                    if (n instanceof i) return u(t) ? t = i.convert(t) : c(t) && (t = new i(t ? 1 : 0)), t instanceof i ? t.gte(n) : g(t, n.toNumber());
                    if (m(t) && m(n)) {
                        if (!t.equalBase(n)) throw new Error("Cannot compare units with different base");
                        return t.value >= n.value
                    }
                    if (h(t) || h(n)) return s.deepMap2(t, n, g);
                    if (l(t) || l(n)) return t >= n;
                    if (c(t)) return g(+t, n);
                    if (c(n)) return g(t, +n);
                    if (p(t) || p(n)) throw new TypeError("No ordering relation is defined for complex numbers");
                    throw new e.error.UnsupportedTypeError("largereq", e["typeof"](t), e["typeof"](n))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(11),
                    o = r.number.isNumber,
                    a = r["boolean"].isBoolean,
                    s = r.number.isInteger,
                    u = i.isCollection;
                e.lcm = function f() {
                    var r, t = arguments[0],
                        c = arguments[1];
                    if (2 == arguments.length) {
                        if (o(t) && o(c)) {
                            if (!s(t) || !s(c)) throw new Error("Parameters in function lcm must be integer numbers");
                            if (0 == t || 0 == c) return 0;
                            for (var l = t * c; 0 != c;) r = c, c = t % r, t = r;
                            return Math.abs(l / t)
                        }
                        if (u(t) || u(c)) return i.deepMap2(t, c, f);
                        if (a(t)) return f(+t, c);
                        if (a(c)) return f(t, +c);
                        if (t instanceof n) return f(t.toNumber(), c);
                        if (c instanceof n) return f(t, c.toNumber());
                        throw new e.error.UnsupportedTypeError("lcm", e["typeof"](t), e["typeof"](c))
                    }
                    if (arguments.length > 2) {
                        for (var p = 1; p < arguments.length; p++) t = f(t, arguments[p]);
                        return t
                    }
                    throw new SyntaxError("Function lcm expects two or more arguments")
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.log = function c(r, t) {
                    if (1 == arguments.length) {
                        if (a(r)) return r >= 0 ? Math.log(r) : c(new i(r, 0));
                        if (u(r)) return new i(Math.log(Math.sqrt(r.re * r.re + r.im * r.im)), Math.atan2(r.im, r.re));
                        if (r instanceof n) return r.isNegative() ? c(r.toNumber()) : r.ln();
                        if (f(r)) return o.deepMap(r, c);
                        if (s(r)) return c(+r);
                        throw new e.error.UnsupportedTypeError("log", e["typeof"](r))
                    }
                    if (2 == arguments.length) return e.divide(c(r), c(t));
                    throw new e.error.ArgumentsError("log", arguments.length, 1, 2)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.log10 = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("log10", arguments.length, 1);
                    if (a(r)) return r >= 0 ? Math.log(r) / Math.LN10 : c(new i(r, 0));
                    if (r instanceof n) return r.isNegative() ? c(r.toNumber()) : r.log();
                    if (u(r)) return new i(Math.log(Math.sqrt(r.re * r.re + r.im * r.im)) / Math.LN10, Math.atan2(r.im, r.re) / Math.LN10);
                    if (f(r)) return o.deepMap(r, c);
                    if (s(r)) return c(+r);
                    throw new e.error.UnsupportedTypeError("log10", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(e, r) {
                    if (r > 0) return e - r * Math.floor(e / r);
                    if (0 == r) return e;
                    throw new Error("Cannot calculate mod for a negative divisor")
                }
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(11),
                    a = n.number.isNumber,
                    s = n["boolean"].isBoolean,
                    u = o.isCollection;
                e.mod = function f(t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("mod", arguments.length, 2);
                    if (a(t) && a(n)) return r(t, n);
                    if (t instanceof i) return a(n) ? n = i.convert(n) : s(n) && (n = new i(n ? 1 : 0)), n instanceof i ? n.isZero() ? t : t.mod(n) : f(t.toNumber(), n);
                    if (n instanceof i) return a(t) ? t = i.convert(t) : s(t) && (t = new i(t ? 1 : 0)), t instanceof i ? n.isZero() ? t : t.mod(n) : f(t, n.toNumber());
                    if (u(t) || u(n)) return o.deepMap2(t, n, f);
                    if (s(t)) return f(+t, n);
                    if (s(n)) return f(t, +n);
                    throw new e.error.UnsupportedTypeError("mod", e["typeof"](t), e["typeof"](n))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r, t) {
                    for (var n = [], i = r.length, o = t[0].length, a = r[0].length, s = 0; i > s; s++) {
                        n[s] = [];
                        for (var u = 0; o > u; u++) {
                            for (var f = null, c = 0; a > c; c++) {
                                var l = e.multiply(r[s][c], t[c][u]);
                                f = null === f ? l : e.add(f, l)
                            }
                            n[s][u] = f
                        }
                    }
                    return n
                }

                function n(r, t) {
                    for (var n = [], i = t.length, o = t[0].length, a = 0; o > a; a++) {
                        for (var s = null, u = 0; i > u; u++) {
                            var f = e.multiply(r[u], t[u][a]);
                            s = 0 === u ? f : e.add(s, f)
                        }
                        n[a] = s
                    }
                    return n
                }

                function i(r, t) {
                    for (var n = [], i = r.length, o = r[0].length, a = 0; i > a; a++) {
                        for (var s = null, u = 0; o > u; u++) {
                            var f = e.multiply(r[a][u], t[u]);
                            s = 0 === u ? f : e.add(s, f)
                        }
                        n[a] = s
                    }
                    return n
                }

                function o(r, t) {
                    var n = r.length;
                    if (!n) throw new Error("Cannot multiply two empty vectors");
                    for (var i = 0, o = 0; n > o; o++) i = e.add(i, e.multiply(r[o], t[o]));
                    return i
                }

                function a(e, r) {
                    return 0 == e.im ? 0 == r.im ? new f(e.re * r.re, 0) : 0 == r.re ? new f(0, e.re * r.im) : new f(e.re * r.re, e.re * r.im) : 0 == e.re ? 0 == r.im ? new f(0, e.im * r.re) : 0 == r.re ? new f(-e.im * r.im, 0) : new f(-e.im * r.im, e.im * r.re) : 0 == r.im ? new f(e.re * r.re, e.im * r.re) : 0 == r.re ? new f(-e.im * r.im, e.re * r.im) : new f(e.re * r.re - e.im * r.im, e.re * r.im + e.im * r.re)
                }
                var s = t(123),
                    u = e.type.BigNumber,
                    f = t(5),
                    c = t(8),
                    l = t(9),
                    p = t(11),
                    m = s.array,
                    h = s.number.isNumber,
                    g = s["boolean"].isBoolean,
                    d = f.isComplex,
                    y = Array.isArray,
                    w = l.isUnit;
                e.multiply = function v(t, s) {
                    var l;
                    if (2 != arguments.length) throw new e.error.ArgumentsError("multiply", arguments.length, 2);
                    if (h(t)) {
                        if (h(s)) return t * s;
                        if (d(s)) return a(new f(t, 0), s);
                        if (w(s)) return l = s.clone(), l.value *= t, l
                    }
                    if (d(t)) {
                        if (h(s)) return a(t, new f(s, 0));
                        if (d(s)) return a(t, s)
                    }
                    if (t instanceof u) return h(s) ? s = u.convert(s) : g(s) && (s = new u(s ? 1 : 0)), s instanceof u ? t.times(s) : v(t.toNumber(), s);
                    if (s instanceof u) return h(t) ? t = u.convert(t) : g(t) && (t = new u(t ? 1 : 0)), t instanceof u ? t.times(s) : v(t, s.toNumber());
                    if (w(t) && h(s)) return l = t.clone(), l.value *= s, l;
                    if (y(t)) {
                        if (y(s)) {
                            var x = m.size(t),
                                b = m.size(s);
                            if (1 == x.length) {
                                if (1 == b.length) {
                                    if (x[0] != b[0]) throw new RangeError("Dimension mismatch in multiplication. Length of A must match length of B (A is " + x[0] + ", B is " + b[0] + x[0] + " != " + b[0] + ")");
                                    return o(t, s)
                                }
                                if (2 == b.length) {
                                    if (x[0] != b[0]) throw new RangeError("Dimension mismatch in multiplication. Length of A must match rows of B (A is " + x[0] + ", B is " + b[0] + "x" + b[1] + ", " + x[0] + " != " + b[0] + ")");
                                    return n(t, s)
                                }
                                throw new Error("Can only multiply a 1 or 2 dimensional matrix (B has " + b.length + " dimensions)")
                            }
                            if (2 == x.length) {
                                if (1 == b.length) {
                                    if (x[1] != b[0]) throw new RangeError("Dimension mismatch in multiplication. Columns of A must match length of B (A is " + x[0] + "x" + x[0] + ", B is " + b[0] + ", " + x[1] + " != " + b[0] + ")");
                                    return i(t, s)
                                }
                                if (2 == b.length) {
                                    if (x[1] != b[0]) throw new RangeError("Dimension mismatch in multiplication. Columns of A must match rows of B (A is " + x[0] + "x" + x[1] + ", B is " + b[0] + "x" + b[1] + ", " + x[1] + " != " + b[0] + ")");
                                    return r(t, s)
                                }
                                throw new Error("Can only multiply a 1 or 2 dimensional matrix (B has " + b.length + " dimensions)")
                            }
                            throw new Error("Can only multiply a 1 or 2 dimensional matrix (A has " + x.length + " dimensions)")
                        }
                        return s instanceof c ? new c(v(t, s.valueOf())) : p.deepMap2(t, s, v)
                    }
                    if (t instanceof c) return new c(s instanceof c ? v(t.valueOf(), s.valueOf()) : v(t.valueOf(), s));
                    if (y(s)) return p.deepMap2(t, s, v);
                    if (s instanceof c) return new c(p.deepMap2(t, s.valueOf(), v));
                    if (g(t)) return v(+t, s);
                    if (g(s)) return v(t, +s);
                    throw new e.error.UnsupportedTypeError("multiply", e["typeof"](t), e["typeof"](s))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                {
                    var r = t(123),
                        n = t(153),
                        i = e.type.BigNumber,
                        o = t(5),
                        a = t(8),
                        s = t(11),
                        u = r.number.isNumber,
                        f = r["boolean"].isBoolean,
                        c = o.isComplex;
                    s.isCollection
                }
                e.norm = function l(r, t) {
                    if (arguments.length < 1 || arguments.length > 2) throw new e.error.ArgumentsError("abs", arguments.length, 1, 2);
                    if (u(r)) return Math.abs(r);
                    if (c(r)) return Math.sqrt(r.re * r.re + r.im * r.im);
                    if (r instanceof i) return r.abs();
                    if (f(r)) return Math.abs(r);
                    if (isArray(r)) {
                        var o = n.size(r);
                        if (null == t && (t = 2), 1 == o.length) {
                            if (t === Number.POSITIVE_INFINITY || "inf" === t) {
                                var s;
                                return e.forEach(r, function (r) {
                                    var t = e.abs(r);
                                    (!s || e.larger(t, s)) && (s = t)
                                }), s
                            }
                            if (t === Number.NEGATIVE_INFINITY || "-inf" === t) {
                                var s;
                                return e.forEach(r, function (r) {
                                    var t = e.abs(r);
                                    (!s || e.smaller(t, s)) && (s = t)
                                }), s
                            }
                            if ("fro" === t) return l(r);
                            if (u(t) && !isNaN(t)) {
                                if (!e.equal(t, 0)) {
                                    var s = 0;
                                    return e.forEach(r, function (r) {
                                        s = e.add(e.pow(e.abs(r), t), s)
                                    }), e.pow(s, 1 / t)
                                }
                                return Number.POSITIVE_INFINITY
                            }
                            throw new Error("Unsupported parameter value")
                        }
                        if (2 == o.length) {
                            if (1 == t) {
                                for (var p = [], m = 0; m < r.length; m++)
                                    for (var h = r[m], g = 0; g < h.length; g++) p[g] = e.add(p[g] || 0, e.abs(h[g]));
                                return e.max(p)
                            }
                            if (t == Number.POSITIVE_INFINITY || "inf" === t) {
                                for (var s = 0, m = 0; m < r.length; m++) {
                                    for (var d = 0, h = r[m], g = 0; g < h.length; g++) d = e.add(d, e.abs(h[g]));
                                    e.larger(d, s) && (s = d)
                                }
                                return s
                            }
                            if ("fro" === t) {
                                var y = e.diag(e.multiply(e.transpose(r), r)),
                                    w = 0;
                                return e.forEach(y, function (r) {
                                    w = e.add(r, w)
                                }), e.sqrt(w)
                            }
                            if (2 == t) throw new Error("Unsupported parameter value, missing implementation of matrix singular value decomposition");
                            throw new Error("Unsupported parameter value")
                        }
                    }
                    if (r instanceof a) return l(r.valueOf(), t);
                    throw new e.error.UnsupportedTypeError("norm", r)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r, t) {
                    var n = e.log(r),
                        i = e.multiply(n, t);
                    return e.exp(i)
                }
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(5),
                    a = t(8),
                    s = (t(11), n.array),
                    u = n.number.isNumber,
                    f = n["boolean"].isBoolean,
                    c = Array.isArray,
                    l = n.number.isInteger,
                    p = o.isComplex;
                e.pow = function m(t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("pow", arguments.length, 2);
                    if (u(t)) {
                        if (u(n)) return l(n) || t >= 0 ? Math.pow(t, n) : r(new o(t, 0), new o(n, 0));
                        if (p(n)) return r(new o(t, 0), n)
                    }
                    if (p(t)) {
                        if (u(n)) return r(t, new o(n, 0));
                        if (p(n)) return r(t, n)
                    }
                    if (t instanceof i) return u(n) ? n = i.convert(n) : f(n) && (n = new i(n ? 1 : 0)), n instanceof i ? n.isInteger() && !t.isNegative() ? t.pow(n) : m(t.toNumber(), n.toNumber()) : m(t.toNumber(), n);
                    if (n instanceof i) return u(t) ? t = i.convert(t) : f(t) && (t = new i(t ? 1 : 0)), t instanceof i ? n.isInteger() && !t.isNegative() ? t.pow(n) : m(t.toNumber(), n.toNumber()) : m(t, n.toNumber());
                    if (c(t)) {
                        if (!u(n) || !l(n) || 0 > n) throw new TypeError("For A^b, b must be a positive integer (value is " + n + ")");
                        var h = s.size(t);
                        if (2 != h.length) throw new Error("For A^b, A must be 2 dimensional (A has " + h.length + " dimensions)");
                        if (h[0] != h[1]) throw new Error("For A^b, A must be square (size is " + h[0] + "x" + h[1] + ")");
                        for (var g = e.eye(h[0]).valueOf(), d = t; n >= 1;) 1 == (1 & n) && (g = e.multiply(d, g)), n >>= 1, d = e.multiply(d, d);
                        return g
                    }
                    if (t instanceof a) return new a(m(t.valueOf(), n));
                    if (f(t)) return m(+t, n);
                    if (f(n)) return m(t, +n);
                    throw new e.error.UnsupportedTypeError("pow", e["typeof"](t), e["typeof"](n))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(e, r) {
                    var t = Math.pow(10, r);
                    return Math.round(e * t) / t
                }
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(5),
                    a = t(11),
                    s = n.number.isNumber,
                    u = n.number.isInteger,
                    f = n["boolean"].isBoolean,
                    c = o.isComplex,
                    l = a.isCollection;
                e.round = function p(t, n) {
                    if (1 != arguments.length && 2 != arguments.length) throw new e.error.ArgumentsError("round", arguments.length, 1, 2);
                    if (void 0 == n) {
                        if (s(t)) return Math.round(t);
                        if (c(t)) return new o(Math.round(t.re), Math.round(t.im));
                        if (t instanceof i) return t.toDecimalPlaces(0);
                        if (l(t)) return a.deepMap(t, p);
                        if (f(t)) return Math.round(t);
                        throw new e.error.UnsupportedTypeError("round", e["typeof"](t))
                    }
                    if (!s(n) || !u(n)) {
                        if (!(n instanceof i)) {
                            if (f(n)) return p(t, +n);
                            throw new TypeError("Number of decimals in function round must be an integer")
                        }
                        n = parseFloat(n.valueOf())
                    }
                    if (0 > n || n > 15) throw new Error("Number of decimals in function round must be in te range of 0-15");
                    if (s(t)) return r(t, n);
                    if (c(t)) return new o(r(t.re, n), r(t.im, n));
                    if (t instanceof i) return t.toDecimalPlaces(n);
                    if (l(t) || l(n)) return a.deepMap2(t, n, p);
                    if (f(t)) return p(+t, n);
                    throw new e.error.UnsupportedTypeError("round", e["typeof"](t), e["typeof"](n))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number,
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isCollection;
                e.sign = function l(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("sign", arguments.length, 1);
                    if (s(r)) return a.sign(r);
                    if (f(r)) {
                        var t = Math.sqrt(r.re * r.re + r.im * r.im);
                        return new i(r.re / t, r.im / t)
                    }
                    if (r instanceof n) return new n(r.cmp(0));
                    if (c(r)) return o.deepMap(r, l);
                    if (u(r)) return a.sign(r);
                    throw new e.error.UnsupportedTypeError("sign", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(5),
                    a = t(9),
                    s = t(11),
                    u = n.number.isNumber,
                    f = n.number.nearlyEqual,
                    c = n["boolean"].isBoolean,
                    l = n.string.isString,
                    p = o.isComplex,
                    m = a.isUnit,
                    h = s.isCollection;
                e.smaller = function g(t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("smaller", arguments.length, 2);
                    if (u(t) && u(n)) return !f(t, n, r.epsilon) && n > t;
                    if (t instanceof i) return u(n) ? n = i.convert(n) : c(n) && (n = new i(n ? 1 : 0)), n instanceof i ? t.lt(n) : g(t.toNumber(), n);
                    if (n instanceof i) return u(t) ? t = i.convert(t) : c(t) && (t = new i(t ? 1 : 0)), t instanceof i ? t.lt(n) : g(t, n.toNumber());
                    if (m(t) && m(n)) {
                        if (!t.equalBase(n)) throw new Error("Cannot compare units with different base");
                        return t.value < n.value
                    }
                    if (h(t) || h(n)) return s.deepMap2(t, n, g);
                    if (l(t) || l(n)) return n > t;
                    if (c(t)) return g(+t, n);
                    if (c(n)) return g(t, +n);
                    if (p(t) || p(n)) throw new TypeError("No ordering relation is defined for complex numbers");
                    throw new e.error.UnsupportedTypeError("smaller", e["typeof"](t), e["typeof"](n))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(5),
                    a = t(9),
                    s = t(11),
                    u = n.number.isNumber,
                    f = n.number.nearlyEqual,
                    c = n["boolean"].isBoolean,
                    l = n.string.isString,
                    p = o.isComplex,
                    m = a.isUnit,
                    h = s.isCollection;
                e.smallereq = function g(t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("smallereq", arguments.length, 2);
                    if (u(t) && u(n)) return f(t, n, r.epsilon) || n > t;
                    if (t instanceof i) return u(n) ? n = i.convert(n) : c(n) && (n = new i(n ? 1 : 0)), n instanceof i ? t.lte(n) : g(t.toNumber(), n);
                    if (n instanceof i) return u(t) ? t = i.convert(t) : c(t) && (t = new i(t ? 1 : 0)), t instanceof i ? t.lte(n) : g(t, n.toNumber());
                    if (m(t) && m(n)) {
                        if (!t.equalBase(n)) throw new Error("Cannot compare units with different base");
                        return t.value <= n.value
                    }
                    if (h(t) || h(n)) return s.deepMap2(t, n, g);
                    if (l(t) || l(n)) return n >= t;
                    if (c(t)) return g(+t, n);
                    if (c(n)) return g(t, +n);
                    if (p(t) || p(n)) throw new TypeError("No ordering relation is defined for complex numbers");
                    throw new e.error.UnsupportedTypeError("smallereq", e["typeof"](t), e["typeof"](n))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.sqrt = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("sqrt", arguments.length, 1);
                    if (a(r)) return r >= 0 ? Math.sqrt(r) : c(new i(r, 0));
                    if (u(r)) {
                        var t = Math.sqrt(r.re * r.re + r.im * r.im);
                        return r.im >= 0 ? new i(.5 * Math.sqrt(2 * (t + r.re)), .5 * Math.sqrt(2 * (t - r.re))) : new i(.5 * Math.sqrt(2 * (t + r.re)), -.5 * Math.sqrt(2 * (t - r.re)))
                    }
                    if (r instanceof n) return r.isNegative() ? c(r.toNumber()) : r.sqrt();
                    if (f(r)) return o.deepMap(r, c);
                    if (s(r)) return c(+r);
                    throw new e.error.UnsupportedTypeError("sqrt", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.square = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("square", arguments.length, 1);
                    if (a(r)) return r * r;
                    if (u(r)) return e.multiply(r, r);
                    if (r instanceof n) return r.times(r);
                    if (f(r)) return o.deepMap(r, c);
                    if (s(r)) return r * r;
                    throw new e.error.UnsupportedTypeError("square", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = (t(8), t(9)),
                    a = t(11),
                    s = r["boolean"].isBoolean,
                    u = r.number.isNumber,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.subtract = function p(r, t) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("subtract", arguments.length, 2);
                    if (u(r)) {
                        if (u(t)) return r - t;
                        if (f(t)) return new i(r - t.re, -t.im)
                    } else if (f(r)) {
                        if (u(t)) return new i(r.re - t, r.im);
                        if (f(t)) return new i(r.re - t.re, r.im - t.im)
                    }
                    if (r instanceof n) return u(t) ? t = n.convert(t) : s(t) && (t = new n(t ? 1 : 0)), t instanceof n ? r.minus(t) : p(r.toNumber(), t);
                    if (t instanceof n) return u(r) ? r = n.convert(r) : s(r) && (r = new n(r ? 1 : 0)), r instanceof n ? r.minus(t) : p(r, t.toNumber());
                    if (c(r) && c(t)) {
                        if (null == r.value) throw new Error("Parameter x contains a unit with undefined value");
                        if (null == t.value) throw new Error("Parameter y contains a unit with undefined value");
                        if (!r.equalBase(t)) throw new Error("Units do not match");
                        var o = r.clone();
                        return o.value -= t.value, o.fixPrefix = !1, o
                    }
                    if (l(r) || l(t)) return a.deepMap2(r, t, p);
                    if (s(r)) return p(+r, t);
                    if (s(t)) return p(r, +t);
                    throw new e.error.UnsupportedTypeError("subtract", e["typeof"](r), e["typeof"](t))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.unary = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("unary", arguments.length, 1);
                    if (s(r)) return -r;
                    if (f(r)) return new i(-r.re, -r.im);
                    if (r instanceof n) return r.neg();
                    if (c(r)) {
                        var t = r.clone();
                        return t.value = -r.value, t
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return -r;
                    throw new e.error.UnsupportedTypeError("unary", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(5),
                    a = t(9),
                    s = t(11),
                    u = n.number.isNumber,
                    f = n.number.nearlyEqual,
                    c = n["boolean"].isBoolean,
                    l = n.string.isString,
                    p = o.isComplex,
                    m = a.isUnit,
                    h = s.isCollection;
                e.unequal = function g(t, n) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("unequal", arguments.length, 2);
                    if (u(t)) {
                        if (u(n)) return !f(t, n, r.epsilon);
                        if (p(n)) return !f(t, n.re, r.epsilon) || !f(n.im, 0, r.epsilon)
                    }
                    if (p(t)) {
                        if (u(n)) return !f(t.re, n, r.epsilon) || !f(t.im, 0, r.epsilon);
                        if (p(n)) return !f(t.re, n.re, r.epsilon) || !f(t.im, n.im, r.epsilon)
                    }
                    if (t instanceof i) return u(n) ? n = i.convert(n) : c(n) && (n = new i(n ? 1 : 0)), n instanceof i ? !t.eq(n) : g(t.toNumber(), n);
                    if (n instanceof i) return u(t) ? t = i.convert(t) : c(t) && (t = new i(t ? 1 : 0)), t instanceof i ? !t.eq(n) : g(t, n.toNumber());
                    if (m(t) && m(n)) {
                        if (!t.equalBase(n)) throw new Error("Cannot compare units with different base");
                        return t.value != n.value
                    }
                    if (h(t) || h(n)) return s.deepMap2(t, n, g);
                    if (l(t) || l(n)) return t != n;
                    if (c(t)) return g(+t, n);
                    if (c(n)) return g(t, +n);
                    throw new e.error.UnsupportedTypeError("unequal", e["typeof"](t), e["typeof"](n))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(e, r) {
                    for (var t, n, i, o = 0, a = 1, s = 1, u = 0; r;) n = Math.floor(e / r), i = e % r, t = o, o = a - n * o, a = t, t = s, s = u - n * s, u = t, e = r, r = i;
                    return 0 > e ? [-e, -a, -u] : [e, e ? a : 0, u]
                }
                var n = t(123),
                    i = e.type.BigNumber,
                    o = n.number.isNumber,
                    a = n["boolean"].isBoolean,
                    s = n.number.isInteger;
                e.xgcd = function u(t, n) {
                    if (2 == arguments.length) {
                        if (o(t) && o(n)) {
                            if (!s(t) || !s(n)) throw new Error("Parameters in function xgcd must be integer numbers");
                            return r(t, n)
                        }
                        if (t instanceof i) return u(t.toNumber(), n);
                        if (n instanceof i) return u(t, n.toNumber());
                        if (a(t)) return u(+t, n);
                        if (a(n)) return u(t, +n);
                        throw new e.error.UnsupportedTypeError("xgcd", e["typeof"](t), e["typeof"](n))
                    }
                    throw new SyntaxError("Function xgcd expects two arguments")
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = o.isCollection,
                    f = i.isComplex;
                e.arg = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("arg", arguments.length, 1);
                    if (a(r)) return Math.atan2(0, r);
                    if (f(r)) return Math.atan2(r.im, r.re);
                    if (u(r)) return o.deepMap(r, c);
                    if (s(r)) return c(+r);
                    if (r instanceof n) return c(r.toNumber());
                    throw new e.error.UnsupportedTypeError("arg", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.object,
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = o.isCollection,
                    c = i.isComplex;
                e.conj = function l(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("conj", arguments.length, 1);
                    return s(r) ? r : r instanceof n ? new n(r) : c(r) ? new i(r.re, -r.im) : f(r) ? o.deepMap(r, l) : u(r) ? +r : a.clone(r)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.object,
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = o.isCollection,
                    c = i.isComplex;
                e.re = function l(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("re", arguments.length, 1);
                    return s(r) ? r : r instanceof n ? new n(r) : c(r) ? r.re : f(r) ? o.deepMap(r, l) : u(r) ? +r : a.clone(r)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = o.isCollection,
                    f = i.isComplex;
                e.im = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("im", arguments.length, 1);
                    return a(r) ? 0 : r instanceof n ? new n(0) : f(r) ? r.im : u(r) ? o.deepMap(r, c) : s(r) ? 0 : 0
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(11),
                    o = i.isCollection,
                    a = r.number.isNumber,
                    s = r.string.isString,
                    u = r["boolean"].isBoolean;
                e.bignumber = function f(r) {
                    if (arguments.length > 1) throw new e.error.ArgumentsError("bignumber", arguments.length, 0, 1);
                    if (r instanceof n || a(r) || s(r)) return new n(r);
                    if (u(r)) return new n(+r);
                    if (o(r)) return i.deepMap(r, f);
                    if (0 == arguments.length) return new n(0);
                    throw new e.error.UnsupportedTypeError("bignumber", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(11),
                    o = i.isCollection,
                    a = r.number.isNumber,
                    s = r.string.isString;
                e["boolean"] = function u(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("boolean", arguments.length, 0, 1);
                    if ("true" === r || r === !0) return !0;
                    if ("false" === r || r === !1) return !1;
                    if (r instanceof Boolean) return 1 == r;
                    if (a(r)) return 0 !== r;
                    if (r instanceof n) return !r.isZero();
                    if (s(r)) {
                        var t = r.toLowerCase();
                        if ("true" === t) return !0;
                        if ("false" === t) return !1;
                        var f = Number(r);
                        if ("" != r && !isNaN(f)) return 0 !== f
                    }
                    if (o(r)) return i.deepMap(r, u);
                    throw new SyntaxError(r.toString() + " is no valid boolean")
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = o.isCollection,
                    s = r.number.isNumber,
                    u = r.string.isString,
                    f = i.isComplex;
                e.complex = function c() {
                    switch (arguments.length) {
                    case 0:
                        return new i(0, 0);
                    case 1:
                        var r = arguments[0];
                        if (s(r)) return new i(r, 0);
                        if (r instanceof n) return new i(r.toNumber(), 0);
                        if (f(r)) return r.clone();
                        if (u(r)) {
                            var t = i.parse(r);
                            if (t) return t;
                            throw new SyntaxError('String "' + r + '" is no valid complex number')
                        }
                        if (a(r)) return o.deepMap(r, c);
                        if ("object" == typeof r) {
                            if ("re" in r && "im" in r) return new i(r.re, r.im);
                            if ("r" in r && "phi" in r) return i.fromPolar(r.r, r.phi)
                        }
                        throw new TypeError("Two numbers, single string or an fitting object expected in function complex");
                    case 2:
                        var l = arguments[0],
                            p = arguments[1];
                        if (l instanceof n && (l = l.toNumber()), p instanceof n && (p = p.toNumber()), s(l) && s(p)) return new i(l, p);
                        throw new TypeError("Two numbers or a single string expected in function complex");
                    default:
                        throw new e.error.ArgumentsError("complex", arguments.length, 0, 2)
                    }
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = (t(123), e.type.BigNumber),
                    n = t(7);
                e.index = function () {
                    var e = new n,
                        t = Array.prototype.slice.apply(arguments).map(function (e) {
                            return e instanceof r ? e.toNumber() : Array.isArray(e) ? e.map(function (e) {
                                return e instanceof r ? e.toNumber() : e
                            }) : e
                        });
                    return n.apply(e, t), e
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = (t(123), t(8));
                e.matrix = function (t) {
                    if (arguments.length > 1) throw new e.error.ArgumentsError("matrix", arguments.length, 0, 1);
                    return new r(t)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(11),
                    o = i.isCollection,
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = r.string.isString;
                e.number = function f(r) {
                    switch (arguments.length) {
                    case 0:
                        return 0;
                    case 1:
                        if (o(r)) return i.deepMap(r, f);
                        if (r instanceof n) return r.toNumber();
                        if (u(r)) {
                            var t = Number(r);
                            if (isNaN(t) && (t = Number(r.valueOf())), isNaN(t)) throw new SyntaxError(r.toString() + " is no valid number");
                            return t
                        }
                        if (s(r)) return r + 0;
                        if (a(r)) return r;
                        throw new e.error.UnsupportedTypeError("number", e["typeof"](r));
                    default:
                        throw new e.error.ArgumentsError("number", arguments.length, 0, 1)
                    }
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(13);
                e.parser = function () {
                    return new r(e)
                }
            }
        },
        function (e) {
            e.exports = function (e) {
                e.select = function (r) {
                    return new e.chaining.Selector(r)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = t(11),
                    i = r.number,
                    o = r.number.isNumber,
                    a = n.isCollection;
                e.string = function s(r) {
                    switch (arguments.length) {
                    case 0:
                        return "";
                    case 1:
                        return o(r) ? i.format(r) : a(r) ? n.deepMap(r, s) : null === r ? "null" : r.toString();
                    default:
                        throw new e.error.ArgumentsError("string", arguments.length, 0, 1)
                    }
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(9),
                    o = t(11),
                    a = o.isCollection,
                    s = r.string.isString;
                e.unit = function u(r) {
                    switch (arguments.length) {
                    case 1:
                        var t = arguments[0];
                        if (t instanceof i) return t.clone();
                        if (s(t)) {
                            if (i.isValuelessUnit(t)) return new i(null, t);
                            var f = i.parse(t);
                            if (f) return f;
                            throw new SyntaxError('String "' + t + '" is no valid unit')
                        }
                        if (a(r)) return o.deepMap(r, u);
                        throw new TypeError("A string or a number and string expected in function unit");
                    case 2:
                        return arguments[0] instanceof n ? new i(arguments[0].toNumber(), arguments[1]) : new i(arguments[0], arguments[1]);
                    default:
                        throw new e.error.ArgumentsError("unit", arguments.length, 1, 2)
                    }
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(t, n, i, o) {
                    if (i > o) {
                        if (t.length != n.length) throw new e.error.DimensionError(t.length, n.length);
                        for (var a = [], s = 0; s < t.length; s++) a[s] = r(t[s], n[s], i, o + 1);
                        return a
                    }
                    return t.concat(n)
                }
                var n = t(123),
                    i = t(8),
                    o = t(11),
                    a = n.object,
                    s = n.array,
                    u = n.number.isNumber,
                    f = n.number.isInteger,
                    c = o.isCollection;
                e.concat = function () {
                    var t, n, o = arguments.length,
                        l = -1,
                        p = !1,
                        m = [];
                    for (t = 0; o > t; t++) {
                        var h = arguments[t];
                        if (h instanceof i && (p = !0), t == o - 1 && u(h)) {
                            if (n = l, l = h, !f(l) || 0 > l) throw new TypeError("Dimension number must be a positive integer (dim = " + l + ")");
                            if (t > 0 && l > n) throw new e.error.DimensionError(l, n, ">")
                        } else {
                            if (!c(h)) throw new e.error.UnsupportedTypeError("concat", e["typeof"](h));
                            var g = a.clone(h).valueOf(),
                                d = s.size(h.valueOf());
                            if (m[t] = g, n = l, l = d.length - 1, t > 0 && l != n) throw new e.error.DimensionError(l, n)
                        }
                    }
                    if (0 == m.length) throw new SyntaxError("At least one matrix expected");
                    for (var y = m.shift(); m.length;) y = r(y, m.shift(), l, 0);
                    return p ? new i(y) : y
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r, t) {
                    function n(r) {
                        var t, n, i = new Array(r.length),
                            o = 0;
                        for (t = 1; t < r.length; t++) o = e.add(o, r[t][t]);
                        for (t = 0; t < r.length; t++) {
                            for (i[t] = new Array(r.length), i[t][t] = e.unary(o), n = 0; t > n; n++) i[t][n] = 0;
                            for (n = t + 1; n < r.length; n++) i[t][n] = r[t][n];
                            t + 1 < r.length && (o = e.subtract(o, r[t + 1][t + 1]))
                        }
                        return i
                    }
                    if (1 == t) return o.clone(r[0][0]);
                    if (2 == t) return e.subtract(e.multiply(r[0][0], r[1][1]), e.multiply(r[1][0], r[0][1]));
                    for (var i = r, a = 0; t - 1 > a; a++) i = e.multiply(n(i), r);
                    return t % 2 == 0 ? e.unary(i[0][0]) : i[0][0]
                }
                var n = t(123),
                    i = t(8),
                    o = n.object,
                    a = n.string;
                e.det = function (t) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("det", arguments.length, 1);
                    var n;
                    switch (t instanceof i ? n = t.size() : t instanceof Array ? (t = new i(t), n = t.size()) : n = [], n.length) {
                    case 0:
                        return o.clone(t);
                    case 1:
                        if (1 == n[0]) return o.clone(t.valueOf()[0]);
                        throw new RangeError("Matrix must be square (size: " + a.format(n) + ")");
                    case 2:
                        var s = n[0],
                            u = n[1];
                        if (s == u) return r(t.clone().valueOf(), s, u);
                        throw new RangeError("Matrix must be square (size: " + a.format(n) + ")");
                    default:
                        throw new RangeError("Matrix must be two dimensional (size: " + a.format(n) + ")")
                    }
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(8),
                    o = r.object,
                    a = r.array.isArray,
                    s = r.number.isNumber,
                    u = r.number.isInteger;
                e.diag = function (r, t) {
                    var f, c, l, p;
                    if (1 != arguments.length && 2 != arguments.length) throw new e.error.ArgumentsError("diag", arguments.length, 1, 2);
                    if (t) {
                        if (t instanceof n && (t = t.toNumber()), !s(t) || !u(t)) throw new TypeError("Second parameter in function diag must be an integer")
                    } else t = 0;
                    var m, h = t > 0 ? t : 0,
                        g = 0 > t ? -t : 0;
                    if (r instanceof i) m = !1;
                    else {
                        if (!a(r)) throw new TypeError("First parameter in function diag must be a Matrix or Array");
                        r = new i(r), m = !0
                    }
                    var d = r.size();
                    switch (d.length) {
                    case 1:
                        c = r.valueOf();
                        var y = new i,
                            w = c[0] instanceof n ? new n(0) : 0;
                        for (y.resize([c.length + g, c.length + h], w), f = y.valueOf(), p = c.length, l = 0; p > l; l++) f[l + g][l + h] = o.clone(c[l]);
                        return m ? y.valueOf() : y;
                    case 2:
                        for (c = [], f = r.valueOf(), p = Math.min(d[0] - g, d[1] - h), l = 0; p > l; l++) c[l] = o.clone(f[l + g][l + h]);
                        return m ? c : new i(c);
                    default:
                        throw new RangeError("Matrix for function diag must be 2 dimensional")
                    }
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(8),
                    a = t(11),
                    s = n.number.isNumber,
                    u = n.number.isInteger,
                    f = Array.isArray;
                e.eye = function (t) {
                    var n = a.argsToArray(arguments),
                        c = t instanceof o ? !0 : f(t) ? !1 : "matrix" === r.matrix;
                    if (0 == n.length) return c ? new o : [];
                    if (1 == n.length) n[1] = n[0];
                    else if (n.length > 2) throw new e.error.ArgumentsError("eye", n.length, 0, 2);
                    var l = n[0],
                        p = n[1];
                    if (l instanceof i && (l = l.toNumber()), p instanceof i && (p = p.toNumber()), !s(l) || !u(l) || 1 > l) throw new Error("Parameters in function eye must be positive integers");
                    if (!s(p) || !u(p) || 1 > p) throw new Error("Parameters in function eye must be positive integers");
                    var m = !1;
                    n = n.map(function (e) {
                        return e instanceof i ? (m = !0, e.toNumber()) : e
                    });
                    var h = new o,
                        g = m ? new i(1) : 1,
                        d = m ? new i(0) : 0;
                    h.resize(n, d);
                    for (var y = e.min(n), w = h.valueOf(), v = 0; y > v; v++) w[v][v] = g;
                    return c ? h : h.valueOf()
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r, t, n) {
                    var i, o, a, s, u;
                    if (1 == t) {
                        if (s = r[0][0], 0 == s) throw Error("Cannot calculate inverse, determinant is zero");
                        return [[e.divide(1, s)]]
                    }
                    if (2 == t) {
                        var f = e.det(r);
                        if (0 == f) throw Error("Cannot calculate inverse, determinant is zero");
                        return [[e.divide(r[1][1], f), e.divide(e.unary(r[0][1]), f)], [e.divide(e.unary(r[1][0]), f), e.divide(r[0][0], f)]]
                    }
                    var c = r.concat();
                    for (i = 0; t > i; i++) c[i] = c[i].concat();
                    for (var l = e.eye(t).valueOf(), p = 0; n > p; p++) {
                        for (i = p; t > i && 0 == c[i][p];) i++;
                        if (i == t || 0 == c[i][p]) throw Error("Cannot calculate inverse, determinant is zero");
                        i != p && (u = c[p], c[p] = c[i], c[i] = u, u = l[p], l[p] = l[i], l[i] = u);
                        var m = c[p],
                            h = l[p];
                        for (i = 0; t > i; i++) {
                            var g = c[i],
                                d = l[i];
                            if (i != p) {
                                if (0 != g[p]) {
                                    for (a = e.divide(e.unary(g[p]), m[p]), o = p; n > o; o++) g[o] = e.add(g[o], e.multiply(a, m[o]));
                                    for (o = 0; n > o; o++) d[o] = e.add(d[o], e.multiply(a, h[o]))
                                }
                            } else {
                                for (a = m[p], o = p; n > o; o++) g[o] = e.divide(g[o], a);
                                for (o = 0; n > o; o++) d[o] = e.divide(d[o], a)
                            }
                        }
                    }
                    return l
                } {
                    var n = t(123),
                        i = n.string,
                        o = t(8);
                    t(11)
                }
                e.inv = function (t) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("inv", arguments.length, 1);
                    var n = e.size(t).valueOf();
                    switch (n.length) {
                    case 0:
                        return e.divide(1, t);
                    case 1:
                        if (1 == n[0]) return t instanceof o ? new o([e.divide(1, t.valueOf()[0])]) : [e.divide(1, t[0])];
                        throw new RangeError("Matrix must be square (size: " + i.format(n) + ")");
                    case 2:
                        var a = n[0],
                            s = n[1];
                        if (a == s) return t instanceof o ? new o(r(t.valueOf(), a, s)) : r(t, a, s);
                        throw new RangeError("Matrix must be square (size: " + i.format(n) + ")");
                    default:
                        throw new RangeError("Matrix must be two dimensional (size: " + i.format(n) + ")")
                    }
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(8),
                    a = t(11),
                    s = n.array,
                    u = Array.isArray;
                e.ones = function (e) {
                    var t = a.argsToArray(arguments),
                        n = e instanceof o ? !0 : u(e) ? !1 : "matrix" === r.matrix;
                    if (0 == t.length) return n ? new o : [];
                    var f = !1;
                    t = t.map(function (e) {
                        return e instanceof i ? (f = !0, e.toNumber()) : e
                    });
                    var c = [],
                        l = f ? new i(1) : 1;
                    return c = s.resize(c, t, l), n ? new o(c) : c
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                function n(e, r, t) {
                    var n = [],
                        i = e;
                    if (t > 0)
                        for (; r > i;) n.push(i), i += t;
                    else if (0 > t)
                        for (; i > r;) n.push(i), i += t;
                    return n
                }

                function i(e, r, t) {
                    var n = [],
                        i = e;
                    if (t > 0)
                        for (; r >= i;) n.push(i), i += t;
                    else if (0 > t)
                        for (; i >= r;) n.push(i), i += t;
                    return n
                }

                function o(e, r, t) {
                    var n = [],
                        i = e.clone(),
                        o = new f(0);
                    if (t.gt(o))
                        for (; i.lt(r);) n.push(i), i = i.plus(t);
                    else if (t.lt(o))
                        for (; i.gt(r);) n.push(i), i = i.plus(t);
                    return n
                }

                function a(e, r, t) {
                    var n = [],
                        i = e.clone(),
                        o = new f(0);
                    if (t.gt(o))
                        for (; i.lte(r);) n.push(i), i = i.plus(t);
                    else if (t.lt(o))
                        for (; i.gte(r);) n.push(i), i = i.plus(t);
                    return n
                }

                function s(e) {
                    var t = e.split(":"),
                        n = null;
                    if ("bignumber" === r.number) try {
                        n = t.map(function (e) {
                            return new f(e)
                        })
                    } catch (i) {
                        return null
                    } else {
                        n = t.map(function (e) {
                            return Number(e)
                        });
                        var o = n.some(function (e) {
                            return isNaN(e)
                        });
                        if (o) return null
                    }
                    switch (n.length) {
                    case 2:
                        return {
                            start: n[0],
                            end: n[1],
                            step: 1
                        };
                    case 3:
                        return {
                            start: n[0],
                            end: n[2],
                            step: n[1]
                        };
                    default:
                        return null
                    }
                }
                var u = t(123),
                    f = e.type.BigNumber,
                    c = t(8),
                    l = (t(11), u["boolean"].isBoolean),
                    p = u.string.isString,
                    m = u.number.isNumber;
                e.range = function () {
                    var t, u, h, g = Array.prototype.slice.call(arguments),
                        d = !1;
                    switch (l(g[g.length - 1]) && (d = g.pop() ? !0 : !1), g.length) {
                    case 1:
                        if (!p(g[0])) throw new TypeError("Two or three numbers or a single string expected in function range");
                        var y = s(g[0]);
                        if (!y) throw new SyntaxError('String "' + g[0] + '" is no valid range');
                        t = y.start, u = y.end, h = y.step;
                        break;
                    case 2:
                        t = g[0], u = g[1], h = 1;
                        break;
                    case 3:
                        t = g[0], u = g[1], h = g[2];
                        break;
                    case 4:
                        throw new TypeError("Parameter includeEnd must be a boolean");
                    default:
                        throw new e.error.ArgumentsError("range", arguments.length, 2, 4)
                    }
                    if (!(m(t) || t instanceof f)) throw new TypeError("Parameter start must be a number");
                    if (!(m(u) || u instanceof f)) throw new TypeError("Parameter end must be a number");
                    if (!(m(h) || h instanceof f)) throw new TypeError("Parameter step must be a number");
                    if (t instanceof f || u instanceof f || h instanceof f) {
                        var w = !0;
                        t instanceof f || (t = f.convert(t)), u instanceof f || (u = f.convert(u)), h instanceof f || (h = f.convert(h)), t instanceof f && u instanceof f && h instanceof f || (w = !1, t instanceof f && (t = t.toNumber()), u instanceof f && (u = u.toNumber()), h instanceof f && (h = h.toNumber()))
                    }
                    var v = w ? d ? a : o : d ? i : n,
                        x = v(t, u, h);
                    return "array" === r.matrix ? x : new c(x)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                function n(r, t, n) {
                    if (void 0 !== n) {
                        if (!c(n) || 1 !== n.length) throw new TypeError("Single character expected as defaultValue")
                    } else n = " "; if (1 !== t.length) throw new e.error.DimensionError(t.length, 1);
                    var i = t[0];
                    if (!l(i) || !p(i)) throw new TypeError("Invalid size, must contain positive integers (size: " + f.format(t) + ")");
                    if (r.length > i) return r.substring(0, i);
                    if (r.length < i) {
                        for (var o = r, a = 0, s = i - r.length; s > a; a++) o += n;
                        return o
                    }
                    return r
                }
                var i = t(123),
                    o = e.type.BigNumber,
                    a = t(8),
                    s = i.array,
                    u = i.object.clone,
                    f = i.string,
                    c = i.string.isString,
                    l = i.number.isNumber,
                    p = i.number.isInteger,
                    m = s.isArray;
                e.resize = function (t, i, f) {
                    if (2 != arguments.length && 3 != arguments.length) throw new e.error.ArgumentsError("resize", arguments.length, 2, 3);
                    var l = t instanceof a ? !0 : m(t) ? !1 : "array" !== r.matrix;
                    if (t instanceof a && (t = t.valueOf()), i instanceof a && (i = i.valueOf()), i.length && i[0] instanceof o && (i = i.map(function (e) {
                        return e instanceof o ? e.toNumber() : e
                    })), c(t)) return n(t, i, f);
                    if (0 == i.length) {
                        for (; m(t);) t = t[0];
                        return u(t)
                    }
                    m(t) || (t = [t]), t = u(t);
                    var p = s.resize(t, i, f);
                    return l ? new a(p) : p
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(5),
                    a = t(9),
                    s = t(8),
                    u = n.array,
                    f = n.number.isNumber,
                    c = n["boolean"].isBoolean,
                    l = n.string.isString,
                    p = o.isComplex,
                    m = a.isUnit;
                e.size = function (t) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("size", arguments.length, 1);
                    var n = "array" === r.matrix;
                    if (f(t) || p(t) || m(t) || c(t) || null == t || t instanceof i) return n ? [] : new s([]);
                    if (l(t)) return n ? [t.length] : new s([t.length]);
                    if (Array.isArray(t)) return u.size(t);
                    if (t instanceof s) return new s(t.size());
                    throw new e.error.UnsupportedTypeError("size", e["typeof"](t))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = t(8),
                    i = r.object,
                    o = r.array,
                    a = Array.isArray;
                e.squeeze = function (r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("squeeze", arguments.length, 1);
                    if (a(r)) return o.squeeze(i.clone(r));
                    if (r instanceof n) {
                        var t = o.squeeze(r.toArray());
                        return a(t) ? new n(t) : t
                    }
                    return i.clone(r)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r, t) {
                    var i, o;
                    if (l(r)) return i = new s(r), o = i.subset(t), o.valueOf();
                    if (r instanceof s) return r.subset(t);
                    if (c(r)) return n(r, t);
                    throw new e.error.UnsupportedTypeError("subset", e["typeof"](r))
                }

                function n(r, t) {
                    if (!(t instanceof u)) throw new TypeError("Index expected");
                    if (1 != t.size().length) throw new e.error.DimensionError(t.size().length, 1);
                    var n = t.range(0),
                        i = "",
                        o = r.length;
                    return n.forEach(function (e) {
                        f.validateIndex(e, o), i += r.charAt(e)
                    }), i
                }

                function i(r, t, n, i) {
                    var a;
                    if (l(r)) return a = new s(e.clone(r)), a.subset(t, n, i), a.valueOf();
                    if (r instanceof s) return r.clone().subset(t, n, i);
                    if (c(r)) return o(r, t, n, i);
                    throw new e.error.UnsupportedTypeError("subset", e["typeof"](r))
                }

                function o(r, t, n, i) {
                    if (!(t instanceof u)) throw new TypeError("Index expected");
                    if (1 != t.size().length) throw new e.error.DimensionError(t.size().length, 1);
                    if (void 0 !== i) {
                        if (!c(i) || 1 !== i.length) throw new TypeError("Single character expected as defaultValue")
                    } else i = " ";
                    var o = t.range(0),
                        a = o.size()[0];
                    if (a != n.length) throw new e.error.DimensionError(o.size()[0], n.length);
                    for (var s = r.length, l = [], p = 0; s > p; p++) l[p] = r.charAt(p);
                    if (o.forEach(function (e, r) {
                        f.validateIndex(e), l[e] = n.charAt(r)
                    }), l.length > s)
                        for (p = s - 1, a = l.length; a > p; p++) l[p] || (l[p] = i);
                    return l.join("")
                }
                var a = t(123),
                    s = t(8),
                    u = t(7),
                    f = a.array,
                    c = a.string.isString,
                    l = Array.isArray;
                e.subset = function () {
                    switch (arguments.length) {
                    case 2:
                        return r(arguments[0], arguments[1]);
                    case 3:
                    case 4:
                        return i(arguments[0], arguments[1], arguments[2], arguments[3]);
                    default:
                        throw new e.error.ArgumentsError("subset", arguments.length, 2, 4)
                    }
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = t(8),
                    i = (t(11), r.object),
                    o = r.string;
                e.transpose = function (r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("transpose", arguments.length, 1);
                    var t = e.size(r).valueOf();
                    switch (t.length) {
                    case 0:
                        return i.clone(r);
                    case 1:
                        return i.clone(r);
                    case 2:
                        var a, s = t[1],
                            u = t[0],
                            f = r instanceof n,
                            c = r.valueOf(),
                            l = [],
                            p = i.clone;
                        if (0 === s) throw new RangeError("Cannot transpose a 2D matrix with no rows(size: " + o.format(t) + ")");
                        for (var m = 0; s > m; m++) {
                            a = l[m] = [];
                            for (var h = 0; u > h; h++) a[h] = p(c[h][m])
                        }
                        return f ? new n(l) : l;
                    default:
                        throw new RangeError("Matrix must be two dimensional (size: " + o.format(t) + ")")
                    }
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(8),
                    a = t(11),
                    s = n.array,
                    u = Array.isArray;
                e.zeros = function (e) {
                    var t = a.argsToArray(arguments),
                        n = e instanceof o ? !0 : u(e) ? !1 : "matrix" === r.matrix;
                    if (0 == t.length) return n ? new o : [];
                    var f = !1;
                    t = t.map(function (e) {
                        return e instanceof i ? (f = !0, e.toNumber()) : e
                    });
                    var c = [],
                        l = f ? new i(0) : 0;
                    return c = s.resize(c, t, l), n ? new o(c) : c
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(11),
                    o = r.number.isNumber,
                    a = r["boolean"].isBoolean,
                    s = r.number.isInteger,
                    u = i.isCollection;
                e.factorial = function c(r) {
                    var t, l;
                    if (1 != arguments.length) throw new e.error.ArgumentsError("factorial", arguments.length, 1);
                    if (o(r)) {
                        if (!s(r) || 0 > r) throw new TypeError("Positive integer value expected in function factorial");
                        for (t = r - 1, l = r; t > 1;) l *= t, t--;
                        return 0 == l && (l = 1), l
                    }
                    if (r instanceof n) {
                        if (!f(r)) throw new TypeError("Positive integer value expected in function factorial");
                        var p = new n(1);
                        for (t = r.minus(p), l = r; t.gt(p);) l = l.times(t), t = t.minus(p);
                        return l.equals(0) && (l = p), l
                    }
                    if (a(r)) return 1;
                    if (u(r)) return i.deepMap(r, c);
                    throw new e.error.UnsupportedTypeError("factorial", e["typeof"](r))
                };
                var f = function (e) {
                    return e.isInteger() && e.gte(0)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                var n = t(8),
                    i = (t(11), {
                        uniform: function () {
                            return Math.random
                        },
                        normal: function () {
                            return function () {
                                for (var e, r, t = -1; 0 > t || t > 1;) e = Math.random(), r = Math.random(), t = 1 / 6 * Math.pow(-2 * Math.log(e), .5) * Math.cos(2 * Math.PI * r) + .5;
                                return t
                            }
                        }
                    });
                e.distribution = function (t) {
                    if (!i.hasOwnProperty(t)) throw new Error("unknown distribution " + t);
                    var o = Array.prototype.slice.call(arguments, 1),
                        a = i[t].apply(this, o);
                    return function (t) {
                        var i = {
                                random: function (t, i, a) {
                                    var u, f, c;
                                    if (arguments.length > 3) throw new e.error.ArgumentsError("random", arguments.length, 0, 3);
                                    if (1 === arguments.length ? Array.isArray(t) ? u = t : c = t : 2 === arguments.length ? Array.isArray(t) ? u = t : (f = t, c = i) : (u = t, f = i, c = a), void 0 === c && (c = 1), void 0 === f && (f = 0), void 0 !== u) {
                                        var l = s(u, f, c, o);
                                        return "array" === r.matrix ? l : new n(l)
                                    }
                                    return o(f, c)
                                },
                                randomInt: function (t, i, o) {
                                    var u, f, c;
                                    if (arguments.length > 3 || arguments.length < 1) throw new e.error.ArgumentsError("randomInt", arguments.length, 1, 3);
                                    if (1 === arguments.length ? c = t : 2 === arguments.length ? "[object Array]" === Object.prototype.toString.call(t) ? u = t : (f = t, c = i) : (u = t, f = i, c = o), void 0 === f && (f = 0), void 0 !== u) {
                                        var l = s(u, f, c, a);
                                        return "array" === r.matrix ? l : new n(l)
                                    }
                                    return a(f, c)
                                },
                                pickRandom: function (r) {
                                    if (1 !== arguments.length) throw new e.error.ArgumentsError("pickRandom", arguments.length, 1);
                                    if (!Array.isArray(r)) throw new e.error.UnsupportedTypeError("pickRandom", e["typeof"](r));
                                    return r[Math.floor(Math.random() * r.length)]
                                }
                            },
                            o = function (e, r) {
                                return e + t() * (r - e)
                            },
                            a = function (e, r) {
                                return Math.floor(e + t() * (r - e))
                            },
                            s = function (e, r, t, n) {
                                var i, o, a = [];
                                if (e = e.slice(0), e.length > 1)
                                    for (o = 0, i = e.shift(); i > o; o++) a.push(s(e, r, t, n));
                                else
                                    for (o = 0, i = e.shift(); i > o; o++) a.push(n(r, t));
                                return a
                            };
                        return i
                    }(a)
                };
                var o = e.distribution("uniform");
                e.random = o.random, e.randomInt = o.randomInt, e.pickRandom = o.pickRandom
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = r.number.isNumber,
                    o = r.number.isInteger;
                e.permutations = function (r, t) {
                    var s, u, f = arguments.length;
                    if (f > 2) throw new e.error.ArgumentsError("permutations", arguments.length, 2);
                    if (i(r)) {
                        if (!o(r) || 0 > r) throw new TypeError("Positive integer value expected in function permutations");
                        if (1 == f) return e.factorial(r);
                        if (2 == f && i(t)) {
                            if (!o(t) || 0 > t) throw new TypeError("Positive integer value expected in function permutations");
                            if (t > r) throw new TypeError("second argument k must be less than or equal to first argument n");
                            for (s = 1, u = r - t + 1; r >= u; u++) s *= u;
                            return s
                        }
                    }
                    if (r instanceof n) {
                        if (void 0 === t && a(r)) return e.factorial(r);
                        if (t = n.convert(t), !(t instanceof n && a(r) && a(t))) throw new TypeError("Positive integer value expected in function permutations");
                        if (t.gt(r)) throw new TypeError("second argument k must be less than or equal to first argument n");
                        for (s = new n(1), u = r.minus(t).plus(1); u.lte(r); u = u.plus(1)) s = s.times(u);
                        return s
                    }
                    throw new e.error.UnsupportedTypeError("permutations", e["typeof"](r))
                };
                var a = function (e) {
                    return e.isInteger() && e.gte(0)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = (t(11), r.number.isNumber),
                    o = r.number.isInteger;
                e.combinations = function (r, t) {
                    var s, u, f, c, l = arguments.length;
                    if (2 != l) throw new e.error.ArgumentsError("combinations", arguments.length, 2);
                    if (i(r)) {
                        if (!o(r) || 0 > r) throw new TypeError("Positive integer value enpected in function combinations");
                        if (t > r) throw new TypeError("k must be less than or equal to n");
                        for (s = Math.max(t, r - t), u = 1, f = 1; r - s >= f; f++) u = u * (s + f) / f;
                        return u
                    }
                    if (r instanceof n) {
                        if (t = n.convert(t), !(t instanceof n && a(r) && a(t))) throw new TypeError("Positive integer value expected in function combinations");
                        if (t.gt(r)) throw new TypeError("k must be less than n in function combinations");
                        for (s = r.minus(t), t.lt(s) && (s = t), u = new n(1), f = new n(1), c = r.minus(s); f.lte(c); f = f.plus(1)) u = u.times(s.plus(f)).dividedBy(f);
                        return u
                    }
                    throw new e.error.UnsupportedTypeError("combinations", e["typeof"](r))
                };
                var a = function (e) {
                    return e.isInteger() && e.gte(0)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r, t) {
                    return e.smaller(r, t) ? r : t
                }

                function n(r) {
                    var t = void 0;
                    if (i.deepForEach(r, function (r) {
                        (void 0 === t || e.smaller(r, t)) && (t = r)
                    }), void 0 === t) throw new Error("Cannot calculate min of an empty array");
                    return t
                }
                var i = (t(8), t(11)),
                    o = i.isCollection;
                e.min = function (e) {
                    if (0 == arguments.length) throw new SyntaxError("Function min requires one or more parameters (0 provided)");
                    if (o(e)) {
                        if (1 == arguments.length) return n(e);
                        if (2 == arguments.length) return i.reduce(arguments[0], arguments[1], r);
                        throw new SyntaxError("Wrong number of parameters")
                    }
                    return n(arguments)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r, t) {
                    return e.larger(r, t) ? r : t
                }

                function n(r) {
                    var t = void 0;
                    if (i.deepForEach(r, function (r) {
                        (void 0 === t || e.larger(r, t)) && (t = r)
                    }), void 0 === t) throw new Error("Cannot calculate max of an empty array");
                    return t
                }
                var i = (t(8), t(11)),
                    o = i.isCollection;
                e.max = function (e) {
                    if (0 == arguments.length) throw new SyntaxError("Function max requires one or more parameters (0 provided)");
                    if (o(e)) {
                        if (1 == arguments.length) return n(e);
                        if (2 == arguments.length) return i.reduce(arguments[0], arguments[1], r);
                        throw new SyntaxError("Wrong number of parameters")
                    }
                    return n(arguments)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r, t) {
                    var n;
                    return n = i.reduce(r, t, e.add), e.divide(n, a(r)[t])
                }

                function n(r) {
                    var t = 0,
                        n = 0;
                    if (i.deepForEach(r, function (r) {
                        t = e.add(t, r), n++
                    }), 0 === n) throw new Error("Cannot calculate mean of an empty array");
                    return e.divide(t, n)
                }
                var i = (t(8), t(11)),
                    o = i.isCollection,
                    a = t(153).size;
                e.mean = function (e) {
                    if (0 == arguments.length) throw new SyntaxError("Function mean requires one or more parameters (0 provided)");
                    if (o(e)) {
                        if (1 == arguments.length) return n(e);
                        if (2 == arguments.length) return r(arguments[0], arguments[1]);
                        throw new SyntaxError("Wrong number of parameters")
                    }
                    return n(arguments)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r) {
                    var t = u(r);
                    t.sort(e.compare);
                    var o = t.length;
                    if (0 == o) throw new Error("Cannot calculate median of an empty array");
                    if (o % 2 == 0) {
                        var s = t[o / 2 - 1],
                            f = t[o / 2];
                        if (!(a(s) || s instanceof i || s instanceof n)) throw new e.error.UnsupportedTypeError("median", e["typeof"](s));
                        if (!(a(f) || f instanceof i || f instanceof n)) throw new e.error.UnsupportedTypeError("median", e["typeof"](f));
                        return e.divide(e.add(s, f), 2)
                    }
                    var c = t[(o - 1) / 2];
                    if (!(a(c) || c instanceof i || c instanceof n)) throw new e.error.UnsupportedTypeError("median", e["typeof"](c));
                    return c
                }
                var n = (t(8), t(9)),
                    i = e.type.BigNumber,
                    o = t(11),
                    a = t(154).isNumber,
                    s = o.isCollection,
                    u = t(153).flatten;
                e.median = function (e) {
                    if (0 == arguments.length) throw new SyntaxError("Function median requires one or more parameters (0 provided)");
                    if (s(e)) {
                        if (1 == arguments.length) return r(e.valueOf());
                        throw 2 == arguments.length ? new Error("median(A, dim) is not yet supported") : new SyntaxError("Wrong number of parameters")
                    }
                    return r(Array.prototype.slice.call(arguments))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r) {
                    var t = void 0;
                    if (n.deepForEach(r, function (r) {
                        t = void 0 === t ? r : e.multiply(t, r)
                    }), void 0 === t) throw new Error("Cannot calculate prod of an empty array");
                    return t
                }
                var n = (t(8), t(11)),
                    i = n.isCollection;
                e.prod = function (e) {
                    if (0 == arguments.length) throw new SyntaxError("Function prod requires one or more parameters (0 provided)");
                    if (i(e)) {
                        if (1 == arguments.length) return r(e);
                        throw 2 == arguments.length ? new Error("prod(A, dim) is not yet supported") : new SyntaxError("Wrong number of parameters")
                    }
                    return r(arguments)
                }
            }
        },
        function (e) {
            e.exports = function (e) {
                e.std = function () {
                    if (0 == arguments.length) throw new SyntaxError("Function std requires one or more parameters (0 provided)");
                    var r = e["var"].apply(null, arguments);
                    return e.sqrt(r)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r) {
                    var t = void 0;
                    if (n.deepForEach(r, function (r) {
                        t = void 0 === t ? r : e.add(t, r)
                    }), void 0 === t) throw new Error("Cannot calculate sum of an empty array");
                    return t
                }
                var n = (t(8), t(11)),
                    i = n.isCollection;
                e.sum = function (e) {
                    if (0 == arguments.length) throw new SyntaxError("Function sum requires one or more parameters (0 provided)");
                    if (i(e)) {
                        if (1 == arguments.length) return r(e);
                        throw 2 == arguments.length ? new Error("sum(A, dim) is not yet supported") : new SyntaxError("Wrong number of parameters")
                    }
                    return r(arguments)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r, t) {
                    var o = 0,
                        a = 0;
                    if (i.deepForEach(r, function (r) {
                        o = e.add(o, r), a++
                    }), 0 === a) throw new Error("Cannot calculate var of an empty array");
                    var s = e.divide(o, a);
                    switch (o = 0, i.deepForEach(r, function (r) {
                        var t = e.subtract(r, s);
                        o = e.add(o, e.multiply(t, t))
                    }), t) {
                    case "uncorrected":
                        return e.divide(o, a);
                    case "biased":
                        return e.divide(o, a + 1);
                    case "unbiased":
                        var u = o instanceof n ? new n(0) : 0;
                        return 1 == a ? u : e.divide(o, a - 1);
                    default:
                        throw new Error('Unknown normalization "' + t + '". Choose "unbiased" (default), "uncorrected", or "biased".')
                    }
                }
                var n = (t(8), e.type.BigNumber),
                    i = t(11),
                    o = i.isCollection,
                    a = t(138).isString,
                    s = "unbiased";
                e["var"] = function (e, t) {
                    if (0 == arguments.length) throw new SyntaxError("Function var requires one or more parameters (0 provided)");
                    if (o(e)) {
                        if (1 == arguments.length) return r(e, s);
                        if (2 == arguments.length) {
                            if (!a(t)) throw new Error("String expected for parameter normalization");
                            return r(e, t)
                        }
                        throw new SyntaxError("Wrong number of parameters")
                    }
                    return r(arguments, s)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.acos = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("acos", arguments.length, 1);
                    if (a(r)) return r >= -1 && 1 >= r ? Math.acos(r) : c(new i(r, 0));
                    if (u(r)) {
                        var t = new i(r.im * r.im - r.re * r.re + 1, -2 * r.re * r.im),
                            l = e.sqrt(t),
                            p = new i(l.re - r.im, l.im + r.re),
                            m = e.log(p);
                        return new i(1.5707963267948966 - m.im, m.re)
                    }
                    if (f(r)) return o.deepMap(r, c);
                    if (s(r)) return Math.acos(r);
                    if (r instanceof n) return c(r.toNumber());
                    throw new e.error.UnsupportedTypeError("acos", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.asin = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("asin", arguments.length, 1);
                    if (a(r)) return r >= -1 && 1 >= r ? Math.asin(r) : c(new i(r, 0));
                    if (u(r)) {
                        var t = r.re,
                            l = r.im,
                            p = new i(l * l - t * t + 1, -2 * t * l),
                            m = e.sqrt(p),
                            h = new i(m.re - l, m.im + t),
                            g = e.log(h);
                        return new i(g.im, -g.re)
                    }
                    if (f(r)) return o.deepMap(r, c);
                    if (s(r)) return Math.asin(r);
                    if (r instanceof n) return c(r.toNumber());
                    throw new e.error.UnsupportedTypeError("asin", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = i.isComplex,
                    f = o.isCollection;
                e.atan = function c(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("atan", arguments.length, 1);
                    if (a(r)) return Math.atan(r);
                    if (u(r)) {
                        var t = r.re,
                            l = r.im,
                            p = t * t + (1 - l) * (1 - l),
                            m = new i((1 - l * l - t * t) / p, -2 * t / p),
                            h = e.log(m);
                        return new i(-.5 * h.im, .5 * h.re)
                    }
                    if (f(r)) return o.deepMap(r, c);
                    if (s(r)) return Math.atan(r);
                    if (r instanceof n) return c(r.toNumber());
                    throw new e.error.UnsupportedTypeError("atan", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(11),
                    a = r.number.isNumber,
                    s = r["boolean"].isBoolean,
                    u = (i.isComplex, o.isCollection);
                e.atan2 = function f(r, t) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("atan2", arguments.length, 2);
                    if (a(r) && a(t)) return Math.atan2(r, t);
                    if (u(r) || u(t)) return o.deepMap2(r, t, f);
                    if (s(r)) return f(+r, t);
                    if (s(t)) return f(r, +t);
                    if (r instanceof n) return f(r.toNumber(), t);
                    if (t instanceof n) return f(r, t.toNumber());
                    throw new e.error.UnsupportedTypeError("atan2", e["typeof"](r), e["typeof"](t))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.cos = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("cos", arguments.length, 1);
                    if (s(r)) return Math.cos(r);
                    if (f(r)) return new i(.5 * Math.cos(r.re) * (Math.exp(-r.im) + Math.exp(r.im)), .5 * Math.sin(r.re) * (Math.exp(-r.im) - Math.exp(r.im)));
                    if (c(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function cos is no angle");
                        return Math.cos(r.value)
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return Math.cos(r);
                    if (r instanceof n) return p(r.toNumber());
                    throw new e.error.UnsupportedTypeError("cos", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.cosh = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("cosh", arguments.length, 1);
                    if (s(r)) return (Math.exp(r) + Math.exp(-r)) / 2;
                    if (f(r)) {
                        var t = Math.exp(r.re),
                            m = Math.exp(-r.re);
                        return new i(Math.cos(r.im) * (t + m) / 2, Math.sin(r.im) * (t - m) / 2)
                    }
                    if (c(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function cosh is no angle");
                        return p(r.value)
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return p(r ? 1 : 0);
                    if (r instanceof n) return p(r.toNumber());
                    throw new e.error.UnsupportedTypeError("cosh", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.cot = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("cot", arguments.length, 1);
                    if (s(r)) return 1 / Math.tan(r);
                    if (f(r)) {
                        var t = Math.exp(-4 * r.im) - 2 * Math.exp(-2 * r.im) * Math.cos(2 * r.re) + 1;
                        return new i(2 * Math.exp(-2 * r.im) * Math.sin(2 * r.re) / t, (Math.exp(-4 * r.im) - 1) / t)
                    }
                    if (c(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function cot is no angle");
                        return 1 / Math.tan(r.value)
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return p(+r);
                    if (r instanceof n) return p(r.toNumber());
                    throw new e.error.UnsupportedTypeError("cot", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.coth = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("coth", arguments.length, 1);
                    if (s(r)) {
                        var t = Math.exp(2 * r);
                        return (t + 1) / (t - 1)
                    }
                    if (f(r)) {
                        var m = Math.exp(2 * r.re),
                            h = m * Math.cos(2 * r.im),
                            g = m * Math.sin(2 * r.im),
                            d = (h - 1) * (h - 1) + g * g;
                        return new i(((h + 1) * (h - 1) + g * g) / d, -2 * g / d)
                    }
                    if (c(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function coth is no angle");
                        return p(r.value)
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return p(r ? 1 : 0);
                    if (r instanceof n) return p(r.toNumber());
                    throw new e.error.UnsupportedTypeError("coth", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.csc = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("csc", arguments.length, 1);
                    if (s(r)) return 1 / Math.sin(r);
                    if (f(r)) {
                        var t = .25 * (Math.exp(-2 * r.im) + Math.exp(2 * r.im)) - .5 * Math.cos(2 * r.re);
                        return new i(.5 * Math.sin(r.re) * (Math.exp(-r.im) + Math.exp(r.im)) / t, .5 * Math.cos(r.re) * (Math.exp(-r.im) - Math.exp(r.im)) / t)
                    }
                    if (c(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function csc is no angle");
                        return 1 / Math.sin(r.value)
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return p(+r);
                    if (r instanceof n) return p(r.toNumber());
                    throw new e.error.UnsupportedTypeError("csc", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number,
                    u = r.number.isNumber,
                    f = r["boolean"].isBoolean,
                    c = i.isComplex,
                    l = o.isUnit,
                    p = a.isCollection;
                e.csch = function m(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("csch", arguments.length, 1);
                    if (u(r)) return 0 == r ? Number.NaN : Math.abs(2 / (Math.exp(r) - Math.exp(-r))) * s.sign(r);
                    if (c(r)) {
                        var t = Math.exp(r.re),
                            h = Math.exp(-r.re),
                            g = Math.cos(r.im) * (t - h),
                            d = Math.sin(r.im) * (t + h),
                            y = g * g + d * d;
                        return new i(2 * g / y, -2 * d / y)
                    }
                    if (l(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function csch is no angle");
                        return m(r.value)
                    }
                    if (p(r)) return a.deepMap(r, m);
                    if (f(r)) return m(r ? 1 : 0);
                    if (r instanceof n) return m(r.toNumber());
                    throw new e.error.UnsupportedTypeError("csch", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.sec = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("sec", arguments.length, 1);
                    if (s(r)) return 1 / Math.cos(r);
                    if (f(r)) {
                        var t = .25 * (Math.exp(-2 * r.im) + Math.exp(2 * r.im)) + .5 * Math.cos(2 * r.re);
                        return new i(.5 * Math.cos(r.re) * (Math.exp(-r.im) + Math.exp(r.im)) / t, .5 * Math.sin(r.re) * (Math.exp(r.im) - Math.exp(-r.im)) / t)
                    }
                    if (c(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function sec is no angle");
                        return 1 / Math.cos(r.value)
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return p(+r);
                    if (r instanceof n) return p(r.toNumber());
                    throw new e.error.UnsupportedTypeError("sec", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.sech = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("sech", arguments.length, 1);
                    if (s(r)) return 2 / (Math.exp(r) + Math.exp(-r));
                    if (f(r)) {
                        var t = Math.exp(r.re),
                            m = Math.exp(-r.re),
                            h = Math.cos(r.im) * (t + m),
                            g = Math.sin(r.im) * (t - m),
                            d = h * h + g * g;
                        return new i(2 * h / d, -2 * g / d)
                    }
                    if (c(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function sech is no angle");
                        return p(r.value)
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return p(r ? 1 : 0);
                    if (r instanceof n) return p(r.toNumber());
                    throw new e.error.UnsupportedTypeError("sech", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.sin = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("sin", arguments.length, 1);
                    if (s(r)) return Math.sin(r);
                    if (f(r)) return new i(.5 * Math.sin(r.re) * (Math.exp(-r.im) + Math.exp(r.im)), .5 * Math.cos(r.re) * (Math.exp(r.im) - Math.exp(-r.im)));
                    if (c(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function sin is no angle");
                        return Math.sin(r.value)
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return Math.sin(r);
                    if (r instanceof n) return p(r.toNumber());
                    throw new e.error.UnsupportedTypeError("sin", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.sinh = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("sinh", arguments.length, 1);
                    if (s(r)) return (Math.exp(r) - Math.exp(-r)) / 2;
                    if (f(r)) {
                        var t = Math.cos(r.im),
                            m = Math.sin(r.im),
                            h = Math.exp(r.re),
                            g = Math.exp(-r.re);
                        return new i(t * (h - g) / 2, m * (h + g) / 2)
                    }
                    if (c(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function sinh is no angle");
                        return p(r.value)
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return p(r ? 1 : 0);
                    if (r instanceof n) return p(r.toNumber());
                    throw new e.error.UnsupportedTypeError("sinh", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.tan = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("tan", arguments.length, 1);
                    if (s(r)) return Math.tan(r);
                    if (f(r)) {
                        var t = Math.exp(-4 * r.im) + 2 * Math.exp(-2 * r.im) * Math.cos(2 * r.re) + 1;
                        return new i(2 * Math.exp(-2 * r.im) * Math.sin(2 * r.re) / t, (1 - Math.exp(-4 * r.im)) / t)
                    }
                    if (c(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function tan is no angle");
                        return Math.tan(r.value)
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return Math.tan(r);
                    if (r instanceof n) return p(r.toNumber());
                    throw new e.error.UnsupportedTypeError("tan", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = e.type.BigNumber,
                    i = t(5),
                    o = t(9),
                    a = t(11),
                    s = r.number.isNumber,
                    u = r["boolean"].isBoolean,
                    f = i.isComplex,
                    c = o.isUnit,
                    l = a.isCollection;
                e.tanh = function p(r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("tanh", arguments.length, 1);
                    if (s(r)) {
                        var t = Math.exp(2 * r);
                        return (t - 1) / (t + 1)
                    }
                    if (f(r)) {
                        var m = Math.exp(2 * r.re),
                            h = m * Math.cos(2 * r.im),
                            g = m * Math.sin(2 * r.im),
                            d = (h + 1) * (h + 1) + g * g;
                        return new i(((h - 1) * (h + 1) + g * g) / d, 2 * g / d)
                    }
                    if (c(r)) {
                        if (!r.hasBase(o.BASE_UNITS.ANGLE)) throw new TypeError("Unit in function tanh is no angle");
                        return p(r.value)
                    }
                    if (l(r)) return a.deepMap(r, p);
                    if (u(r)) return p(r ? 1 : 0);
                    if (r instanceof n) return p(r.toNumber());
                    throw new e.error.UnsupportedTypeError("tanh", e["typeof"](r))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = t(9),
                    i = t(11),
                    o = r.string.isString,
                    a = n.isUnit,
                    s = i.isCollection;
                e.to = function u(r, t) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("to", arguments.length, 2);
                    if (a(r) && (a(t) || o(t))) return r.to(t);
                    if (s(r) || s(t)) return i.deepMap2(r, t, u);
                    throw new e.error.UnsupportedTypeError("to", e["typeof"](r), e["typeof"](t))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = r.object;
                e.clone = function (r) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("clone", arguments.length, 1);
                    return n.clone(r)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = r.string;
                e.format = function (r, t) {
                    var i = arguments.length;
                    if (1 !== i && 2 !== i) throw new e.error.ArgumentsError("format", i, 1, 2);
                    return n.format(r, t)
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r, t, n) {
                    var i = r instanceof o || t instanceof o || n instanceof o;
                    if (r instanceof o || (r = new o(r)), g(t) && (t instanceof o || (t = new o(t)), !f(r.size(), t.size()))) throw new RangeError("Dimension mismatch ([" + r.size().join(", ") + "] != [" + t.size().join(", ") + "])");
                    if (g(n) && (n instanceof o || (n = new o(n)), !f(r.size(), n.size()))) throw new e.error.DimensionError(r.size(), n.size());
                    var a = t instanceof o,
                        s = n instanceof o,
                        u = r.map(function (r, i) {
                            return e.ifElse(r, a ? t.get(i) : t, s ? n.get(i) : n)
                        });
                    return i ? u : u.valueOf()
                }
                var n = t(123),
                    i = e.type.BigNumber,
                    o = t(8),
                    a = t(5),
                    s = t(9),
                    u = t(11),
                    f = n.object.deepEqual,
                    c = n.number.isNumber,
                    l = n.string.isString,
                    p = n["boolean"].isBoolean,
                    m = a.isComplex,
                    h = s.isUnit,
                    g = u.isCollection;
                e.ifElse = function (t, n, o) {
                    if (3 != arguments.length) throw new e.error.ArgumentsError("ifElse", arguments.length, 3);
                    if (c(t) || p(t)) return t ? n : o;
                    if (t instanceof i) return t.isZero() ? o : n;
                    if (l(t)) return t ? n : o;
                    if (m(t)) return t.re || t.im ? n : o;
                    if (h(t)) return t.value ? n : o;
                    if (null === t || void 0 === t) return o;
                    if (g(t)) return r(t, n, o);
                    throw new e.error.UnsupportedTypeError("ifElse", e["typeof"](t))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(r, t, n) {
                    (n.override || void 0 === e[r]) && (e[r] = n.wrap && "function" == typeof t ? function () {
                        for (var r = [], n = 0, i = arguments.length; i > n; n++) r[n] = arguments[n].valueOf();
                        return t.apply(e, r)
                    } : t, e.chaining.Selector.createProxy(r, t))
                }

                function n(e) {
                    return "function" == typeof e || s(e) || u(e) || f(e) || c(e)
                }
                var i = t(123),
                    o = t(5),
                    a = t(9),
                    s = i.number.isNumber,
                    u = i.string.isString,
                    f = o.isComplex,
                    c = a.isUnit;
                e["import"] = function l(o, a) {
                    var s = arguments.length;
                    if (1 != s && 2 != s) throw new e.error.ArgumentsError("import", s, 1, 2);
                    var f, c = {
                        override: !1,
                        wrap: !0
                    };
                    if (a && a instanceof Object && i.object.extend(c, a), u(o)) {
                        var p = t(155)(o);
                        l(p)
                    } else {
                        if ("object" != typeof o) throw new TypeError("Object or module name expected");
                        for (f in o)
                            if (o.hasOwnProperty(f)) {
                                var m = o[f];
                                n(m) ? r(f, m, c) : l(m)
                            }
                    }
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(e, r) {
                    var t = [],
                        n = function (i, o) {
                            return Array.isArray(i) ? i.map(function (e, r) {
                                return t[o] = r, n(e, o + 1)
                            }) : r(i, t, e)
                        };
                    return n(e, 0)
                }
                var n = t(8).isMatrix;
                e.map = function (t, i) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("map", arguments.length, 2);
                    if (Array.isArray(t)) return r(t, i);
                    if (n(t)) return t.map(i);
                    throw new e.error.UnsupportedTypeError("map", e["typeof"](t))
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(123),
                    n = r.string.isString;
                e.print = function (r, t, i) {
                    var o = arguments.length;
                    if (2 != o && 3 != o) throw new e.error.ArgumentsError("print", o, 2, 3);
                    if (!n(r)) throw new TypeError("String expected as first parameter in function format");
                    if (!(t instanceof Object)) throw new TypeError("Object expected as second parameter in function format");
                    return r.replace(/\$([\w\.]+)/g, function (r, o) {
                        for (var a = o.split("."), s = t[a.shift()]; a.length && void 0 !== s;) {
                            var u = a.shift();
                            s = u ? s[u] : s + "."
                        }
                        return void 0 !== s ? n(s) ? s : e.format(s, i) : r
                    })
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                var r = t(156),
                    n = t(5),
                    i = t(8),
                    o = t(9),
                    a = t(7),
                    s = t(6),
                    u = t(10);
                e["typeof"] = function (t) {
                    if (1 != arguments.length) throw new e.error.ArgumentsError("typeof", arguments.length, 1);
                    var f = r.type(t);
                    if ("object" === f) {
                        if (t instanceof n) return "complex";
                        if (t instanceof i) return "matrix";
                        if (t instanceof o) return "unit";
                        if (t instanceof a) return "index";
                        if (t instanceof s) return "range";
                        if (t instanceof u) return "help";
                        if (t instanceof e.type.BigNumber) return "bignumber";
                        if (t instanceof e.chaining.Selector) return "selector"
                    }
                    return f
                }
            }
        },
        function (e, r, t) {
            e.exports = function (e) {
                function r(e, r) {
                    var t = [],
                        n = function (i, o) {
                            Array.isArray(i) ? i.forEach(function (e, r) {
                                t[o] = r, n(e, o + 1)
                            }) : r(i, t, e)
                        };
                    n(e, 0)
                }
                var n = t(8).isMatrix;
                e.forEach = function (t, i) {
                    if (2 != arguments.length) throw new e.error.ArgumentsError("forEach", arguments.length, 2);
                    if (Array.isArray(t)) return r(t, i);
                    if (n(t)) return t.forEach(i);
                    throw new e.error.UnsupportedTypeError("forEach", e["typeof"](t))
                }
            }
        },
        function (e) {
            function r(e, t, n, i) {
                if (!(this instanceof r)) throw new SyntaxError("Constructor must be called with the new operator");
                this.fn = e, this.count = t, this.min = n, this.max = i, this.message = "Wrong number of arguments in function " + e + " (" + t + " provided, " + n + (void 0 != i ? "-" + i : "") + " expected)", this.stack = (new Error).stack
            }
            r.prototype = new Error, r.prototype.constructor = Error, r.prototype.name = "ArgumentsError", e.exports = r
        },
        function (e) {
            function r(e, t, n) {
                if (!(this instanceof r)) throw new SyntaxError("Constructor must be called with the new operator");
                this.actual = e, this.expected = t, this.relation = n, this.message = "Dimension mismatch (" + (Array.isArray(e) ? "[" + e.join(", ") + "]" : e) + " " + (this.relation || "!=") + " " + (Array.isArray(t) ? "[" + t.join(", ") + "]" : t) + ")", this.stack = (new Error).stack
            }
            r.prototype = new RangeError, r.prototype.constructor = RangeError, r.prototype.name = "DimensionError", e.exports = r
        },
        function (e) {
            function r(e, t, n) {
                if (!(this instanceof r)) throw new SyntaxError("Constructor must be called with the new operator");
                this.index = e, arguments.length < 3 ? (this.min = 0, this.max = t) : (this.min = t, this.max = n), this.message = void 0 !== this.min && this.index < this.min ? "Index out of range (" + this.index + " < " + this.min + ")" : void 0 !== this.max && this.index >= this.max ? "Index out of range (" + this.index + " > " + (this.max - 1) + ")" : "Index out of range (" + this.index + ")", this.stack = (new Error).stack
            }
            r.prototype = new RangeError, r.prototype.constructor = RangeError, r.prototype.name = "IndexError", e.exports = r
        },
        function (e) {
            function r(e) {
                if (!(this instanceof r)) throw new SyntaxError("Constructor must be called with the new operator");
                this.fn = e, this.types = Array.prototype.splice.call(arguments, 1), this.message = e ? 0 == this.types.length ? "Unsupported type of argument in function " + e : "Function " + e + "(" + this.types.join(", ") + ") not supported" : "Unsupported type of argument", this.stack = (new Error).stack
            }
            r.prototype = new TypeError, r.prototype.constructor = TypeError, r.prototype.name = "UnsupportedTypeError", e.exports = r
        },
        function (e, r, t) {
            var n;
            (function (e) {
                ! function (i) {
                    "use strict";

                    function o(e, r, t, n) {
                        return !((!(!n && t > 3 && 4 == e[r] || (n || 4 > t) && 9 == e[r]) || 9 != e[r + 1] || 9 != e[r + 2] || 9 != e[r + 3] || null == n && 9 != e[r + 4]) && (null != n || 5 != e[r] && e[r] || e[r + 1] || e[r + 2] || e[r + 3] || e[r + 4]))
                    }

                    function a(e, r, t) {
                        var n = e.constructor;
                        return null == r || ((w = 0 > r || r > 8) || 0 !== r && (n.errors ? parseInt : parseFloat)(r) != r) && !l(n, "rounding mode", r, t, 0) ? n.rounding : 0 | r
                    }

                    function s(e, r, t, n) {
                        var i = e.constructor;
                        return !(w = (n || 0) > r || r >= A + 1) && (0 === r || (i.errors ? parseInt : parseFloat)(r) == r) || l(i, "argument", r, t, 0)
                    }

                    function u(e, r, t, n, i, o) {
                        var a = e.constructor,
                            s = e.e - r.e,
                            u = e.s == r.s ? 1 : -1,
                            f = e.c,
                            c = r.c;
                        if (!(f && f[0] && c && c[0])) return new a(e.s && r.s && (f ? !c || f[0] != c[0] : c) ? f && 0 == f[0] || !c ? 0 * u : u / 0 : 0 / 0);
                        var l, p, m, g, d, y, w = c.slice(),
                            v = y = c.length,
                            x = f.length,
                            b = f.slice(0, y),
                            E = b.length,
                            N = new a(u),
                            M = N.c = [];
                        for (p = u = 0; c[p] == (f[p] || 0); p++);
                        if (c[p] > (f[p] || 0) && (s--, u = 1), N.e = s, null == t ? (t = a.precision, n = a.rounding) : i && (t += s + 1), o = o || 10, t >= 0) {
                            for (u += t; E++ < y; b.push(0));
                            w.unshift(p = 0);
                            do {
                                for (m = 0; o > m; m++) {
                                    if (y != (E = b.length)) l = y > E ? 1 : -1;
                                    else
                                        for (g = -1, l = 0; ++g < y;)
                                            if (c[g] != b[g]) {
                                                l = c[g] > b[g] ? 1 : -1;
                                                break
                                            } if (!(0 > l)) break;
                                    for (d = E == y ? c : w; E;) {
                                        if (b[--E] < d[E]) {
                                            for (g = E; g && !b[--g]; b[g] = o - 1);
                                            --b[g], b[E] += o
                                        }
                                        b[E] -= d[E]
                                    }
                                    for (; !b[0]; b.shift());
                                }
                                M[p++] = l ? m : ++m, b[0] && l ? b[E] = f[v] || 0 : b = [f[v]]
                            } while ((v++ < x || null != b[0]) && u--);
                            !M[0] && p > 1 && M.shift(), t >= p && (t = null)
                        }
                        return h(N, t, n, null != b[0], o)
                    }

                    function f(e, r) {
                        var t, n, i, a, s, f, c, l = 0,
                            p = 0,
                            m = 0,
                            g = e.constructor,
                            d = g.ONE,
                            y = g.rounding,
                            w = g.precision;
                        if (!e.c || !e.c[0] || e.e > 17) return new g(e.c ? e.c[0] ? e.s < 0 ? 0 : 1 / 0 : d : e.s ? e.s < 0 ? 0 : e : 0 / 0);
                        for (null == r ? (b = !1, s = w) : s = r, c = new g(.03125); e.e > -2;) e = e.times(c), m += 5;
                        for (n = Math.log(Math.pow(2, m)) / Math.LN10 * 2 + 5 | 0, s += n, t = a = f = new g(d), g.precision = s;;) {
                            if (a = h(a.times(e), s, 1), t = t.times(++p), c = f.plus(u(a, t, s, 1)), c.c.slice(0, s).join("") === f.c.slice(0, s).join("")) {
                                for (i = m; i--;) f = h(f.times(f), s, 1);
                                if (null != r) return g.precision = w, f;
                                if (!(3 > l && o(f.c, s - n, y, l))) return h(f, g.precision = w, y, b = !0);
                                g.precision = s += 10, t = a = c = new g(d), p = 0, l++
                            }
                            f = c
                        }
                    }

                    function c(e, r, t, n) {
                        var i = e.constructor,
                            o = (e = new i(e)).e,
                            a = e.c;
                        if (!a) return e.toString();
                        for (a.length > ++r && h(e, r, t), o = n ? r : r + e.e - o; a.length < o; a.push(0));
                        return o = e.e, 1 == n || 2 == n && (o >= r || o <= i.toExpNeg) ? (e.s < 0 && a[0] ? "-" : "") + (a.length > 1 ? a[0] + "." + a.slice(1).join("") : a[0]) + (0 > o ? "e" : "e+") + o : e.toString()
                    }

                    function l(e, r, t, n, i) {
                        if (e.errors) {
                            var o = new Error((n || ["new Decimal", "cmp", "div", "eq", "gt", "gte", "lt", "lte", "minus", "mod", "plus", "times", "toFraction", "pow", "random", "log", "sqrt", "toNearest", "divToInt"][x ? 0 > x ? -x : x : 0 > 1 / x ? 1 : 0]) + "() " + (["number type has more than 15 significant digits", "LN10 out of digits"][r] || r + ([w ? " out of range" : " not an integer", " not a boolean or binary digit"][i] || "")) + ": " + t);
                            throw o.name = "Decimal Error", w = x = 0, o
                        }
                    }

                    function p(e, r, t) {
                        var n = new e(e.ONE);
                        for (b = !1; 1 & t && (n = n.times(r)), t >>= 1, t;) r = r.times(r);
                        return b = !0, n
                    }

                    function m(e, r) {
                        var t, n, i, a, s, f, c, p, g, d = 1,
                            y = 10,
                            w = e,
                            v = w.c,
                            x = w.constructor,
                            E = x.ONE,
                            N = x.rounding,
                            M = x.precision;
                        if (w.s < 0 || !v || !v[0] || !w.e && 1 == v[0] && 1 == v.length) return new x(v && !v[0] ? -1 / 0 : 1 != w.s ? 0 / 0 : v ? 0 : w);
                        if (null == r ? (b = !1, s = M) : s = r, x.precision = s += y, !(Math.abs(n = w.e) < 15e14)) return w = new x(w), w.e = 0, s + 2 > T.length && l(x, 1, s + 2, "ln"), w = m(w, s - y).plus(new x(T.slice(0, s + 2)).times(n + "")), x.precision = M, null == r ? h(w, M, N, b = !0) : w;
                        for (; v[0] < 7 && 1 != v[0] || 1 == v[0] && v[1] > 3;) w = w.times(e), v = w.c, d++;
                        for (n = w.e, v[0] > 1 ? (1 == d ? w = new x("0." + v.join("")) : w.e = -1, n++) : w = new x("1." + v.slice(1).join("")), p = w, f = i = w = u(w.minus(E), w.plus(E), s, 1), g = h(w.times(w), s, 1), t = 3;;) {
                            if (i = h(i.times(g), s, 1), c = f.plus(u(i, new x(t), s, 1)), c.c.slice(0, s).join("") === f.c.slice(0, s).join("")) {
                                if (f = f.times(2), 0 !== n && (s + 2 > T.length && l(x, 1, s + 2, "ln"), f = f.plus(new x(T.slice(0, s + 2)).times(n + ""))), f = u(f, new x(d), s, 1), null != r) return x.precision = M, f;
                                if (!o(f.c, s - y, N, a)) return h(f, x.precision = M, N, b = !0);
                                x.precision = s += y, c = i = w = u(p.minus(E), p.plus(E), s, 1), g = h(w.times(w), s, 1), t = a = 1
                            }
                            f = c, t += 2
                        }
                    }

                    function h(e, r, t, n, i) {
                        var o, a, s, u, f = e.constructor;
                        if (r != o) {
                            if (!(u = e.c)) return e;
                            if (s = e.s < 0, a = (i = i || 10) / 2, o = u[r], n = n || 0 > r || null != u[r + 1], n = 4 > t ? (null != o || n) && (0 == t || 2 == t && !s || 3 == t && s) : o > a || o == a && (4 == t || n || 6 == t && 1 & u[r - 1] || 7 == t && !s || 8 == t && s), 1 > r || !u[0]) return u.length = 0, n ? (r = r - e.e - 1, u[0] = 1, e.e = -r || 0) : u[0] = e.e = 0, e;
                            if (u.length > r && (u.length = r), r--, n) {
                                for (o = r; null == u[o]; u[o--] = 0);
                                for (--i; ++u[r] > i;) u[r] = 0, r-- || (++e.e, u.unshift(1))
                            }
                            for (r = u.length; !u[--r]; u.pop());
                        }
                        return b && (e.e > f.maxE ? e.c = e.e = null : e.e < f.minE && (e.c = [e.e = 0])), e
                    }
                    var g, d, y, w, v = Object.prototype.toString,
                        x = 0,
                        b = !0,
                        E = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_",
                        N = {},
                        M = 9e15,
                        A = 1e9,
                        S = 3e3,
                        T = "2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058";
                    N.absoluteValue = N.abs = function () {
                        var e = new this.constructor(this);
                        return e.s < 0 && (e.s = 1), h(e)
                    }, N.ceil = function () {
                        return h(new this.constructor(this), this.e + 1, 2)
                    }, N.comparedTo = N.cmp = function (e, r) {
                        var t, n = this,
                            i = n.c,
                            o = (x = -x, e = new n.constructor(e, r), e.c),
                            a = n.s,
                            s = e.s,
                            u = n.e,
                            f = e.e;
                        if (!a || !s) return null;
                        if (t = i && !i[0], r = o && !o[0], t || r) return t ? r ? 0 : -s : a;
                        if (a != s) return a;
                        if (t = 0 > a, !i || !o) return u == f ? 0 : !i ^ t ? 1 : -1;
                        if (u != f) return u > f ^ t ? 1 : -1;
                        for (a = -1, s = (u = i.length) < (f = o.length) ? u : f; ++a < s;)
                            if (i[a] != o[a]) return i[a] > o[a] ^ t ? 1 : -1;
                        return u == f ? 0 : u > f ^ t ? 1 : -1
                    }, N.decimalPlaces = N.dp = function () {
                        var e = this;
                        return e.c ? Math.max(e.c.length - e.e - 1, 0) : null
                    }, N.dividedBy = N.div = function (e, r) {
                        return x = 2, u(this, new this.constructor(e, r))
                    }, N.dividedToIntegerBy = N.divToInt = function (e, r) {
                        var t = this,
                            n = t.constructor;
                        return x = 18, h(u(t, new n(e, r), 0, 1, 1), n.precision, n.rounding)
                    }, N.equals = N.eq = function (e, r) {
                        return x = 3, 0 === this.cmp(e, r)
                    }, N.exponential = N.exp = function () {
                        return f(this)
                    }, N.floor = function () {
                        return h(new this.constructor(this), this.e + 1, 3)
                    }, N.greaterThan = N.gt = function (e, r) {
                        return x = 4, this.cmp(e, r) > 0
                    }, N.greaterThanOrEqualTo = N.gte = function (e, r) {
                        return x = 5, r = this.cmp(e, r), 1 == r || 0 === r
                    }, N.isFinite = function () {
                        return !!this.c
                    }, N.isInteger = N.isInt = function () {
                        return !!this.c && this.e > this.c.length - 2
                    }, N.isNaN = function () {
                        return !this.s
                    }, N.isNegative = N.isNeg = function () {
                        return this.s < 0
                    }, N.isZero = function () {
                        return !!this.c && 0 == this.c[0]
                    }, N.lessThan = N.lt = function (e, r) {
                        return x = 6, this.cmp(e, r) < 0
                    }, N.lessThanOrEqualTo = N.lte = function (e, r) {
                        return x = 7, r = this.cmp(e, r), -1 == r || 0 === r
                    }, N.logarithm = N.log = function (e, r) {
                        var t, n, i, a, s, f, c, p, g, d = this,
                            y = d.constructor,
                            w = y.precision,
                            v = y.rounding,
                            E = 5;
                        if (null == e) e = new y(10), t = !0;
                        else {
                            if (x = 15, e = new y(e, r), n = e.c, e.s < 0 || !n || !n[0] || !e.e && 1 == n[0] && 1 == n.length) return new y(0 / 0);
                            t = e.eq(10)
                        } if (n = d.c, d.s < 0 || !n || !n[0] || !d.e && 1 == n[0] && 1 == n.length) return new y(n && !n[0] ? -1 / 0 : 1 != d.s ? 0 / 0 : n ? 0 : 1 / 0);
                        if (s = t && (1 != n[0] || n.length > 1) || (1 & e.c[e.c.length - 1]) != (1 & n[n.length - 1]) || 0, b = !1, c = w + E, p = c + 10, f = m(d, c), t ? (p > T.length && l(y, 1, p, "log"), i = new y(T.slice(0, p))) : i = m(e, c), g = u(f, i, c, 1), o(g.c, a = w, v))
                            do
                                if (c += 10, f = m(d, c), t ? (p = c + 10, p > T.length && l(y, 1, p, "log"), i = new y(T.slice(0, p))) : i = m(e, c), g = u(f, i, c, 1), !s) {
                                    for (n = g.c; 9 == n[++a];);
                                    a == w + E + 10 && (g = h(g, w + 1, 0));
                                    break
                                }
                        while (o(g.c, a += 10, v));
                        return b = !0, h(g, w, v)
                    }, N.minus = function (e, r) {
                        var t, n, i, o, a = this,
                            s = a.constructor,
                            u = a.s;
                        if (x = 8, e = new s(e, r), r = e.s, !u || !r) return new s(0 / 0);
                        if (u != r) return e.s = -r, a.plus(e);
                        var f = a.c,
                            c = a.e,
                            l = e.c,
                            p = e.e,
                            m = s.precision,
                            g = s.rounding;
                        if (!c || !p) {
                            if (!f || !l) return f ? (e.s = -r, e) : new s(l ? a : 0 / 0);
                            if (!f[0] || !l[0]) return a = l[0] ? (e.s = -r, e) : new s(f[0] ? a : 3 == g ? -0 : 0), b ? h(a, m, g) : a
                        }
                        if (f = f.slice(), n = f.length, u = c - p) {
                            for ((o = 0 > u) ? (u = -u, t = f, n = l.length) : (p = c, t = l), m > n && (n = m), u > (n += 2) && (u = n, t.length = 1), t.reverse(), r = u; r--; t.push(0));
                            t.reverse()
                        } else
                            for ((o = n < (i = l.length)) && (i = n), u = r = 0; i > r; r++)
                                if (f[r] != l[r]) {
                                    o = f[r] < l[r];
                                    break
                                } if (o && (t = f, f = l, l = t, e.s = -e.s), (r = -((i = f.length) - l.length)) > 0)
                            for (; r--; f[i++] = 0);
                        for (r = l.length; r > u;) {
                            if (f[--r] < l[r]) {
                                for (n = r; n && !f[--n]; f[n] = 9);
                                --f[n], f[r] += 10
                            }
                            f[r] -= l[r]
                        }
                        for (; 0 == f[--i]; f.pop());
                        for (; 0 == f[0]; f.shift(), --p);
                        return f[0] || (f = [p = 0], e.s = 3 == g ? -1 : 1), e.c = f, e.e = p, b ? h(e, m, g) : e
                    }, N.modulo = N.mod = function (e, r) {
                        var t, n, i = this,
                            o = i.constructor,
                            a = o.modulo;
                        return x = 9, e = new o(e, r), r = e.s, t = !i.c || !r || e.c && !e.c[0], t || !e.c || i.c && !i.c[0] ? t ? new o(0 / 0) : h(new o(i), o.precision, o.rounding) : (b = !1, 9 == a ? (e.s = 1, n = u(i, e, 0, 3, 1), e.s = r, n.s *= r) : n = u(i, e, 0, a, 1), n = n.times(e), b = !0, i.minus(n))
                    }, N.naturalLogarithm = N.ln = function () {
                        return m(this)
                    }, N.negated = N.neg = function () {
                        var e = new this.constructor(this);
                        return e.s = -e.s || null, h(e)
                    }, N.plus = function (e, r) {
                        var t, n = this,
                            i = n.constructor,
                            o = n.s;
                        if (x = 10, e = new i(e, r), r = e.s, !o || !r) return new i(0 / 0);
                        if (o != r) return e.s = -r, n.minus(e);
                        var a = n.e,
                            s = n.c,
                            u = e.e,
                            f = e.c,
                            c = i.precision,
                            l = i.rounding;
                        if (!a || !u) {
                            if (!s || !f) return new i(o / 0);
                            if (!s[0] || !f[0]) return n = f[0] ? e : new i(s[0] ? n : 0 * o), b ? h(n, c, l) : n
                        }
                        if (s = s.slice(), o = a - u) {
                            for (0 > o ? (o = -o, t = s, r = f.length) : (u = a, t = f, r = s.length), c > r && (r = c), o > ++r && (o = r, t.length = 1), t.reverse(); o--; t.push(0));
                            t.reverse()
                        }
                        for (s.length - f.length < 0 && (t = f, f = s, s = t), o = f.length, r = 0; o; s[o] %= 10) r = (s[--o] = s[o] + f[o] + r) / 10 | 0;
                        for (r && (s.unshift(r), ++u), o = s.length; 0 == s[--o]; s.pop());
                        return e.c = s, e.e = u, b ? h(e, c, l) : e
                    }, N.precision = N.sd = function (e) {
                        var r = this;
                        return null != e && e !== !!e && 1 !== e && 0 !== e && l(r.constructor, "argument", e, "precision", 1), r.c ? e ? Math.max(r.e + 1, r.c.length) : r.c.length : null
                    }, N.round = function () {
                        var e = this,
                            r = e.constructor;
                        return h(new r(e), e.e + 1, r.rounding)
                    }, N.squareRoot = N.sqrt = function () {
                        var e, r, t, n, i, o = this,
                            a = o.c,
                            s = o.s,
                            f = o.e,
                            c = o.constructor,
                            l = new c(.5);
                        if (1 !== s || !a || !a[0]) return new c(!s || 0 > s && (!a || a[0]) ? 0 / 0 : a ? o : 1 / 0);
                        for (b = !1, s = Math.sqrt(+o), 0 == s || s == 1 / 0 ? (e = a.join(""), (e.length + f) % 2 == 0 && (e += "0"), t = new c(Math.sqrt(e) + ""), t.c || (t.c = [1]), t.e = Math.floor((f + 1) / 2) - (0 > f || f % 2)) : t = new c(s.toString()), r = (f = c.precision) + 3;;)
                            if (i = t, t = l.times(i.plus(u(o, i, r + 2, 1))), i.c.slice(0, r).join("") === t.c.slice(0, r).join("")) {
                                if (a = t.c, 9 != a[r - 3] && (n || 4 != a[r - 3]) || 9 != a[r - 2] || 9 != a[r - 1] || 9 != a[r]) {
                                    if (!(a[r - 3] && 5 != a[r - 3] || a[r - 2] || a[r - 1] || a[r] || (a.length > f + 1 && (a.length = f + 1), t.times(t).eq(o)))) {
                                        for (; a.length < f;) a.push(0);
                                        a[f]++
                                    }
                                    break
                                }
                                if (!n && (i = h(i, f + 1, 0), i.times(i).eq(o))) {
                                    t = i;
                                    break
                                }
                                r += 4, n = 1
                            }
                        return b = !0, h(t, f, c.rounding)
                    }, N.times = function (e, r) {
                        var t, n = this,
                            i = n.constructor,
                            o = n.c,
                            a = (x = 11, e = new i(e, r), e.c),
                            s = n.e,
                            u = e.e,
                            f = n.s;
                        if (r = e.s, e.s = f == r ? 1 : -1, !((s || o && o[0]) && (u || a && a[0]))) return new i(!f || !r || o && !o[0] && !a || a && !a[0] && !o ? 0 / 0 : o && a ? 0 * e.s : e.s / 0);
                        for (e.e = s + u, f = o.length, r = a.length, r > f && (t = o, o = a, a = t, u = f, f = r, r = u), u = f + r, t = []; u--; t.push(0));
                        for (s = r - 1; s > -1; s--) {
                            for (r = 0, u = f + s; u > s; r = r / 10 | 0) r = t[u] + a[s] * o[u - s - 1] + r, t[u--] = r % 10 | 0;
                            r && (t[u] = (t[u] + r) % 10)
                        }
                        for (r && ++e.e, t[0] || t.shift(), u = t.length; !t[--u]; t.pop());
                        return e.c = t, b ? h(e, i.precision, i.rounding) : e
                    }, N.toDecimalPlaces = N.toDP = function (e, r) {
                        var t = this;
                        return t = new t.constructor(t), null != e && s(t, e, "toDP") ? h(t, (0 | e) + t.e + 1, a(t, r, "toDP")) : t
                    }, N.toExponential = function (e, r) {
                        var t = this;
                        return c(t, null != e && s(t, e, "toExponential") || !t.c ? 0 | e : t.c.length - 1, null != e && a(t, r, "toExponential"), 1)
                    }, N.toFixed = function (e, r) {
                        var t, n = this,
                            i = n.constructor,
                            o = i.toExpNeg,
                            u = i.toExpPos;
                        return null != e && (e = s(n, e, t = "toFixed", -A) ? n.e + (0 | e) : null, r = a(n, r, t)), i.toExpNeg = -(i.toExpPos = 1 / 0), null == e ? t = n.toString() : (t = c(n, e, r), n.s < 0 && n.c && (n.c[0] ? t.indexOf("-") < 0 && (t = "-" + t) : t = t.replace("-", ""))), i.toExpNeg = o, i.toExpPos = u, t
                    }, N.toFormat = function (e, r, t) {
                        var n = this.toFixed(r).split(".");
                        return n[0].replace(/\B(?=(\d{3})+$)/g, null == e ? "," : e + "") + (n[1] ? "." + (t ? n[1].replace(/\d{5}\B/g, "$&" + t) : n[1]) : "")
                    }, N.toFraction = function (e) {
                        var r, t, n, i, o, a, s, f = this,
                            c = f.constructor,
                            p = r = new c(c.ONE),
                            m = a = new c(0),
                            h = f.c,
                            g = new c(c.ONE),
                            d = c.precision;
                        if (!h) return f.toString();
                        for (n = g.e = h.length - f.e - 1, (null == e || (!(x = 12, o = new c(e)).s || (w = o.cmp(p) < 0 || !o.c) || c.errors && o.e < o.c.length - 1) && !l(c, "max denominator", e, "toFraction", 0) || (e = o).cmp(g) > 0) && (e = n > 0 ? g : p), b = !1, o = new c(h.join("")), c.precision = h.length; s = u(o, g, 0, 1, 1), t = r.plus(s.times(m)), 1 != t.cmp(e);) r = m, m = t, p = a.plus(s.times(t = p)), a = t, g = o.minus(s.times(t = g)), o = t;
                        return t = u(e.minus(r), m, 0, 1, 1), a = a.plus(t.times(p)), r = r.plus(t.times(m)), a.s = p.s = f.s, n *= 2, i = u(p, m, n, 1, 1).minus(f).abs().cmp(u(a, r, n, 1, 1).minus(f).abs()) < 1 ? [p.toString(), m.toString()] : [a.toString(), r.toString()], b = !0, c.precision = d, i
                    }, N.toNearest = function (e, r) {
                        var t = this,
                            n = t.constructor;
                        return t = new n(t), null == e ? (e = new n(n.ONE), r = n.rounding) : (x = 17, e = new n(e), r = a(t, r, "toNearest")), e.c ? t.c && (b = !1, 4 > r && (r = [4, 5, 7, 8][r]), 1 == e.c[0] && 1 == e.c.length ? (t.e -= e.e, h(t, t.e + 1, r), t.c[0] && (t.e += e.e)) : e.c[0] ? t = u(t, e, 0, r, 1).times(e) : t.c = [t.e = 0], b = !0, h(t)) : t.s && (e.s && (e.s = t.s), t = e), t
                    }, N.toNumber = function () {
                        var e = this;
                        return +e || (0 | e) * e.s
                    }, N.toPower = N.pow = function (e, r) {
                        var t, n, i, a, s = this,
                            u = s.constructor,
                            c = s.s,
                            l = (x = 13, +(e = new u(e, r))),
                            g = 0 > l ? -l : l,
                            d = u.precision,
                            y = u.rounding;
                        if (!s.c || !e.c || (i = !s.c[0]) || !e.c[0]) return new u(Math.pow(i ? 0 * c : +s, l));
                        if (s = new u(s), t = s.c.length, !s.e && s.c[0] == s.s && 1 == t) return s;
                        if (r = e.c.length - 1, e.e || e.c[0] != e.s || r)
                            if (i = e.e >= r, !i && 0 > c) a = new u(0 / 0);
                            else {
                                if (i && S > t * g) {
                                    if (a = p(u, s, g), e.s < 0) return u.ONE.div(a)
                                } else {
                                    if (c = 0 > c && 1 & e.c[Math.max(e.e, r)] ? -1 : 1, r = Math.pow(+s, l), n = 0 != r && isFinite(r) ? new u(r + "").e : Math.floor(l * (Math.log("0." + s.c.join("")) / Math.LN10 + s.e + 1)), n > u.maxE + 1 || n < u.minE - 1) return new u(n > 0 ? c / 0 : 0);
                                    if (b = !1, u.rounding = s.s = 1, g = Math.min(12, (n + "").length), a = f(e.times(m(s, d + g)), d), a = h(a, d + 5, 1), o(a.c, d, y)) {
                                        for (n = d + 10, a = h(f(e.times(m(s, n + g)), n), n + 5, 1), g = d; 9 == a.c[++g];);
                                        g == d + 15 && (a = h(a, d + 1, 0))
                                    }
                                    a.s = c, b = !0, u.rounding = y
                                }
                                a = h(a, d, y)
                            } else a = h(s, d, y);
                        return a
                    }, N.toPrecision = function (e, r) {
                        return null != e && s(this, e, "toPrecision", 1) ? c(this, 0 | --e, a(this, r, "toPrecision"), 2) : this.toString()
                    }, N.toSignificantDigits = N.toSD = function (e, r) {
                        var t = this,
                            n = t.constructor;
                        return t = new n(t), null != e && s(t, e, "toSD", 1) ? h(t, 0 | e, a(t, r, "toSD")) : h(t, n.precision, n.rounding)
                    }, N.toString = function (e) {
                        var r, t, n, i = this,
                            o = i.constructor,
                            a = i.e;
                        if (null === a) t = i.s ? "Infinity" : "NaN";
                        else {
                            if (e === r && (a <= o.toExpNeg || a >= o.toExpPos)) return c(i, i.c.length - 1, o.rounding, 1);
                            if (t = i.c.join(""), 0 > a) {
                                for (; ++a; t = "0" + t);
                                t = "0." + t
                            } else if (n = t.length, a > 0)
                                if (++a > n)
                                    for (a -= n; a--; t += "0");
                                else n > a && (t = t.slice(0, a) + "." + t.slice(a));
                            else if (r = t.charAt(0), n > 1) t = r + "." + t.slice(1);
                            else if ("0" == r) return r;
                            if (null != e)
                                if ((w = !(e >= 2 && 65 > e)) || e != (0 | e) && o.errors) l(o, "base", e, "toString", 0);
                                else if (t = g(o, t, 0 | e, 10, i.s), "0" == t) return t
                        }
                        return i.s < 0 ? "-" + t : t
                    }, N.truncated = N.trunc = function () {
                        return h(new this.constructor(this), this.e + 1, 1)
                    }, N.valueOf = N.toJSON = function () {
                        return this.toString()
                    }, g = function () {
                        function e(e, r, t) {
                            for (var n, i, o = [0], a = 0, s = e.length; s > a;) {
                                for (i = o.length; i--; o[i] *= r);
                                for (o[n = 0] += E.indexOf(e.charAt(a++)); n < o.length; n++) o[n] > t - 1 && (null == o[n + 1] && (o[n + 1] = 0), o[n + 1] += o[n] / t | 0, o[n] %= t)
                            }
                            return o.reverse()
                        }
                        return function (r, t, n, i, o) {
                            var a, s, f, c = t.indexOf("."),
                                l = new r(i);
                            for (37 > i && (t = t.toLowerCase()), 0 > c ? (a = new r(l), f = [1]) : (a = p(r, l, t.length - c - 1), f = e(a.toFixed(), 10, n), t = t.replace(".", "")), l.c = f, l.e = f.length, s = e(t, i, n), a.c = s, a.e = s.length, a.s = o, a = u(a, l, r.precision, r.rounding, 0, n), s = a.c, c = s.length; c--;) s[c] = E.charAt(s[c]);
                            return a.s = 1, a.toFixed()
                        }
                    }(), y = function () {
                        function e(e) {
                            var r, t, n, i = this,
                                o = "config",
                                a = i.errors ? parseInt : parseFloat;
                            return e == t || "object" != typeof e && !l(i, "object expected", e, o) ? i : ((n = e[r = "precision"]) != t && ((w = 1 > n || n > A) || a(n) != n ? l(i, r, n, o, 0) : i[r] = 0 | n), (n = e[r = "rounding"]) != t && ((w = 0 > n || n > 8) || a(n) != n ? l(i, r, n, o, 0) : i[r] = 0 | n), (n = e[r = "toExpNeg"]) != t && ((w = -M > n || n > 0) || a(n) != n ? l(i, r, n, o, 0) : i[r] = Math.floor(n)), (n = e[r = "toExpPos"]) != t && ((w = 0 > n || n > M) || a(n) != n ? l(i, r, n, o, 0) : i[r] = Math.floor(n)), (n = e[r = "minE"]) != t && ((w = -M > n || n > 0) || a(n) != n ? l(i, r, n, o, 0) : i[r] = Math.floor(n)), (n = e[r = "maxE"]) != t && ((w = 0 > n || n > M) || a(n) != n ? l(i, r, n, o, 0) : i[r] = Math.floor(n)), (n = e[r = "errors"]) != t && (n === !!n || 1 === n || 0 === n ? (w = x = 0, i[r] = !!n) : l(i, r, n, o, 1)), (n = e[r = "crypto"]) != t && (n === !!n || 1 === n || 0 === n ? i[r] = !(!n || !d || "object" != typeof d) : l(i, r, n, o, 1)), (n = e[r = "modulo"]) != t && ((w = 0 > n || n > 9) || a(n) != n ? l(i, r, n, o, 0) : i[r] = 0 | n), i)
                        }

                        function r(e) {
                            return new this(e).exp()
                        }

                        function t(e) {
                            return new this(e).ln()
                        }

                        function n(e, r) {
                            return new this(e).log(r)
                        }

                        function o(e, r, t) {
                            var n, i, o = 0;
                            for ("[object Array]" == v.call(r[0]) && (r = r[0]), n = new e(r[0]); ++o < r.length;) {
                                if (i = new e(r[o]), !i.s) {
                                    n = i;
                                    break
                                }
                                n[t](i) && (n = i)
                            }
                            return n
                        }

                        function a() {
                            return o(this, arguments, "lt")
                        }

                        function u() {
                            return o(this, arguments, "gt")
                        }

                        function f(e, r) {
                            return new this(e).pow(r)
                        }

                        function c(e) {
                            return new this(e).sqrt()
                        }

                        function p(i) {
                            function o(e, r) {
                                var t = this;
                                if (!(t instanceof o)) return l(o, "Decimal called without new", e), new o(e, r);
                                if (e instanceof o) {
                                    if (null == r) return x = 0, t.constructor = e.constructor, t.s = e.s, t.e = e.e, void(t.c = (e = e.c) ? e.slice() : e);
                                    if (10 == r) return h(new o(e), o.precision, o.rounding);
                                    e += ""
                                }
                                return m(t.constructor = o, t, e, r)
                            }
                            return o.precision = 20, o.rounding = 4, o.modulo = 1, o.toExpNeg = -7, o.toExpPos = 21, o.minE = -M, o.maxE = M, o.errors = !0, o.crypto = !1, o.prototype = N, o.ONE = new o(1), o.ROUND_UP = 0, o.ROUND_DOWN = 1, o.ROUND_CEIL = 2, o.ROUND_FLOOR = 3, o.ROUND_HALF_UP = 4, o.ROUND_HALF_DOWN = 5, o.ROUND_HALF_EVEN = 6, o.ROUND_HALF_CEIL = 7, o.ROUND_HALF_FLOOR = 8, o.EUCLID = 9, o.config = e, o.constructor = p, o.exp = r, o.ln = t, o.log = n, o.max = a, o.min = u, o.pow = f, o.sqrt = c, o.random = y, null != i && o.config(i), o
                        }
                        var m = function () {
                                var e = /^-?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,
                                    r = String.prototype.trim || function () {
                                        return this.replace(/^\s+|\s+$/g, "")
                                    };
                                return function (t, n, i, o) {
                                    var a, s, u, f, c, p;
                                    if ("string" != typeof i && (i = (f = "number" == typeof i || "[object Number]" == v.call(i)) && 0 === i && 0 > 1 / i ? "-0" : i + ""), c = i, o == s && e.test(i)) n.s = "-" == i.charAt(0) ? (i = i.slice(1), -1) : 1;
                                    else {
                                        if (10 == o) return h(new t(i), t.precision, t.rounding);
                                        if (i = r.call(i).replace(/^\+(?!-)/, ""), n.s = "-" == i.charAt(0) ? (i = i.replace(/^-(?!-)/, ""), -1) : 1, o != s ? o != (0 | o) && t.errors || (w = !(o >= 2 && 65 > o)) ? (l(t, "base", o, 0, 0), p = e.test(i)) : (a = "[" + E.slice(0, o = 0 | o) + "]+", i = i.replace(/\.$/, "").replace(/^\./, "0."), (p = new RegExp("^" + a + "(?:\\." + a + ")?$", 37 > o ? "i" : "").test(i)) ? (f && (i.replace(/^0\.0*|\./, "").length > 15 && l(t, 0, c), f = !f), i = g(t, i, 10, o, n.s)) : "Infinity" != i && "NaN" != i && (l(t, "not a base " + o + " number", c), i = "NaN")) : p = e.test(i), !p) return n.c = n.e = null, "Infinity" != i && ("NaN" != i && l(t, "not a number", c), n.s = null), x = 0, n
                                    }
                                    for ((s = i.indexOf(".")) > -1 && (i = i.replace(".", "")), (u = i.search(/e/i)) > 0 ? (0 > s && (s = u), s += +i.slice(u + 1), i = i.substring(0, u)) : 0 > s && (s = i.length), u = 0;
                                        "0" == i.charAt(u); u++);
                                    if (u == (o = i.length)) n.c = [n.e = 0];
                                    else {
                                        for (f && o > 15 && i.slice(u).length > 15 && l(t, 0, c);
                                            "0" == i.charAt(--o););
                                        for (n.e = s - u - 1, n.c = [], s = 0; o >= u; n.c[s++] = +i.charAt(u++));
                                        b && (n.e > t.maxE ? n.c = n.e = null : n.e < t.minE && (n.c = [n.e = 0]))
                                    }
                                    x = 0
                                }
                            }(),
                            y = function () {
                                function e(e) {
                                    var r = Math.random();
                                    return e ? (r * e | 0) + "" : (1 + r + "").slice(2, -2)
                                }

                                function r(e) {
                                    var t;
                                    return e ? (t = d.getRandomValues(new i.Uint8Array(1))[0], t > (256 / e | 0) * e - 1 ? r(e) : t % e + "") : (t = d.getRandomValues(new i.Uint32Array(1))[0], t >= 4e9 ? r(e) : (t + 1e9 + "").slice(1))
                                }

                                function t(e) {
                                    var r, n, i = d.randomBytes;
                                    return e ? (n = i(1)[0], n > (256 / e | 0) * e - 1 ? t(e) : n % e + "") : (r = i(8), r[0] = 67, r[1] = 15 & r[1] | 48, n = r.readDoubleBE(0), n > 9003599627370495 ? t(e) : (n - 0xc72815b398000 + "").slice(2))
                                }
                                return function (n, i) {
                                    var o, a, u, f, c, p, m, h, g = this,
                                        y = new g(0),
                                        w = e;
                                    if (p = n == a || !(x = 14, n = new g(n)).c && !l(g, "limit must be finite", n, "random")) n = new g(g.ONE);
                                    else if (!n.c[0]) return y;
                                    g.crypto && (d.getRandomValues ? w = r : d.randomBytes && (w = t)), a = n.e, c = (o = n.c).length;
                                    do {
                                        u = 0, h = w(o[0] + 1) + w();
                                        do f = o[u], m = h.charAt(u++); while (f == m)
                                    } while (m > f || u > c || "" == m);
                                    for (u = 0;
                                        "0" == h.charAt(u); u++, a--);
                                    for (p ? i = g.precision : null != i && s(n, i, "random", 1) ? i |= 0 : i = a + 1, i += u; h.length < i;) h += w();
                                    for (;
                                        "0" == h.charAt(--i););
                                    if (++i > 0)
                                        for (y.c = []; i > u; y.c.push(+h.charAt(u++)));
                                    else y.c = [a = 0];
                                    return y.e = a, y.s = n.s, y
                                }
                            }();
                        return p()
                    }(), "undefined" != typeof e && e && e.exports ? (e.exports = y, d = t(258)) : (d = i.crypto, n = function () {
                        return y
                    }.call(r, t, r, e), !(void 0 !== n && (e.exports = n)))
                }(this)
            }).call(r, t(259)(e))
        },
        function (e, r, t) {
            r.array = t(153), r["boolean"] = t(256), r.number = t(154), r.bignumber = t(257), r.object = t(3), r.string = t(138), r.types = t(156)
        },
        function (e, r, t) {
            function n(e) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (this.nodes = e || [], !a(this.nodes) || !this.nodes.every(s)) throw new TypeError("Array containing Nodes expected")
            }
            var i = t(137),
                o = (t(3), t(138)),
                a = (t(11), t(123), Array.isArray),
                s = i.isNode;
            n.prototype = new i, n.prototype.type = "ArrayNode", n.prototype._compile = function (e) {
                var r = "array" !== e.math.config().matrix,
                    t = this.nodes.map(function (r) {
                        return r._compile(e)
                    });
                return (r ? "math.matrix([" : "[") + t.join(",") + (r ? "])" : "]")
            }, n.prototype.find = function (e) {
                var r = [];
                this.match(e) && r.push(this);
                for (var t = this.nodes, n = 0, i = t.length; i > n; n++) r = r.concat(t[n].find(e));
                return r
            }, n.prototype.toString = function () {
                return o.format(this.nodes)
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (!o(e)) throw new TypeError('String expected for parameter "name"');
                if (!(r instanceof i)) throw new TypeError('Node expected for parameter "expr"');
                this.name = e, this.expr = r
            }
            var i = t(137),
                o = t(138).isString;
            n.prototype = new i, n.prototype.type = "AssignmentNode", n.prototype._compile = function (e) {
                return 'scope["' + this.name + '"] = ' + this.expr._compile(e)
            }, n.prototype.find = function (e) {
                var r = [];
                return this.match(e) && r.push(this), r = r.concat(this.expr.find(e))
            }, n.prototype.toString = function () {
                return this.name + " = " + this.expr.toString()
            }, e.exports = n
        },
        function (e, r, t) {
            function n() {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                this.params = []
            }
            var i = t(137),
                o = t(256).isBoolean;
            n.prototype = new i, n.prototype.type = "BlockNode", n.prototype.add = function (e, r) {
                if (void 0 === r && (r = !0), !(e instanceof i)) throw new TypeError('Node expected for parameter "expr"');
                if (!o(r)) throw new TypeError('Boolean expected for parameter "visible"');
                var t = this.params.length;
                this.params[t] = {
                    node: e,
                    visible: r
                }
            }, n.prototype._compile = function (e) {
                var r = this.params.map(function (r) {
                    var t = r.node._compile(e);
                    return r.visible ? "results.push(" + t + ");" : t + ";"
                });
                return "(function () {var results = [];" + r.join("") + "return results;})()"
            }, n.prototype.find = function (e) {
                var r = [];
                this.match(e) && r.push(this);
                for (var t = this.params, n = 0, i = t.length; i > n; n++) r = r.concat(t[n].node.find(e));
                return r
            }, n.prototype.toString = function () {
                return this.params.map(function (e) {
                    return e.node.toString() + (e.visible ? "" : ";")
                }).join("\n")
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (!a(e)) throw new TypeError('String expected for parameter "type"');
                if (!a(r)) throw new TypeError('String expected for parameter "value"');
                this.valueType = e, this.value = r
            }
            var i = t(137),
                o = t(138),
                a = o.isString;
            n.prototype = new i, n.prototype.type = "ConstantNode", n.prototype._compile = function (e) {
                switch (this.valueType) {
                case "number":
                    return "bignumber" === e.math.config().number ? 'math.bignumber("' + this.value + '")' : this.value.replace(/^(0*)[0-9]/, function (e, r) {
                        return e.substring(r.length)
                    });
                case "string":
                    return '"' + this.value + '"';
                case "complex":
                    return "math.complex(0, " + this.value + ")";
                case "boolean":
                    return this.value;
                case "undefined":
                    return this.value;
                case "null":
                    return this.value;
                default:
                    throw new TypeError('Unsupported type of constant "' + this.valueType + '"')
                }
            }, n.prototype.toString = function () {
                switch (this.valueType) {
                case "string":
                    return '"' + this.value + '"';
                case "complex":
                    return this.value + "i";
                default:
                    return this.value
                }
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r, t) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (!o(e)) throw new TypeError('String expected for parameter "name"');
                if (!isArray(r) || !r.every(o)) throw new TypeError('Array containing strings expected for parameter "args"');
                if (!(t instanceof i)) throw new TypeError('Node expected for parameter "expr"');
                this.name = e, this.args = r, this.expr = t
            }
            var i = t(137),
                o = t(138).isString;
            isArray = Array.isArray, n.prototype = new i, n.prototype.type = "FunctionNode", n.prototype._compile = function (e) {
                return 'scope["' + this.name + '"] =   (function (scope) {    scope = Object.create(scope);     var fn = function ' + this.name + "(" + this.args.join(",") + ") {      if (arguments.length != " + this.args.length + ') {        throw new SyntaxError("Wrong number of arguments in function ' + this.name + ' (" + arguments.length + " provided, ' + this.args.length + ' expected)");      }' + this.args.map(function (e, r) {
                    return 'scope["' + e + '"] = arguments[' + r + "];"
                }).join("") + "      return " + this.expr._compile(e) + '    };    fn.syntax = "' + this.name + "(" + this.args.join(", ") + ')";    return fn;  })(scope);'
            }, n.prototype.find = function (e) {
                var r = [];
                return this.match(e) && r.push(this), r = r.concat(this.expr.find(e))
            }, n.prototype.toString = function () {
                return "function " + this.name + "(" + this.args.join(", ") + ") = " + this.expr.toString()
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (!(e instanceof i)) throw new TypeError('Node expected for parameter "object"');
                if (!isArray(r) || !r.every(s)) throw new TypeError('Array containing Nodes expected for parameter "ranges"');
                this.object = e, this.ranges = r
            }
            var i = t(137),
                o = t(132),
                a = t(133),
                s = i.isNode;
            n.prototype = new i, n.prototype.type = "IndexNode", n.prototype._compile = function (e) {
                return this.compileSubset(e)
            }, n.prototype.compileSubset = function (e, r) {
                var t = {
                        type: a,
                        properties: {
                            name: "end"
                        }
                    },
                    n = !1,
                    i = this.ranges.map(function (e) {
                        var r = e.find(t).length > 0;
                        return n = r ? r : n, r
                    }),
                    s = this.ranges.map(function (r, t) {
                        var n = i[t];
                        return r instanceof o ? n ? '(function (scope) {  scope = Object.create(scope);   scope["end"] = size[' + t + "];  var step = " + (r.step ? r.step._compile(e) : "1") + ";  return [    " + r.start._compile(e) + " - 1,     " + r.end._compile(e) + " - (step > 0 ? 0 : 2),     step  ];})(scope)" : "(function () {  var step = " + (r.step ? r.step._compile(e) : "1") + ";  return [    " + r.start._compile(e) + " - 1,     " + r.end._compile(e) + " - (step > 0 ? 0 : 2),     step  ];})()" : n ? '(function (scope) {  scope = Object.create(scope);   scope["end"] = size[' + t + "];  return " + r._compile(e) + " - 1;})(scope)" : r._compile(e) + " - 1"
                    });
                return n ? "(function () {  var obj = " + this.object._compile(e) + ";  var size = math.size(obj).valueOf();  return math.subset(    obj,     math.index(" + s.join(", ") + ")    " + (r ? ", " + r : "") + "  );})()" : "math.subset(" + this.object._compile(e) + ",math.index(" + s.join(", ") + ")" + (r ? ", " + r : "") + ")"
            }, n.prototype.find = function (e) {
                var r = [];
                this.match(e) && r.push(this), r = r.concat(this.object.find(e));
                for (var t = this.ranges, n = 0, i = t.length; i > n; n++) r = r.concat(t[n].find(e));
                return r
            }, n.prototype.objectName = function () {
                return this.object.name
            }, n.prototype.toString = function () {
                return this.object.toString() + "[" + this.ranges.join(", ") + "]"
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r, t) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                this.op = e, this.fn = r, this.params = t
            }
            var i = t(137);
            n.prototype = new i, n.prototype.type = "OperatorNode", n.prototype._compile = function (e) {
                if (!(this.fn in e.math)) throw new Error("Function " + this.fn + ' missing in provided namespace "math"');
                var r = this.params.map(function (r) {
                    return r._compile(e)
                });
                return "math." + this.fn + "(" + r.join(", ") + ")"
            }, n.prototype.find = function (e) {
                var r = [];
                this.match(e) && r.push(this);
                var t = this.params;
                if (t)
                    for (var n = 0, i = t.length; i > n; n++) r = r.concat(t[n].find(e));
                return r
            }, n.prototype.toString = function () {
                var e = this.params;
                switch (e.length) {
                case 1:
                    return "-" == this.op ? "-" + e[0].toString() : e[0].toString() + this.op;
                case 2:
                    var r = e[0].toString();
                    e[0] instanceof n && (r = "(" + r + ")");
                    var t = e[1].toString();
                    return e[1] instanceof n && (t = "(" + t + ")"), r + " " + this.op + " " + t;
                default:
                    return this.op + "(" + this.params.join(", ") + ")"
                }
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (!(e instanceof i)) throw new TypeError('Node expected for parameter "object"');
                if (!isArray(r) || !r.every(o)) throw new TypeError('Array containing Nodes expected for parameter "params"');
                this.object = e, this.params = r
            }
            var i = t(137),
                o = i.isNode;
            n.prototype = new i, n.prototype.type = "ParamsNode", n.prototype._compile = function (e) {
                var r = this.params.map(function (r) {
                    return r._compile(e)
                });
                return this.object._compile(e) + "(" + r.join(", ") + ")"
            }, n.prototype.find = function (e) {
                var r = [];
                this.match(e) && r.push(this), r = r.concat(this.object.find(e));
                for (var t = this.params, n = 0, i = t.length; i > n; n++) r = r.concat(t[n].find(e));
                return r
            }, n.prototype.toString = function () {
                return this.object.toString() + "(" + this.params.join(", ") + ")"
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (!Array.isArray(e) || 2 != e.length && 3 != e.length || !e.every(o)) throw new TypeError('Expected an Array containing 2 or 3 Nodes as parameter "params"');
                this.start = e[0], this.end = e[1], this.step = e[2]
            }
            var i = t(137),
                o = i.isNode;
            n.prototype = new i, n.prototype.type = "RangeNode", n.prototype._compile = function (e) {
                return "math.range(" + this.start._compile(e) + ", " + this.end._compile(e) + ", " + (this.step ? this.step._compile(e) + ", " : "") + "true)"
            }, n.prototype.find = function (e) {
                var r = [];
                return this.match(e) && r.push(this), r = r.concat(this.start.find(e)), this.step && (r = r.concat(this.step.find(e))), r = r.concat(this.end.find(e))
            }, n.prototype.toString = function () {
                var e = this.start.toString();
                return this.step && (e += ":" + this.step.toString()), e += ":" + this.end.toString()
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (!s(e)) throw new TypeError('String expected for parameter "name"');
                this.name = e
            }

            function i(e) {
                throw new Error("Undefined symbol " + e)
            }
            var o = t(137),
                a = t(9),
                s = t(138).isString;
            n.prototype = new o, n.prototype.type = "SymbolNode", n.prototype._compile = function (e) {
                return e.undef = i, e.Unit = a, '(scope["' + this.name + '"] !== undefined ? scope["' + this.name + '"] : math["' + this.name + '"] !== undefined ? math["' + this.name + '"] : ' + (a.isValuelessUnit(this.name) ? 'new Unit(null, "' + this.name + '")' : 'undef("' + this.name + '")') + ")"
            }, n.prototype.toString = function () {
                return this.name
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r, t) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                this.ops = e, this.fn = r, this.params = t
            }
            var i = t(130);
            n.prototype = new i, n.prototype.type = "TernaryNode", n.prototype.toString = function () {
                return this.params[0] + " " + this.ops[0] + " " + this.params[1] + " " + this.ops[1] + " " + this.params[2]
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (!(e instanceof i)) throw new TypeError('Node expected for parameter "value"');
                if (!o(r)) throw new TypeError('String expected for parameter "unit"');
                this.value = e, this.unit = r
            }
            var i = t(137),
                o = (t(9), t(138).isString);
            n.prototype = new i, n.prototype.type = "UnitNode", n.prototype._compile = function (e) {
                return "math.unit(" + this.value._compile(e) + ', "' + this.unit + '")'
            }, n.prototype.find = function (e) {
                var r = [];
                return this.match(e) && r.push(this), r = r.concat(this.value.find(e))
            }, n.prototype.toString = function () {
                return this.value + " " + this.unit
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, r) {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator");
                if (!(e instanceof o)) throw new TypeError('Expected IndexNode for parameter "index"');
                if (!(r instanceof i)) throw new TypeError('Expected Node for parameter "expr"');
                this.index = e, this.expr = r
            }
            var i = t(137),
                o = t(129);
            n.prototype = new i, n.prototype.type = "UpdateNode", n.prototype._compile = function (e) {
                return 'scope["' + this.index.objectName() + '"] = ' + this.index.compileSubset(e, this.expr._compile(e))
            }, n.prototype.find = function (e) {
                var r = [];
                return this.match(e) && r.push(this), r = r.concat(this.index.find(e)), r = r.concat(this.expr.find(e))
            }, n.prototype.toString = function () {
                return this.index.toString() + " = " + this.expr.toString()
            }, e.exports = n
        },
        function (e, r, t) {
            function n() {
                if (!(this instanceof n)) throw new SyntaxError("Constructor must be called with the new operator")
            }
            var i = t(4);
            n.prototype.eval = function () {
                throw new Error("Node.eval is deprecated. Use Node.compile(math).eval([scope]) instead.")
            }, n.prototype.type = "Node", n.prototype.compile = function (e) {
                if ("object" != typeof e) throw new TypeError("Object expected for parameter math");
                var r = {
                        math: e,
                        error: i
                    },
                    t = this._compile(r),
                    n = Object.keys(r).map(function (e) {
                        return "    var " + e + ' = defs["' + e + '"];'
                    }),
                    o = n.join(" ") + 'return {  "eval": function (scope) {    try {      scope = scope || {};      return ' + t + ";    } catch (err) {      if (err instanceof defs.error.IndexError) {        err = new defs.error.IndexError(err.index + 1, err.min + 1, err.max + 1);      }      throw err;    }  }};",
                    a = new Function("defs", o);
                return a(r)
            }, n.prototype._compile = function () {
                throw new Error("Cannot compile a Node interface")
            }, n.prototype.find = function (e) {
                return this.match(e) ? [this] : []
            }, n.prototype.match = function (e) {
                var r = !0;
                if (e) {
                    !e.type || this instanceof e.type || (r = !1);
                    var t = e.properties;
                    if (r && t)
                        for (var n in t)
                            if (t.hasOwnProperty(n) && this[n] !== t[n]) {
                                r = !1;
                                break
                            }
                }
                return r
            }, n.prototype.toString = function () {
                return ""
            }, n.isNode = function (e) {
                return e instanceof n
            }, e.exports = n
        },
        function (e, r, t) {
            function n(e, t) {
                if (Array.isArray(e)) {
                    for (var i = "[", o = e.length, a = 0; o > a; a++) 0 != a && (i += ", "), i += n(e[a], t);
                    return i += "]"
                }
                return r.format(e, t)
            }
            var i = t(154),
                o = t(257),
                a = t(122);
            r.isString = function (e) {
                return e instanceof String || "string" == typeof e
            }, r.endsWith = function (e, r) {
                var t = e.length - r.length,
                    n = e.length;
                return e.substring(t, n) === r
            }, r.format = function (e, t) {
                return i.isNumber(e) ? i.format(e, t) : e instanceof a ? o.format(e, t) : Array.isArray(e) ? n(e, t) : r.isString(e) ? '"' + e + '"' : "function" == typeof e ? e.syntax ? e.syntax + "" : "function" : e instanceof Object ? "function" == typeof e.format ? e.format(t) : e.toString() : String(e)
            }
        },
        function (e) {
            e.exports = {
                name: "e",
                category: "Constants",
                syntax: ["e"],
                description: "Euler's number, the base of the natural logarithm. Approximately equal to 2.71828",
                examples: ["e", "e ^ 2", "exp(2)", "log(e)"],
                seealso: ["exp"]
            }
        },
        function (e) {
            e.exports = {
                name: "false",
                category: "Constants",
                syntax: ["false"],
                description: "Boolean value false",
                examples: ["false"],
                seealso: ["true"]
            }
        },
        function (e) {
            e.exports = {
                name: "i",
                category: "Constants",
                syntax: ["i"],
                description: "Imaginary unit, defined as i*i=-1. A complex number is described as a + b*i, where a is the real part, and b is the imaginary part.",
                examples: ["i", "i * i", "sqrt(-1)"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "Infinity",
                category: "Constants",
                syntax: ["Infinity"],
                description: "Infinity, a number which is larger than the maximum number that can be handled by a floating point number.",
                examples: ["Infinity", "1 / 0"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "LN2",
                category: "Constants",
                syntax: ["LN2"],
                description: "Returns the natural logarithm of 2, approximately equal to 0.693",
                examples: ["LN2", "log(2)"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "LN10",
                category: "Constants",
                syntax: ["LN10"],
                description: "Returns the natural logarithm of 10, approximately equal to 2.302",
                examples: ["LN10", "log(10)"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "LOG2E",
                category: "Constants",
                syntax: ["LOG2E"],
                description: "Returns the base-2 logarithm of E, approximately equal to 1.442",
                examples: ["LOG2E", "log(e, 2)"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "LOG10E",
                category: "Constants",
                syntax: ["LOG10E"],
                description: "Returns the base-10 logarithm of E, approximately equal to 0.434",
                examples: ["LOG10E", "log(e, 10)"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "NaN",
                category: "Constants",
                syntax: ["NaN"],
                description: "Not a number",
                examples: ["NaN", "0 / 0"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "pi",
                category: "Constants",
                syntax: ["pi"],
                description: "The number pi is a mathematical constant that is the ratio of a circle's circumference to its diameter, and is approximately equal to 3.14159",
                examples: ["pi", "sin(pi/2)"],
                seealso: ["tau"]
            }
        },
        function (e) {
            e.exports = {
                name: "SQRT1_2",
                category: "Constants",
                syntax: ["SQRT1_2"],
                description: "Returns the square root of 1/2, approximately equal to 0.707",
                examples: ["SQRT1_2", "sqrt(1/2)"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "SQRT2",
                category: "Constants",
                syntax: ["SQRT2"],
                description: "Returns the square root of 2, approximately equal to 1.414",
                examples: ["SQRT2", "sqrt(2)"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "tau",
                category: "Constants",
                syntax: ["pi"],
                description: "Tau is the ratio constant of a circle's circumference to radius, equal to 2 * pi, approximately 6.2832.",
                examples: ["tau", "2 * pi"],
                seealso: ["pi"]
            }
        },
        function (e) {
            e.exports = {
                name: "true",
                category: "Constants",
                syntax: ["true"],
                description: "Boolean value true",
                examples: ["true"],
                seealso: ["false"]
            }
        },
        function (e, r, t) {
            function n(e) {
                for (var r = []; l(e);) r.push(e.length), e = e[0];
                return r
            }

            function i(e, r, t) {
                var n, o = e.length;
                if (o != r[t]) throw new f(o, r[t]);
                if (t < r.length - 1) {
                    var a = t + 1;
                    for (n = 0; o > n; n++) {
                        var s = e[n];
                        if (!l(s)) throw new f(r.length - 1, r.length, "<");
                        i(e[n], r, a)
                    }
                } else
                    for (n = 0; o > n; n++)
                        if (l(e[n])) throw new f(r.length + 1, r.length, ">")
            }

            function o(e, r, t, n) {
                if (!l(e)) throw Error("Array expected");
                var i, a, s = e.length,
                    f = r[t],
                    c = Math.min(s, f);
                if (e.length = f, t < r.length - 1) {
                    var p = t + 1;
                    for (i = 0; c > i; i++) a = e[i], o(a, r, p, n);
                    for (i = c; f > i; i++) a = [], e[i] = a, o(a, r, p, n)
                } else if (void 0 !== n)
                    for (i = s; f > i; i++) e[i] = u.clone(n)
            }
            var a = t(154),
                s = t(138),
                u = t(3),
                f = (t(156), t(119)),
                c = t(120),
                l = Array.isArray;
            r.size = function (e) {
                var t = n(e);
                return r.validate(e, t), t
            }, r.validate = function (e, r) {
                var t = 0 == r.length;
                if (t) {
                    if (l(e)) throw new f(e.length, 0)
                } else i(e, r, 0)
            }, r.validateIndex = function (e, r) {
                if (!a.isNumber(e) || !a.isInteger(e)) throw new TypeError("Index must be an integer (value: " + e + ")");
                if (0 > e) throw new c(e);
                if (void 0 !== r && e >= r) throw new c(e, r)
            }, r.resize = function (e, r, t) {
                if (!l(e) || !l(r)) throw new TypeError("Array expected");
                if (0 === r.length) throw new Error("Resizing to scalar is not supported");
                r.forEach(function (e) {
                    if (!a.isNumber(e) || !a.isInteger(e) || 0 > e) throw new TypeError("Invalid size, must contain positive integers (size: " + s.format(r) + ")")
                });
                for (var n = 1, i = e[0]; l(i);) n++, i = i[0];
                for (; n < r.length;) e = [e], n++;
                for (; n > r.length;) e = e[0], n--;
                return o(e, r, 0, t), e
            }, r.squeeze = function (e) {
                for (; l(e) && 1 === e.length;) e = e[0];
                return e
            }, r.unsqueeze = function (e, t) {
                for (var n = r.size(e), i = 0, o = t - n.length; o > i; i++) e = [e];
                return e
            }, r.flatten = function (e) {
                for (var r = e, t = Array.isArray; t(r[0]);) {
                    for (var n = [], i = 0, o = r.length; o > i; i++) n = n.concat.apply(n, r[i]);
                    r = n
                }
                return r
            }, r.isArray = l
        },
        function (e, r) {
            r.isNumber = function (e) {
                return e instanceof Number || "number" == typeof e
            }, r.isInteger = function (e) {
                return e == Math.round(e)
            }, r.sign = function (e) {
                return e > 0 ? 1 : 0 > e ? -1 : 0
            }, r.format = function (e, t) {
                if ("function" == typeof t) return t(e);
                if (1 / 0 === e) return "Infinity";
                if (e === -1 / 0) return "-Infinity";
                if (isNaN(e)) return "NaN";
                var n = "auto",
                    i = void 0;
                switch (void 0 !== t && (t.notation && (n = t.notation), r.isNumber(t) ? i = t : t.precision && (i = t.precision)), n) {
                case "fixed":
                    return r.toFixed(e, i);
                case "exponential":
                    return r.toExponential(e, i);
                case "auto":
                    var o = .001,
                        a = 1e5;
                    if (t && t.exponential && (void 0 !== t.exponential.lower && (o = t.exponential.lower), void 0 !== t.exponential.upper && (a = t.exponential.upper)), 0 === e) return "0";
                    var s, u = Math.abs(e);
                    if (u >= o && a > u) {
                        var f = i ? e.toPrecision(Math.min(i, 21)) : e.toPrecision();
                        s = parseFloat(f) + ""
                    } else s = r.toExponential(e, i);
                    return s.replace(/((\.\d*?)(0+))($|e)/, function () {
                        var e = arguments[2],
                            r = arguments[4];
                        return "." !== e ? e + r : r
                    });
                default:
                    throw new Error('Unknown notation "' + n + '". Choose "auto", "exponential", or "fixed".')
                }
            }, r.toExponential = function (e, r) {
                return void 0 !== r ? e.toExponential(Math.min(r - 1, 20)) : e.toExponential()
            }, r.toFixed = function (e, r) {
                return e.toFixed(Math.min(r, 20))
            }, r.digits = function (e) {
                return e.toExponential().replace(/e.*$/, "").replace(/^0\.?0*|\./, "").length
            }, r.DBL_EPSILON = Number.EPSILON || 2.220446049250313e-16, r.nearlyEqual = function (e, t, n) {
                if (null == n) return e == t;
                if (e == t) return !0;
                if (isNaN(e) || isNaN(t)) return !1;
                if (isFinite(e) && isFinite(t)) {
                    var i = Math.abs(e - t);
                    return i < r.DBL_EPSILON ? !0 : i <= Math.max(Math.abs(e), Math.abs(t)) * n
                }
                return !1
            }
        },
        function (e, r, t) {
            function n(e) {
                return t(i(e))
            }

            function i(e) {
                return o[e] || function () {
                    throw new Error("Cannot find module '" + e + "'.")
                }()
            }
            var o = {
                "./clone": 110,
                "./clone.js": 110,
                "./forEach": 117,
                "./forEach.js": 117,
                "./format": 111,
                "./format.js": 111,
                "./ifElse": 112,
                "./ifElse.js": 112,
                "./import": 113,
                "./import.js": 113,
                "./map": 114,
                "./map.js": 114,
                "./print": 115,
                "./print.js": 115,
                "./typeof": 116,
                "./typeof.js": 116
            };
            n.keys = function () {
                return Object.keys(o)
            }, n.resolve = i, e.exports = n
        },
        function (e, r) {
            r.type = function t(e) {
                var t = typeof e;
                if ("object" === t) {
                    if (null === e) return "null";
                    if (e instanceof Boolean) return "boolean";
                    if (e instanceof Number) return "number";
                    if (e instanceof String) return "string";
                    if (Array.isArray(e)) return "array";
                    if (e instanceof Date) return "date"
                }
                return t
            }
        },
        function (e) {
            e.exports = {
                name: "abs",
                category: "Arithmetic",
                syntax: ["abs(x)"],
                description: "Compute the absolute value.",
                examples: ["abs(3.5)", "abs(-4.2)"],
                seealso: ["sign"]
            }
        },
        function (e) {
            e.exports = {
                name: "add",
                category: "Operators",
                syntax: ["x + y", "add(x, y)"],
                description: "Add two values.",
                examples: ["2.1 + 3.6", "ans - 3.6", "3 + 2i", '"hello" + " world"', "3 cm + 2 inch"],
                seealso: ["subtract"]
            }
        },
        function (e) {
            e.exports = {
                name: "ceil",
                category: "Arithmetic",
                syntax: ["ceil(x)"],
                description: "Round a value towards plus infinity.If x is complex, both real and imaginary part are rounded towards plus infinity.",
                examples: ["ceil(3.2)", "ceil(3.8)", "ceil(-4.2)"],
                seealso: ["floor", "fix", "round"]
            }
        },
        function (e) {
            e.exports = {
                name: "compare",
                category: "Operators",
                syntax: ["compare(x, y)"],
                description: "Compare two values. Returns 1 if x is larger than y, -1 if x is smaller than y, and 0 if x and y are equal.",
                examples: ["compare(2, 3)", "compare(3, 2)", "compare(2, 2)", "compare(5cm, 40mm)", "compare(2, [1, 2, 3])"],
                seealso: ["equal", "unequal", "smaller", "smallereq", "largereq"]
            }
        },
        function (e) {
            e.exports = {
                name: "cube",
                category: "Arithmetic",
                syntax: ["cube(x)"],
                description: "Compute the cube of a value. The cube of x is x * x * x.",
                examples: ["cube(2)", "2^3", "2 * 2 * 2"],
                seealso: ["multiply", "square", "pow"]
            }
        },
        function (e) {
            e.exports = {
                name: "divide",
                category: "Operators",
                syntax: ["x / y", "divide(x, y)"],
                description: "Divide two values.",
                examples: ["2 / 3", "ans * 3", "4.5 / 2", "3 + 4 / 2", "(3 + 4) / 2", "18 km / 4.5"],
                seealso: ["multiply"]
            }
        },
        function (e) {
            e.exports = {
                name: "edivide",
                category: "Operators",
                syntax: ["x ./ y", "edivide(x, y)"],
                description: "divide two values element wise.",
                examples: ["a = [1, 2, 3; 4, 5, 6]", "b = [2, 1, 1; 3, 2, 5]", "a ./ b"],
                seealso: ["multiply", "emultiply", "divide"]
            }
        },
        function (e) {
            e.exports = {
                name: "emultiply",
                category: "Operators",
                syntax: ["x .* y", "emultiply(x, y)"],
                description: "multiply two values element wise.",
                examples: ["a = [1, 2, 3; 4, 5, 6]", "b = [2, 1, 1; 3, 2, 5]", "a .* b"],
                seealso: ["multiply", "divide", "edivide"]
            }
        },
        function (e) {
            e.exports = {
                name: "epow",
                category: "Operators",
                syntax: ["x .^ y", "epow(x, y)"],
                description: "Calculates the power of x to y element wise.",
                examples: ["a = [1, 2, 3; 4, 5, 6]", "a .^ 2"],
                seealso: ["pow"]
            }
        },
        function (e) {
            e.exports = {
                name: "equal",
                category: "Operators",
                syntax: ["x == y", "equal(x, y)"],
                description: "Check equality of two values. Returns true if the values are equal, and false if not.",
                examples: ["2+2 == 3", "2+2 == 4", "a = 3.2", "b = 6-2.8", "a == b", "50cm == 0.5m"],
                seealso: ["unequal", "smaller", "larger", "smallereq", "largereq", "compare"]
            }
        },
        function (e) {
            e.exports = {
                name: "exp",
                category: "Arithmetic",
                syntax: ["exp(x)"],
                description: "Calculate the exponent of a value.",
                examples: ["exp(1.3)", "e ^ 1.3", "log(exp(1.3))", "x = 2.4", "(exp(i*x) == cos(x) + i*sin(x))   # Euler's formula"],
                seealso: ["square", "multiply", "log"]
            }
        },
        function (e) {
            e.exports = {
                name: "fix",
                category: "Arithmetic",
                syntax: ["fix(x)"],
                description: "Round a value towards zero.If x is complex, both real and imaginary part are rounded towards zero.",
                examples: ["fix(3.2)", "fix(3.8)", "fix(-4.2)", "fix(-4.8)"],
                seealso: ["ceil", "floor", "round"]
            }
        },
        function (e) {
            e.exports = {
                name: "floor",
                category: "Arithmetic",
                syntax: ["floor(x)"],
                description: "Round a value towards minus infinity.If x is complex, both real and imaginary part are rounded towards minus infinity.",
                examples: ["floor(3.2)", "floor(3.8)", "floor(-4.2)"],
                seealso: ["ceil", "fix", "round"]
            }
        },
        function (e) {
            e.exports = {
                name: "gcd",
                category: "Arithmetic",
                syntax: ["gcd(a, b)", "gcd(a, b, c, ...)"],
                description: "Compute the greatest common divisor.",
                examples: ["gcd(8, 12)", "gcd(-4, 6)", "gcd(25, 15, -10)"],
                seealso: ["lcm", "xgcd"]
            }
        },
        function (e) {
            e.exports = {
                name: "larger",
                category: "Operators",
                syntax: ["x > y", "larger(x, y)"],
                description: "Check if value x is larger than y. Returns true if x is larger than y, and false if not.",
                examples: ["2 > 3", "5 > 2*2", "a = 3.3", "b = 6-2.8", "(a > b)", "(b < a)", "5 cm > 2 inch"],
                seealso: ["equal", "unequal", "smaller", "smallereq", "largereq", "compare"]
            }
        },
        function (e) {
            e.exports = {
                name: "largereq",
                category: "Operators",
                syntax: ["x >= y", "largereq(x, y)"],
                description: "Check if value x is larger or equal to y. Returns true if x is larger or equal to y, and false if not.",
                examples: ["2 > 1+1", "2 >= 1+1", "a = 3.2", "b = 6-2.8", "(a > b)"],
                seealso: ["equal", "unequal", "smallereq", "smaller", "largereq", "compare"]
            }
        },
        function (e) {
            e.exports = {
                name: "lcm",
                category: "Arithmetic",
                syntax: ["lcm(x, y)"],
                description: "Compute the least common multiple.",
                examples: ["lcm(4, 6)", "lcm(6, 21)", "lcm(6, 21, 5)"],
                seealso: ["gcd"]
            }
        },
        function (e) {
            e.exports = {
                name: "log",
                category: "Arithmetic",
                syntax: ["log(x)", "log(x, base)"],
                description: "Compute the logarithm of a value. If no base is provided, the natural logarithm of x is calculated. If base if provided, the logarithm is calculated for the specified base. log(x, base) is defined as log(x) / log(base).",
                examples: ["log(3.5)", "a = log(2.4)", "exp(a)", "10 ^ 3", "log(1000, 10)", "log(1000) / log(10)", "b = logb(1024, 2)", "2 ^ b"],
                seealso: ["exp", "log10"]
            }
        },
        function (e) {
            e.exports = {
                name: "log10",
                category: "Arithmetic",
                syntax: ["log10(x)"],
                description: "Compute the 10-base logarithm of a value.",
                examples: ["log10(1000)", "10 ^ 3", "log10(0.01)", "log(1000) / log(10)", "log(1000, 10)"],
                seealso: ["exp", "log"]
            }
        },
        function (e) {
            e.exports = {
                name: "mod",
                category: "Operators",
                syntax: ["x % y", "x mod y", "mod(x, y)"],
                description: "Calculates the modulus, the remainder of an integer division.",
                examples: ["7 % 3", "11 % 2", "10 mod 4", "function isOdd(x) = x % 2", "isOdd(2)", "isOdd(3)"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "multiply",
                category: "Operators",
                syntax: ["x * y", "multiply(x, y)"],
                description: "multiply two values.",
                examples: ["2.1 * 3.6", "ans / 3.6", "2 * 3 + 4", "2 * (3 + 4)", "3 * 2.1 km"],
                seealso: ["divide"]
            }
        },
        function (e) {
            e.exports = {
                name: "norm",
                category: "Arithmetic",
                syntax: ["norm(x)", "norm(x, p)"],
                description: "Calculate the norm of a number, vector or matrix.",
                examples: ["norm([[1, 2], [3, 4]])", "norm([[1, 2, 3, 4]], 3.5)", "norm(-4.2)", "norm([[1, 2], [-3, -4]], 'fro')"]
            }
        },
        function (e) {
            e.exports = {
                name: "pow",
                category: "Operators",
                syntax: ["x ^ y", "pow(x, y)"],
                description: "Calculates the power of x to y, x^y.",
                examples: ["2^3 = 8", "2*2*2", "1 + e ^ (pi * i)"],
                seealso: ["unequal", "smaller", "larger", "smallereq", "largereq"]
            }
        },
        function (e) {
            e.exports = {
                name: "round",
                category: "Arithmetic",
                syntax: ["round(x)", "round(x, n)"],
                description: "round a value towards the nearest integer.If x is complex, both real and imaginary part are rounded towards the nearest integer. When n is specified, the value is rounded to n decimals.",
                examples: ["round(3.2)", "round(3.8)", "round(-4.2)", "round(-4.8)", "round(pi, 3)", "round(123.45678, 2)"],
                seealso: ["ceil", "floor", "fix"]
            }
        },
        function (e) {
            e.exports = {
                name: "sign",
                category: "Arithmetic",
                syntax: ["sign(x)"],
                description: "Compute the sign of a value. The sign of a value x is 1 when x>1, -1 when x<0, and 0 when x=0.",
                examples: ["sign(3.5)", "sign(-4.2)", "sign(0)"],
                seealso: ["abs"]
            }
        },
        function (e) {
            e.exports = {
                name: "smaller",
                category: "Operators",
                syntax: ["x < y", "smaller(x, y)"],
                description: "Check if value x is smaller than value y. Returns true if x is smaller than y, and false if not.",
                examples: ["2 < 3", "5 < 2*2", "a = 3.3", "b = 6-2.8", "(a < b)", "5 cm < 2 inch"],
                seealso: ["equal", "unequal", "larger", "smallereq", "largereq", "compare"]
            }
        },
        function (e) {
            e.exports = {
                name: "smallereq",
                category: "Operators",
                syntax: ["x <= y", "smallereq(x, y)"],
                description: "Check if value x is smaller or equal to value y. Returns true if x is smaller than y, and false if not.",
                examples: ["2 < 1+1", "2 <= 1+1", "a = 3.2", "b = 6-2.8", "(a < b)"],
                seealso: ["equal", "unequal", "larger", "smaller", "largereq", "compare"]
            }
        },
        function (e) {
            e.exports = {
                name: "sqrt",
                category: "Arithmetic",
                syntax: ["sqrt(x)"],
                description: "Compute the square root value. If x = y * y, then y is the square root of x.",
                examples: ["sqrt(25)", "5 * 5", "sqrt(-1)"],
                seealso: ["square", "multiply"]
            }
        },
        function (e) {
            e.exports = {
                name: "square",
                category: "Arithmetic",
                syntax: ["square(x)"],
                description: "Compute the square of a value. The square of x is x * x.",
                examples: ["square(3)", "sqrt(9)", "3^2", "3 * 3"],
                seealso: ["multiply", "pow", "sqrt", "cube"]
            }
        },
        function (e) {
            e.exports = {
                name: "subtract",
                category: "Operators",
                syntax: ["x - y", "subtract(x, y)"],
                description: "subtract two values.",
                examples: ["5.3 - 2", "ans + 2", "2/3 - 1/6", "2 * 3 - 3", "2.1 km - 500m"],
                seealso: ["add"]
            }
        },
        function (e) {
            e.exports = {
                name: "unary",
                category: "Operators",
                syntax: ["-x", "unary(x)"],
                description: "Inverse the sign of a value.",
                examples: ["-4.5", "-(-5.6)"],
                seealso: ["add", "subtract"]
            }
        },
        function (e) {
            e.exports = {
                name: "unequal",
                category: "Operators",
                syntax: ["x != y", "unequal(x, y)"],
                description: "Check unequality of two values. Returns true if the values are unequal, and false if they are equal.",
                examples: ["2+2 != 3", "2+2 != 4", "a = 3.2", "b = 6-2.8", "a != b", "50cm != 0.5m", "5 cm != 2 inch"],
                seealso: ["equal", "smaller", "larger", "smallereq", "largereq", "compare"]
            }
        },
        function (e) {
            e.exports = {
                name: "xgcd",
                category: "Arithmetic",
                syntax: ["xgcd(a, b)"],
                description: "Calculate the extended greatest common divisor for two values",
                examples: ["xgcd(8, 12)", "gcd(8, 12)", "xgcd(36163, 21199)"],
                seealso: ["gcd", "lcm"]
            }
        },
        function (e) {
            e.exports = {
                name: "arg",
                category: "Complex",
                syntax: ["arg(x)"],
                description: "Compute the argument of a complex value. If x = a+bi, the argument is computed as atan2(b, a).",
                examples: ["arg(2 + 2i)", "atan2(3, 2)", "arg(2 - 3i)"],
                seealso: ["re", "im", "conj", "abs"]
            }
        },
        function (e) {
            e.exports = {
                name: "conj",
                category: "Complex",
                syntax: ["conj(x)"],
                description: "Compute the complex conjugate of a complex value. If x = a+bi, the complex conjugate is a-bi.",
                examples: ["conj(2 + 3i)", "conj(2 - 3i)", "conj(-5.2i)"],
                seealso: ["re", "im", "abs", "arg"]
            }
        },
        function (e) {
            e.exports = {
                name: "re",
                category: "Complex",
                syntax: ["re(x)"],
                description: "Get the real part of a complex number.",
                examples: ["re(2 + 3i)", "im(2 + 3i)", "re(-5.2i)", "re(2.4)"],
                seealso: ["im", "conj", "abs", "arg"]
            }
        },
        function (e) {
            e.exports = {
                name: "im",
                category: "Complex",
                syntax: ["im(x)"],
                description: "Get the imaginary part of a complex number.",
                examples: ["im(2 + 3i)", "re(2 + 3i)", "im(-5.2i)", "im(2.4)"],
                seealso: ["re", "conj", "abs", "arg"]
            }
        },
        function (e) {
            e.exports = {
                name: "bignumber",
                category: "Type",
                syntax: ["bignumber(x)"],
                description: "Create a big number from a number or string.",
                examples: ["0.1 + 0.2", "bignumber(0.1) + bignumber(0.2)", 'bignumber("7.2")', 'bignumber("7.2e500")', "bignumber([0.1, 0.2, 0.3])"],
                seealso: ["boolean", "complex", "index", "matrix", "string", "unit"]
            }
        },
        function (e) {
            e.exports = {
                name: "boolean",
                category: "Type",
                syntax: ["x", "boolean(x)"],
                description: "Convert a string or number into a boolean.",
                examples: ["boolean(0)", "boolean(1)", "boolean(3)", 'boolean("true")', 'boolean("false")', "boolean([1, 0, 1, 1])"],
                seealso: ["bignumber", "complex", "index", "matrix", "number", "string", "unit"]
            }
        },
        function (e) {
            e.exports = {
                name: "complex",
                category: "Type",
                syntax: ["complex()", "complex(re, im)", "complex(string)"],
                description: "Create a complex number.",
                examples: ["complex()", "complex(2, 3)", 'complex("7 - 2i")'],
                seealso: ["bignumber", "boolean", "index", "matrix", "number", "string", "unit"]
            }
        },
        function (e) {
            e.exports = {
                name: "index",
                category: "Type",
                syntax: ["[start]", "[start:end]", "[start:step:end]", "[start1, start 2, ...]", "[start1:end1, start2:end2, ...]", "[start1:step1:end1, start2:step2:end2, ...]"],
                description: "Create an index to get or replace a subset of a matrix",
                examples: ["[]", "[1, 2, 3]", "A = [1, 2, 3; 4, 5, 6]", "A[1, :]", "A[1, 2] = 50", "A[0:2, 0:2] = ones(2, 2)"],
                seealso: ["bignumber", "boolean", "complex", "matrix,", "number", "range", "string", "unit"]
            }
        },
        function (e) {
            e.exports = {
                name: "matrix",
                category: "Type",
                syntax: ["[]", "[a1, b1, ...; a2, b2, ...]", "matrix()", "matrix([...])"],
                description: "Create a matrix.",
                examples: ["[]", "[1, 2, 3]", "[1, 2, 3; 4, 5, 6]", "matrix()", "matrix([3, 4])"],
                seealso: ["bignumber", "boolean", "complex", "index", "number", "string", "unit"]
            }
        },
        function (e) {
            e.exports = {
                name: "number",
                category: "Type",
                syntax: ["x", "number(x)"],
                description: "Create a number or convert a string or boolean into a number.",
                examples: ["2", "2e3", "4.05", "number(2)", 'number("7.2")', "number(true)", "number([true, false, true, true])"],
                seealso: ["bignumber", "boolean", "complex", "index", "matrix", "string", "unit"]
            }
        },
        function (e) {
            e.exports = {
                name: "string",
                category: "Type",
                syntax: ['"text"', "string(x)"],
                description: "Create a string or convert a value to a string",
                examples: ['"Hello World!"', "string(4.2)", "string(3 + 2i)"],
                seealso: ["bignumber", "boolean", "complex", "index", "matrix", "number", "unit"]
            }
        },
        function (e) {
            e.exports = {
                name: "unit",
                category: "Type",
                syntax: ["value unit", "unit(value, unit)", "unit(string)"],
                description: "Create a unit.",
                examples: ["5.5 mm", "3 inch", 'unit(7.1, "kilogram")', 'unit("23 deg")'],
                seealso: ["bignumber", "boolean", "complex", "index", "matrix", "number", "string"]
            }
        },
        function (e) {
            e.exports = {
                name: "eval",
                category: "Expression",
                syntax: ["eval(expression)", "eval([expr1, expr2, expr3, ...])"],
                description: "Evaluate an expression or an array with expressions.",
                examples: ['eval("2 + 3")', 'eval("sqrt(" + 4 + ")")'],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "help",
                category: "Expression",
                syntax: ["help(object)", "help(string)"],
                description: "Display documentation on a function or data type.",
                examples: ["help(sqrt)", 'help("complex")'],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "concat",
                category: "Matrix",
                syntax: ["concat(a, b, c, ...)", "concat(a, b, c, ..., dim)"],
                description: "Concatenate matrices. By default, the matrices are concatenated by the first dimension. The dimension on which to concatenate can be provided as last argument.",
                examples: ["a = [1, 2; 5, 6]", "b = [3, 4; 7, 8]", "concat(a, b)", "[a, b]", "concat(a, b, 2)", "[a; b]"],
                seealso: ["det", "diag", "eye", "inv", "ones", "range", "size", "squeeze", "subset", "transpose", "zeros"]
            }
        },
        function (e) {
            e.exports = {
                name: "det",
                category: "Matrix",
                syntax: ["det(x)"],
                description: "Calculate the determinant of a matrix",
                examples: ["det([1, 2; 3, 4])", "det([-2, 2, 3; -1, 1, 3; 2, 0, -1])"],
                seealso: ["concat", "diag", "eye", "inv", "ones", "range", "size", "squeeze", "subset", "transpose", "zeros"]
            }
        },
        function (e) {
            e.exports = {
                name: "diag",
                category: "Matrix",
                syntax: ["diag(x)", "diag(x, k)"],
                description: "Create a diagonal matrix or retrieve the diagonal of a matrix. When x is a vector, a matrix with the vector values on the diagonal will be returned. When x is a matrix, a vector with the diagonal values of the matrix is returned.When k is provided, the k-th diagonal will be filled in or retrieved, if k is positive, the values are placed on the super diagonal. When k is negative, the values are placed on the sub diagonal.",
                examples: ["diag(1:3)", "diag(1:3, 1)", "a = [1, 2, 3; 4, 5, 6; 7, 8, 9]", "diag(a)"],
                seealso: ["concat", "det", "eye", "inv", "ones", "range", "size", "squeeze", "subset", "transpose", "zeros"]
            }
        },
        function (e) {
            e.exports = {
                name: "eye",
                category: "Matrix",
                syntax: ["eye(n)", "eye(m, n)", "eye([m, n])", "eye"],
                description: "Returns the identity matrix with size m-by-n. The matrix has ones on the diagonal and zeros elsewhere.",
                examples: ["eye(3)", "eye(3, 5)", "a = [1, 2, 3; 4, 5, 6]", "eye(size(a))"],
                seealso: ["concat", "det", "diag", "inv", "ones", "range", "size", "squeeze", "subset", "transpose", "zeros"]
            }
        },
        function (e) {
            e.exports = {
                name: "inv",
                category: "Matrix",
                syntax: ["inv(x)"],
                description: "Calculate the inverse of a matrix",
                examples: ["inv([1, 2; 3, 4])", "inv(4)", "1 / 4"],
                seealso: ["concat", "det", "diag", "eye", "ones", "range", "size", "squeeze", "subset", "transpose", "zeros"]
            }
        },
        function (e) {
            e.exports = {
                name: "ones",
                category: "Matrix",
                syntax: ["ones(m)", "ones(m, n)", "ones(m, n, p, ...)", "ones([m])", "ones([m, n])", "ones([m, n, p, ...])", "ones"],
                description: "Create a matrix containing ones.",
                examples: ["ones(3)", "ones(3, 5)", "ones([2,3]) * 4.5", "a = [1, 2, 3; 4, 5, 6]", "ones(size(a))"],
                seealso: ["concat", "det", "diag", "eye", "inv", "range", "size", "squeeze", "subset", "transpose", "zeros"]
            }
        },
        function (e) {
            e.exports = {
                name: "range",
                category: "Type",
                syntax: ["start:end", "start:step:end", "range(start, end)", "range(start, end, step)", "range(string)"],
                description: "Create a range. Lower bound of the range is included, upper bound is excluded.",
                examples: ["1:5", "3:-1:-3", "range(3, 7)", "range(0, 12, 2)", 'range("4:10")', "a = [1, 2, 3, 4; 5, 6, 7, 8]", "a[1:2, 1:2]"],
                seealso: ["concat", "det", "diag", "eye", "inv", "ones", "size", "squeeze", "subset", "transpose", "zeros"]
            }
        },
        function (e) {
            e.exports = {
                name: "resize",
                category: "Matrix",
                syntax: ["resize(x, size)", "resize(x, size, defaultValue)"],
                description: "Resize a matrix.",
                examples: ["resize([1,2,3,4,5], [3])", "resize([1,2,3], [5], 0)", "resize(2, [2, 3], 0)", 'resize("hello", [8], "!")'],
                seealso: ["size", "subset", "squeeze"]
            }
        },
        function (e) {
            e.exports = {
                name: "size",
                category: "Matrix",
                syntax: ["size(x)"],
                description: "Calculate the size of a matrix.",
                examples: ["size(2.3)", 'size("hello world")', "a = [1, 2; 3, 4; 5, 6]", "size(a)", "size(1:6)"],
                seealso: ["concat", "det", "diag", "eye", "inv", "ones", "range", "squeeze", "subset", "transpose", "zeros"]
            }
        },
        function (e) {
            e.exports = {
                name: "squeeze",
                category: "Matrix",
                syntax: ["squeeze(x)"],
                description: "Remove singleton dimensions from a matrix.",
                examples: ["a = zeros(1,3,2)", "size(squeeze(a))", "b = zeros(3,1,1)", "size(squeeze(b))"],
                seealso: ["concat", "det", "diag", "eye", "inv", "ones", "range", "size", "subset", "transpose", "zeros"]
            }
        },
        function (e) {
            e.exports = {
                name: "subset",
                category: "Matrix",
                syntax: ["value(index)", "value(index) = replacement", "subset(value, [index])", "subset(value, [index], replacement)"],
                description: "Get or set a subset of a matrix or string. Indexes are one-based. Both the ranges lower-bound and upper-bound are included.",
                examples: ["d = [1, 2; 3, 4]", "e = []", "e[1, 1:2] = [5, 6]", "e[2, :] = [7, 8]", "f = d * e", "f[2, 1]", "f[:, 1]"],
                seealso: ["concat", "det", "diag", "eye", "inv", "ones", "range", "size", "squeeze", "transpose", "zeros"]
            }
        },
        function (e) {
            e.exports = {
                name: "transpose",
                category: "Matrix",
                syntax: ["x'", "transpose(x)"],
                description: "Transpose a matrix",
                examples: ["a = [1, 2, 3; 4, 5, 6]", "a'", "transpose(a)"],
                seealso: ["concat", "det", "diag", "eye", "inv", "ones", "range", "size", "squeeze", "subset", "zeros"]
            }
        },
        function (e) {
            e.exports = {
                name: "zeros",
                category: "Matrix",
                syntax: ["zeros(m)", "zeros(m, n)", "zeros(m, n, p, ...)", "zeros([m])", "zeros([m, n])", "zeros([m, n, p, ...])", "zeros"],
                description: "Create a matrix containing zeros.",
                examples: ["zeros(3)", "zeros(3, 5)", "a = [1, 2, 3; 4, 5, 6]", "zeros(size(a))"],
                seealso: ["concat", "det", "diag", "eye", "inv", "ones", "range", "size", "squeeze", "subset", "transpose"]
            }
        },
        function (e) {
            e.exports = {
                name: "combinations",
                category: "Probability",
                syntax: ["combinations(n, k)"],
                description: "Compute the number of combinations of n items taken k at a time",
                examples: ["combinations(7, 5)"],
                seealso: ["permutations", "factorial"]
            }
        },
        function (e) {
            e.exports = {
                name: "distribution",
                category: "Probability",
                syntax: ["distribution(name)", "distribution(name, arg1, arg2, ...)"],
                description: 'Create a distribution object of a specific type. A distribution object contains functions `random([size,] [min,] [max])`, `randomInt([size,] [min,] [max])`, and `pickRandom(array)`. Available types of distributions: "uniform", "normal". Note that the function distribution is currently not available via the expression parser.',
                examples: [],
                seealso: ["random", "randomInt"]
            }
        },
        function (e) {
            e.exports = {
                name: "factorial",
                category: "Probability",
                syntax: ["n!", "factorial(n)"],
                description: "Compute the factorial of a value",
                examples: ["5!", "5*4*3*2*1", "3!"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "permutations",
                category: "Probability",
                syntax: ["permutations(n)", "permutations(n, k)"],
                description: "Compute the number of permutations of n items taken k at a time",
                examples: ["permutations(5)", "permutations(5, 4)"],
                seealso: ["combinations", "factorial"]
            }
        },
        function (e) {
            e.exports = {
                name: "pickRandom",
                category: "Probability",
                syntax: ["pickRandom(array)"],
                description: "Pick a random entry from a given array.",
                examples: ["pickRandom(0:10)", "pickRandom([1, 3, 1, 6])"],
                seealso: ["distribution", "random", "randomInt"]
            }
        },
        function (e) {
            e.exports = {
                name: "random",
                category: "Probability",
                syntax: ["random()", "random(max)", "random(min, max)", "random(size)", "random(size, max)", "random(size, min, max)"],
                description: "Return a random number.",
                examples: ["random()", "random(10, 20)", "random([2, 3])"],
                seealso: ["distribution", "pickRandom", "randomInt"]
            }
        },
        function (e) {
            e.exports = {
                name: "randInt",
                category: "Probability",
                syntax: ["randInt()", "randInt(max)", "randInt(min, max)", "randInt(size)", "randInt(size, max)", "randInt(size, min, max)"],
                description: "Return a random integer number",
                examples: ["randInt()", "randInt(10, 20)", "randInt([2, 3], 10)"],
                seealso: ["distribution", "pickRandom", "random"]
            }
        },
        function (e) {
            e.exports = {
                name: "max",
                category: "Statistics",
                syntax: ["max(a, b, c, ...)", "max(A)", "max(A, dim)"],
                description: "Compute the maximum value of a list of values.",
                examples: ["max(2, 3, 4, 1)", "max([2, 3, 4, 1])", "max([2, 5; 4, 3], 0)", "max([2, 5; 4, 3], 1)", "max(2.7, 7.1, -4.5, 2.0, 4.1)", "min(2.7, 7.1, -4.5, 2.0, 4.1)"],
                seealso: ["mean", "median", "min", "prod", "std", "sum", "var"]
            }
        },
        function (e) {
            e.exports = {
                name: "mean",
                category: "Statistics",
                syntax: ["mean(a, b, c, ...)", "mean(A)", "mean(A, dim)"],
                description: "Compute the arithmetic mean of a list of values.",
                examples: ["mean(2, 3, 4, 1)", "mean([2, 3, 4, 1])", "mean([2, 5; 4, 3], 0)", "mean([2, 5; 4, 3], 1)", "mean([1.0, 2.7, 3.2, 4.0])"],
                seealso: ["max", "median", "min", "prod", "std", "sum", "var"]
            }
        },
        function (e) {
            e.exports = {
                name: "median",
                category: "Statistics",
                syntax: ["median(a, b, c, ...)", "median(A)"],
                description: "Compute the median of all values. The values are sorted and the middle value is returned. In case of an even number of values, the average of the two middle values is returned.",
                examples: ["median(4, 2, 7)", "median([3, -1, 5, 7])"],
                seealso: ["max", "mean", "min", "prod", "std", "sum", "var"]
            }
        },
        function (e) {
            e.exports = {
                name: "min",
                category: "Statistics",
                syntax: ["min(a, b, c, ...)", "min(A)", "min(A, dim)"],
                description: "Compute the minimum value of a list of values.",
                examples: ["min(2, 3, 4, 1)", "min([2, 3, 4, 1])", "min([2, 5; 4, 3], 0)", "min([2, 5; 4, 3], 1)", "min(2.7, 7.1, -4.5, 2.0, 4.1)", "max(2.7, 7.1, -4.5, 2.0, 4.1)"],
                seealso: ["max", "mean", "median", "prod", "std", "sum", "var"]
            }
        },
        function (e) {
            e.exports = {
                name: "prod",
                category: "Statistics",
                syntax: ["prod(a, b, c, ...)", "prod(A)"],
                description: "Compute the product of all values.",
                examples: ["prod(2, 3, 4)", "prod([2, 3, 4])", "prod([2, 5; 4, 3])"],
                seealso: ["max", "mean", "min", "median", "min", "std", "sum", "var"]
            }
        },
        function (e) {
            e.exports = {
                name: "std",
                category: "Statistics",
                syntax: ["std(a, b, c, ...)", "std(A)", "std(A, normalization)"],
                description: 'Compute the standard deviation of all values, defined as std(A) = sqrt(var(A)). Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',
                examples: ["std(2, 4, 6)", "std([2, 4, 6, 8])", 'std([2, 4, 6, 8], "uncorrected")', 'std([2, 4, 6, 8], "biased")', "std([1, 2, 3; 4, 5, 6])"],
                seealso: ["max", "mean", "min", "median", "min", "prod", "sum", "var"]
            }
        },
        function (e) {
            e.exports = {
                name: "sum",
                category: "Statistics",
                syntax: ["sum(a, b, c, ...)", "sum(A)"],
                description: "Compute the sum of all values.",
                examples: ["sum(2, 3, 4, 1)", "sum([2, 3, 4, 1])", "sum([2, 5; 4, 3])"],
                seealso: ["max", "mean", "median", "min", "prod", "std", "sum", "var"]
            }
        },
        function (e) {
            e.exports = {
                name: "var",
                category: "Statistics",
                syntax: ["var(a, b, c, ...)", "var(A)", "var(A, normalization)"],
                description: 'Compute the variance of all values. Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',
                examples: ["var(2, 4, 6)", "var([2, 4, 6, 8])", 'var([2, 4, 6, 8], "uncorrected")', 'var([2, 4, 6, 8], "biased")', "var([1, 2, 3; 4, 5, 6])"],
                seealso: ["max", "mean", "min", "median", "min", "prod", "std", "sum"]
            }
        },
        function (e) {
            e.exports = {
                name: "acos",
                category: "Trigonometry",
                syntax: ["acos(x)"],
                description: "Compute the inverse cosine of a value in radians.",
                examples: ["acos(0.5)", "acos(cos(2.3))"],
                seealso: ["cos", "acos", "asin"]
            }
        },
        function (e) {
            e.exports = {
                name: "asin",
                category: "Trigonometry",
                syntax: ["asin(x)"],
                description: "Compute the inverse sine of a value in radians.",
                examples: ["asin(0.5)", "asin(sin(2.3))"],
                seealso: ["sin", "acos", "asin"]
            }
        },
        function (e) {
            e.exports = {
                name: "atan",
                category: "Trigonometry",
                syntax: ["atan(x)"],
                description: "Compute the inverse tangent of a value in radians.",
                examples: ["atan(0.5)", "atan(tan(2.3))"],
                seealso: ["tan", "acos", "asin"]
            }
        },
        function (e) {
            e.exports = {
                name: "atan2",
                category: "Trigonometry",
                syntax: ["atan2(y, x)"],
                description: "Computes the principal value of the arc tangent of y/x in radians.",
                examples: ["atan2(2, 2) / pi", "angle = 60 deg in rad", "x = cos(angle)", "y = sin(angle)", "atan2(y, x)"],
                seealso: ["sin", "cos", "tan"]
            }
        },
        function (e) {
            e.exports = {
                name: "cos",
                category: "Trigonometry",
                syntax: ["cos(x)"],
                description: "Compute the cosine of x in radians.",
                examples: ["cos(2)", "cos(pi / 4) ^ 2", "cos(180 deg)", "cos(60 deg)", "sin(0.2)^2 + cos(0.2)^2"],
                seealso: ["acos", "sin", "tan"]
            }
        },
        function (e) {
            e.exports = {
                name: "cosh",
                category: "Trigonometry",
                syntax: ["cosh(x)"],
                description: "Compute the hyperbolic cosine of x in radians.",
                examples: ["cosh(2)", "cosh(pi / 4) ^ 2", "cosh(180 deg)", "cosh(60 deg)", "sinh(0.2)^2 + cosh(0.2)^2"],
                seealso: ["sinh", "tanh", "coth"]
            }
        },
        function (e) {
            e.exports = {
                name: "cot",
                category: "Trigonometry",
                syntax: ["cot(x)"],
                description: "Compute the cotangent of x in radians. Defined as 1/tan(x)",
                examples: ["cot(2)", "1 / tan(2)"],
                seealso: ["sec", "csc", "tan"]
            }
        },
        function (e) {
            e.exports = {
                name: "coth",
                category: "Trigonometry",
                syntax: ["coth(x)"],
                description: "Compute the hyperbolic cotangent of x in radians.",
                examples: ["coth(2)"],
                seealso: ["sech", "csch", "tanh"]
            }
        },
        function (e) {
            e.exports = {
                name: "csc",
                category: "Trigonometry",
                syntax: ["csc(x)"],
                description: "Compute the cosecant of x in radians. Defined as 1/sin(x)",
                examples: ["csc(2)", "1 / sin(2)"],
                seealso: ["sec", "cot", "sin"]
            }
        },
        function (e) {
            e.exports = {
                name: "csch",
                category: "Trigonometry",
                syntax: ["csch(x)"],
                description: "Compute the hyperbolic cosecant of x in radians. Defined as 1/sinh(x)",
                examples: ["csch(2)", "1 / sinh(2)"],
                seealso: ["sech", "coth", "sinh"]
            }
        },
        function (e) {
            e.exports = {
                name: "sec",
                category: "Trigonometry",
                syntax: ["sec(x)"],
                description: "Compute the secant of x in radians. Defined as 1/cos(x)",
                examples: ["sec(2)", "1 / cos(2)"],
                seealso: ["cot", "csc", "cos"]
            }
        },
        function (e) {
            e.exports = {
                name: "sech",
                category: "Trigonometry",
                syntax: ["sech(x)"],
                description: "Compute the hyperbolic secant of x in radians. Defined as 1/cosh(x)",
                examples: ["sech(2)", "1 / cosh(2)"],
                seealso: ["coth", "csch", "cosh"]
            }
        },
        function (e) {
            e.exports = {
                name: "sin",
                category: "Trigonometry",
                syntax: ["sin(x)"],
                description: "Compute the sine of x in radians.",
                examples: ["sin(2)", "sin(pi / 4) ^ 2", "sin(90 deg)", "sin(30 deg)", "sin(0.2)^2 + cos(0.2)^2"],
                seealso: ["asin", "cos", "tan"]
            }
        },
        function (e) {
            e.exports = {
                name: "sinh",
                category: "Trigonometry",
                syntax: ["sinh(x)"],
                description: "Compute the hyperbolic sine of x in radians.",
                examples: ["sinh(2)", "sinh(pi / 4) ^ 2", "sinh(90 deg)", "sinh(30 deg)", "sinh(0.2)^2 + cosh(0.2)^2"],
                seealso: ["cosh", "tanh"]
            }
        },
        function (e) {
            e.exports = {
                name: "tan",
                category: "Trigonometry",
                syntax: ["tan(x)"],
                description: "Compute the tangent of x in radians.",
                examples: ["tan(0.5)", "sin(0.5) / cos(0.5)", "tan(pi / 4)", "tan(45 deg)"],
                seealso: ["atan", "sin", "cos"]
            }
        },
        function (e) {
            e.exports = {
                name: "tanh",
                category: "Trigonometry",
                syntax: ["tanh(x)"],
                description: "Compute the hyperbolic tangent of x in radians.",
                examples: ["tanh(0.5)", "sinh(0.5) / cosh(0.5)", "tanh(pi / 4)", "tanh(45 deg)"],
                seealso: ["sinh", "cosh"]
            }
        },
        function (e) {
            e.exports = {
                name: "to",
                category: "Units",
                syntax: ["x to unit", "to(x, unit)"],
                description: "Change the unit of a value.",
                examples: ["5 inch in cm", "3.2kg in g", "16 bytes in bits"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "clone",
                category: "Utils",
                syntax: ["clone(x)"],
                description: "Clone a variable. Creates a copy of primitive variables,and a deep copy of matrices",
                examples: ["clone(3.5)", "clone(2 - 4i)", "clone(45 deg)", "clone([1, 2; 3, 4])", 'clone("hello world")'],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "map",
                category: "Utils",
                syntax: ["map(x, callback)"],
                description: "Create a new matrix or array with the results of the callback function executed on each entry of the matrix/array.",
                examples: ["map([1, 2, 3], function(val) { return math.max(val, 1.5) })"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "forEach",
                category: "Utils",
                syntax: ["forEach(x, callback)"],
                description: "Iterates over all elements of a matrix/array, and executes the given callback.",
                examples: ["forEach([1, 2, 3], function(val) { console.log(val) })"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "format",
                category: "Utils",
                syntax: ["format(value)", "format(value, precision)"],
                description: "Format a value of any type as string.",
                examples: ["format(2.3)", "format(3 - 4i)", "format([])", "format(pi, 3)"],
                seealso: ["print"]
            }
        },
        function (e) {
            e.exports = {
                name: "ifElse",
                category: "Utils",
                syntax: ["ifElse(conditional, trueExpr, falseExpr)"],
                description: "Executes a conditional expression.",
                examples: ["ifElse(10 > 0, 10, 0)", 'ifElse("", true, false)', "ifElse([4, 6, 0, -1], true, false)"],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "import",
                category: "Utils",
                syntax: ["import(string)"],
                description: "Import functions from a file.",
                examples: ['import("numbers")', 'import("./mylib.js")'],
                seealso: []
            }
        },
        function (e) {
            e.exports = {
                name: "typeof",
                category: "Utils",
                syntax: ["typeof(x)"],
                description: "Get the type of a variable.",
                examples: ["typeof(3.5)", "typeof(2 - 4i)", "typeof(45 deg)", 'typeof("hello world")'],
                seealso: []
            }
        },
        function (e, r) {
            r.isBoolean = function (e) {
                return e instanceof Boolean || "boolean" == typeof e
            }
        },
        function (e, r, t) {
            var n = t(122),
                i = t(154).isNumber;
            digits = t(154).digits, r.isBigNumber = function (e) {
                return e instanceof n
            }, r.format = function (e, t) {
                if ("function" == typeof t) return t(e);
                if (!e.isFinite()) return e.isNaN() ? "NaN" : e.gt(0) ? "Infinity" : "-Infinity";
                var n = "auto",
                    o = void 0;
                switch (void 0 !== t && (t.notation && (n = t.notation), i(t) ? o = t : t.precision && (o = t.precision)), n) {
                case "fixed":
                    return r.toFixed(e, o);
                case "exponential":
                    return r.toExponential(e, o);
                case "auto":
                    var a = .001,
                        s = 1e5;
                    t && t.exponential && (void 0 !== t.exponential.lower && (a = t.exponential.lower), void 0 !== t.exponential.upper && (s = t.exponential.upper)); {
                        ({
                            toExpNeg: e.constructor.toExpNeg,
                            toExpPos: e.constructor.toExpPos
                        })
                    }
                    if (e.constructor.config({
                        toExpNeg: Math.round(Math.log(a) / Math.LN10),
                        toExpPos: Math.round(Math.log(s) / Math.LN10)
                    }), e.isZero()) return "0";
                    var u, f = e.abs();
                    return u = f.gte(a) && f.lt(s) ? e.toSignificantDigits(o).toFixed() : r.toExponential(e, o), u.replace(/((\.\d*?)(0+))($|e)/, function () {
                        var e = arguments[2],
                            r = arguments[4];
                        return "." !== e ? e + r : r
                    });
                default:
                    throw new Error('Unknown notation "' + n + '". Choose "auto", "exponential", or "fixed".')
                }
            }, r.toExponential = function (e, r) {
                return void 0 !== r ? e.toExponential(r - 1) : e.toExponential()
            }, r.toFixed = function (e, r) {
                return e.toFixed(r || 0)
            }
        },
        function (e, r, t) {
            function n() {
                var e = [].slice.call(arguments).join(" ");
                throw new Error([e, "we accept pull requests", "http://github.com/dominictarr/crypto-browserify"].join("\n"))
            }

            function i(e, r) {
                for (var t in e) r(e[t], t)
            }
            var o = t(264).Buffer,
                a = t(260);
            r.createHash = t(261), r.createHmac = t(262), r.randomBytes = function (e, r) {
                if (!r || !r.call) return new o(a(e));
                try {
                    r.call(this, void 0, new o(a(e)))
                } catch (t) {
                    r(t)
                }
            };
            var s = t(263)(r.createHmac);
            r.pbkdf2 = s.pbkdf2, r.pbkdf2Sync = s.pbkdf2Sync, i(["createCredentials", "createCipher", "createCipheriv", "createDecipher", "createDecipheriv", "createSign", "createVerify", "createDiffieHellman"], function (e) {
                r[e] = function () {
                    n("sorry,", e, "is not implemented yet")
                }
            })
        },
        function (e) {
            e.exports = function (e) {
                return e.webpackPolyfill || (e.deprecate = function () {}, e.paths = [], e.children = [], e.webpackPolyfill = 1), e
            }
        },
        function (e, r, t) {
            (function (r) {
                ! function () {
                    var t, n, i = this;
                    t = function (e) {
                        for (var t, t, n = new r(e), i = 0; e > i; i++) 0 == (3 & i) && (t = 4294967296 * Math.random()), n[i] = t >>> ((3 & i) << 3) & 255;
                        return n
                    }, i.crypto && crypto.getRandomValues && (n = function (e) {
                        var t = new r(e);
                        return crypto.getRandomValues(t), t
                    }), e.exports = n || t
                }()
            }).call(r, t(264).Buffer)
        },
        function (e, r, t) {
            (function (r) {
                function n(e) {
                    return function () {
                        var t = [],
                            n = {
                                update: function (e, n) {
                                    return r.isBuffer(e) || (e = new r(e, n)), t.push(e), this
                                },
                                digest: function (n) {
                                    var i = r.concat(t),
                                        o = e(i);
                                    return t = null, n ? o.toString(n) : o
                                }
                            };
                        return n
                    }
                }
                var i = t(266),
                    o = n(t(265));
                e.exports = function (e) {
                    return "md5" === e ? new o : i(e)
                }
            }).call(r, t(264).Buffer)
        },
        function (e, r, t) {
            (function (r) {
                function n(e, t) {
                    if (!(this instanceof n)) return new n(e, t);
                    this._opad = u, this._alg = e, t = this._key = r.isBuffer(t) ? t : new r(t), t.length > o ? t = i(e).update(t).digest() : t.length < o && (t = r.concat([t, a], o));
                    for (var s = this._ipad = new r(o), u = this._opad = new r(o), f = 0; o > f; f++) s[f] = 54 ^ t[f], u[f] = 92 ^ t[f];
                    this._hash = i(e).update(s)
                }
                var i = t(261),
                    o = 64,
                    a = new r(o);
                a.fill(0), e.exports = n, n.prototype.update = function (e, r) {
                    return this._hash.update(e, r), this
                }, n.prototype.digest = function (e) {
                    var r = this._hash.digest();
                    return i(this._alg).update(this._opad).update(r).digest(e)
                }
            }).call(r, t(264).Buffer)
        },
        function (e, r, t) {
            var n = t(264).Buffer,
                i = 64,
                o = new n(i);
            o.fill(0), e.exports = function (e, r) {
                return r = r || {}, r.pbkdf2 = function (e, t, n, i, o) {
                    if ("function" != typeof o) throw new Error("No callback provided to pbkdf2");
                    setTimeout(function () {
                        o(null, r.pbkdf2Sync(e, t, n, i))
                    })
                }, r.pbkdf2Sync = function (r, t, a, s) {
                    if ("number" != typeof a) throw new TypeError("Iterations not a number");
                    if (0 > a) throw new TypeError("Bad iterations");
                    if ("number" != typeof s) throw new TypeError("Key length not a number");
                    if (0 > s) throw new TypeError("Bad key length");
                    var r = n.isBuffer(r) ? r : new n(r);
                    r.length > i ? r = createHash(alg).update(r).digest() : r.length < i && (r = n.concat([r, o], i));
                    var u, f, c, l = 0,
                        p = 1,
                        m = new n(4),
                        h = new n(s);
                    for (h.fill(0); s;) {
                        f = s > 20 ? 20 : s, m[0] = p >> 24 & 255, m[1] = p >> 16 & 255, m[2] = p >> 8 & 255, m[3] = 255 & p, u = e("sha1", r), u.update(t), u.update(m), c = u.digest(), c.copy(h, l, 0, f);
                        for (var g = 1; a > g; g++) {
                            u = e("sha1", r), u.update(c), c = u.digest();
                            for (var d = 0; f > d; d++) h[d] ^= c[d]
                        }
                        s -= f, p++, l += f
                    }
                    return h
                }, r
            }
        },
        function (e, r, t) {
            (function (e) {
                function e(r, t, n) {
                    if (!(this instanceof e)) return new e(r, t, n);
                    var i = typeof r;
                    if ("base64" === t && "string" === i)
                        for (r = T(r); r.length % 4 !== 0;) r += "=";
                    var o;
                    if ("number" === i) o = C(r);
                    else if ("string" === i) o = e.byteLength(r, t);
                    else {
                        if ("object" !== i) throw new Error("First argument needs to be a number, array or string.");
                        o = C(r.length)
                    }
                    var a;
                    e._useTypedArrays ? a = e._augment(new Uint8Array(o)) : (a = this, a.length = o, a._isBuffer = !0);
                    var s;
                    if (e._useTypedArrays && "number" == typeof r.byteLength) a._set(r);
                    else if (U(r))
                        for (s = 0; o > s; s++) a[s] = e.isBuffer(r) ? r.readUInt8(s) : r[s];
                    else if ("string" === i) a.write(r, 0, t);
                    else if ("number" === i && !e._useTypedArrays && !n)
                        for (s = 0; o > s; s++) a[s] = 0;
                    return a
                }

                function n(r, t, n, i) {
                    n = Number(n) || 0;
                    var o = r.length - n;
                    i ? (i = Number(i), i > o && (i = o)) : i = o;
                    var a = t.length;
                    D(a % 2 === 0, "Invalid hex string"), i > a / 2 && (i = a / 2);
                    for (var s = 0; i > s; s++) {
                        var u = parseInt(t.substr(2 * s, 2), 16);
                        D(!isNaN(u), "Invalid hex string"), r[n + s] = u
                    }
                    return e._charsWritten = 2 * s, s
                }

                function i(r, t, n, i) {
                    var o = e._charsWritten = j(I(t), r, n, i);
                    return o
                }

                function o(r, t, n, i) {
                    var o = e._charsWritten = j(z(t), r, n, i);
                    return o
                }

                function a(e, r, t, n) {
                    return o(e, r, t, n)
                }

                function s(r, t, n, i) {
                    var o = e._charsWritten = j(L(t), r, n, i);
                    return o
                }

                function u(r, t, n, i) {
                    var o = e._charsWritten = j(q(t), r, n, i);
                    return o
                }

                function f(e, r, t) {
                    return G.fromByteArray(0 === r && t === e.length ? e : e.slice(r, t))
                }

                function c(e, r, t) {
                    var n = "",
                        i = "";
                    t = Math.min(e.length, t);
                    for (var o = r; t > o; o++) e[o] <= 127 ? (n += R(i) + String.fromCharCode(e[o]), i = "") : i += "%" + e[o].toString(16);
                    return n + R(i)
                }

                function l(e, r, t) {
                    var n = "";
                    t = Math.min(e.length, t);
                    for (var i = r; t > i; i++) n += String.fromCharCode(e[i]);
                    return n
                }

                function p(e, r, t) {
                    return l(e, r, t)
                }

                function m(e, r, t) {
                    var n = e.length;
                    (!r || 0 > r) && (r = 0), (!t || 0 > t || t > n) && (t = n);
                    for (var i = "", o = r; t > o; o++) i += _(e[o]);
                    return i
                }

                function h(e, r, t) {
                    for (var n = e.slice(r, t), i = "", o = 0; o < n.length; o += 2) i += String.fromCharCode(n[o] + 256 * n[o + 1]);
                    return i
                }

                function g(e, r, t, n) {
                    n || (D("boolean" == typeof t, "missing or invalid endian"), D(void 0 !== r && null !== r, "missing offset"), D(r + 1 < e.length, "Trying to read beyond buffer length"));
                    var i = e.length;
                    if (!(r >= i)) {
                        var o;
                        return t ? (o = e[r], i > r + 1 && (o |= e[r + 1] << 8)) : (o = e[r] << 8, i > r + 1 && (o |= e[r + 1])), o
                    }
                }

                function d(e, r, t, n) {
                    n || (D("boolean" == typeof t, "missing or invalid endian"), D(void 0 !== r && null !== r, "missing offset"), D(r + 3 < e.length, "Trying to read beyond buffer length"));
                    var i = e.length;
                    if (!(r >= i)) {
                        var o;
                        return t ? (i > r + 2 && (o = e[r + 2] << 16), i > r + 1 && (o |= e[r + 1] << 8), o |= e[r], i > r + 3 && (o += e[r + 3] << 24 >>> 0)) : (i > r + 1 && (o = e[r + 1] << 16), i > r + 2 && (o |= e[r + 2] << 8), i > r + 3 && (o |= e[r + 3]), o += e[r] << 24 >>> 0), o
                    }
                }

                function y(e, r, t, n) {
                    n || (D("boolean" == typeof t, "missing or invalid endian"), D(void 0 !== r && null !== r, "missing offset"), D(r + 1 < e.length, "Trying to read beyond buffer length"));
                    var i = e.length;
                    if (!(r >= i)) {
                        var o = g(e, r, t, !0),
                            a = 32768 & o;
                        return a ? -1 * (65535 - o + 1) : o
                    }
                }

                function w(e, r, t, n) {
                    n || (D("boolean" == typeof t, "missing or invalid endian"), D(void 0 !== r && null !== r, "missing offset"), D(r + 3 < e.length, "Trying to read beyond buffer length"));
                    var i = e.length;
                    if (!(r >= i)) {
                        var o = d(e, r, t, !0),
                            a = 2147483648 & o;
                        return a ? -1 * (4294967295 - o + 1) : o
                    }
                }

                function v(e, r, t, n) {
                    return n || (D("boolean" == typeof t, "missing or invalid endian"), D(r + 3 < e.length, "Trying to read beyond buffer length")), V.read(e, r, t, 23, 4)
                }

                function x(e, r, t, n) {
                    return n || (D("boolean" == typeof t, "missing or invalid endian"), D(r + 7 < e.length, "Trying to read beyond buffer length")), V.read(e, r, t, 52, 8)
                }

                function b(e, r, t, n, i) {
                    i || (D(void 0 !== r && null !== r, "missing value"), D("boolean" == typeof n, "missing or invalid endian"), D(void 0 !== t && null !== t, "missing offset"), D(t + 1 < e.length, "trying to write beyond buffer length"), k(r, 65535));
                    var o = e.length;
                    if (!(t >= o))
                        for (var a = 0, s = Math.min(o - t, 2); s > a; a++) e[t + a] = (r & 255 << 8 * (n ? a : 1 - a)) >>> 8 * (n ? a : 1 - a)
                }

                function E(e, r, t, n, i) {
                    i || (D(void 0 !== r && null !== r, "missing value"), D("boolean" == typeof n, "missing or invalid endian"), D(void 0 !== t && null !== t, "missing offset"), D(t + 3 < e.length, "trying to write beyond buffer length"), k(r, 4294967295));
                    var o = e.length;
                    if (!(t >= o))
                        for (var a = 0, s = Math.min(o - t, 4); s > a; a++) e[t + a] = r >>> 8 * (n ? a : 3 - a) & 255
                }

                function N(e, r, t, n, i) {
                    i || (D(void 0 !== r && null !== r, "missing value"), D("boolean" == typeof n, "missing or invalid endian"), D(void 0 !== t && null !== t, "missing offset"), D(t + 1 < e.length, "Trying to write beyond buffer length"), P(r, 32767, -32768));
                    var o = e.length;
                    t >= o || (r >= 0 ? b(e, r, t, n, i) : b(e, 65535 + r + 1, t, n, i))
                }

                function M(e, r, t, n, i) {
                    i || (D(void 0 !== r && null !== r, "missing value"), D("boolean" == typeof n, "missing or invalid endian"), D(void 0 !== t && null !== t, "missing offset"), D(t + 3 < e.length, "Trying to write beyond buffer length"), P(r, 2147483647, -2147483648));
                    var o = e.length;
                    t >= o || (r >= 0 ? E(e, r, t, n, i) : E(e, 4294967295 + r + 1, t, n, i))
                }

                function A(e, r, t, n, i) {
                    i || (D(void 0 !== r && null !== r, "missing value"), D("boolean" == typeof n, "missing or invalid endian"), D(void 0 !== t && null !== t, "missing offset"), D(t + 3 < e.length, "Trying to write beyond buffer length"), F(r, 3.4028234663852886e38, -3.4028234663852886e38));
                    var o = e.length;
                    t >= o || V.write(e, r, t, n, 23, 4)
                }

                function S(e, r, t, n, i) {
                    i || (D(void 0 !== r && null !== r, "missing value"), D("boolean" == typeof n, "missing or invalid endian"), D(void 0 !== t && null !== t, "missing offset"), D(t + 7 < e.length, "Trying to write beyond buffer length"), F(r, 1.7976931348623157e308, -1.7976931348623157e308));
                    var o = e.length;
                    t >= o || V.write(e, r, t, n, 52, 8)
                }

                function T(e) {
                    return e.trim ? e.trim() : e.replace(/^\s+|\s+$/g, "")
                }

                function O(e, r, t) {
                    return "number" != typeof e ? t : (e = ~~e, e >= r ? r : e >= 0 ? e : (e += r, e >= 0 ? e : 0))
                }

                function C(e) {
                    return e = ~~Math.ceil(+e), 0 > e ? 0 : e
                }

                function B(e) {
                    return (Array.isArray || function (e) {
                        return "[object Array]" === Object.prototype.toString.call(e)
                    })(e)
                }

                function U(r) {
                    return B(r) || e.isBuffer(r) || r && "object" == typeof r && "number" == typeof r.length
                }

                function _(e) {
                    return 16 > e ? "0" + e.toString(16) : e.toString(16)
                }

                function I(e) {
                    for (var r = [], t = 0; t < e.length; t++) {
                        var n = e.charCodeAt(t);
                        if (127 >= n) r.push(e.charCodeAt(t));
                        else {
                            var i = t;
                            n >= 55296 && 57343 >= n && t++;
                            for (var o = encodeURIComponent(e.slice(i, t + 1)).substr(1).split("%"), a = 0; a < o.length; a++) r.push(parseInt(o[a], 16))
                        }
                    }
                    return r
                }

                function z(e) {
                    for (var r = [], t = 0; t < e.length; t++) r.push(255 & e.charCodeAt(t));
                    return r
                }

                function q(e) {
                    for (var r, t, n, i = [], o = 0; o < e.length; o++) r = e.charCodeAt(o), t = r >> 8, n = r % 256, i.push(n), i.push(t);
                    return i
                }

                function L(e) {
                    return G.toByteArray(e)
                }

                function j(e, r, t, n) {
                    for (var i = 0; n > i && !(i + t >= r.length || i >= e.length); i++) r[i + t] = e[i];
                    return i
                }

                function R(e) {
                    try {
                        return decodeURIComponent(e)
                    } catch (r) {
                        return String.fromCharCode(65533)
                    }
                }

                function k(e, r) {
                    D("number" == typeof e, "cannot write a non-number as a number"), D(e >= 0, "specified a negative value for writing an unsigned value"), D(r >= e, "value is larger than maximum value for type"), D(Math.floor(e) === e, "value has a fractional component")
                }

                function P(e, r, t) {
                    D("number" == typeof e, "cannot write a non-number as a number"), D(r >= e, "value larger than maximum allowed value"), D(e >= t, "value smaller than minimum allowed value"), D(Math.floor(e) === e, "value has a fractional component")
                }

                function F(e, r, t) {
                    D("number" == typeof e, "cannot write a non-number as a number"), D(r >= e, "value larger than maximum allowed value"), D(e >= t, "value smaller than minimum allowed value")
                }

                function D(e, r) {
                    if (!e) throw new Error(r || "Failed assertion")
                }
                /*!
                 * The buffer module from node.js, for the browser.
                 *
                 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
                 * @license  MIT
                 */
                var G = t(272),
                    V = t(268);
                r.Buffer = e, r.SlowBuffer = e, r.INSPECT_MAX_BYTES = 50, e.poolSize = 8192, e._useTypedArrays = function () {
                    try {
                        var e = new ArrayBuffer(0),
                            r = new Uint8Array(e);
                        return r.foo = function () {
                            return 42
                        }, 42 === r.foo() && "function" == typeof r.subarray
                    } catch (t) {
                        return !1
                    }
                }(), e.isEncoding = function (e) {
                    switch (String(e).toLowerCase()) {
                    case "hex":
                    case "utf8":
                    case "utf-8":
                    case "ascii":
                    case "binary":
                    case "base64":
                    case "raw":
                    case "ucs2":
                    case "ucs-2":
                    case "utf16le":
                    case "utf-16le":
                        return !0;
                    default:
                        return !1
                    }
                }, e.isBuffer = function (e) {
                    return !(null === e || void 0 === e || !e._isBuffer)
                }, e.byteLength = function (e, r) {
                    var t;
                    switch (e += "", r || "utf8") {
                    case "hex":
                        t = e.length / 2;
                        break;
                    case "utf8":
                    case "utf-8":
                        t = I(e).length;
                        break;
                    case "ascii":
                    case "binary":
                    case "raw":
                        t = e.length;
                        break;
                    case "base64":
                        t = L(e).length;
                        break;
                    case "ucs2":
                    case "ucs-2":
                    case "utf16le":
                    case "utf-16le":
                        t = 2 * e.length;
                        break;
                    default:
                        throw new Error("Unknown encoding")
                    }
                    return t
                }, e.concat = function (r, t) {
                    if (D(B(r), "Usage: Buffer.concat(list, [totalLength])\nlist should be an Array."), 0 === r.length) return new e(0);
                    if (1 === r.length) return r[0];
                    var n;
                    if ("number" != typeof t)
                        for (t = 0, n = 0; n < r.length; n++) t += r[n].length;
                    var i = new e(t),
                        o = 0;
                    for (n = 0; n < r.length; n++) {
                        var a = r[n];
                        a.copy(i, o), o += a.length
                    }
                    return i
                }, e.prototype.write = function (e, r, t, f) {
                    if (isFinite(r)) isFinite(t) || (f = t, t = void 0);
                    else {
                        var c = f;
                        f = r, r = t, t = c
                    }
                    r = Number(r) || 0;
                    var l = this.length - r;
                    t ? (t = Number(t), t > l && (t = l)) : t = l, f = String(f || "utf8").toLowerCase();
                    var p;
                    switch (f) {
                    case "hex":
                        p = n(this, e, r, t);
                        break;
                    case "utf8":
                    case "utf-8":
                        p = i(this, e, r, t);
                        break;
                    case "ascii":
                        p = o(this, e, r, t);
                        break;
                    case "binary":
                        p = a(this, e, r, t);
                        break;
                    case "base64":
                        p = s(this, e, r, t);
                        break;
                    case "ucs2":
                    case "ucs-2":
                    case "utf16le":
                    case "utf-16le":
                        p = u(this, e, r, t);
                        break;
                    default:
                        throw new Error("Unknown encoding")
                    }
                    return p
                }, e.prototype.toString = function (e, r, t) {
                    var n = this;
                    if (e = String(e || "utf8").toLowerCase(), r = Number(r) || 0, t = void 0 !== t ? Number(t) : t = n.length, t === r) return "";
                    var i;
                    switch (e) {
                    case "hex":
                        i = m(n, r, t);
                        break;
                    case "utf8":
                    case "utf-8":
                        i = c(n, r, t);
                        break;
                    case "ascii":
                        i = l(n, r, t);
                        break;
                    case "binary":
                        i = p(n, r, t);
                        break;
                    case "base64":
                        i = f(n, r, t);
                        break;
                    case "ucs2":
                    case "ucs-2":
                    case "utf16le":
                    case "utf-16le":
                        i = h(n, r, t);
                        break;
                    default:
                        throw new Error("Unknown encoding")
                    }
                    return i
                }, e.prototype.toJSON = function () {
                    return {
                        type: "Buffer",
                        data: Array.prototype.slice.call(this._arr || this, 0)
                    }
                }, e.prototype.copy = function (r, t, n, i) {
                    var o = this;
                    if (n || (n = 0), i || 0 === i || (i = this.length), t || (t = 0), i !== n && 0 !== r.length && 0 !== o.length) {
                        D(i >= n, "sourceEnd < sourceStart"), D(t >= 0 && t < r.length, "targetStart out of bounds"), D(n >= 0 && n < o.length, "sourceStart out of bounds"), D(i >= 0 && i <= o.length, "sourceEnd out of bounds"), i > this.length && (i = this.length), r.length - t < i - n && (i = r.length - t + n);
                        var a = i - n;
                        if (100 > a || !e._useTypedArrays)
                            for (var s = 0; a > s; s++) r[s + t] = this[s + n];
                        else r._set(this.subarray(n, n + a), t)
                    }
                }, e.prototype.slice = function (r, t) {
                    var n = this.length;
                    if (r = O(r, n, 0), t = O(t, n, n), e._useTypedArrays) return e._augment(this.subarray(r, t));
                    for (var i = t - r, o = new e(i, void 0, !0), a = 0; i > a; a++) o[a] = this[a + r];
                    return o
                }, e.prototype.get = function (e) {
                    return console.log(".get() is deprecated. Access using array indexes instead."), this.readUInt8(e)
                }, e.prototype.set = function (e, r) {
                    return console.log(".set() is deprecated. Access using array indexes instead."), this.writeUInt8(e, r)
                }, e.prototype.readUInt8 = function (e, r) {
                    return r || (D(void 0 !== e && null !== e, "missing offset"), D(e < this.length, "Trying to read beyond buffer length")), e >= this.length ? void 0 : this[e]
                }, e.prototype.readUInt16LE = function (e, r) {
                    return g(this, e, !0, r)
                }, e.prototype.readUInt16BE = function (e, r) {
                    return g(this, e, !1, r)
                }, e.prototype.readUInt32LE = function (e, r) {
                    return d(this, e, !0, r)
                }, e.prototype.readUInt32BE = function (e, r) {
                    return d(this, e, !1, r)
                }, e.prototype.readInt8 = function (e, r) {
                    if (r || (D(void 0 !== e && null !== e, "missing offset"), D(e < this.length, "Trying to read beyond buffer length")), !(e >= this.length)) {
                        var t = 128 & this[e];
                        return t ? -1 * (255 - this[e] + 1) : this[e]
                    }
                }, e.prototype.readInt16LE = function (e, r) {
                    return y(this, e, !0, r)
                }, e.prototype.readInt16BE = function (e, r) {
                    return y(this, e, !1, r)
                }, e.prototype.readInt32LE = function (e, r) {
                    return w(this, e, !0, r)
                }, e.prototype.readInt32BE = function (e, r) {
                    return w(this, e, !1, r)
                }, e.prototype.readFloatLE = function (e, r) {
                    return v(this, e, !0, r)
                }, e.prototype.readFloatBE = function (e, r) {
                    return v(this, e, !1, r)
                }, e.prototype.readDoubleLE = function (e, r) {
                    return x(this, e, !0, r)
                }, e.prototype.readDoubleBE = function (e, r) {
                    return x(this, e, !1, r)
                }, e.prototype.writeUInt8 = function (e, r, t) {
                    t || (D(void 0 !== e && null !== e, "missing value"), D(void 0 !== r && null !== r, "missing offset"), D(r < this.length, "trying to write beyond buffer length"), k(e, 255)), r >= this.length || (this[r] = e)
                }, e.prototype.writeUInt16LE = function (e, r, t) {
                    b(this, e, r, !0, t)
                }, e.prototype.writeUInt16BE = function (e, r, t) {
                    b(this, e, r, !1, t)
                }, e.prototype.writeUInt32LE = function (e, r, t) {
                    E(this, e, r, !0, t)
                }, e.prototype.writeUInt32BE = function (e, r, t) {
                    E(this, e, r, !1, t)
                }, e.prototype.writeInt8 = function (e, r, t) {
                    t || (D(void 0 !== e && null !== e, "missing value"), D(void 0 !== r && null !== r, "missing offset"), D(r < this.length, "Trying to write beyond buffer length"), P(e, 127, -128)), r >= this.length || (e >= 0 ? this.writeUInt8(e, r, t) : this.writeUInt8(255 + e + 1, r, t))
                }, e.prototype.writeInt16LE = function (e, r, t) {
                    N(this, e, r, !0, t)
                }, e.prototype.writeInt16BE = function (e, r, t) {
                    N(this, e, r, !1, t)
                }, e.prototype.writeInt32LE = function (e, r, t) {
                    M(this, e, r, !0, t)
                }, e.prototype.writeInt32BE = function (e, r, t) {
                    M(this, e, r, !1, t)
                }, e.prototype.writeFloatLE = function (e, r, t) {
                    A(this, e, r, !0, t)
                }, e.prototype.writeFloatBE = function (e, r, t) {
                    A(this, e, r, !1, t)
                }, e.prototype.writeDoubleLE = function (e, r, t) {
                    S(this, e, r, !0, t)
                }, e.prototype.writeDoubleBE = function (e, r, t) {
                    S(this, e, r, !1, t)
                }, e.prototype.fill = function (e, r, t) {
                    if (e || (e = 0), r || (r = 0), t || (t = this.length), "string" == typeof e && (e = e.charCodeAt(0)), D("number" == typeof e && !isNaN(e), "value is not a number"), D(t >= r, "end < start"), t !== r && 0 !== this.length) {
                        D(r >= 0 && r < this.length, "start out of bounds"), D(t >= 0 && t <= this.length, "end out of bounds");
                        for (var n = r; t > n; n++) this[n] = e
                    }
                }, e.prototype.inspect = function () {
                    for (var e = [], t = this.length, n = 0; t > n; n++)
                        if (e[n] = _(this[n]), n === r.INSPECT_MAX_BYTES) {
                            e[n + 1] = "...";
                            break
                        }
                    return "<Buffer " + e.join(" ") + ">"
                }, e.prototype.toArrayBuffer = function () {
                    if ("undefined" != typeof Uint8Array) {
                        if (e._useTypedArrays) return new e(this).buffer;
                        for (var r = new Uint8Array(this.length), t = 0, n = r.length; n > t; t += 1) r[t] = this[t];
                        return r.buffer
                    }
                    throw new Error("Buffer.toArrayBuffer not supported in this browser")
                };
                var H = e.prototype;
                e._augment = function (e) {
                    return e._isBuffer = !0, e._get = e.get, e._set = e.set, e.get = H.get, e.set = H.set, e.write = H.write, e.toString = H.toString, e.toLocaleString = H.toString, e.toJSON = H.toJSON, e.copy = H.copy, e.slice = H.slice, e.readUInt8 = H.readUInt8, e.readUInt16LE = H.readUInt16LE, e.readUInt16BE = H.readUInt16BE, e.readUInt32LE = H.readUInt32LE, e.readUInt32BE = H.readUInt32BE, e.readInt8 = H.readInt8, e.readInt16LE = H.readInt16LE, e.readInt16BE = H.readInt16BE, e.readInt32LE = H.readInt32LE, e.readInt32BE = H.readInt32BE, e.readFloatLE = H.readFloatLE, e.readFloatBE = H.readFloatBE, e.readDoubleLE = H.readDoubleLE, e.readDoubleBE = H.readDoubleBE, e.writeUInt8 = H.writeUInt8, e.writeUInt16LE = H.writeUInt16LE, e.writeUInt16BE = H.writeUInt16BE, e.writeUInt32LE = H.writeUInt32LE, e.writeUInt32BE = H.writeUInt32BE, e.writeInt8 = H.writeInt8, e.writeInt16LE = H.writeInt16LE, e.writeInt16BE = H.writeInt16BE, e.writeInt32LE = H.writeInt32LE, e.writeInt32BE = H.writeInt32BE, e.writeFloatLE = H.writeFloatLE, e.writeFloatBE = H.writeFloatBE, e.writeDoubleLE = H.writeDoubleLE, e.writeDoubleBE = H.writeDoubleBE, e.fill = H.fill, e.inspect = H.inspect, e.toArrayBuffer = H.toArrayBuffer, e
                }
            }).call(r, t(264).Buffer)
        },
        function (e, r, t) {
            function n(e, r) {
                e[r >> 5] |= 128 << r % 32, e[(r + 64 >>> 9 << 4) + 14] = r;
                for (var t = 1732584193, n = -271733879, i = -1732584194, c = 271733878, l = 0; l < e.length; l += 16) {
                    var p = t,
                        m = n,
                        h = i,
                        g = c;
                    t = o(t, n, i, c, e[l + 0], 7, -680876936), c = o(c, t, n, i, e[l + 1], 12, -389564586), i = o(i, c, t, n, e[l + 2], 17, 606105819), n = o(n, i, c, t, e[l + 3], 22, -1044525330), t = o(t, n, i, c, e[l + 4], 7, -176418897), c = o(c, t, n, i, e[l + 5], 12, 1200080426), i = o(i, c, t, n, e[l + 6], 17, -1473231341), n = o(n, i, c, t, e[l + 7], 22, -45705983), t = o(t, n, i, c, e[l + 8], 7, 1770035416), c = o(c, t, n, i, e[l + 9], 12, -1958414417), i = o(i, c, t, n, e[l + 10], 17, -42063), n = o(n, i, c, t, e[l + 11], 22, -1990404162), t = o(t, n, i, c, e[l + 12], 7, 1804603682), c = o(c, t, n, i, e[l + 13], 12, -40341101), i = o(i, c, t, n, e[l + 14], 17, -1502002290), n = o(n, i, c, t, e[l + 15], 22, 1236535329), t = a(t, n, i, c, e[l + 1], 5, -165796510), c = a(c, t, n, i, e[l + 6], 9, -1069501632), i = a(i, c, t, n, e[l + 11], 14, 643717713), n = a(n, i, c, t, e[l + 0], 20, -373897302), t = a(t, n, i, c, e[l + 5], 5, -701558691), c = a(c, t, n, i, e[l + 10], 9, 38016083), i = a(i, c, t, n, e[l + 15], 14, -660478335), n = a(n, i, c, t, e[l + 4], 20, -405537848), t = a(t, n, i, c, e[l + 9], 5, 568446438), c = a(c, t, n, i, e[l + 14], 9, -1019803690), i = a(i, c, t, n, e[l + 3], 14, -187363961), n = a(n, i, c, t, e[l + 8], 20, 1163531501), t = a(t, n, i, c, e[l + 13], 5, -1444681467), c = a(c, t, n, i, e[l + 2], 9, -51403784), i = a(i, c, t, n, e[l + 7], 14, 1735328473), n = a(n, i, c, t, e[l + 12], 20, -1926607734), t = s(t, n, i, c, e[l + 5], 4, -378558), c = s(c, t, n, i, e[l + 8], 11, -2022574463), i = s(i, c, t, n, e[l + 11], 16, 1839030562), n = s(n, i, c, t, e[l + 14], 23, -35309556), t = s(t, n, i, c, e[l + 1], 4, -1530992060), c = s(c, t, n, i, e[l + 4], 11, 1272893353), i = s(i, c, t, n, e[l + 7], 16, -155497632), n = s(n, i, c, t, e[l + 10], 23, -1094730640), t = s(t, n, i, c, e[l + 13], 4, 681279174), c = s(c, t, n, i, e[l + 0], 11, -358537222), i = s(i, c, t, n, e[l + 3], 16, -722521979), n = s(n, i, c, t, e[l + 6], 23, 76029189), t = s(t, n, i, c, e[l + 9], 4, -640364487), c = s(c, t, n, i, e[l + 12], 11, -421815835), i = s(i, c, t, n, e[l + 15], 16, 530742520), n = s(n, i, c, t, e[l + 2], 23, -995338651), t = u(t, n, i, c, e[l + 0], 6, -198630844), c = u(c, t, n, i, e[l + 7], 10, 1126891415), i = u(i, c, t, n, e[l + 14], 15, -1416354905), n = u(n, i, c, t, e[l + 5], 21, -57434055), t = u(t, n, i, c, e[l + 12], 6, 1700485571), c = u(c, t, n, i, e[l + 3], 10, -1894986606), i = u(i, c, t, n, e[l + 10], 15, -1051523), n = u(n, i, c, t, e[l + 1], 21, -2054922799), t = u(t, n, i, c, e[l + 8], 6, 1873313359), c = u(c, t, n, i, e[l + 15], 10, -30611744), i = u(i, c, t, n, e[l + 6], 15, -1560198380), n = u(n, i, c, t, e[l + 13], 21, 1309151649), t = u(t, n, i, c, e[l + 4], 6, -145523070), c = u(c, t, n, i, e[l + 11], 10, -1120210379), i = u(i, c, t, n, e[l + 2], 15, 718787259), n = u(n, i, c, t, e[l + 9], 21, -343485551), t = f(t, p), n = f(n, m), i = f(i, h), c = f(c, g)
                }
                return Array(t, n, i, c)
            }

            function i(e, r, t, n, i, o) {
                return f(c(f(f(r, e), f(n, o)), i), t)
            }

            function o(e, r, t, n, o, a, s) {
                return i(r & t | ~r & n, e, r, o, a, s)
            }

            function a(e, r, t, n, o, a, s) {
                return i(r & n | t & ~n, e, r, o, a, s)
            }

            function s(e, r, t, n, o, a, s) {
                return i(r ^ t ^ n, e, r, o, a, s)
            }

            function u(e, r, t, n, o, a, s) {
                return i(t ^ (r | ~n), e, r, o, a, s)
            }

            function f(e, r) {
                var t = (65535 & e) + (65535 & r),
                    n = (e >> 16) + (r >> 16) + (t >> 16);
                return n << 16 | 65535 & t
            }

            function c(e, r) {
                return e << r | e >>> 32 - r
            }
            var l = t(267);
            e.exports = function (e) {
                return l.hash(e, n, 16)
            }
        },
        function (e, r, t) {
            var r = e.exports = function (e) {
                    var t = r[e];
                    if (!t) throw new Error(e + " is not supported (we accept pull requests)");
                    return new t
                },
                n = t(264).Buffer,
                i = t(269)(n);
            r.sha = r.sha1 = t(270)(n, i), r.sha256 = t(271)(n, i)
        },
        function (e, r, t) {
            function n(e, r) {
                if (e.length % s !== 0) {
                    var t = e.length + (s - e.length % s);
                    e = a.concat([e, u], t)
                }
                for (var n = [], i = r ? e.readInt32BE : e.readInt32LE, o = 0; o < e.length; o += s) n.push(i.call(e, o));
                return n
            }

            function i(e, r, t) {
                for (var n = new a(r), i = t ? n.writeInt32BE : n.writeInt32LE, o = 0; o < e.length; o++) i.call(n, e[o], 4 * o, !0);
                return n
            }

            function o(e, r, t, o) {
                a.isBuffer(e) || (e = new a(e));
                var s = r(n(e, o), e.length * f);
                return i(s, t, o)
            }
            var a = t(264).Buffer,
                s = 4,
                u = new a(s);
            u.fill(0);
            var f = 8;
            e.exports = {
                hash: o
            }
        },
        function (e, r) {
            r.read = function (e, r, t, n, i) {
                var o, a, s = 8 * i - n - 1,
                    u = (1 << s) - 1,
                    f = u >> 1,
                    c = -7,
                    l = t ? i - 1 : 0,
                    p = t ? -1 : 1,
                    m = e[r + l];
                for (l += p, o = m & (1 << -c) - 1, m >>= -c, c += s; c > 0; o = 256 * o + e[r + l], l += p, c -= 8);
                for (a = o & (1 << -c) - 1, o >>= -c, c += n; c > 0; a = 256 * a + e[r + l], l += p, c -= 8);
                if (0 === o) o = 1 - f;
                else {
                    if (o === u) return a ? 0 / 0 : 1 / 0 * (m ? -1 : 1);
                    a += Math.pow(2, n), o -= f
                }
                return (m ? -1 : 1) * a * Math.pow(2, o - n)
            }, r.write = function (e, r, t, n, i, o) {
                var a, s, u, f = 8 * o - i - 1,
                    c = (1 << f) - 1,
                    l = c >> 1,
                    p = 23 === i ? Math.pow(2, -24) - Math.pow(2, -77) : 0,
                    m = n ? 0 : o - 1,
                    h = n ? 1 : -1,
                    g = 0 > r || 0 === r && 0 > 1 / r ? 1 : 0;
                for (r = Math.abs(r), isNaN(r) || 1 / 0 === r ? (s = isNaN(r) ? 1 : 0, a = c) : (a = Math.floor(Math.log(r) / Math.LN2), r * (u = Math.pow(2, -a)) < 1 && (a--, u *= 2), r += a + l >= 1 ? p / u : p * Math.pow(2, 1 - l), r * u >= 2 && (a++, u /= 2), a + l >= c ? (s = 0, a = c) : a + l >= 1 ? (s = (r * u - 1) * Math.pow(2, i), a += l) : (s = r * Math.pow(2, l - 1) * Math.pow(2, i), a = 0)); i >= 8; e[t + m] = 255 & s, m += h, s /= 256, i -= 8);
                for (a = a << i | s, f += i; f > 0; e[t + m] = 255 & a, m += h, a /= 256, f -= 8);
                e[t + m - h] |= 128 * g
            }
        },
        function (e, r, t) {
            var n = t(273),
                i = n.write,
                o = n.zeroFill;
            e.exports = function (e) {
                function r(r, t) {
                    this._block = new e(r), this._finalSize = t, this._blockSize = r, this._len = 0, this._s = 0
                }

                function t(e, r) {
                    return null == r ? e.byteLength || e.length : "ascii" == r || "binary" == r ? e.length : "hex" == r ? e.length / 2 : "base64" == r ? e.length / 3 : void 0
                }
                return r.prototype.init = function () {
                    this._s = 0, this._len = 0
                }, r.prototype.update = function (r, n) {
                    var o, a = this._blockSize;
                    n || "string" != typeof r || (n = "utf8"), n ? ("utf-8" === n && (n = "utf8"), ("base64" === n || "utf8" === n) && (r = new e(r, n), n = null), o = t(r, n)) : o = r.byteLength || r.length;
                    for (var s = this._len += o, u = this._s = this._s || 0, f = 0, c = this._block; s > u;) {
                        var l = Math.min(o, f + a);
                        i(c, r, n, u % a, f, l);
                        var p = l - f;
                        u += p, f += p, u % a || this._update(c)
                    }
                    return this._s = u, this
                }, r.prototype.digest = function (e) {
                    var r = this._blockSize,
                        t = this._finalSize,
                        i = 8 * this._len,
                        a = this._block,
                        s = i % (8 * r);
                    a[this._len % r] = 128, o(this._block, this._len % r + 1), s >= 8 * t && (this._update(this._block), n.zeroFill(this._block, 0)), a.writeInt32BE(i, t + 4);
                    var u = this._update(this._block) || this._hash();
                    return null == e ? u : u.toString(e)
                }, r.prototype._update = function () {
                    throw new Error("_update must be implemented by subclass")
                }, r
            }
        },
        function (e, r, t) {
            e.exports = function (e, r) {
                function n() {
                    return g.length ? g.pop().init() : this instanceof n ? (this._w = h, r.call(this, 64, 56), this._h = null, void this.init()) : new n
                }

                function i(e, r, t, n) {
                    return 20 > e ? r & t | ~r & n : 40 > e ? r ^ t ^ n : 60 > e ? r & t | r & n | t & n : r ^ t ^ n
                }

                function o(e) {
                    return 20 > e ? 1518500249 : 40 > e ? 1859775393 : 60 > e ? -1894007588 : -899497514
                }

                function a(e, r) {
                    return e + r | 0
                }

                function s(e, r) {
                    return e << r | e >>> 32 - r
                }
                var u = t(275).inherits;
                u(n, r);
                var f = 0,
                    c = 4,
                    l = 8,
                    p = 12,
                    m = 16,
                    h = new Int32Array(80),
                    g = [];
                n.prototype.init = function () {
                    return this._a = 1732584193, this._b = 4023233417, this._c = 2562383102, this._d = 271733878, this._e = 3285377520, r.prototype.init.call(this), this
                }, n.prototype._POOL = g;
                new e(1) instanceof DataView;
                return n.prototype._update = function () {
                    {
                        var e, r, t, n, u, f, c, l, p, m, h = this._block;
                        this._h
                    }
                    e = f = this._a, r = c = this._b, t = l = this._c, n = p = this._d, u = m = this._e;
                    for (var g = this._w, d = 0; 80 > d; d++) {
                        var y = g[d] = 16 > d ? h.readInt32BE(4 * d) : s(g[d - 3] ^ g[d - 8] ^ g[d - 14] ^ g[d - 16], 1),
                            w = a(a(s(e, 5), i(d, r, t, n)), a(a(u, y), o(d)));
                        u = n, n = t, t = s(r, 30), r = e, e = w
                    }
                    this._a = a(e, f), this._b = a(r, c), this._c = a(t, l), this._d = a(n, p), this._e = a(u, m)
                }, n.prototype._hash = function () {
                    g.length < 100 && g.push(this);
                    var r = new e(20);
                    return r.writeInt32BE(0 | this._a, f), r.writeInt32BE(0 | this._b, c), r.writeInt32BE(0 | this._c, l), r.writeInt32BE(0 | this._d, p), r.writeInt32BE(0 | this._e, m), r
                }, n
            }
        },
        function (e, r, t) {
            {
                var n = t(275).inherits;
                t(274), t(273)
            }
            e.exports = function (e, r) {
                function t() {
                    h.length, this.init(), this._w = m, r.call(this, 64, 56)
                }

                function i(e, r) {
                    return e >>> r | e << 32 - r
                }

                function o(e, r) {
                    return e >>> r
                }

                function a(e, r, t) {
                    return e & r ^ ~e & t
                }

                function s(e, r, t) {
                    return e & r ^ e & t ^ r & t
                }

                function u(e) {
                    return i(e, 2) ^ i(e, 13) ^ i(e, 22)
                }

                function f(e) {
                    return i(e, 6) ^ i(e, 11) ^ i(e, 25)
                }

                function c(e) {
                    return i(e, 7) ^ i(e, 18) ^ o(e, 3)
                }

                function l(e) {
                    return i(e, 17) ^ i(e, 19) ^ o(e, 10)
                }
                var p = [1116352408, 1899447441, 3049323471, 3921009573, 961987163, 1508970993, 2453635748, 2870763221, 3624381080, 310598401, 607225278, 1426881987, 1925078388, 2162078206, 2614888103, 3248222580, 3835390401, 4022224774, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, 2554220882, 2821834349, 2952996808, 3210313671, 3336571891, 3584528711, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, 2177026350, 2456956037, 2730485921, 2820302411, 3259730800, 3345764771, 3516065817, 3600352804, 4094571909, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, 2227730452, 2361852424, 2428436474, 2756734187, 3204031479, 3329325298];
                n(t, r);
                var m = new Array(64),
                    h = [];
                t.prototype.init = function () {
                    return this._a = 1779033703, this._b = -1150833019, this._c = 1013904242, this._d = -1521486534, this._e = 1359893119, this._f = -1694144372, this._g = 528734635, this._h = 1541459225, this._len = this._s = 0, this
                };
                return t.prototype._update = function () {
                    var e, r, t, n, i, o, m, h, g, d, y = this._block,
                        w = this._w;
                    e = 0 | this._a, r = 0 | this._b, t = 0 | this._c, n = 0 | this._d, i = 0 | this._e, o = 0 | this._f, m = 0 | this._g, h = 0 | this._h;
                    for (var v = 0; 64 > v; v++) {
                        var x = w[v] = 16 > v ? y.readInt32BE(4 * v) : l(w[v - 2]) + w[v - 7] + c(w[v - 15]) + w[v - 16];
                        g = h + f(i) + a(i, o, m) + p[v] + x, d = u(e) + s(e, r, t), h = m, m = o, o = i, i = n + g, n = t, t = r, r = e, e = g + d
                    }
                    this._a = e + this._a | 0, this._b = r + this._b | 0, this._c = t + this._c | 0, this._d = n + this._d | 0, this._e = i + this._e | 0, this._f = o + this._f | 0, this._g = m + this._g | 0, this._h = h + this._h | 0
                }, t.prototype._hash = function () {
                    h.length < 10 && h.push(this);
                    var r = new e(32);
                    return r.writeInt32BE(this._a, 0), r.writeInt32BE(this._b, 4), r.writeInt32BE(this._c, 8), r.writeInt32BE(this._d, 12), r.writeInt32BE(this._e, 16), r.writeInt32BE(this._f, 20), r.writeInt32BE(this._g, 24), r.writeInt32BE(this._h, 28), r
                }, t
            }
        },
        function (e) {
            var r = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
            ! function () {
                "use strict";

                function t(e) {
                    var r = e.charCodeAt(0);
                    return r === a ? 62 : r === s ? 63 : u > r ? -1 : u + 10 > r ? r - u + 26 + 26 : c + 26 > r ? r - c : f + 26 > r ? r - f + 26 : void 0
                }

                function n(e) {
                    function r(e) {
                        f[l++] = e
                    }
                    var n, i, a, s, u, f;
                    if (e.length % 4 > 0) throw new Error("Invalid string. Length must be a multiple of 4");
                    var c = e.length;
                    u = "=" === e.charAt(c - 2) ? 2 : "=" === e.charAt(c - 1) ? 1 : 0, f = new o(3 * e.length / 4 - u), a = u > 0 ? e.length - 4 : e.length;
                    var l = 0;
                    for (n = 0, i = 0; a > n; n += 4, i += 3) s = t(e.charAt(n)) << 18 | t(e.charAt(n + 1)) << 12 | t(e.charAt(n + 2)) << 6 | t(e.charAt(n + 3)), r((16711680 & s) >> 16), r((65280 & s) >> 8), r(255 & s);
                    return 2 === u ? (s = t(e.charAt(n)) << 2 | t(e.charAt(n + 1)) >> 4, r(255 & s)) : 1 === u && (s = t(e.charAt(n)) << 10 | t(e.charAt(n + 1)) << 4 | t(e.charAt(n + 2)) >> 2, r(s >> 8 & 255), r(255 & s)), f
                }

                function i(e) {
                    function t(e) {
                        return r.charAt(e)
                    }

                    function n(e) {
                        return t(e >> 18 & 63) + t(e >> 12 & 63) + t(e >> 6 & 63) + t(63 & e)
                    }
                    var i, o, a, s = e.length % 3,
                        u = "";
                    for (i = 0, a = e.length - s; a > i; i += 3) o = (e[i] << 16) + (e[i + 1] << 8) + e[i + 2], u += n(o);
                    switch (s) {
                    case 1:
                        o = e[e.length - 1], u += t(o >> 2), u += t(o << 4 & 63), u += "==";
                        break;
                    case 2:
                        o = (e[e.length - 2] << 8) + e[e.length - 1], u += t(o >> 10), u += t(o >> 4 & 63), u += t(o << 2 & 63), u += "="
                    }
                    return u
                }
                var o = "undefined" != typeof Uint8Array ? Uint8Array : Array,
                    a = ("0".charCodeAt(0), "+".charCodeAt(0)),
                    s = "/".charCodeAt(0),
                    u = "0".charCodeAt(0),
                    f = "a".charCodeAt(0),
                    c = "A".charCodeAt(0);
                e.exports.toByteArray = n, e.exports.fromByteArray = i
            }()
        },
        function (e, r) {
            function t(e, r, t, n, i, o) {
                var a = o - i;
                if ("ascii" === t || "binary" === t)
                    for (var s = 0; a > s; s++) e[n + s] = r.charCodeAt(s + i);
                else if (null == t)
                    for (var s = 0; a > s; s++) e[n + s] = r[s + i];
                else {
                    if ("hex" !== t) throw new Error("base64" === t ? "base64 encoding not yet supported" : t + " encoding not yet supported");
                    for (var s = 0; a > s; s++) {
                        var u = i + s;
                        e[n + s] = parseInt(r[2 * u] + r[2 * u + 1], 16)
                    }
                }
            }

            function n(e, r) {
                for (var t = r; t < e.length; t++) e[t] = 0
            }
            r.write = t, r.zeroFill = n, r.toString = toString
        },
        function (e, r, t) {
            (function (e, r) {
                function t(e, r, t, n) {
                    e = e.buffer || e;
                    for (var i = "", o = e.byteLength || e.length, a = 0; o > a; a++) {
                        var s = 4294967292 & a | (n ? 3 - a % 4 : a % 4);
                        i = i + (e[s] >> 4).toString(16) + (15 & e[s]).toString(16) + (r - 1 == a % r ? " " : "") + (t - 1 == a % t ? "\n" : "")
                    }
                    return i
                }
                var n = e.exports = function (e, r) {
                    return r = r || {}, r.groups = r.groups || 4, r.wrap = r.wrap || 16, t(e, r.groups, r.wrap, r.bigendian, r.ints)
                };
                if (n.defaults = function (e) {
                    return function (r) {
                        return n(r, e)
                    }
                }, !e.parent) {
                    var i = new r(64);
                    console.log(n(i)), console.log(n(i, {
                        bigendian: !0
                    }))
                }
            }).call(r, t(259)(e), t(264).Buffer)
        },
        function (e, r, t) {
            (function (e, n) {
                function i(e, t) {
                    var n = {
                        seen: [],
                        stylize: a
                    };
                    return arguments.length >= 3 && (n.depth = arguments[2]), arguments.length >= 4 && (n.colors = arguments[3]), g(t) ? n.showHidden = t : t && r._extend(n, t), b(n.showHidden) && (n.showHidden = !1), b(n.depth) && (n.depth = 2), b(n.colors) && (n.colors = !1), b(n.customInspect) && (n.customInspect = !0), n.colors && (n.stylize = o), u(n, e, n.depth)
                }

                function o(e, r) {
                    var t = i.styles[r];
                    return t ? "[" + i.colors[t][0] + "m" + e + "[" + i.colors[t][1] + "m" : e
                }

                function a(e) {
                    return e
                }

                function s(e) {
                    var r = {};
                    return e.forEach(function (e) {
                        r[e] = !0
                    }), r
                }

                function u(e, t, n) {
                    if (e.customInspect && t && S(t.inspect) && t.inspect !== r.inspect && (!t.constructor || t.constructor.prototype !== t)) {
                        var i = t.inspect(n, e);
                        return v(i) || (i = u(e, i, n)), i
                    }
                    var o = f(e, t);
                    if (o) return o;
                    var a = Object.keys(t),
                        g = s(a);
                    if (e.showHidden && (a = Object.getOwnPropertyNames(t)), A(t) && (a.indexOf("message") >= 0 || a.indexOf("description") >= 0)) return c(t);
                    if (0 === a.length) {
                        if (S(t)) {
                            var d = t.name ? ": " + t.name : "";
                            return e.stylize("[Function" + d + "]", "special")
                        }
                        if (E(t)) return e.stylize(RegExp.prototype.toString.call(t), "regexp");
                        if (M(t)) return e.stylize(Date.prototype.toString.call(t), "date");
                        if (A(t)) return c(t)
                    }
                    var y = "",
                        w = !1,
                        x = ["{", "}"];
                    if (h(t) && (w = !0, x = ["[", "]"]), S(t)) {
                        var b = t.name ? ": " + t.name : "";
                        y = " [Function" + b + "]"
                    }
                    if (E(t) && (y = " " + RegExp.prototype.toString.call(t)), M(t) && (y = " " + Date.prototype.toUTCString.call(t)), A(t) && (y = " " + c(t)), 0 === a.length && (!w || 0 == t.length)) return x[0] + y + x[1];
                    if (0 > n) return E(t) ? e.stylize(RegExp.prototype.toString.call(t), "regexp") : e.stylize("[Object]", "special");
                    e.seen.push(t);
                    var N;
                    return N = w ? l(e, t, n, g, a) : a.map(function (r) {
                        return p(e, t, n, g, r, w)
                    }), e.seen.pop(), m(N, y, x)
                }

                function f(e, r) {
                    if (b(r)) return e.stylize("undefined", "undefined");
                    if (v(r)) {
                        var t = "'" + JSON.stringify(r).replace(/^"|"$/g, "").replace(/'/g, "\\'").replace(/\\"/g, '"') + "'";
                        return e.stylize(t, "string")
                    }
                    return w(r) ? e.stylize("" + r, "number") : g(r) ? e.stylize("" + r, "boolean") : d(r) ? e.stylize("null", "null") : void 0
                }

                function c(e) {
                    return "[" + Error.prototype.toString.call(e) + "]"
                }

                function l(e, r, t, n, i) {
                    for (var o = [], a = 0, s = r.length; s > a; ++a) o.push(U(r, String(a)) ? p(e, r, t, n, String(a), !0) : "");
                    return i.forEach(function (i) {
                        i.match(/^\d+$/) || o.push(p(e, r, t, n, i, !0))
                    }), o
                }

                function p(e, r, t, n, i, o) {
                    var a, s, f;
                    if (f = Object.getOwnPropertyDescriptor(r, i) || {
                        value: r[i]
                    }, f.get ? s = f.set ? e.stylize("[Getter/Setter]", "special") : e.stylize("[Getter]", "special") : f.set && (s = e.stylize("[Setter]", "special")), U(n, i) || (a = "[" + i + "]"), s || (e.seen.indexOf(f.value) < 0 ? (s = d(t) ? u(e, f.value, null) : u(e, f.value, t - 1), s.indexOf("\n") > -1 && (s = o ? s.split("\n").map(function (e) {
                        return "  " + e
                    }).join("\n").substr(2) : "\n" + s.split("\n").map(function (e) {
                        return "   " + e
                    }).join("\n"))) : s = e.stylize("[Circular]", "special")), b(a)) {
                        if (o && i.match(/^\d+$/)) return s;
                        a = JSON.stringify("" + i), a.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/) ? (a = a.substr(1, a.length - 2), a = e.stylize(a, "name")) : (a = a.replace(/'/g, "\\'").replace(/\\"/g, '"').replace(/(^"|"$)/g, "'"), a = e.stylize(a, "string"))
                    }
                    return a + ": " + s
                }

                function m(e, r, t) {
                    var n = 0,
                        i = e.reduce(function (e, r) {
                            return n++, r.indexOf("\n") >= 0 && n++, e + r.replace(/\u001b\[\d\d?m/g, "").length + 1
                        }, 0);
                    return i > 60 ? t[0] + ("" === r ? "" : r + "\n ") + " " + e.join(",\n  ") + " " + t[1] : t[0] + r + " " + e.join(", ") + " " + t[1]
                }

                function h(e) {
                    return Array.isArray(e)
                }

                function g(e) {
                    return "boolean" == typeof e
                }

                function d(e) {
                    return null === e
                }

                function y(e) {
                    return null == e
                }

                function w(e) {
                    return "number" == typeof e
                }

                function v(e) {
                    return "string" == typeof e
                }

                function x(e) {
                    return "symbol" == typeof e
                }

                function b(e) {
                    return void 0 === e
                }

                function E(e) {
                    return N(e) && "[object RegExp]" === O(e)
                }

                function N(e) {
                    return "object" == typeof e && null !== e
                }

                function M(e) {
                    return N(e) && "[object Date]" === O(e)
                }

                function A(e) {
                    return N(e) && ("[object Error]" === O(e) || e instanceof Error)
                }

                function S(e) {
                    return "function" == typeof e
                }

                function T(e) {
                    return null === e || "boolean" == typeof e || "number" == typeof e || "string" == typeof e || "symbol" == typeof e || "undefined" == typeof e
                }

                function O(e) {
                    return Object.prototype.toString.call(e)
                }

                function C(e) {
                    return 10 > e ? "0" + e.toString(10) : e.toString(10)
                }

                function B() {
                    var e = new Date,
                        r = [C(e.getHours()), C(e.getMinutes()), C(e.getSeconds())].join(":");
                    return [e.getDate(), q[e.getMonth()], r].join(" ")
                }

                function U(e, r) {
                    return Object.prototype.hasOwnProperty.call(e, r)
                }
                var _ = /%[sdj%]/g;
                r.format = function (e) {
                    if (!v(e)) {
                        for (var r = [], t = 0; t < arguments.length; t++) r.push(i(arguments[t]));
                        return r.join(" ")
                    }
                    for (var t = 1, n = arguments, o = n.length, a = String(e).replace(_, function (e) {
                        if ("%%" === e) return "%";
                        if (t >= o) return e;
                        switch (e) {
                        case "%s":
                            return String(n[t++]);
                        case "%d":
                            return Number(n[t++]);
                        case "%j":
                            try {
                                return JSON.stringify(n[t++])
                            } catch (r) {
                                return "[Circular]"
                            }
                        default:
                            return e
                        }
                    }), s = n[t]; o > t; s = n[++t]) a += d(s) || !N(s) ? " " + s : " " + i(s);
                    return a
                }, r.deprecate = function (t, i) {
                    function o() {
                        if (!a) {
                            if (n.throwDeprecation) throw new Error(i);
                            n.traceDeprecation ? console.trace(i) : console.error(i), a = !0
                        }
                        return t.apply(this, arguments)
                    }
                    if (b(e.process)) return function () {
                        return r.deprecate(t, i).apply(this, arguments)
                    };
                    if (n.noDeprecation === !0) return t;
                    var a = !1;
                    return o
                };
                var I, z = {};
                r.debuglog = function (e) {
                    if (b(I) && (I = n.env.NODE_DEBUG || ""), e = e.toUpperCase(), !z[e])
                        if (new RegExp("\\b" + e + "\\b", "i").test(I)) {
                            var t = n.pid;
                            z[e] = function () {
                                var n = r.format.apply(r, arguments);
                                console.error("%s %d: %s", e, t, n)
                            }
                        } else z[e] = function () {};
                    return z[e]
                }, r.inspect = i, i.colors = {
                    bold: [1, 22],
                    italic: [3, 23],
                    underline: [4, 24],
                    inverse: [7, 27],
                    white: [37, 39],
                    grey: [90, 39],
                    black: [30, 39],
                    blue: [34, 39],
                    cyan: [36, 39],
                    green: [32, 39],
                    magenta: [35, 39],
                    red: [31, 39],
                    yellow: [33, 39]
                }, i.styles = {
                    special: "cyan",
                    number: "yellow",
                    "boolean": "yellow",
                    undefined: "grey",
                    "null": "bold",
                    string: "green",
                    date: "magenta",
                    regexp: "red"
                }, r.isArray = h, r.isBoolean = g, r.isNull = d, r.isNullOrUndefined = y, r.isNumber = w, r.isString = v, r.isSymbol = x, r.isUndefined = b, r.isRegExp = E, r.isObject = N, r.isDate = M, r.isError = A, r.isFunction = S, r.isPrimitive = T, r.isBuffer = t(276);
                var q = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                r.log = function () {
                    console.log("%s - %s", B(), r.format.apply(r, arguments))
                }, r.inherits = t(278), r._extend = function (e, r) {
                    if (!r || !N(r)) return e;
                    for (var t = Object.keys(r), n = t.length; n--;) e[t[n]] = r[t[n]];
                    return e
                }
            }).call(r, function () {
                return this
            }(), t(277))
        },
        function (e) {
            e.exports = function (e) {
                return e && "object" == typeof e && "function" == typeof e.copy && "function" == typeof e.fill && "function" == typeof e.readUInt8
            }
        },
        function (e) {
            function r() {}
            var t = e.exports = {};
            t.nextTick = function () {
                var e = "undefined" != typeof window && window.setImmediate,
                    r = "undefined" != typeof window && window.postMessage && window.addEventListener;
                if (e) return function (e) {
                    return window.setImmediate(e)
                };
                if (r) {
                    var t = [];
                    return window.addEventListener("message", function (e) {
                            var r = e.source;
                            if ((r === window || null === r) && "process-tick" === e.data && (e.stopPropagation(), t.length > 0)) {
                                var n = t.shift();
                                n()
                            }
                        }, !0),
                        function (e) {
                            t.push(e), window.postMessage("process-tick", "*")
                        }
                }
                return function (e) {
                    setTimeout(e, 0)
                }
            }(), t.title = "browser", t.browser = !0, t.env = {}, t.argv = [], t.on = r, t.once = r, t.off = r, t.emit = r, t.binding = function () {
                throw new Error("process.binding is not supported")
            }, t.cwd = function () {
                return "/"
            }, t.chdir = function () {
                throw new Error("process.chdir is not supported")
            }
        },
        function (e) {
            e.exports = "function" == typeof Object.create ? function (e, r) {
                e.super_ = r, e.prototype = Object.create(r.prototype, {
                    constructor: {
                        value: e,
                        enumerable: !1,
                        writable: !0,
                        configurable: !0
                    }
                })
            } : function (e, r) {
                e.super_ = r;
                var t = function () {};
                t.prototype = r.prototype, e.prototype = new t, e.prototype.constructor = e
            }
        }])
});
//# sourceMappingURL=math.map