(function() {
  var maxDecimals, maxLength, truncate;

  this.Calculator = angular.module('Calculator', []);

  maxDecimals = 8;

  maxLength = 15;

  Calculator.controller('CalculatorCtrl', function($scope) {
    var errorTimeout, math;
    math = mathjs();
    errorTimeout = null;
    $scope.cursorPosition = 0;
    $scope.expression = '';
    $scope.insertChar = function(char) {
      return $scope.expression += char;
    };
    $scope.clear = function() {
      return $scope.expression = '';
    };
    return $scope.evaluate = function() {
      var exception;
      if (!$scope.expression) {
        return;
      }
      try {
        return $scope.expression = truncate(math["eval"]($scope.expression.replace('×', '*')).toString());
      } catch (_error) {
        exception = _error;
        $scope.error = true;
        clearTimeout(errorTimeout);
        return errorTimeout = setTimeout((function() {
          return $scope.$apply(function() {
            return $scope.error = false;
          });
        }), 1500);
      }
    };
  });

  truncate = function(expression) {
    var decimalSectionLength, onesSectionLength, parts;
    parts = expression.split('.');
    if (parts.length === 1) {
      return expression;
    }
    onesSectionLength = parts[0].length;
    decimalSectionLength = Math.min(maxDecimals, maxLength - onesSectionLength);
    if (decimalSectionLength < 1) {
      decimalSectionLength = 1;
    }
    return parts[0] + '.' + parts[1].slice(0, +decimalSectionLength + 1 || 9e9);
  };

}).call(this);
