$(function () {
    var decimalDot = false;

    // If user clicks any key in board
    $("#numbers button").click(function () {
		// Hide option menu 
		$("#settings-button").removeClass("active", 100);
		$("#settings-list").fadeOut(400);
		
		
        var box = $(this).clone().hide();
        var clickedText = box.text();
		
        var fieldValue = $("#display-input div").first().text();

        // if the key is C (Clear)
        if (clickedText == "C") {
            // Clear everything
            $("#display-input div").first().text("");
        }
		
        // if the key selected is the decimal point
        else if (clickedText == ".") {
            // We add a leading zero if the input field is empty or the decimal dot is preceeded by an operation sign
            if (((!fieldValue) || (isNaN(fieldValue.substr(-1, 1)))) &&  (fieldValue.substr(-1, 1) != ".")) {
                $("#display-input div").first().append("0.");
                decimalDot = true;
            }
			
            // Make sure that the decimal is added only once
            else if (decimalDot == false) {
                $("#display-input div").first().append($(this).text());
                decimalDot = true;
            }
        }
		
        // else just add numbers
        else {
            $("#display-input div").first().append($(this).text());
        }
    });

    $("#operations button").click(function () {
        // Add field text to field value var
        var fieldValue = $("#display-input div").first().text();
		
        // if fieldVlaue is not blank perform operation
        if (fieldValue) {
            $("#display-input div").proccessOperation($(this).text());
            // Set decimal point var back to false so user can add a decimal number again
            decimalDot = false;
        }
    });

    $("#equals").click(function () {
        // Create vars
        var fieldValue = $("#display-input div").first().text();
		
        // if fieldVlaue is not blank perform operation
        if (fieldValue) {
            var result = $("#display-input div").proccessOperation($(this).text());
			
            // if there is a decimal point in the result set decimalDot var back to true
            if (result.text().indexOf(".") != -1)
                decimalDot = true;
        }
    });
	
	$("#display-backspace").click(function () {
        // remove the last number and display the rest of the text
            var newValue = $("#display-input div").first().text().slice(0, -1);
            $("#display-input div").first().text(newValue);
		})
	});

$.fn.appendText = function (text) {
    //$("#display-input").append($(this).text());
};

$.fn.proccessOperation = function (text) {
    // return this.each(function () {
    var $this = $(this);
	
    // First we place the field value into a variable for later use
    var fieldValue = $(this).text();

    // Sometime we end up with negative result so we should delete the minus in order to perform the calculation correctly
    var firstFieldValue = $this.first().text().slice(0, 1);
    var negativeResult = false;

    if (firstFieldValue == "-") {
        // Set negative result to true so we can use that later when doing the calculations
        negativeResult = true;

        // remove the leading negative sign from the text to perofm regExp correctly
        fieldValue = $this.first().text().slice(1);
    }

    // Search the field value for any operation signs
    var operations = /[-|x|+|]/g;
    var matches = fieldValue.match(operations);

    // Store the last charcter in the field value to check it later
    var lastFieldValue = $this.first().text().slice(-1);

    // Are there any matches found?
    if (!matches) {
        // Make sure that equal sign does not get processes
        if (text != "=")
            $this.first().append(text);

    }
    // Matches are found but the last digit in the field is an operation sign. This means that user wants to change the operation
    // So we change the operation to the new one
    else if ((matches) && (isNaN(lastFieldValue))) {
        // Remove the operation sign and add a new one. Also do not do that for equlas sign
        if (text != "=") {
            var newOperationSign = $this.first().text().slice(0, -1);
            $this.first().text(newOperationSign).append(text);
        }
    } else {
        // Split fieldVlaue based on the operation so we have two numbers to perfom calculations on
        var array = fieldValue.split(matches);

        // perform the calculation
        var calculationResult = calculate(array, matches, negativeResult);

        // Display result and add the pressed operation if it was not equals button
        if (text != "=")
            $this.last().append(calculationResult + text);
        else
            $this.last().append(calculationResult);

        // Animate removal of first div
        $this.first().animate({
            top: '-35px',
        }, "fast", function () {
            // remove this element since it is not needed any more
            $(this).remove();
        });

        // Animate removal of last div
        $this.last().animate({
            top: '-30px',
        }, "fast", function () {
            // Set element top margin to zero to stop change after the deletion of the first element
            $(this).css('top', '0px');

            // Create a new div element and append it
            $this.after("<div></div>");
        });
    }
    //});

    return $this;
};

/*
	perform calcuations
*/
function calculate(numbersArray, operation, negativeResult) {
    var result;
    var firstNumber = parseFloat(numbersArray[0], 10);
    var secondNumber = parseFloat(numbersArray[1], 10);

    // Is the first number negative? then add a negative sign
    if (negativeResult)
        firstNumber = (-firstNumber);

    // Get the last matched operation. Some numbers might have two operation signs due to haveing a negative value as a result of calucation
    //var operation = matches.pop();

    if (operation == "+")
        result = firstNumber + secondNumber;
    else if (operation == "-")
        result = firstNumber - secondNumber;
    else if (operation == "x")
        result = firstNumber * secondNumber;
    else if (operation == "")
        result = firstNumber / secondNumber;

    // Round to 2 decimal numbers
    return Math.round(result * 100) / 100;
}