$(function () {

    // Set array for default options
    var defaultOptionsArray = new Array();
    defaultOptionsArray['theme-option'] = "blue";
    defaultOptionsArray['font-option'] = "sans-serif";

    // Change theme
    $('#main-theme').attr('href', 'css/' + getOption('theme-option') + '.css');
	
     // Change font
    $('#display-input, #board button').css('font-family', getOption('font-option'));
    
	
    // Handle settings button click on main page
    $("#settings-button").click(function () {
        if ($(this).hasClass("active")) {
            $(this).removeClass("active", 100);
            $("#settings-list").fadeOut(400)
        } else {
            $(this).addClass("active", 100);
            $("#settings-list").fadeIn(400);
        }
    });
	
    // Select an option
    $("#settings-list li").click(function () {
        $(this).parent().fadeOut(400);
        var themeBox = $(this).attr("class");
		$("#" + themeBox).show("slide", { direction: "down" }, 400);
        $("#settings-button").removeClass("active", 100);
		
		// Set selected theme
		$('#tick').clone().appendTo("#" + getOption('theme-option')).removeAttr('id').show();
		
		// Set selected font
		$('#tick').clone().appendTo("#" + getOption('font-option')).removeAttr('id').show();
    });

    /* Pressing Cancel button */
    $(".cancel-button").click(function () {
		$(this).parents('.single-option-dialog').hide("slide", { direction: "down" }, 400);
    });

    // Handle choosing theme
    $("#change-theme-form .option-wrapper div").click(function () {
		// Display and process tick
        $(this).tickOption('theme-option');

        // Change theme
        $('#main-theme').attr('href', 'css/' + $(this).attr('id') + '.css');
    });

	// Handle choosing theme
    $("#change-font-form .option-wrapper div").click(function () {
		// Display tick
        $(this).tickOption('font-option');

        // Change font
        $('#display-input, #board button').css('font-family', getOption('font-option'));
    });
	
	
    // Show & hide tick for multiple options
    $.fn.tickOption = function (optionName) {
		// Store the selected option
        storeOption(optionName, $(this).attr('id'));
		
        // Fade out and remove
        $(this).siblings().find(".tick").fadeOut(200, function () {
            $(this).remove();
        });
		
        // check if tick div is not cloned yet
        if ($(this).find('.tick').length == 0)
            $('#tick').clone().appendTo(this).removeAttr('id').fadeIn(200);
			
		// Slide out theme options window
       $(this).parents('.single-option-dialog').hide("slide", { direction: "down" }, 400);
    };
	
	function storeOption(key, value) {
    return localStorage.setItem(key, value);
};

function removeOption(key) {
    return localStorage.removeItem(key, value);
};

function getOption(key) {
	var preference = (localStorage.getItem(key) ? localStorage.getItem(key) : defaultOptionsArray[key]);
    return preference;
};
});

