//Some Variables
var mois = new Array('Janvier', 'F&eacute;vrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Ao&ucirc;t', 'Septembre', 'Octobre', 'Novembre', 'D&eacute;cembre');
var jours = new Array('Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi');

$(window).load(function() {
  date();
  actualiser(1);
  $(".loader").fadeOut("20000");
  reload(3600);
});

function reload(s){
  setTimeout(function(){
    window.location.reload();
  }, s * 1000);
}

function getEventKey(evt, key){
  for(var i = 0; i < evt[0].length; i++){
   if(evt[1][i][0] == key){
    return evt[1][i][3];
   }
  }
}

function actualiser(week){
  var myRequest = new XMLHttpRequest({mozSystem: true});
  myRequest.open("GET", "http://adeweb.univ-reunion.fr/jsp/custom/modules/plannings/anonymous_cal.jsp?resources=4775,4776,4777,4773,4774&projectId=4&calType=ical&nbWeeks=" + week, true);
  myRequest.onload = function(){
    if(myRequest.readyState == 4){
      if(myRequest.status == 200 || myRequest.status == 0){
        datas = myRequest.responseText;
        parsage(datas);
      }
    }
  };
  myRequest.send(null); 
}

function parsage(datas){
  datas = (ICAL.parse(datas));
  show(datas);
}

function insert_element(description, location, summary, dtstart, dtend){
  calendar = document.getElementById("calendar");  
  div = document.createElement("div");
 
  if(getDate(dtend) >= getNow()){
    div.innerHTML = not_null(format_descr(description)) + "</br><strong>" + not_null(summary) + "</strong></br>" + not_null(format_time(dtstart)) + " - " + not_null(getHour(dtend)) + ":00</br>" + not_null(location);  
    div.className = "jumbotron";
    if((getDate(dtstart) <= getNow()) && (getDate(dtend) >= getNow())){
      div.style.backgroundColor="#2ecc71";
      div.style.border='2px solid #27ae60';
  }
  calendar.appendChild(div);
  }
}

function getNow(){
  var now = new Date();
  return now;
}

function getHour(time){
  var hour = new Date(time);
  return hour.getHours();
}

function getDate(time){
  var date = new Date(time);
  return date;
}

function show(datas){
  datas[2].sort(function(x, y) {
    if(x[1][2] > y[1][2]) return(1);
    if(x[1][2] < y[1][2]) return(-1);
    return(0);
  });
  for(var i = 0; i < datas[2].length; i++){
    var evt = datas[2][i];
    insert_element(getEventKey(evt, "description"), getEventKey(evt, "location"), getEventKey(evt, "summary"), getEventKey(evt, "dtstart"), getEventKey(evt, "dtend"));
  }
}

function format_descr(descr){
  RegDescr = / ?\(Exported.*$/;
  Descr = descr.replace(RegDescr, "");
  return Descr;
}

function format_time(time){
  var dateI = new Date(ICAL.design.value['date-time'].undecorate(time));
  var date = dateI.getDate() + " " + mois[dateI.getMonth()] + " " + dateI.getFullYear() + " &mdash; " + dateI.getHours() + ":" + (dateI.getMinutes() == 0 ? dateI.getMinutes() + "0" : dateI.getMinutes());
  return date;
}

function not_null(value){
  if(value == null || value == undefined){
    return "";
  }else{
    return value;
  }
}

function date(){
  date = new Date;
  resultat = jours[date.getDay()] + " " + date.getDate() + " " + mois[date.getMonth()] + " " + date.getFullYear();
  time = document.getElementById("time");  
  div = document.createElement("div");
  div.innerHTML = "<strong>" + resultat + "</strong>";  
  div.className = "";
  time.appendChild(div);
}


