angular.module('calorieTables.controllers', [])

    .directive('ads', function() {
        return {
            restrict: 'A',
            templateUrl: 'templates/ads.html',
            controller: function() {
                (adsbygoogle = window.adsbygoogle || []).push({});
            }
        };
    })

    .controller('HomeCtrl', function ($scope, Category) {
        $scope.category = Category.all();

    })

    .controller('CategoryCtrl', function ($scope, $ionicScrollDelegate, filterFilter, CaloriesList, $stateParams, Category, $ionicPopup) {

        var list = CaloriesList.getCaloriesByCategory($stateParams.categoryId);
        $scope.categoryName = Category.get($stateParams.categoryId).name;

        $scope.calories = list.sort(function (a, b) {
            return a.name > b.name ? 1 : -1;
        });

        $scope.scrollBottom = function () {
            $ionicScrollDelegate.scrollBottom(true);
        };

        $scope.getCalories = function () {
            return list.filter(function (item) {
                var itemDoesMatch = !$scope.search ||
                    item.name.toLowerCase().indexOf($scope.search.toLowerCase()) > -1;
                return itemDoesMatch;
            })
        };

        $scope.clearSearch = function () {
            $scope.data.searchQuery = '';
        };

        // An alert dialog
        $scope.showAlert = function (obj) {
            var alertPopup = $ionicPopup.alert({
                title:obj.name,
                template:'<div class="popup-diteils">' +
                    '<div class="row"><div class="col">Quantity</div><div class="col text-right"><span class="badge badge-calm">' + obj.quantity + '</span></div></div>' +
                    '<div class="row"><div class="col">Energy</div><div class="col text-right"><span class="badge badge-calm">' + obj.energy + ' Kcal</span></div></div>' +
                    '<div class="row"><div class="col">Protein</div><div class="col text-right"><span class="badge badge-calm">' + obj.protein + '</span></div></div>' +
                    '<div class="row"><div class="col">Fat</div><div class="col text-right"><span class="badge badge-calm">' + obj.fat + '</span></div></div>' +
                    '<div class="row"><div class="col">Sugar</div><div class="col text-right"><span class="badge badge-calm">' + obj.sugar + '</span></div></div>' +
                    '</div>'
            });
        };
    });