angular.module('calorieTables.services', [])
/**
 *  service that returns list of categories.
 */
.factory('Category', function() {
  // Might use a resource here that returns a JSON array
        var category = [
            { id:0, name:'Bread and cereals', count:99},
            { id:1, name:'Sweets and desserts', count:89},
            { id:2, name:'Fruits', count:100},
            { id:3, name:'Vegetables', count:71},
            { id:4, name:'Dairy products', count:84},
            { id:5, name:'Poultry', count:27},
            { id:6, name:'Meats', count:123},
            { id:7, name:'Fish and seafood', count:160},
            { id:8, name:'Soups', count:48},
            { id:9, name:'Floury dishes', count:18},
            { id:10, name:'Eggs', count:11},
            { id:11, name:'Mushrooms', count:12},
            { id:12, name:'Snacks and fats', count:27},
            { id:13, name:'Alcohol', count:26},
            { id:14, name:'Beverages', count:51},
            { id:15, name:'Dips and sauces', count:35}
        ];

  return {
      all: function() {
          return category;
      },
      get: function(categoryId) {
          // Simple index lookup
          return category[categoryId];
      }
  }
})

.factory('CaloriesList', function() {
    var caloriesList = {
        0 : [
            {name:'A cake with jam',quantity:'100 g',energy:284,protein:'5,3',fat:61,sugar:'2,1',categoryId:1},
            {name:'Baguette',quantity:'100 g',energy:282,protein:'7,9',fat:'1,7',sugar:'60,1',categoryId:1},
            {name:'Barley flakes',quantity:'100 g',energy:355,protein:'9,8',fat:'3,6',sugar:'79,4',categoryId:1},
            {name:'Bran',quantity:'100 g',energy:185,protein:16,fat:'4,6',sugar:'61,9',categoryId:1},
            {name:'Broad bean',quantity:'100 g',energy:66,protein:'7,1',fat:'0,4',sugar:14,categoryId:1},
            {name:'Brown basmati rice',quantity:'100 g',energy:331,protein:'6,3',fat:'4,4',sugar:'65,1',categoryId:1},
            {name:'Buckwheat cooked in water',quantity:'100 g',energy:90,protein:'3,2',fat:'0,8',sugar:'17,1',categoryId:1},
            {name:'Buckwheat cooked, loose',quantity:'100 g',energy:101,protein:3,fat:'3,4',sugar:'14,6',categoryId:1},
            {name:'Buckwheat flour',quantity:'100 g',energy:367,protein:'13,6',fat:'1,2',sugar:'73,7',categoryId:1},
            {name:'Buckwheat instant – cooked',quantity:'100 g',energy:132,protein:'4,5',fat:'2,3',sugar:25,categoryId:1},
            {name:'Buckwheat porridge',quantity:'100 g',energy:336,protein:'12,6',fat:'3,1',sugar:'69,3',categoryId:1},
            {name:'Buns',quantity:'100 g',energy:299,protein:8,fat:'5,3',sugar:'53,7',categoryId:1},
            {name:'Cake flour',quantity:'100 g',energy:334,protein:'10,3',fat:'1,1',sugar:'68,9',categoryId:1},
            {name:'Cheese buns',quantity:'100 g',energy:318,protein:'10,6',fat:'12,3',sugar:'40,1',categoryId:1},
            {name:'Chick-peas dry pulse',quantity:'100 g',energy:309,protein:'20,1',fat:'4,3',sugar:'46,4',categoryId:1},
            {name:'Cooked beans',quantity:'100 g',energy:123,protein:'7,8',fat:'0,5',sugar:'21,5',categoryId:1},
            {name:'Cooked millet, loose',quantity:'100 g',energy:135,protein:'4,7',fat:'1,1',sugar:'26,1',categoryId:1},
            {name:'Cooked pearl barley',quantity:'100 g',energy:106,protein:'3,1',fat:'0,4',sugar:23,categoryId:1},
            {name:'Cooked peas',quantity:'100 g',energy:60,protein:6,fat:0,sugar:9,categoryId:1},
            {name:'Cooked wheat barley',quantity:'100 g',energy:108,protein:'3,4',fat:'0,4',sugar:'22,1',categoryId:1},
            {name:'Corn flakes',quantity:'100 g',energy:363,protein:'6,9',fat:'2,5',sugar:'83,6',categoryId:1},
            {name:'Cornflour',quantity:'100 g',energy:330,protein:'7,2',fat:'1,5',sugar:'70,2',categoryId:1},
            {name:'Couscous',quantity:'100 g',energy:358,protein:13,fat:2,sugar:72,categoryId:1},
            {name:'Defatted soy flour',quantity:'100 g',energy:291,protein:'48,9',fat:1,sugar:'21,7',categoryId:1},
            {name:'Doughnuts',quantity:'100 g',energy:296,protein:'5,6',fat:13,sugar:'38,8',categoryId:1},
            {name:'Dry soya beans',quantity:'100 g',energy:382,protein:'34,3',fat:'19,6',sugar:'32,7',categoryId:1},
            {name:'Egg pasta',quantity:'100 g',energy:345,protein:'11,3',fat:'2,1',sugar:68,categoryId:1},
            {name:'Fine-ground barley',quantity:'100 g',energy:324,protein:10,fat:'1,3',sugar:'66,3',categoryId:1},
            {name:'Fine-ground barley – cooked',quantity:'100 g',energy:334,protein:'8,4',fat:2,sugar:'74,9',categoryId:1},
            {name:'Full-fat soy flour',quantity:'100 g',energy:385,protein:'36,5',fat:'18,6',sugar:'17,9',categoryId:1},
            {name:'Green beans dry',quantity:'100 g',energy:24,protein:2,fat:'0,2',sugar:'3,6',categoryId:1},
            {name:'Grits',quantity:'100 g',energy:328,protein:'10,3',fat:1,sugar:'67,7',categoryId:1},
            {name:'Grits cooked in milk',quantity:'100 g',energy:98,protein:3,fat:'3,2',sugar:'15,3',categoryId:1},
            {name:'Grits cooked in water',quantity:'100 g',energy:80,protein:'2,5',fat:'0,2',sugar:'16,8',categoryId:1},
            {name:'Hercules oat flakes',quantity:'100 g',energy:305,protein:11,fat:'6,2',sugar:'50,1',categoryId:1},
            {name:'Homemade pasta',quantity:'100 g',energy:322,protein:12,fat:'3,7',sugar:'60,1',categoryId:1},
            {name:'Jam buns',quantity:'100 g',energy:293,protein:'6,5',fat:'4,2',sugar:'57,1',categoryId:1},
            {name:'Lentil sprouts',quantity:'100 g',energy:119,protein:9,fat:'0,6',sugar:'22,1',categoryId:1},
            {name:'Lentils dry',quantity:'100 g',energy:111,protein:'7,8',fat:0,sugar:'20,1',categoryId:1},
            {name:'Loose rice',quantity:'100 g',energy:113,protein:'2,4',fat:'0,2',sugar:'24,9',categoryId:1},
            {name:'Low-fat soy flour',quantity:'100 g',energy:334,protein:43,fat:'9,5',sugar:'19,1',categoryId:1},
            {name:'Macaroni 1 st Class',quantity:'100 g',energy:335,protein:'10,7',fat:'1,3',sugar:'68,4',categoryId:1},
            {name:'Meat-based risotto',quantity:'100 g',energy:229,protein:'7,4',fat:'11,8',sugar:'24,2',categoryId:1},
            {name:'Medium grain rice',quantity:'100 g',energy:330,protein:7,fat:1,sugar:'71,4',categoryId:1},
            {name:'Millet balls',quantity:'100 g',energy:170,protein:'6,9',fat:'5,9',sugar:'22,2',categoryId:1},
            {name:'Millet cooked in water',quantity:'100 g',energy:90,protein:3,fat:'0,7',sugar:17,categoryId:1},
            {name:'Millet porridge',quantity:'100 g',energy:346,protein:'10,5',fat:'2,9',sugar:'71,6',categoryId:1},
            {name:'Muesli with dry fruits',quantity:'100 g',energy:325,protein:'8,4',fat:'3,4',sugar:'72,2',categoryId:1},
            {name:'Muesli with nuts and raisins',quantity:'100 g',energy:375,protein:'11,5',fat:'12,7',sugar:'62,9',categoryId:1},
            {name:'Oat flour',quantity:'100 g',energy:369,protein:13,fat:'6,8',sugar:'64,9',categoryId:1},
            {name:'Oat porridge',quantity:'100 g',energy:303,protein:11,fat:'6,1',sugar:'49,7',categoryId:1},
            {name:'Oat porridge cooked in milk',quantity:'100 g',energy:102,protein:'3,2',fat:'4,1',sugar:'14,2',categoryId:1},
            {name:'Oat porridge cooked in water',quantity:'100 g',energy:88,protein:3,fat:'1,7',sugar:15,categoryId:1},
            {name:'Oat porridge milk',quantity:'100 g',energy:105,protein:'3,2',fat:'4,3',sugar:'14,2',categoryId:1},
            {name:'Oat porridge on the water',quantity:'100 g',energy:84,protein:'2,9',fat:'1,4',sugar:'14,8',categoryId:1},
            {name:'Panicum',quantity:'100 g',energy:348,protein:'11,5',fat:'3,3',sugar:'66,5',categoryId:1},
            {name:'Pasta and eggs casserole',quantity:'100 g',energy:152,protein:'4,6',fat:'8,3',sugar:'14,8',categoryId:1},
            {name:'Pasta higher grades',quantity:'100 g',energy:337,protein:'10,4',fat:'1,1',sugar:'69,7',categoryId:1},
            {name:'Pasta with oil',quantity:'100 g',energy:135,protein:'3,4',fat:5,sugar:19,categoryId:1},
            {name:'Pearl balls with cream cheese',quantity:'100 g',energy:166,protein:'7,9',fat:'6,4',sugar:'18,9',categoryId:1},
            {name:'Pearl barley',quantity:'100 g',energy:320,protein:'9,3',fat:'1,1',sugar:'66,5',categoryId:1},
            {name:'Peas, dry pulse',quantity:'100 g',energy:298,protein:'20,5',fat:2,sugar:'48,6',categoryId:1},
            {name:'Peas, seeds',quantity:'100 g',energy:298,protein:'20,5',fat:2,sugar:'49,5',categoryId:1},
            {name:'Plaited white bread',quantity:'100 g',energy:333,protein:7,fat:7,sugar:'61,6',categoryId:1},
            {name:'Poppy-seed buns',quantity:'100 g',energy:304,protein:'7,5',fat:'5,2',sugar:'55,5',categoryId:1},
            {name:'Porridge barley crumbly',quantity:'100 g',energy:108,protein:'3,4',fat:'0,4',sugar:'22,1',categoryId:1},
            {name:'Porridge barley viscous water',quantity:'100 g',energy:76,protein:'2,3',fat:'0,3',sugar:'15,7',categoryId:1},
            {name:'Red beans dry',quantity:'100 g',energy:93,protein:'8,4',fat:'0,3',sugar:'13,7',categoryId:1},
            {name:'Red lentil, dry seeds',quantity:'100 g',energy:284,protein:24,fat:'1,5',sugar:'42,7',categoryId:1},
            {name:'Regular bread',quantity:'100 g',energy:245,protein:'5,4',fat:'1,3',sugar:57,categoryId:1},
            {name:'Rice Casserole',quantity:'100 g',energy:144,protein:4,fat:'5,6',sugar:'19,4',categoryId:1},
            {name:'Rice casserole with cheese',quantity:'100 g',energy:189,protein:'5,1',fat:'7,1',sugar:'26,1',categoryId:1},
            {name:'Rice dessert',quantity:'100 g',energy:133,protein:3,fat:'2,9',sugar:'23,5',categoryId:1},
            {name:'Rice flour',quantity:'100 g',energy:371,protein:'7,4',fat:'0,6',sugar:82,categoryId:1},
            {name:'Rice porridge cooked in milk',quantity:'100 g',energy:97,protein:'2,5',fat:16,sugar:'3,1',categoryId:1},
            {name:'Rice porridge cooked in water',quantity:'100 g',energy:78,protein:'1,5',fat:'0,1',sugar:'17,4',categoryId:1},
            {name:'Rice pudding',quantity:'100 g',energy:202,protein:'5,6',fat:'5,7',sugar:32,categoryId:1},
            {name:'Risotto with meat and vegetables',quantity:'100 g',energy:185,protein:'6,6',fat:10,sugar:'18,3',categoryId:1},
            {name:'Rolls',quantity:'100 g',energy:235,protein:8,fat:'0,9',sugar:'48,9',categoryId:1},
            {name:'Rye bread',quantity:'100 g',energy:223,protein:'5,6',fat:'1,7',sugar:'51,5',categoryId:1},
            {name:'Rye flakes',quantity:'100 g',energy:343,protein:'6,4',fat:'3,2',sugar:'82,6',categoryId:1},
            {name:'Rye flour Hanging',quantity:'100 g',energy:293,protein:'10,7',fat:'1,9',sugar:'56,8',categoryId:1},
            {name:'Soya beans',quantity:'100 g',energy:381,protein:2,fat:'0,1',sugar:1,categoryId:1},
            {name:'Soya sprouts',quantity:'100 g',energy:141,protein:'13,1',fat:'6,7',sugar:'9,6',categoryId:1},
            {name:'Spaghetti Bolognese',quantity:'100 g',energy:560,protein:0,fat:18,sugar:0,categoryId:1},
            {name:'Split peas',quantity:'100 g',energy:299,protein:23,fat:'1,6',sugar:'48,1',categoryId:1},
            {name:'Toast',quantity:'100 g',energy:305,protein:'8,1',fat:'4,7',sugar:'58,8',categoryId:1},
            {name:'Ukrainin galushki',quantity:'100 g',energy:106,protein:'3,9',fat:1,sugar:'20,3',categoryId:1},
            {name:'Veggie burgers',quantity:'100 g',energy:141,protein:3,fat:'5,3',sugar:'20,2',categoryId:1},
            {name:'Wheat barley cooked in water',quantity:'100 g',energy:92,protein:'3,2',fat:'0,3',sugar:'18,7',categoryId:1},
            {name:'Wheat bread',quantity:'100 g',energy:249,protein:'6,8',fat:'1,4',sugar:56,categoryId:1},
            {name:'Wheat flakes',quantity:'100 g',energy:351,protein:9,fat:3,sugar:81,categoryId:1},
            {name:'Wheat flower',quantity:'100 g',energy:342,protein:'9,2',fat:'1,2',sugar:'74,9',categoryId:1},
            {name:'Wheat flower 1st class',quantity:'100 g',energy:331,protein:'10,6',fat:'1,3',sugar:'67,6',categoryId:1},
            {name:'Wheat flower 2nd class',quantity:'100 g',energy:324,protein:'11,7',fat:'1,8',sugar:'63,7',categoryId:1},
            {name:'Wheat rolls',quantity:'100 g',energy:272,protein:'7,3',fat:'1,5',sugar:'58,5',categoryId:1},
            {name:'White kidney beans dry',quantity:'100 g',energy:102,protein:7,fat:'0,5',sugar:'16,9',categoryId:1},
            {name:'White rice',quantity:'100 g',energy:344,protein:'6,7',fat:'0,7',sugar:'78,9',categoryId:1},
            {name:'Whole-grain bread',quantity:'100 g',energy:228,protein:'8,6',fat:'1,4',sugar:'43,9',categoryId:1}
        ],

        1 : [
            {name:'Almond cakes',quantity:'100 g',energy:421,protein:'8,5',fat:'1,6',sugar:'65,5',categoryId:2},
            {name:'Almond gateau',quantity:'100 g',energy:535,protein:'6,6',fat:'35,8',sugar:'46,8',categoryId:2},
            {name:'Apple jelly',quantity:'100 ml',energy:97,protein:'0,1',fat:'0,1',sugar:'23,7',categoryId:2},
            {name:'Apple mousse',quantity:'100 g',energy:127,protein:'2,2',fat:'0,5',sugar:'28,7',categoryId:2},
            {name:'Apple pie',quantity:'100 g',energy:186,protein:'3,5',fat:6,sugar:30,categoryId:2},
            {name:'Apricot jelly',quantity:'100 ml',energy:54,protein:'0,4',fat:0,sugar:'12,9',categoryId:2},
            {name:'Basic short cake',quantity:'100 g',energy:429,protein:'5,2',fat:'23,8',sugar:'49,9',categoryId:2},
            {name:'Caramel and chocolate cream sweets',quantity:'100 g',energy:366,protein:0,fat:'0,1',sugar:'94,7',categoryId:2},
            {name:'Caramel and fruit sweets',quantity:'100 g',energy:357,protein:'0,1',fat:'0,1',sugar:'92,1',categoryId:2},
            {name:'Caramel and liqueor sweets',quantity:'100 g',energy:358,protein:0,fat:'0,1',sugar:'92,6',categoryId:2},
            {name:'Caramel and milk sweets',quantity:'100 g',energy:363,protein:'0,8',fat:1,sugar:'91,2',categoryId:2},
            {name:'Caramel and peanut sweets',quantity:'100 g',energy:410,protein:'3,1',fat:'7,3',sugar:'86,6',categoryId:2},
            {name:'Caramel sweets',quantity:'100 g',energy:370,protein:0,fat:'0,1',sugar:'95,7',categoryId:2},
            {name:'Caramel with chocolate-peanut filling sweets',quantity:'100 g',energy:420,protein:'1,8',fat:'9,2',sugar:'86,1',categoryId:2},
            {name:'Cheesecake with raisins',quantity:'100 g',energy:333,protein:'13,9',fat:'13,4',sugar:'39,7',categoryId:2},
            {name:'Cherry jelly',quantity:'100 ml',energy:78,protein:'0,2',fat:0,sugar:'18,9',categoryId:2},
            {name:'Chocolate bars',quantity:'100 g',energy:451,protein:'3,6',fat:'18,2',sugar:'68,9',categoryId:2},
            {name:'Chocolate cream gateau',quantity:'100 g',energy:335,protein:'4,4',fat:'12,4',sugar:'53,6',categoryId:2},
            {name:'Chocolate cream sweets',quantity:'100 g',energy:369,protein:'2,2',fat:'4,6',sugar:'83,6',categoryId:2},
            {name:'Chocolate ice cream',quantity:'100 g',energy:236,protein:'3,6',fat:15,sugar:'22,3',categoryId:2},
            {name:'Chocolate sweets with chocolate cream filling',quantity:'100 g',energy:401,protein:'2,9',fat:'10,7',sugar:'76,6',categoryId:2},
            {name:'Chocolate sweets with cream filling',quantity:'100 g',energy:523,protein:'7,5',fat:'31,8',sugar:'53,6',categoryId:2},
            {name:'Chocolate sweets with filling and wafers',quantity:'100 g',energy:535,protein:'5,8',fat:32,sugar:'57,9',categoryId:2},
            {name:'Chocolate sweets with fruit filling',quantity:'100 g',energy:369,protein:'1,6',fat:'8,6',sugar:'74,3',categoryId:2},
            {name:'Chocolate sweets with grillage',quantity:'100 g',energy:510,protein:'5,3',fat:'26,9',sugar:'64,4',categoryId:2},
            {name:'Chocolate wafers',quantity:'100 g',energy:550,protein:'8,5',fat:'34,5',sugar:'51,5',categoryId:2},
            {name:'Cookies with cream',quantity:'100 g',energy:436,protein:'7,5',fat:'11,8',sugar:'74,4',categoryId:2},
            {name:'Cranberry jelly',quantity:'100 ml',energy:53,protein:0,fat:0,sugar:13,categoryId:2},
            {name:'Cream gateau',quantity:'100 g',energy:391,protein:'5,6',fat:20,sugar:'58,8',categoryId:2},
            {name:'Cream ice-cream',quantity:'100 g',energy:179,protein:'3,3',fat:10,sugar:'19,8',categoryId:2},
            {name:'Cream ice-cream chocolate flavour',quantity:'100 g',energy:188,protein:'3,5',fat:10,sugar:'21,5',categoryId:2},
            {name:'Cream ice-cream toffee flavour',quantity:'100 g',energy:186,protein:'3,5',fat:10,sugar:'21,6',categoryId:2},
            {name:'Cream ice-cream with chocolate sauce',quantity:'100 g',energy:271,protein:'3,2',fat:20,sugar:'19,4',categoryId:2},
            {name:'Cream ice-cream with fruit',quantity:'100 g',energy:166,protein:'3,2',fat:8,sugar:'20,1',categoryId:2},
            {name:'Cream toffee',quantity:'100 g',energy:400,protein:'3,6',fat:'7,3',sugar:'83,5',categoryId:2},
            {name:'Cream-filled chocolate',quantity:'100 g',energy:450,protein:'3,9',fat:'17,6',sugar:'68,8',categoryId:2},
            {name:'Dark chocolate',quantity:'100 g',energy:531,protein:'5,3',fat:'28,9',sugar:64,categoryId:2},
            {name:'Dark chocolate',quantity:'100 g',energy:549,protein:'5,4',fat:'35,3',sugar:'52,6',categoryId:2},
            {name:'Dried apple jelly',quantity:'100 ml',energy:66,protein:'0,1',fat:0,sugar:'16,3',categoryId:2},
            {name:'Eclair (cream cake)',quantity:'100 g',energy:329,protein:'5,9',fat:'10,2',sugar:'55,2',categoryId:2},
            {name:'Eskimo ice cream',quantity:'100 g',energy:270,protein:'3,5',fat:20,sugar:'19,6',categoryId:2},
            {name:'French cakes with cream',quantity:'100 g',energy:555,protein:'5,4',fat:'38,6',sugar:'46,4',categoryId:2},
            {name:'French cakes with fruit',quantity:'100 g',energy:466,protein:'5,7',fat:'25,6',sugar:'52,7',categoryId:2},
            {name:'Frozen caramel creamer',quantity:'100 g',energy:235,protein:3,fat:15,sugar:23,categoryId:2},
            {name:'Frozen creamer',quantity:'100 g',energy:227,protein:'3,2',fat:15,sugar:'20,8',categoryId:2},
            {name:'Fruit and chocolate cream sweets',quantity:'100 g',energy:346,protein:0,fat:0,sugar:'90,6',categoryId:2},
            {name:'Fruit drops in chocolate',quantity:'100 g',energy:389,protein:'5,7',fat:'10,2',sugar:'73,1',categoryId:2},
            {name:'Fruit gateau',quantity:'100 g',energy:391,protein:'5,6',fat:20,sugar:'58,8',categoryId:2},
            {name:'Fruit jelly',quantity:'100 g',energy:293,protein:'0,4',fat:0,sugar:76,categoryId:2},
            {name:'Ginger bread cakes',quantity:'100 g',energy:366,protein:'5,9',fat:'4,7',sugar:75,categoryId:2},
            {name:'Ice cream with chocolate',quantity:'100 g',energy:310,protein:'3,2',fat:24,sugar:'20,1',categoryId:2},
            {name:'Ice cream with fruit',quantity:'100 g',energy:206,protein:'3,2',fat:12,sugar:'21,1',categoryId:2},
            {name:'Leavened cake',quantity:'100 g',energy:290,protein:'7,4',fat:'8,2',sugar:'47,7',categoryId:2},
            {name:'Meringues',quantity:'100 g',energy:304,protein:'0,8',fat:0,sugar:'78,3',categoryId:2},
            {name:'Milk chocolate',quantity:'100 g',energy:549,protein:'9,8',fat:'32,8',sugar:'54,7',categoryId:2},
            {name:'Milk chocolate foam',quantity:'100 g',energy:549,protein:'6,9',fat:'35,5',sugar:'52,3',categoryId:2},
            {name:'Milk chocolate with hazelnuts',quantity:'100 g',energy:539,protein:'8,6',fat:'30,9',sugar:'57,3',categoryId:2},
            {name:'Milky ice- cream chocolate flavour',quantity:'100 g',energy:138,protein:'4,2',fat:'3,5',sugar:23,categoryId:2},
            {name:'Milky ice-cream',quantity:'100 g',energy:126,protein:'3,2',fat:'3,5',sugar:'21,3',categoryId:2},
            {name:'Milky ice-cream toffee',quantity:'100 g',energy:134,protein:'3,5',fat:'3,5',sugar:'23,1',categoryId:2},
            {name:'Milky ice-cream with chocolate sauce',quantity:'100 g',energy:231,protein:'3,2',fat:15,sugar:'20,6',categoryId:2},
            {name:'Milky ice-cream with fruit',quantity:'100 g',energy:124,protein:'3,2',fat:'2,8',sugar:'21,2',categoryId:2},
            {name:'Milky sweets',quantity:'100 g',energy:364,protein:'2,7',fat:'4,3',sugar:'82,3',categoryId:2},
            {name:'Pastries kroshkovoe',quantity:'100 g',energy:438,protein:'6,1',fat:'23,8',sugar:'51,4',categoryId:2},
            {name:'Peanut drops',quantity:'100 g',energy:552,protein:'11,9',fat:'38,3',sugar:41,categoryId:2},
            {name:'Pears in vanilla sauce',quantity:'100 g',energy:151,protein:'1,6',fat:'1,1',sugar:'34,8',categoryId:2},
            {name:'Plum jelly',quantity:'100 ml',energy:63,protein:'0,1',fat:0,sugar:'15,5',categoryId:2},
            {name:'Powdered chocolate',quantity:'100 g',energy:487,protein:'5,2',fat:'24,3',sugar:64,categoryId:2},
            {name:'Prunes with cream',quantity:'100 g',energy:281,protein:'2,3',fat:'12,6',sugar:38,categoryId:2},
            {name:'Puff pastry gateau',quantity:'100 g',energy:533,protein:5,fat:'37,4',sugar:44,categoryId:2},
            {name:'Regular chocolate',quantity:'100 g',energy:544,protein:'5,4',fat:'35,3',sugar:'52,6',categoryId:2},
            {name:'Scones with fruit',quantity:'100 g',energy:435,protein:'5,1',fat:'18,5',sugar:'62,6',categoryId:2},
            {name:'Soy bar',quantity:'100 g',energy:527,protein:'3,3',fat:'30,5',sugar:'62,5',categoryId:2},
            {name:'Sponge cake',quantity:'100 g',energy:344,protein:'4,7',fat:'0,9',sugar:'64,2',categoryId:2},
            {name:'Sponge cake with fruit',quantity:'100 g',energy:355,protein:'4,7',fat:'9,3',sugar:'64,2',categoryId:2},
            {name:'Strawberries in jelly',quantity:'100 g',energy:126,protein:'15,4',fat:'0,2',sugar:16,categoryId:2},
            {name:'Strawberries with whipped cream',quantity:'100 g',energy:127,protein:'1,1',fat:'10,4',sugar:'8,4',categoryId:2},
            {name:'Sugar biscuits',quantity:'100 g',energy:458,protein:'10,4',fat:'5,2',sugar:'76,8',categoryId:2},
            {name:'Sugar drops',quantity:'100 g',energy:374,protein:0,fat:0,sugar:98,categoryId:2},
            {name:'Tea-cake',quantity:'100 g',energy:384,protein:'6,4',fat:'17,6',sugar:'53,5',categoryId:2},
            {name:'Toffee',quantity:'100 g',energy:395,protein:'3,3',fat:'7,5',sugar:'81,8',categoryId:2},
            {name:'Tort cake with fruit',quantity:'100 g',energy:276,protein:'3,2',fat:9,sugar:'47,2',categoryId:2},
            {name:'Traditional halva',quantity:'100 g',energy:516,protein:'12,7',fat:'29,9',sugar:'50,6',categoryId:2},
            {name:'Vanilla halva',quantity:'100 g',energy:523,protein:'11,6',fat:'29,7',sugar:54,categoryId:2},
            {name:'Wafers with chocolate filling',quantity:'100 g',energy:539,protein:'3,4',fat:'30,2',sugar:'64,7',categoryId:2},
            {name:'Wafers with fruit filling',quantity:'100 g',energy:350,protein:'3,2',fat:'2,8',sugar:'80,1',categoryId:2},
            {name:'White chocolate',quantity:'100 g',energy:278,protein:'7,7',fat:'38,4',sugar:51,categoryId:2}
        ],
        2 : [
            {name:'Almonds',quantity:'100 g',energy:572,protein:20,fat:52,sugar:'20,5',categoryId:3},
            {name:'American blueberry',quantity:'100 g',energy:35,protein:1,fat:0,sugar:7,categoryId:3},
            {name:'Apple jam',quantity:'100 g',energy:250,protein:'0,4',fat:0,sugar:'65,3',categoryId:3},
            {name:'Apple preserve',quantity:'100 g',energy:254,protein:'0,4',fat:0,sugar:'66,2',categoryId:3},
            {name:'Apples',quantity:'100 g',energy:46,protein:'0,4',fat:'0,4',sugar:'12,1',categoryId:3},
            {name:'Apricot jam, high sugar',quantity:'100 g',energy:265,protein:'0,5',fat:0,sugar:'68,8',categoryId:3},
            {name:'Apricot jam, low-sugar',quantity:'100 g',energy:157,protein:'0,4',fat:'0,1',sugar:'38,8',categoryId:3},
            {name:'Apricots',quantity:'100 g',energy:47,protein:'0,9',fat:'0,2',sugar:'11,9',categoryId:3},
            {name:'Avocado',quantity:'100 g',energy:160,protein:2,fat:'15,3',sugar:'7,4',categoryId:3},
            {name:'Bananas',quantity:'100 g',energy:95,protein:1,fat:'0,3',sugar:'23,5',categoryId:3},
            {name:'Black rowan-berry',quantity:'100 g',energy:52,protein:'1,5',fat:'0,1',sugar:'10,9',categoryId:3},
            {name:'Blackberries',quantity:'100 g',energy:31,protein:2,fat:0,sugar:'4,4',categoryId:3},
            {name:'Blackberries',quantity:'100 g',energy:45,protein:'0,8',fat:'0,6',sugar:'12,2',categoryId:3},
            {name:'Blackcurrant jam, high-sugar',quantity:'100 g',energy:251,protein:'0,5',fat:'0,1',sugar:'63,9',categoryId:3},
            {name:'Blackcurrant jam, low-sugar',quantity:'100 g',energy:152,protein:'0,5',fat:'0,1',sugar:'39,6',categoryId:3},
            {name:'Blackcurrants',quantity:'100 g',energy:35,protein:'1,3',fat:'0,2',sugar:'14,9',categoryId:3},
            {name:'Blueberry',quantity:'100 g',energy:43,protein:'0,7',fat:'0,5',sugar:8,categoryId:3},
            {name:'Cashews',quantity:'100 g',energy:633,protein:'25,2',fat:'53,6',sugar:'12,6',categoryId:3},
            {name:'Cedar nuts',quantity:'100 g',energy:629,protein:12,fat:61,sugar:12,categoryId:3},
            {name:'Cherries',quantity:'100 g',energy:61,protein:1,fat:'0,3',sugar:'14,6',categoryId:3},
            {name:'Coco nuts',quantity:'100 g',energy:380,protein:'3,4',fat:'33,5',sugar:'29,5',categoryId:3},
            {name:'Cranberry',quantity:'100 g',energy:26,protein:'0,5',fat:0,sugar:'3,8',categoryId:3},
            {name:'Dried apples',quantity:'100 g',energy:238,protein:'2,1',fat:'2,1',sugar:'62,3',categoryId:3},
            {name:'Dried apricots',quantity:'100 g',energy:284,protein:'5,4',fat:'1,2',sugar:'72,2',categoryId:3},
            {name:'Dried apricots with stone',quantity:'100 g',energy:227,protein:5,fat:0,sugar:53,categoryId:3},
            {name:'Dried bananas',quantity:'100 g',energy:390,protein:'3,9',fat:'1,8',sugar:'80,5',categoryId:3},
            {name:'Dried briar fruit',quantity:'100 g',energy:110,protein:'3,4',fat:0,sugar:'21,5',categoryId:3},
            {name:'Dried dates',quantity:'100 g',energy:277,protein:2,fat:'0,4',sugar:74,categoryId:3},
            {name:'Dried figs',quantity:'100 g',energy:290,protein:'3,6',fat:'1,2',sugar:78,categoryId:3},
            {name:'Dried peach',quantity:'100 g',energy:254,protein:3,fat:'0,4',sugar:'57,7',categoryId:3},
            {name:'Dried pears',quantity:'100 g',energy:270,protein:'2,3',fat:'0,6',sugar:'62,6',categoryId:3},
            {name:'Figs',quantity:'100 g',energy:49,protein:'0,7',fat:'0,2',sugar:'11,2',categoryId:3},
            {name:'Fresh briar fruit',quantity:'100 g',energy:51,protein:'1,6',fat:0,sugar:10,categoryId:3},
            {name:'Gooseberries',quantity:'100 g',energy:41,protein:'0,8',fat:'0,2',sugar:'11,8',categoryId:3},
            {name:'Grapefruit',quantity:'100 g',energy:36,protein:'0,6',fat:'0,2',sugar:'9,8',categoryId:3},
            {name:'Grapes',quantity:'100 g',energy:69,protein:'0,5',fat:'0,2',sugar:'17,6',categoryId:3},
            {name:'Guava',quantity:'100 g',energy:57,protein:'0,8',fat:0,sugar:'0,6',categoryId:3},
            {name:'Hazelnuts',quantity:'100 g',energy:640,protein:'14,4',fat:63,sugar:'14,9',categoryId:3},
            {name:'Hazelnuts',quantity:'100 g',energy:707,protein:'16,1',fat:'66,9',sugar:'9,9',categoryId:3},
            {name:'Kiwi fruit',quantity:'100 g',energy:56,protein:'0,9',fat:'0,5',sugar:'13,9',categoryId:3},
            {name:'Kiwi fruit jam, low-sugar',quantity:'100 g',energy:154,protein:'0,4',fat:'0,2',sugar:'37,8',categoryId:3},
            {name:'Lemon',quantity:'100 g',energy:36,protein:'0,8',fat:'0,3',sugar:'9,5',categoryId:3},
            {name:'Mandarin jam, low sugar',quantity:'100 g',energy:259,protein:'0,3',fat:0,sugar:'67,8',categoryId:3},
            {name:'Mandarin preserve',quantity:'100 g',energy:278,protein:'0,7',fat:0,sugar:'72,3',categoryId:3},
            {name:'Mandarins',quantity:'100 g',energy:42,protein:'0,6',fat:'0,2',sugar:'11,2',categoryId:3},
            {name:'Mango',quantity:'100 g',energy:67,protein:'0,5',fat:'0,3',sugar:'11,5',categoryId:3},
            {name:'Melon',quantity:'100 g',energy:36,protein:'0,9',fat:'0,3',sugar:'8,4',categoryId:3},
            {name:'Mirabelle',quantity:'100 g',energy:27,protein:'0,2',fat:0,sugar:'6,4',categoryId:3},
            {name:'Mulberry',quantity:'100 g',energy:50,protein:'0,7',fat:0,sugar:12,categoryId:3},
            {name:'Mustard pits',quantity:'100 g',energy:474,protein:'25,8',fat:'30,8',sugar:'23,4',categoryId:3},
            {name:'Nectarine',quantity:'100 g',energy:48,protein:'0,9',fat:'0,2',sugar:'11,8',categoryId:3},
            {name:'Orange jam, low-sugar',quantity:'100 g',energy:159,protein:'0,3',fat:'0,1',sugar:'39,2',categoryId:3},
            {name:'Oranges',quantity:'100 g',energy:44,protein:'0,9',fat:'0,2',sugar:'11,3',categoryId:3},
            {name:'Papaya',quantity:'100 g',energy:48,protein:'0,6',fat:'0,1',sugar:'9,2',categoryId:3},
            {name:'Peach jam, low-sugar',quantity:'100 g',energy:155,protein:'0,5',fat:'0,1',sugar:'38,3',categoryId:3},
            {name:'Peach preserve',quantity:'100 g',energy:248,protein:'0,5',fat:0,sugar:'64,3',categoryId:3},
            {name:'Peaches',quantity:'100 g',energy:46,protein:1,fat:'0,2',sugar:'11,9',categoryId:3},
            {name:'Peaches in syrup',quantity:'100 g',energy:73,protein:'0,4',fat:'0,1',sugar:'18,2',categoryId:3},
            {name:'Peanuts',quantity:'100 g',energy:560,protein:'25,7',fat:'46,1',sugar:'19,2',categoryId:3},
            {name:'Pear preserve',quantity:'100 g',energy:271,protein:'0,4',fat:0,sugar:'70,9',categoryId:3},
            {name:'Pears',quantity:'100 g',energy:54,protein:'0,6',fat:'0,2',sugar:'14,4',categoryId:3},
            {name:'Pecans',quantity:'100 g',energy:589,protein:'20,5',fat:'48,5',sugar:25,categoryId:3},
            {name:'Persimmon/kaki',quantity:'100 g',energy:53,protein:'0,5',fat:0,sugar:'13,2',categoryId:3},
            {name:'Pineapple',quantity:'100 g',energy:54,protein:'0,4',fat:'0,2',sugar:'13,6',categoryId:3},
            {name:'Pineapple jam, low-sugar',quantity:'100 g',energy:157,protein:'0,2',fat:'0,1',sugar:'38,6',categoryId:3},
            {name:'Pineapple slices in syrup',quantity:'100 g',energy:84,protein:'0,4',fat:'0,1',sugar:21,categoryId:3},
            {name:'Plum jam',quantity:'100 g',energy:218,protein:1,fat:'0,2',sugar:53,categoryId:3},
            {name:'Plum jam, high-sugar',quantity:'100 g',energy:251,protein:'0,3',fat:'0,1',sugar:'62,1',categoryId:3},
            {name:'Plum jam, low-sugar',quantity:'100 g',energy:153,protein:'0,3',fat:'0,1',sugar:'37,9',categoryId:3},
            {name:'Plum preserve',quantity:'100 g',energy:281,protein:'0,4',fat:0,sugar:'73,4',categoryId:3},
            {name:'Plums',quantity:'100 g',energy:45,protein:'0,6',fat:'0,2',sugar:'11,7',categoryId:3},
            {name:'Pomegranate',quantity:'100 g',energy:52,protein:'0,9',fat:0,sugar:'11,2',categoryId:3},
            {name:'Poppy seeds',quantity:'100 g',energy:478,protein:'20,1',fat:'42,9',sugar:'24,7',categoryId:3},
            {name:'Prunes',quantity:'100 g',energy:267,protein:'3,5',fat:'1,2',sugar:'68,9',categoryId:3},
            {name:'Pumpkin seeds',quantity:'100 g',energy:556,protein:'24,5',fat:'45,8',sugar:18,categoryId:3},
            {name:'Quince',quantity:'100 g',energy:40,protein:'0,6',fat:'0,5',sugar:'7,9',categoryId:3},
            {name:'Quince preserve',quantity:'100 g',energy:263,protein:'0,4',fat:0,sugar:'68,7',categoryId:3},
            {name:'Raisins',quantity:'100 g',energy:277,protein:'2,3',fat:'0,5',sugar:'71,2',categoryId:3},
            {name:'Raspberries',quantity:'100 g',energy:29,protein:'1,3',fat:'0,3',sugar:12,categoryId:3},
            {name:'Raspberry',quantity:'100 g',energy:28,protein:'0,8',fat:0,sugar:6,categoryId:3},
            {name:'Raspberry preserve',quantity:'100 g',energy:275,protein:'0,6',fat:0,sugar:'71,2',categoryId:3},
            {name:'Redcurrants',quantity:'100 g',energy:31,protein:'1,1',fat:'0,2',sugar:'13,8',categoryId:3},
            {name:'Roast chestnuts',quantity:'100 g',energy:182,protein:'3,2',fat:'2,2',sugar:'33,8',categoryId:3},
            {name:'Rowan preserve',quantity:'100 g',energy:246,protein:'0,4',fat:0,sugar:'63,8',categoryId:3},
            {name:'Rowan-berry',quantity:'100 g',energy:46,protein:'1,4',fat:'0,1',sugar:'8,6',categoryId:3},
            {name:'Sea Buckthorn',quantity:'100 g',energy:52,protein:'0,9',fat:'2,5',sugar:5,categoryId:3},
            {name:'Sesame seeds',quantity:'100 g',energy:565,protein:'19,4',fat:'48,7',sugar:'12,2',categoryId:3},
            {name:'Sour cherries',quantity:'100 g',energy:47,protein:'0,9',fat:'0,4',sugar:'10,9',categoryId:3},
            {name:'Sour cherry jam, high-sugar',quantity:'100 g',energy:252,protein:'0,4',fat:'0,2',sugar:'61,7',categoryId:3},
            {name:'Sour cherry jam, low-sugar',quantity:'100 g',energy:154,protein:'0,4',fat:'0,2',sugar:'37,8',categoryId:3},
            {name:'Strawberries',quantity:'100 g',energy:28,protein:'0,7',fat:'0,4',sugar:'7,2',categoryId:3},
            {name:'Strawberry jam, high-sugar',quantity:'100 g',energy:252,protein:'0,3',fat:'0,2',sugar:'62,3',categoryId:3},
            {name:'Strawberry jam, low-sugar',quantity:'100 g',energy:153,protein:'0,3',fat:'0,2',sugar:'37,8',categoryId:3},
            {name:'Strawberry preserve',quantity:'100 g',energy:271,protein:'0,3',fat:0,sugar:'70,9',categoryId:3},
            {name:'Sunflower seeds',quantity:'100 g',energy:561,protein:'24,4',fat:'43,7',sugar:'24,6',categoryId:3},
            {name:'Walnuts',quantity:'100 g',energy:645,protein:16,fat:'60,3',sugar:18,categoryId:3},
            {name:'Watermelon',quantity:'100 g',energy:36,protein:'0,6',fat:'0,1',sugar:'8,4',categoryId:3},
            {name:'Whitecurants',quantity:'100 g',energy:33,protein:1,fat:'0,2',sugar:'13,1',categoryId:3},
            {name:'Wild strawberries',quantity:'100 g',energy:33,protein:'0,8',fat:'0,5',sugar:'8,3',categoryId:3},
            {name:'Wildberry jam, low-sugar',quantity:'100 g',energy:153,protein:'0,3',fat:'0,2',sugar:'38,2',categoryId:3}
        ],
        3 : [
            {name:'Asparagus shoots',quantity:'100 g',energy:23,protein:'2,2',fat:'0,2',sugar:'3,3',categoryId:4},
            {name:'Beets',quantity:'100 g',energy:37,protein:'1,5',fat:'0,1',sugar:'7,6',categoryId:4},
            {name:'Black olives, marinated',quantity:'100 g',energy:361,protein:'2,2',fat:'8,7',sugar:36,categoryId:4},
            {name:'Boiled Brussels sprouts',quantity:'100 g',energy:25,protein:'2,6',fat:'0,4',sugar:'2,8',categoryId:4},
            {name:'Boiled cauliflower',quantity:'100 g',energy:17,protein:2,fat:'0,3',sugar:'1,8',categoryId:4},
            {name:'Boiled green peas',quantity:'100 g',energy:62,protein:'5,3',fat:'0,4',sugar:'9,2',categoryId:4},
            {name:'Boiled zucchini',quantity:'100 g',energy:13,protein:'0,8',fat:'0,1',sugar:'2,5',categoryId:4},
            {name:'Broccoli fresh',quantity:'100 g',energy:25,protein:3,fat:'0,4',sugar:'2,4',categoryId:4},
            {name:'Canola',quantity:'100 g',energy:34,protein:'1,2',fat:'0,1',sugar:'7,4',categoryId:4},
            {name:'Cauliflower fresh',quantity:'100 g',energy:21,protein:'2,4',fat:'0,3',sugar:'2,3',categoryId:4},
            {name:'Celery root',quantity:'100 g',energy:21,protein:'1,6',fat:'0,3',sugar:'7,7',categoryId:4},
            {name:'Celery-top',quantity:'100 g',energy:13,protein:1,fat:'0,2',sugar:'3,6',categoryId:4},
            {name:'Chicory',quantity:'100 g',energy:21,protein:'1,7',fat:'0,2',sugar:'4,1',categoryId:4},
            {name:'Chives',quantity:'100 g',energy:29,protein:'4,1',fat:'0,8',sugar:'3,9',categoryId:4},
            {name:'Cooked beets',quantity:'100 g',energy:49,protein:'1,8',fat:0,sugar:'10,8',categoryId:4},
            {name:'Cooked carrots',quantity:'100 g',energy:25,protein:'0,8',fat:'0,3',sugar:5,categoryId:4},
            {name:'Cooked potatoes',quantity:'100 g',energy:82,protein:2,fat:'0,4',sugar:'16,7',categoryId:4},
            {name:'Cooked summer squash',quantity:'100 g',energy:15,protein:1,fat:0,sugar:3,categoryId:4},
            {name:'Corn fresh',quantity:'100 g',energy:97,protein:3,fat:'1,2',sugar:'18,2',categoryId:4},
            {name:'Cucumbers',quantity:'100 g',energy:15,protein:'0,7',fat:'0,1',sugar:3,categoryId:4},
            {name:'Dill',quantity:'100 g',energy:28,protein:'1,3',fat:'0,3',sugar:'7,7',categoryId:4},
            {name:'Dill pickles',quantity:'100 g',energy:11,protein:1,fat:'0,1',sugar:'1,9',categoryId:4},
            {name:'Eggplant',quantity:'100 g',energy:18,protein:1,fat:'0,2',sugar:'3,1',categoryId:4},
            {name:'Fried potatoes',quantity:'100 g',energy:192,protein:'2,8',fat:'9,5',sugar:'23,4',categoryId:4},
            {name:'Fried squash',quantity:'100 g',energy:88,protein:'1,1',fat:6,sugar:'6,7',categoryId:4},
            {name:'Garlic',quantity:'100 g',energy:146,protein:'6,4',fat:'0,5',sugar:'32,6',categoryId:4},
            {name:'Green beans fresh',quantity:'100 g',energy:24,protein:2,fat:'0,2',sugar:'3,6',categoryId:4},
            {name:'Green olives, marinated',quantity:'100 g',energy:125,protein:'1,4',fat:'12,7',sugar:'4,1',categoryId:4},
            {name:'Green peppers',quantity:'100 g',energy:27,protein:'1,3',fat:0,sugar:'5,3',categoryId:4},
            {name:'Horseradish',quantity:'100 g',energy:67,protein:'4,5',fat:'0,6',sugar:'18,1',categoryId:4},
            {name:'Kohlrabi',quantity:'100 g',energy:29,protein:'2,2',fat:'0,3',sugar:'6,5',categoryId:4},
            {name:'Leek',quantity:'100 g',energy:24,protein:'2,2',fat:'0,3',sugar:'5,7',categoryId:4},
            {name:'Lettuce',quantity:'100 g',energy:12,protein:'1,2',fat:'0,3',sugar:'1,3',categoryId:4},
            {name:'Mashed aubergines',quantity:'100 g',energy:148,protein:'1,7',fat:'13,3',sugar:'5,1',categoryId:4},
            {name:'Mashed courgettes',quantity:'100 g',energy:122,protein:2,fat:9,sugar:'8,5',categoryId:4},
            {name:'Onions',quantity:'100 g',energy:30,protein:'1,4',fat:'0,4',sugar:'6,9',categoryId:4},
            {name:'Parsley, leaves',quantity:'100 g',energy:41,protein:'4,4',fat:'0,4',sugar:9,categoryId:4},
            {name:'Parsley, root',quantity:'100 g',energy:38,protein:'2,6',fat:'0,5',sugar:'10,5',categoryId:4},
            {name:'Pattypan squash',quantity:'100 g',energy:19,protein:'0,6',fat:'0,1',sugar:'4,1',categoryId:4},
            {name:'Peeled tomatoes in tins',quantity:'100 g',energy:11,protein:'0,5',fat:'2,3',sugar:0,categoryId:4},
            {name:'Peking cabbage',quantity:'100 g',energy:12,protein:'1,2',fat:'0,2',sugar:'3,2',categoryId:4},
            {name:'Pepper',quantity:'100 g',energy:26,protein:'0,9',fat:'0,3',sugar:'5,2',categoryId:4},
            {name:'Potato puree',quantity:'100 g',energy:74,protein:'2,2',fat:'0,8',sugar:'14,3',categoryId:4},
            {name:'Potatoes',quantity:'100 g',energy:80,protein:2,fat:0,sugar:16,categoryId:4},
            {name:'Pumpkin',quantity:'100 g',energy:28,protein:'1,3',fat:'0,3',sugar:'7,7',categoryId:4},
            {name:'Pumpkin fried',quantity:'100 g',energy:76,protein:'1,4',fat:'5,5',sugar:'5,2',categoryId:4},
            {name:'Raddish',quantity:'100 g',energy:14,protein:1,fat:'0,2',sugar:'4,4',categoryId:4},
            {name:'Raw Brussels sprouts',quantity:'100 g',energy:34,protein:4,fat:'0,5',sugar:'3,5',categoryId:4},
            {name:'Raw carrot',quantity:'100 g',energy:31,protein:'0,8',fat:'0,3',sugar:'6,6',categoryId:4},
            {name:'Raw green peas',quantity:'100 g',energy:79,protein:6,fat:'0,7',sugar:12,categoryId:4},
            {name:'Red cabbage',quantity:'100 g',energy:27,protein:'1,9',fat:'0,2',sugar:'6,7',categoryId:4},
            {name:'Red kidney beans',quantity:'100 g',energy:93,protein:'8,4',fat:'0,3',sugar:'13,7',categoryId:4},
            {name:'Red peppers',quantity:'100 g',energy:26,protein:'1,3',fat:0,sugar:'5,3',categoryId:4},
            {name:'Rhubarbar',quantity:'100 g',energy:9,protein:'0,5',fat:'0,1',sugar:'4,6',categoryId:4},
            {name:'Salty tomatoes',quantity:'100 g',energy:16,protein:'1,1',fat:'0,1',sugar:'1,6',categoryId:4},
            {name:'Savoy cabbage',quantity:'100 g',energy:38,protein:'3,3',fat:'0,4',sugar:'7,8',categoryId:4},
            {name:'Sorrel',quantity:'100 g',energy:21,protein:'1,1',fat:'0,8',sugar:'4,9',categoryId:4},
            {name:'Sour cabbage',quantity:'100 g',energy:12,protein:'1,1',fat:'0,2',sugar:'3,4',categoryId:4},
            {name:'Spinach',quantity:'100 g',energy:17,protein:'2,7',fat:'0,4',sugar:'0,8',categoryId:4},
            {name:'Stewed white cabbage',quantity:'100 g',energy:75,protein:2,fat:'3,3',sugar:'9,6',categoryId:4},
            {name:'Summer squash',quantity:'100 g',energy:23,protein:'0,6',fat:'0,3',sugar:'4,9',categoryId:4},
            {name:'Sweet potatoes',quantity:'100 g',energy:61,protein:2,fat:0,sugar:'13,3',categoryId:4},
            {name:'Tomatoes',quantity:'100 g',energy:19,protein:'0,8',fat:'0,3',sugar:'3,5',categoryId:4},
            {name:'Turnip',quantity:'100 g',energy:26,protein:'1,1',fat:'0,3',sugar:'8,2',categoryId:4},
            {name:'Vinaigret salad',quantity:'100 g',energy:92,protein:'1,3',fat:6,sugar:'7,8',categoryId:4},
            {name:'White cabbage',quantity:'100 g',energy:29,protein:'1,7',fat:'0,2',sugar:'7,4',categoryId:4},
            {name:'White cabbage, browned',quantity:'100 g',energy:69,protein:'1,6',fat:'4,7',sugar:'7,2',categoryId:4},
            {name:'White kidney beans fresh',quantity:'100 g',energy:102,protein:7,fat:'0,5',sugar:'16,9',categoryId:4},
            {name:'Whole tomatoes in tins',quantity:'100 g',energy:20,protein:'1,1',fat:0,sugar:'3,8',categoryId:4},
            {name:'Young beet leaves',quantity:'100 g',energy:17,protein:'2,1',fat:'0,5',sugar:'5,5',categoryId:4},
            {name:'Zucchini',quantity:'100 g',energy:16,protein:'1,5',fat:'0,2',sugar:3,categoryId:4}
        ],
        4 : [
            {name:'Acidophilus milk 1%',quantity:'100 ml',energy:40,protein:3,fat:1,sugar:4,categoryId:5},
            {name:'Acidophilus milk 3,2%',quantity:'100 ml',energy:57,protein:'2,8',fat:'3,2',sugar:'3,8',categoryId:5},
            {name:'Bryndza cow’s milk cheese',quantity:'100 g',energy:260,protein:'17,9',fat:'20,1',sugar:0,categoryId:5},
            {name:'Bryndza sheep’s milk cheese',quantity:'100 g',energy:298,protein:'14,6',fat:'25,5',sugar:0,categoryId:5},
            {name:'Butter',quantity:'100 g',energy:659,protein:'1,1',fat:'73,5',sugar:'1,1',categoryId:5},
            {name:'Butter sandwich',quantity:'100 g',energy:566,protein:'2,5',fat:'61,5',sugar:0,categoryId:5},
            {name:'Butter unsalted',quantity:'100 g',energy:748,protein:'0,5',fat:'82,5',sugar:0,categoryId:5},
            {name:'Buttermilk 0,5% fat',quantity:'100 ml',energy:37,protein:'3,4',fat:'0,5',sugar:'4,7',categoryId:5},
            {name:'Buttermilk 1% fat',quantity:'100 ml',energy:40,protein:'3,3',fat:1,sugar:'4,7',categoryId:5},
            {name:'Camembert Cheese',quantity:'100 g',energy:324,protein:'15,3',fat:'28,8',sugar:'0,1',categoryId:5},
            {name:'Casserole cheese',quantity:'100 g',energy:168,protein:'17,6',fat:'4,2',sugar:'14,2',categoryId:5},
            {name:'Cheese Baltic',quantity:'100 g',energy:209,protein:30,fat:9,sugar:0,categoryId:5},
            {name:'Cheese melted Russia',quantity:'100 g',energy:340,protein:22,fat:27,sugar:0,categoryId:5},
            {name:'Cheese Russia',quantity:'100 g',energy:360,protein:23,fat:29,sugar:0,categoryId:5},
            {name:'Cheese, coated',quantity:'100 g',energy:407,protein:'8,5',fat:'27,8',sugar:32,categoryId:5},
            {name:'Coffee cream, 20% fat',quantity:'100 ml',energy:206,protein:'2,8',fat:20,sugar:'3,7',categoryId:5},
            {name:'Coffee cream, 9% fat',quantity:'100 ml',energy:107,protein:'2,8',fat:9,sugar:4,categoryId:5},
            {name:'Condensed cream with sugar',quantity:'100 ml',energy:382,protein:8,fat:19,sugar:47,categoryId:5},
            {name:'Cottage cheese, half-fat',quantity:'100 g',energy:133,protein:'18,7',fat:'4,7',sugar:'3,7',categoryId:5},
            {name:'Cottage cheese, non-fat',quantity:'100 g',energy:99,protein:'19,8',fat:'0,5',sugar:'3,5',categoryId:5},
            {name:'Cottage cheese, whole-fat',quantity:'100 g',energy:175,protein:'17,7',fat:'10,1',sugar:'3,5',categoryId:5},
            {name:'Cream powder 42%',quantity:'100 g',energy:577,protein:19,fat:42,sugar:'30,2',categoryId:5},
            {name:'Curd Dessert',quantity:'100 g',energy:156,protein:'13,9',fat:'6,2',sugar:'11,2',categoryId:5},
            {name:'Curd from cottage cheese',quantity:'100 g',energy:183,protein:'18,6',fat:'3,6',sugar:'18,2',categoryId:5},
            {name:'Curd with carrots',quantity:'100 g',energy:232,protein:'12,9',fat:'11,5',sugar:'18,8',categoryId:5},
            {name:'Dutch cheese',quantity:'100 g',energy:352,protein:26,fat:'26,8',sugar:0,categoryId:5},
            {name:'Evaporated milk, sweetened',quantity:'100 ml',energy:326,protein:'7,5',fat:8,sugar:'55,3',categoryId:5},
            {name:'Evaporated milk, unsweetened',quantity:'100 ml',energy:131,protein:'6,6',fat:'7,5',sugar:'9,4',categoryId:5},
            {name:'Fat kefir',quantity:'100 ml',energy:56,protein:'2,8',fat:'3,2',sugar:'4,1',categoryId:5},
            {name:'Feta cheese',quantity:'100 g',energy:215,protein:17,fat:16,sugar:1,categoryId:5},
            {name:'Fruit yoghurt',quantity:'100 ml',energy:63,protein:'3,7',fat:'1,5',sugar:'8,9',categoryId:5},
            {name:'Fruit yoghurt 3,2%',quantity:'100 ml',energy:85,protein:5,fat:'3,2',sugar:'8,5',categoryId:5},
            {name:'Full-cream Brie cheese',quantity:'100 g',energy:329,protein:'19,8',fat:28,sugar:'0,2',categoryId:5},
            {name:'Full-cream Camembert cheese',quantity:'100 g',energy:291,protein:'21,4',fat:23,sugar:'0,2',categoryId:5},
            {name:'Full-cream Cheddar cheese',quantity:'100 g',energy:391,protein:'27,1',fat:'31,7',sugar:'0,1',categoryId:5},
            {name:'Goat milk',quantity:'100 ml',energy:68,protein:'3,2',fat:'4,1',sugar:'4,5',categoryId:5},
            {name:'Homemade pasta and cheese casserole',quantity:'100 g',energy:180,protein:'7,7',fat:'7,4',sugar:'20,3',categoryId:5},
            {name:'Kefir 0% fat',quantity:'100 ml',energy:30,protein:3,fat:'0,1',sugar:'3,8',categoryId:5},
            {name:'Kefir 2% fat',quantity:'100 ml',energy:51,protein:'3,4',fat:2,sugar:'4,7',categoryId:5},
            {name:'Kumys made of cow milk, non-fat',quantity:'100 ml',energy:41,protein:3,fat:'0,1',sugar:'6,3',categoryId:5},
            {name:'Kumys made of horse milk',quantity:'100 ml',energy:41,protein:3,fat:'0,1',sugar:'6,3',categoryId:5},
            {name:'Macaroni milk soup',quantity:'100 ml',energy:58,protein:'2,2',fat:'1,9',sugar:'7,9',categoryId:5},
            {name:'Melted butter',quantity:'100 ml',energy:892,protein:'0,2',fat:99,sugar:0,categoryId:5},
            {name:'Melted cheese',quantity:'100 g',energy:298,protein:'13,5',fat:27,sugar:'1,2',categoryId:5},
            {name:'Milk 0,5% fat',quantity:'100 ml',energy:39,protein:'3,5',fat:'0,5',sugar:'5,1',categoryId:5},
            {name:'Milk 1,5% fat',quantity:'100 ml',energy:47,protein:'3,4',fat:'1,5',sugar:5,categoryId:5},
            {name:'Milk 2% fat',quantity:'100 ml',energy:51,protein:'3,4',fat:2,sugar:'4,9',categoryId:5},
            {name:'Milk 3,2% fat',quantity:'100 ml',energy:61,protein:'3,3',fat:'3,2',sugar:'4,8',categoryId:5},
            {name:'Milk 3,5%',quantity:'100 ml',energy:64,protein:'3,3',fat:'3,5',sugar:'4,8',categoryId:5},
            {name:'Milk 6%',quantity:'100 ml',energy:84,protein:3,fat:6,sugar:'4,7',categoryId:5},
            {name:'Natural yoghurt, 2% fat',quantity:'100 ml',energy:60,protein:'4,3',fat:2,sugar:'6,2',categoryId:5},
            {name:'Natural yoghurt, 3,2% fat',quantity:'100 ml',energy:66,protein:5,fat:'3,2',sugar:'3,5',categoryId:5},
            {name:'Non-fat acidophilus milk',quantity:'100 ml',energy:31,protein:3,fat:'0,1',sugar:'3,9',categoryId:5},
            {name:'Parmesan cheese',quantity:'100 g',energy:452,protein:'41,5',fat:32,sugar:'0,1',categoryId:5},
            {name:'Peasant unsalted butter',quantity:'100 g',energy:661,protein:'0,8',fat:'72,5',sugar:0,categoryId:5},
            {name:'Powdered milk, fat-free',quantity:'100 g',energy:360,protein:'35,7',fat:'0,8',sugar:'51,2',categoryId:5},
            {name:'Powdered milk, whole',quantity:'100 g',energy:479,protein:27,fat:24,sugar:'38,7',categoryId:5},
            {name:'Pudding of curd',quantity:'100 g',energy:224,protein:'13,9',fat:'9,6',sugar:'20,1',categoryId:5},
            {name:'Pumpkin soup with milk and semolina',quantity:'100 ml',energy:50,protein:2,fat:'2,2',sugar:'5,4',categoryId:5},
            {name:'Rice milk soup',quantity:'100 ml',energy:54,protein:'1,8',fat:'1,9',sugar:'7,3',categoryId:5},
            {name:'Roquefort cheese',quantity:'100 g',energy:337,protein:20,fat:28,sugar:0,categoryId:5},
            {name:'Ryazhenka 1%',quantity:'100 ml',energy:40,protein:3,fat:1,sugar:'4,2',categoryId:5},
            {name:'Ryazhenka 2,5%',quantity:'100 ml',energy:54,protein:'2,9',fat:'2,5',sugar:'4,2',categoryId:5},
            {name:'Ryazhenka 4%',quantity:'100 ml',energy:67,protein:'2,8',fat:4,sugar:'4,2',categoryId:5},
            {name:'Ryazhenka 6%',quantity:'100 ml',energy:84,protein:5,fat:6,sugar:'4,1',categoryId:5},
            {name:'Sheep milk',quantity:'100 ml',energy:107,protein:6,fat:7,sugar:'5,1',categoryId:5},
            {name:'Smoked cheese',quantity:'100 g',energy:270,protein:23,fat:19,sugar:0,categoryId:5},
            {name:'Sour cream 20%',quantity:'100 ml',energy:206,protein:'2,8',fat:20,sugar:'3,2',categoryId:5},
            {name:'Sour Cream 25%',quantity:'100 ml',energy:248,protein:'2,6',fat:25,sugar:25,categoryId:5},
            {name:'Sour cream, 10% fat',quantity:'100 ml',energy:115,protein:3,fat:10,sugar:'2,9',categoryId:5},
            {name:'Sour cream, 12% fat',quantity:'100 ml',energy:133,protein:'2,7',fat:12,sugar:'3,9',categoryId:5},
            {name:'Sour cream, 18% fat',quantity:'100 ml',energy:184,protein:'2,5',fat:18,sugar:'3,6',categoryId:5},
            {name:'Sour cream, 30% fat',quantity:'100 ml',energy:294,protein:'2,4',fat:30,sugar:'3,1',categoryId:5},
            {name:'Sour lean',quantity:'100 g',energy:30,protein:3,fat:'0,1',sugar:'3,8',categoryId:5},
            {name:'Sour milk 1%',quantity:'100 ml',energy:40,protein:3,fat:1,sugar:'4,1',categoryId:5},
            {name:'Sour milk 2,5%',quantity:'100 ml',energy:53,protein:'2,9',fat:'2,5',sugar:'4,1',categoryId:5},
            {name:'Sour milk 3,2%',quantity:'100 ml',energy:58,protein:'2,8',fat:'3,2',sugar:'4,1',categoryId:5},
            {name:'Suluguni',quantity:'100 g',energy:285,protein:'19,5',fat:22,sugar:0,categoryId:5},
            {name:'Sweet acidophilus milk 3,2%',quantity:'100 ml',energy:77,protein:'2,8',fat:'3,2',sugar:'8,6',categoryId:5},
            {name:'Swiss cheese',quantity:'100 g',energy:396,protein:'24,9',fat:'31,8',sugar:0,categoryId:5},
            {name:'Weight Curd',quantity:'100 g',energy:341,protein:'7,1',fat:23,sugar:'27,5',categoryId:5},
            {name:'Weight Curd with raisins',quantity:'100 g',energy:343,protein:'6,8',fat:'21,6',sugar:'29,9',categoryId:5},
            {name:'Whip cream, 30% fat',quantity:'100 ml',energy:287,protein:'2,2',fat:30,sugar:'3,1',categoryId:5},
            {name:'Whipped cream with vanilla',quantity:'100 ml',energy:346,protein:'2,8',fat:28,sugar:'21,6',categoryId:5}
        ],
        5 : [
            {name:'Browned chicken ',quantity:'100 g' ,energy:204,protein:'26,3',fat:11,sugar:0,categoryId:6},
            {name:'Chicken ',quantity:'100 g' ,energy:202,protein:'18,5',fat:'14,3',sugar:0,categoryId:6},
            {name:'Chicken ',quantity:'100 g' ,energy:156,protein:'18,7',fat:'7,8',sugar:'0,4',categoryId:6},
            {name:'Chicken breast ',quantity:'100 g' ,energy:99,protein:'21,5',fat:'1,3',sugar:0,categoryId:6},
            {name:'Chicken cooked with vegetables ',quantity:'100 g' ,energy:99,protein:'7,6',fat:'6,4',sugar:'4,6',categoryId:6},
            {name:'Chicken gizzard ',quantity:'100 g' ,energy:114,protein:'18,2',fat:'4,2',sugar:'0,6',categoryId:6},
            {name:'Chicken hearts ',quantity:'100 g' ,energy:159,protein:'15,8',fat:'10,3',sugar:'0,8',categoryId:6},
            {name:'Chicken leg ',quantity:'100 g' ,energy:158,protein:'16,8',fat:'10,2',sugar:0,categoryId:6},
            {name:'Chicken liver ',quantity:'100 g' ,energy:136,protein:'19,1',fat:'6,3',sugar:'0,6',categoryId:6},
            {name:'Chicken mince cutlets ',quantity:'100 g' ,energy:248,protein:'19,7',fat:'15,7',sugar:'7,6',categoryId:6},
            {name:'Chicken wing ',quantity:'100 g' ,energy:186,protein:'19,2',fat:'12,2',sugar:0,categoryId:6},
            {name:'Chicken, boiled ',quantity:'100 g' ,energy:143,protein:'24,6',fat:5,sugar:0,categoryId:6},
            {name:'Chicken, tabaka ',quantity:'100 g' ,energy:271,protein:25,fat:21,sugar:'0,2',categoryId:6},
            {name:'Cooked duck ',quantity:'100 g' ,energy:248,protein:'19,7',fat:'18,8',sugar:0,categoryId:6},
            {name:'Duck ',quantity:'100 g' ,energy:308,protein:'13,5',fat:'28,6',sugar:0,categoryId:6},
            {name:'Fried chicken cutlet in breadcrumbs ',quantity:'100 g' ,energy:382,protein:'19,9',fat:'27,8',sugar:'14,3',categoryId:6},
            {name:'Goose ',quantity:'100 g' ,energy:339,protein:'14,1',fat:'31,8',sugar:0,categoryId:6},
            {name:'Hen in jelly ',quantity:'100 g' ,energy:192,protein:'27,3',fat:'8,9',sugar:'1,2',categoryId:6},
            {name:'Roast chicken ',quantity:'100 g' ,energy:179,protein:'16,4',fat:'12,7',sugar:'0,1',categoryId:6},
            {name:'Roast chicken thigh ',quantity:'100 g' ,energy:195,protein:'29,4',fat:'8,6',sugar:0,categoryId:6},
            {name:'Roast chicken,stuffed ',quantity:'100 g' ,energy:199,protein:'20,5',fat:'11,9',sugar:'2,8',categoryId:6},
            {name:'Roast duck ',quantity:'100 g' ,energy:266,protein:'22,6',fat:'19,5',sugar:0,categoryId:6},
            {name:'Turkey breast ',quantity:'100 g' ,energy:84,protein:'19,2',fat:'0,7',sugar:0,categoryId:6},
            {name:'Turkey cooked ',quantity:'100 g' ,energy:195,protein:'25,3',fat:'10,4',sugar:0,categoryId:6},
            {name:'Turkey leg ',quantity:'100 g' ,energy:131,protein:'18,4',fat:'6,4',sugar:0,categoryId:6},
            {name:'Turkey shin ',quantity:'100 g' ,energy:142,protein:'15,7',fat:'8,9',sugar:0,categoryId:6},
            {name:'Turkey wings ',quantity:'100 g' ,energy:168,protein:'16,5',fat:'11,4',sugar:0,categoryId:6}
        ],
        6 : [
            {name:'Beef balls steam',quantity:'100 g',energy:194,protein:14,fat:'11,6',sugar:'8,2',categoryId:7},
            {name:'Beef cooked in natural juice',quantity:'100 g',energy:214,protein:'15,4',fat:'16,9',sugar:0,categoryId:7},
            {name:'Beef goulash',quantity:'100 g',energy:148,protein:14,fat:'9,2',sugar:'2,6',categoryId:7},
            {name:'Beef ham, boiled',quantity:'100 g',energy:107,protein:'20,9',fat:2,sugar:'1,1',categoryId:7},
            {name:'Beef hamburger',quantity:'100 g',energy:220,protein:'14,6',fat:'11,8',sugar:'13,6',categoryId:7},
            {name:'Beef hearts',quantity:'100 g',energy:96,protein:16,fat:'3,5',sugar:0,categoryId:7},
            {name:'Beef kidneys',quantity:'100 g',energy:86,protein:'15,2',fat:'2,8',sugar:0,categoryId:7},
            {name:'Beef legs in jelly',quantity:'100 g',energy:60,protein:6,fat:4,sugar:0,categoryId:7},
            {name:'Beef liver',quantity:'100 g',energy:125,protein:20,fat:'3,1',sugar:4,categoryId:7},
            {name:'Beef pate',quantity:'100 g',energy:275,protein:'16,1',fat:'23,3',sugar:'0,4',categoryId:7},
            {name:'Beef sausages',quantity:'100 g',energy:215,protein:'11,4',fat:'18,2',sugar:'1,5',categoryId:7},
            {name:'Beef schnitzel',quantity:'100 g',energy:338,protein:'17,6',fat:'25,1',sugar:'10,2',categoryId:7},
            {name:'Beef steak',quantity:'100 g',energy:214,protein:'28,8',fat:11,sugar:0,categoryId:7},
            {name:'Beef stew',quantity:'100 g',energy:212,protein:'16,8',fat:'14,3',sugar:'3,9',categoryId:7},
            {name:'Beef tongue in jelly',quantity:'100 g',energy:212,protein:'22,4',fat:'13,6',sugar:'2,4',categoryId:7},
            {name:'Beef tongues',quantity:'100 g',energy:146,protein:'12,2',fat:'10,9',sugar:0,categoryId:7},
            {name:'Beef, brisket',quantity:'100 g',energy:217,protein:'19,3',fat:'15,7',sugar:0,categoryId:7},
            {name:'Beef, meatloaf',quantity:'100 g',energy:157,protein:'16,7',fat:'10,1',sugar:0,categoryId:7},
            {name:'Black pudding',quantity:'100 g',energy:274,protein:9,fat:'19,5',sugar:'14,5',categoryId:7},
            {name:'Boeuf Stogonow',quantity:'100 g',energy:220,protein:'19,5',fat:'14,3',sugar:'3,7',categoryId:7},
            {name:'Boiled sausages Capital',quantity:'100 g',energy:319,protein:'15,1',fat:'28,7',sugar:0,categoryId:7},
            {name:'Boiled sausages doctoral',quantity:'100 g',energy:257,protein:'12,8',fat:'22,2',sugar:'1,5',categoryId:7},
            {name:'Boiled sausages Moscow',quantity:'100 g',energy:250,protein:'11,5',fat:'21,8',sugar:2,categoryId:7},
            {name:'Boiled sausages Russian',quantity:'100 g',energy:302,protein:'11,8',fat:'28,9',sugar:0,categoryId:7},
            {name:'Brains',quantity:'100 g',energy:124,protein:'11,7',fat:'8,6',sugar:0,categoryId:7},
            {name:'Buzhenina boiled',quantity:'100 g',energy:233,protein:'16,4',fat:'18,3',sugar:1,categoryId:7},
            {name:'Chicken hot-dogs',quantity:'100 g',energy:259,protein:'10,8',fat:'22,4',sugar:'4,2',categoryId:7},
            {name:'Cooked beef',quantity:'100 g',energy:254,protein:'25,8',fat:'16,8',sugar:0,categoryId:7},
            {name:'Cooked lamb',quantity:'100 g',energy:243,protein:22,fat:'17,2',sugar:0,categoryId:7},
            {name:'Cooked pork',quantity:'100 g',energy:364,protein:'22,6',fat:30,sugar:'3,1',categoryId:7},
            {name:'Cooked pork sausage',quantity:'100 g',energy:274,protein:'10,2',fat:'25,1',sugar:'1,9',categoryId:7},
            {name:'Cooked rabbit',quantity:'100 g',energy:204,protein:'24,6',fat:'11,7',sugar:0,categoryId:7},
            {name:'Cooked veal',quantity:'100 g',energy:131,protein:'30,7',fat:'0,9',sugar:0,categoryId:7},
            {name:'Cutlet',quantity:'100 g',energy:105,protein:'20,5',fat:'2,4',sugar:0,categoryId:7},
            {name:'Deer meat',quantity:'100 g',energy:155,protein:'19,5',fat:'8,5',sugar:0,categoryId:7},
            {name:'Fat pork',quantity:'100 g',energy:486,protein:'11,5',fat:'48,9',sugar:0,categoryId:7},
            {name:'Fried rabbit',quantity:'100 g',energy:233,protein:25,fat:'14,8',sugar:0,categoryId:7},
            {name:'Headcheese',quantity:'100 g',energy:336,protein:'12,6',fat:32,sugar:'0,5',categoryId:7},
            {name:'Horse meat',quantity:'100 g',energy:121,protein:'20,9',fat:'4,1',sugar:0,categoryId:7},
            {name:'Hot dogs',quantity:'100 g',energy:226,protein:'10,4',fat:'20,1',sugar:'0,8',categoryId:7},
            {name:'Jerky cervelat',quantity:'100 g',energy:425,protein:'16,1',fat:'40,1',sugar:0,categoryId:7},
            {name:'Jerky Cracow',quantity:'100 g',energy:466,protein:'16,2',fat:'44,6',sugar:0,categoryId:7},
            {name:'Jerky Minsk',quantity:'100 g',energy:287,protein:'17,4',fat:23,sugar:'2,7',categoryId:7},
            {name:'Jerky Moscow',quantity:'100 g',energy:406,protein:'19,1',fat:'36,6',sugar:0,categoryId:7},
            {name:'Jerky Odessa',quantity:'100 g',energy:402,protein:'14,8',fat:'38,1',sugar:0,categoryId:7},
            {name:'Jerky Poltava',quantity:'100 g',energy:417,protein:'16,4',fat:39,sugar:0,categoryId:7},
            {name:'Jerky Snack',quantity:'100 g',energy:366,protein:15,fat:33,sugar:'2,3',categoryId:7},
            {name:'Jerky Tallinn',quantity:'100 g',energy:373,protein:'17,1',fat:'33,8',sugar:0,categoryId:7},
            {name:'Jerky Ukrainian',quantity:'100 g',energy:376,protein:'16,5',fat:'34,4',sugar:0,categoryId:7},
            {name:'Lamb hearts',quantity:'100 g',energy:82,protein:'13,5',fat:'2,5',sugar:0,categoryId:7},
            {name:'Lamb kidneys',quantity:'100 g',energy:77,protein:'13,6',fat:'2,5',sugar:0,categoryId:7},
            {name:'Lamb liver',quantity:'100 g',energy:101,protein:'18,7',fat:'2,9',sugar:0,categoryId:7},
            {name:'Lamb stew',quantity:'100 g',energy:213,protein:'14,2',fat:'15,6',sugar:'3,9',categoryId:7},
            {name:'Lamb stew, canned',quantity:'100 g',energy:191,protein:'17,4',fat:'13,4',sugar:'0,2',categoryId:7},
            {name:'Liver pate',quantity:'100 g',energy:301,protein:'11,6',fat:'28,1',sugar:'3,4',categoryId:7},
            {name:'Mixed meat hamburger',quantity:'100 g',energy:284,protein:13,fat:'21,1',sugar:'11,8',categoryId:7},
            {name:'Mixed meat meatballs',quantity:'100 g',energy:272,protein:'13,5',fat:'17,5',sugar:'15,9',categoryId:7},
            {name:'Mutton leg',quantity:'100 g',energy:232,protein:18,fat:18,sugar:0,categoryId:7},
            {name:'Mutton shoulder',quantity:'100 g',energy:284,protein:'15,6',fat:25,sugar:0,categoryId:7},
            {name:'Pork chap',quantity:'100 g',energy:630,protein:'7,4',fat:'67,8',sugar:0,categoryId:7},
            {name:'Pork chops in breadcrumbs',quantity:'100 g',energy:351,protein:19,fat:'24,1',sugar:'15,9',categoryId:7},
            {name:'Pork ham, boiled',quantity:'100 g',energy:244,protein:'15,1',fat:'20,2',sugar:'0,9',categoryId:7},
            {name:'Pork ham, tinned',quantity:'100 g',energy:126,protein:'17,6',fat:'6,2',sugar:0,categoryId:7},
            {name:'Pork hamburger',quantity:'100 g',energy:340,protein:'10,6',fat:'26,8',sugar:'13,6',categoryId:7},
            {name:'Pork hearts',quantity:'100 g',energy:165,protein:'16,9',fat:'4,8',sugar:0,categoryId:7},
            {name:'Pork hot-dogs',quantity:'100 g',energy:342,protein:'9,5',fat:'34,3',sugar:0,categoryId:7},
            {name:'Pork kidneys',quantity:'100 g',energy:102,protein:'16,8',fat:'3,8',sugar:0,categoryId:7},
            {name:'Pork leg',quantity:'100 g',energy:261,protein:18,fat:'21,3',sugar:0,categoryId:7},
            {name:'Pork liver',quantity:'100 g',energy:130,protein:22,fat:'3,4',sugar:'2,6',categoryId:7},
            {name:'Pork sausages',quantity:'100 g',energy:332,protein:'10,1',fat:'31,6',sugar:'1,9',categoryId:7},
            {name:'Pork schnitzel',quantity:'100 g',energy:400,protein:'18,8',fat:'32,1',sugar:'9,8',categoryId:7},
            {name:'Pork shish kebabs',quantity:'100 g',energy:324,protein:'26,5',fat:'23,1',sugar:0,categoryId:7},
            {name:'Pork shoulder',quantity:'100 g',energy:257,protein:16,fat:'21,7',sugar:0,categoryId:7},
            {name:'Pork steak',quantity:'100 g',energy:472,protein:'21,7',fat:'42,7',sugar:'1,5',categoryId:7},
            {name:'Pork stew',quantity:'100 g',energy:333,protein:'13,1',fat:'29,4',sugar:'3,9',categoryId:7},
            {name:'Pork tongues',quantity:'100 g',energy:165,protein:'16,5',fat:'11,1',sugar:0,categoryId:7},
            {name:'Pork, boneless bacon',quantity:'100 g',energy:510,protein:'10,1',fat:53,sugar:0,categoryId:7},
            {name:'Pork, knuckle with skin',quantity:'100 g',energy:294,protein:'18,6',fat:'24,7',sugar:0,categoryId:7},
            {name:'Pork, neck',quantity:'100 g',energy:267,protein:'16,1',fat:'22,8',sugar:0,categoryId:7},
            {name:'Pork, raw roast, bone-in',quantity:'100 g',energy:174,protein:21,fat:10,sugar:0,categoryId:7},
            {name:'Rabbit meat',quantity:'100 g',energy:156,protein:21,fat:8,sugar:0,categoryId:7},
            {name:'Raw sausage and smoked ham',quantity:'100 g',energy:514,protein:'20,9',fat:'47,8',sugar:0,categoryId:7},
            {name:'Raw sausage and smoked pork',quantity:'100 g',energy:568,protein:13,fat:'57,3',sugar:0,categoryId:7},
            {name:'Raw-smoked sausage Capital',quantity:'100 g',energy:487,protein:24,fat:'43,4',sugar:0,categoryId:7},
            {name:'Raw-smoked sausage cervelat',quantity:'100 g',energy:461,protein:24,fat:'40,5',sugar:0,categoryId:7},
            {name:'Raw-smoked sausage Moscow',quantity:'100 g',energy:473,protein:'24,8',fat:'41,5',sugar:0,categoryId:7},
            {name:'Rib of beef',quantity:'100 g',energy:117,protein:'20,9',fat:'3,6',sugar:0,categoryId:7},
            {name:'Roast beef',quantity:'100 g',energy:152,protein:'21,5',fat:'7,3',sugar:0,categoryId:7},
            {name:'Roast pork',quantity:'100 g',energy:291,protein:'30,4',fat:'18,7',sugar:'0,7',categoryId:7},
            {name:'Russian Sausage',quantity:'100 g',energy:243,protein:'11,3',fat:22,sugar:0,categoryId:7},
            {name:'Salami',quantity:'100 g',energy:568,protein:'21,6',fat:'53,7',sugar:'1,4',categoryId:7},
            {name:'Salo',quantity:'100 g',energy:797,protein:'2,4',fat:89,sugar:0,categoryId:7},
            {name:'Sausage',quantity:'100 g',energy:170,protein:'12,1',fat:'13,5',sugar:0,categoryId:7},
            {name:'Sausage amateur',quantity:'100 g',energy:304,protein:9,fat:'29,5',sugar:'0,7',categoryId:7},
            {name:'Sausage boiled milk',quantity:'100 g',energy:252,protein:'11,7',fat:'22,8',sugar:0,categoryId:7},
            {name:'Sausage boiled tea',quantity:'100 g',energy:216,protein:'11,7',fat:'18,4',sugar:'1,9',categoryId:7},
            {name:'Sausage cooked dining',quantity:'100 g',energy:319,protein:'11,1',fat:'20,2',sugar:'1,9',categoryId:7},
            {name:'Sausage cooked ham',quantity:'100 g',energy:301,protein:'12,2',fat:28,sugar:0,categoryId:7},
            {name:'Sausage raw-smoked caviar',quantity:'100 g',energy:608,protein:'9,9',fat:'63,2',sugar:0,categoryId:7},
            {name:'Sausage special',quantity:'100 g',energy:270,protein:'11,8',fat:'24,7',sugar:0,categoryId:7},
            {name:'Sausages Dairy',quantity:'100 g',energy:266,protein:11,fat:'23,9',sugar:'1,6',categoryId:7},
            {name:'Sirloin beef',quantity:'100 g',energy:113,protein:'20,1',fat:'3,5',sugar:0,categoryId:7},
            {name:'Sirloin pork',quantity:'100 g',energy:165,protein:'19,9',fat:'9,1',sugar:'0,9',categoryId:7},
            {name:'Smoked sausage, ham',quantity:'100 g',energy:420,protein:'17,3',fat:39,sugar:0,categoryId:7},
            {name:'Stewed beef',quantity:'100 g',energy:220,protein:'16,8',fat:17,sugar:'0,2',categoryId:7},
            {name:'Stewed pork',quantity:'100 g',energy:225,protein:'11,4',fat:'19,8',sugar:'1,2',categoryId:7},
            {name:'Stewed pork ribs',quantity:'100 g',energy:210,protein:'7,9',fat:'19,2',sugar:'2,2',categoryId:7},
            {name:'Stewed pork, canning',quantity:'100 g',energy:349,protein:'14,9',fat:'32,2',sugar:'0,2',categoryId:7},
            {name:'The meat in white sauce (beef), canned',quantity:'100 g',energy:220,protein:18,fat:'14,8',sugar:'3,6',categoryId:7},
            {name:'Thin dry smoked sausage',quantity:'100 g',energy:326,protein:'27,4',fat:'24,3',sugar:0,categoryId:7},
            {name:'Tinned beef',quantity:'100 g',energy:347,protein:'16,9',fat:31,sugar:'0,2',categoryId:7},
            {name:'Tinned pork',quantity:'100 g',energy:217,protein:'20,5',fat:'14,9',sugar:'0,2',categoryId:7},
            {name:'Touristique (lamb), canned',quantity:'100 g',energy:210,protein:18,fat:'15,2',sugar:'0,2',categoryId:7},
            {name:'Turkey fillet',quantity:'100 g',energy:105,protein:'15,8',fat:'4,6',sugar:'0,1',categoryId:7},
            {name:'Turkey ham',quantity:'100 g',energy:84,protein:'17,1',fat:'1,6',sugar:'0,1',categoryId:7},
            {name:'Udder',quantity:'100 g',energy:173,protein:'12,3',fat:'13,7',sugar:0,categoryId:7},
            {name:'Veal cutlet in breadcrumbs',quantity:'100 g',energy:365,protein:'27,1',fat:'21,3',sugar:'17,4',categoryId:7},
            {name:'Veal leg',quantity:'100 g',energy:108,protein:'19,9',fat:'3,1',sugar:0,categoryId:7},
            {name:'Veal liver',quantity:'100 g',energy:124,protein:'19,2',fat:'3,3',sugar:'4,1',categoryId:7},
            {name:'Veal meatballs',quantity:'100 g',energy:250,protein:'16,2',fat:'14,6',sugar:'14,3',categoryId:7},
            {name:'Veal shoulder',quantity:'100 g',energy:106,protein:'19,9',fat:'2,8',sugar:0,categoryId:7},
            {name:'Venison',quantity:'100 g',energy:125,protein:21,fat:'4,5',sugar:0,categoryId:7},
            {name:'Wild duck',quantity:'100 g',energy:121,protein:'22,7',fat:'3,1',sugar:'0,5',categoryId:7}
        ],
        7 : [
            {name:'Anchois ',quantity:'100 g' ,energy:166,protein:'21,2',fat:9,sugar:0,categoryId:8},
            {name:'Atlantic horse mackerel in oil ',quantity:'100 g' ,energy:309,protein:'15,6',fat:'27,4',sugar:0,categoryId:8},
            {name:'Atlantic horse mackerel in tomato sauce ',quantity:'100 g' ,energy:110,protein:'14,8',fat:'2,3',sugar:'7,3',categoryId:8},
            {name:'Balyk – smoked soft parts of sturgeon ',quantity:'100 g' ,energy:194,protein:'20,4',fat:'12,5',sugar:0,categoryId:8},
            {name:'Belica dried ',quantity:'100 g' ,energy:235,protein:'46,4',fat:'5,5',sugar:0,categoryId:8},
            {name:'Black caviar ',quantity:'100 g' ,energy:237,protein:'27,2',fat:'14,2',sugar:0,categoryId:8},
            {name:'Blanched beluga ',quantity:'100 g' ,energy:234,protein:'23,3',fat:'15,6',sugar:0,categoryId:8},
            {name:'Bream ',quantity:'100 g' ,energy:221,protein:42,fat:'5,9',sugar:0,categoryId:8},
            {name:'Bream in tomato sauce ',quantity:'100 g' ,energy:138,protein:'15,3',fat:'7,4',sugar:'2,6',categoryId:8},
            {name:'Carp in tomato sauce ',quantity:'100 g' ,energy:145,protein:'12,4',fat:'8,7',sugar:'4,1',categoryId:8},
            {name:'Catfish in tomato sauce ',quantity:'100 g' ,energy:126,protein:'12,9',fat:'6,3',sugar:'4,3',categoryId:8},
            {name:'Caviar, cod ',quantity:'100 g' ,energy:115,protein:24,fat:'0,2',sugar:0,categoryId:8},
            {name:'Caviar, large ',quantity:'100 g' ,energy:230,protein:'31,2',fat:'11,7',sugar:0,categoryId:8},
            {name:'Caviar, pollock ',quantity:'100 g' ,energy:131,protein:'28,4',fat:'1,9',sugar:0,categoryId:8},
            {name:'Caviar, salmon ',quantity:'100 g' ,energy:251,protein:'31,6',fat:'13,8',sugar:0,categoryId:8},
            {name:'Caviar, siberian sturgeon ',quantity:'100 g' ,energy:221,protein:'28,4',fat:'11,9',sugar:0,categoryId:8},
            {name:'Caviar, sturgeon ',quantity:'100 g' ,energy:236,protein:36,fat:'10,2',sugar:0,categoryId:8},
            {name:'Clams ',quantity:'100 g' ,energy:50,protein:'9,1',fat:'1,5',sugar:0,categoryId:8},
            {name:'Cod liver ',quantity:'100 g' ,energy:610,protein:4,fat:66,sugar:0,categoryId:8},
            {name:'Cod, fish balls ',quantity:'100 g' ,energy:112,protein:'14,2',fat:'2,6',sugar:'8,8',categoryId:8},
            {name:'Cod, fish fillets in breadcrumbs ',quantity:'100 g' ,energy:273,protein:'19,1',fat:'15,8',sugar:'14,6',categoryId:8},
            {name:'Cod, minced cutlet ',quantity:'100 g' ,energy:260,protein:'14,9',fat:'17,8',sugar:'10,9',categoryId:8},
            {name:'Cold smoked cod ',quantity:'100 g' ,energy:94,protein:'22,1',fat:'0,5',sugar:0,categoryId:8},
            {name:'Cooked Atlantic horse mackerel ',quantity:'100 g' ,energy:133,protein:'20,6',fat:'5,6',sugar:0,categoryId:8},
            {name:'Cooked bream ',quantity:'100 g' ,energy:160,protein:'29,7',fat:'4,6',sugar:0,categoryId:8},
            {name:'Cooked burbot ',quantity:'100 g' ,energy:92,protein:'21,4',fat:'0,7',sugar:0,categoryId:8},
            {name:'Cooked carp ',quantity:'100 g' ,energy:102,protein:16,fat:'3,7',sugar:2,categoryId:8},
            {name:'Cooked catfish ',quantity:'100 g' ,energy:196,protein:'18,4',fat:'13,6',sugar:0,categoryId:8},
            {name:'Cooked cod ',quantity:'100 g' ,energy:78,protein:'17,8',fat:'0,7',sugar:0,categoryId:8},
            {name:'Cooked crabs ',quantity:'100 g' ,energy:96,protein:16,fat:'3,6',sugar:0,categoryId:8},
            {name:'Cooked crayfish ',quantity:'100 g' ,energy:97,protein:'20,3',fat:'1,3',sugar:1,categoryId:8},
            {name:'Cooked crucian ',quantity:'100 g' ,energy:102,protein:'20,7',fat:'2,1',sugar:0,categoryId:8},
            {name:'Cooked flounder ',quantity:'100 g' ,energy:103,protein:'18,3',fat:'3,3',sugar:0,categoryId:8},
            {name:'Cooked hake ',quantity:'100 g' ,energy:95,protein:'18,5',fat:'2,3',sugar:0,categoryId:8},
            {name:'Cooked halibut ',quantity:'100 g' ,energy:216,protein:14,fat:'17,8',sugar:0,categoryId:8},
            {name:'Cooked mackerel ',quantity:'100 g' ,energy:124,protein:'22,8',fat:'3,6',sugar:0,categoryId:8},
            {name:'Cooked mackerel – powtórka? – dop tłumacza ',quantity:'100 g' ,energy:211,protein:'19,6',fat:'14,7',sugar:0,categoryId:8},
            {name:'Cooked pike ',quantity:'100 g' ,energy:98,protein:'21,3',fat:'1,3',sugar:0,categoryId:8},
            {name:'Cooked pike-perch ',quantity:'100 g' ,energy:97,protein:'21,3',fat:'1,3',sugar:0,categoryId:8},
            {name:'Cooked pollock ',quantity:'100 g' ,energy:79,protein:'17,6',fat:1,sugar:0,categoryId:8},
            {name:'Cooked prawns ',quantity:'100 g' ,energy:95,protein:'18,9',fat:'2,2',sugar:0,categoryId:8},
            {name:'Cooked sardine ',quantity:'100 g' ,energy:178,protein:'20,1',fat:'10,8',sugar:0,categoryId:8},
            {name:'Cooked sea crayfish ',quantity:'100 g' ,energy:90,protein:'20,5',fat:'0,7',sugar:'0,3',categoryId:8},
            {name:'Cooked sea perch ',quantity:'100 g' ,energy:112,protein:'19,9',fat:'3,6',sugar:0,categoryId:8},
            {name:'Cooked squid ',quantity:'100 g' ,energy:110,protein:18,fat:'4,2',sugar:0,categoryId:8},
            {name:'Cooked sturgeon ',quantity:'100 g' ,energy:179,protein:'17,7',fat:12,sugar:0,categoryId:8},
            {name:'Cooked wolffish ',quantity:'100 g' ,energy:114,protein:'15,5',fat:'5,8',sugar:0,categoryId:8},
            {name:'Fish cutlet of perch ',quantity:'100 g' ,energy:215,protein:'17,6',fat:'12,5',sugar:'8,1',categoryId:8},
            {name:'Fish salad of perch ',quantity:'100 g' ,energy:182,protein:'4,7',fat:'15,7',sugar:'5,5',categoryId:8},
            {name:'Flounder in oil ',quantity:'100 g' ,energy:249,protein:'14,4',fat:'21,3',sugar:0,categoryId:8},
            {name:'Flounder in tomato sauce ',quantity:'100 g' ,energy:125,protein:'12,6',fat:'5,4',sugar:'6,3',categoryId:8},
            {name:'Fresh Atlantic horse mackerel ',quantity:'100 g' ,energy:119,protein:19,fat:5,sugar:0,categoryId:8},
            {name:'Fresh beluga ',quantity:'100 g' ,energy:147,protein:21,fat:'0,7',sugar:0,categoryId:8},
            {name:'Fresh bream ',quantity:'100 g' ,energy:126,protein:'20,9',fat:'4,7',sugar:0,categoryId:8},
            {name:'Fresh burbot ',quantity:'100 g' ,energy:80,protein:'18,8',fat:'0,6',sugar:0,categoryId:8},
            {name:'Fresh capelin ',quantity:'100 g' ,energy:157,protein:'13,4',fat:'11,5',sugar:0,categoryId:8},
            {name:'Fresh carp ',quantity:'100 g' ,energy:110,protein:18,fat:'4,2',sugar:0,categoryId:8},
            {name:'Fresh catfish ',quantity:'100 g' ,energy:143,protein:'16,8',fat:'8,5',sugar:0,categoryId:8},
            {name:'Fresh chum salmon ',quantity:'100 g' ,energy:138,protein:22,fat:'5,6',sugar:0,categoryId:8},
            {name:'Fresh cod ',quantity:'100 g' ,energy:78,protein:'17,7',fat:'0,7',sugar:0,categoryId:8},
            {name:'Fresh crayfish ',quantity:'100 g' ,energy:76,protein:'15,5',fat:1,sugar:'1,2',categoryId:8},
            {name:'Fresh crucian ',quantity:'100 g' ,energy:87,protein:'17,7',fat:'1,8',sugar:0,categoryId:8},
            {name:'Fresh eel ',quantity:'100 g' ,energy:332,protein:'14,5',fat:'30,5',sugar:0,categoryId:8},
            {name:'Fresh flounder ',quantity:'100 g' ,energy:83,protein:'16,5',fat:'1,8',sugar:0,categoryId:8},
            {name:'Fresh hake ',quantity:'100 g' ,energy:86,protein:'16,6',fat:'2,2',sugar:0,categoryId:8},
            {name:'Fresh herring ',quantity:'100 g' ,energy:161,protein:'16,3',fat:'10,7',sugar:0,categoryId:8},
            {name:'Fresh ide ',quantity:'100 g' ,energy:81,protein:'18,2',fat:1,sugar:0,categoryId:8},
            {name:'Fresh mackerel ',quantity:'100 g' ,energy:181,protein:'18,7',fat:'11,9',sugar:0,categoryId:8},
            {name:'Fresh mullet ',quantity:'100 g' ,energy:124,protein:21,fat:'0,4',sugar:0,categoryId:8},
            {name:'Fresh Pacific saury ',quantity:'100 g' ,energy:182,protein:'18,6',fat:12,sugar:0,categoryId:8},
            {name:'Fresh pike ',quantity:'100 g' ,energy:82,protein:'18,4',fat:'0,8',sugar:0,categoryId:8},
            {name:'Fresh pike-perch ',quantity:'100 g' ,energy:84,protein:'19,2',fat:'0,7',sugar:0,categoryId:8},
            {name:'Fresh pollock ',quantity:'100 g' ,energy:73,protein:'16,6',fat:'0,6',sugar:0,categoryId:8},
            {name:'Fresh prawns ',quantity:'100 g' ,energy:97,protein:22,fat:1,sugar:0,categoryId:8},
            {name:'Fresh river perch ',quantity:'100 g' ,energy:82,protein:'18,5',fat:'0,9',sugar:0,categoryId:8},
            {name:'Fresh roach ',quantity:'100 g' ,energy:110,protein:19,fat:'0,4',sugar:0,categoryId:8},
            {name:'Fresh salmon ',quantity:'100 g' ,energy:201,protein:'19,9',fat:'13,6',sugar:0,categoryId:8},
            {name:'Fresh sardine ',quantity:'100 g' ,energy:169,protein:'20,6',fat:'9,6',sugar:0,categoryId:8},
            {name:'Fresh sea crayfish (lobster) ',quantity:'100 g' ,energy:89,protein:'18,8',fat:'1,3',sugar:'0,5',categoryId:8},
            {name:'Fresh sea eel ',quantity:'100 g' ,energy:93,protein:'19,1',fat:'1,9',sugar:0,categoryId:8},
            {name:'Fresh sea perch ',quantity:'100 g' ,energy:117,protein:'17,6',fat:'5,2',sugar:0,categoryId:8},
            {name:'Fresh squid ',quantity:'100 g' ,energy:74,protein:18,fat:'0,3',sugar:0,categoryId:8},
            {name:'Fresh starry sturgeon ',quantity:'100 g' ,energy:160,protein:17,fat:1,sugar:0,categoryId:8},
            {name:'Fresh sterlet ',quantity:'100 g' ,energy:122,protein:17,fat:'6,1',sugar:0,categoryId:8},
            {name:'Fresh sturgeon ',quantity:'100 g' ,energy:163,protein:'16,4',fat:'10,9',sugar:0,categoryId:8},
            {name:'Fresh tuna ',quantity:'100 g' ,energy:101,protein:23,fat:1,sugar:0,categoryId:8},
            {name:'Fresh white halibut ',quantity:'100 g' ,energy:102,protein:'18,9',fat:3,sugar:0,categoryId:8},
            {name:'Fried Atlantic horse mackerel ',quantity:'100 g' ,energy:190,protein:'20,3',fat:'10,5',sugar:'3,7',categoryId:8},
            {name:'Fried cod ',quantity:'100 g' ,energy:111,protein:23,fat:'0,1',sugar:0,categoryId:8},
            {name:'Fried pink salmon ',quantity:'100 g' ,energy:169,protein:'22,1',fat:9,sugar:0,categoryId:8},
            {name:'Fried river perch ',quantity:'100 g' ,energy:180,protein:'20,6',fat:'9,1',sugar:4,categoryId:8},
            {name:'Fried sturgeon ',quantity:'100 g' ,energy:273,protein:16,fat:'17,4',sugar:'13,2',categoryId:8},
            {name:'Fried wolffish ',quantity:'100 g' ,energy:209,protein:'22,2',fat:'11,5',sugar:'4,1',categoryId:8},
            {name:'Grilled cod ',quantity:'100 g' ,energy:172,protein:'22,1',fat:'9,1',sugar:'0,6',categoryId:8},
            {name:'Grilled salmon ',quantity:'100 g' ,energy:283,protein:'20,7',fat:'22,3',sugar:'0,6',categoryId:8},
            {name:'Hake collops ',quantity:'100 g' ,energy:140,protein:'13,1',fat:'5,6',sugar:'9,3',categoryId:8},
            {name:'Herring in oil ',quantity:'100 g' ,energy:301,protein:'16,4',fat:'26,5',sugar:0,categoryId:8},
            {name:'Herring in sour cream ',quantity:'100 g' ,energy:97,protein:'5,5',fat:'6,2',sugar:'5,3',categoryId:8},
            {name:'Herring in tomato sauce ',quantity:'100 g' ,energy:159,protein:'13,8',fat:'9,7',sugar:'4,6',categoryId:8},
            {name:'Hot smoked cod ',quantity:'100 g' ,energy:115,protein:26,fat:'1,2',sugar:0,categoryId:8},
            {name:'Hot smoked red herring ',quantity:'100 g' ,energy:215,protein:'21,8',fat:'14,3',sugar:0,categoryId:8},
            {name:'Hot smoked sea perch ',quantity:'100 g' ,energy:175,protein:'23,5',fat:9,sugar:0,categoryId:8},
            {name:'Oyster ',quantity:'100 g' ,energy:95,protein:14,fat:'0,3',sugar:6,categoryId:8},
            {name:'Pacific saury blanched in oil ',quantity:'100 g' ,energy:283,protein:'18,3',fat:'23,3',sugar:0,categoryId:8},
            {name:'Pike in tomato sauce ',quantity:'100 g' ,energy:108,protein:'14,2',fat:4,sugar:'3,6',categoryId:8},
            {name:'Pike-perch collops ',quantity:'100 g' ,energy:164,protein:'12,1',fat:'7,4',sugar:'12,1',categoryId:8},
            {name:'Pike-perch in tomato sauce ',quantity:'100 g' ,energy:119,protein:14,fat:'5,3',sugar:'3,7',categoryId:8},
            {name:'Pink salmon ',quantity:'100 g' ,energy:168,protein:'22,9',fat:'7,8',sugar:0,categoryId:8},
            {name:'Pink salmon in tomato sauce ',quantity:'100 g' ,energy:132,protein:'14,5',fat:'5,1',sugar:'6,9',categoryId:8},
            {name:'Red caviar ',quantity:'100 g' ,energy:203,protein:28,fat:'9,7',sugar:0,categoryId:8},
            {name:'Roast cod ',quantity:'100 g' ,energy:90,protein:6,fat:'3,7',sugar:8,categoryId:8},
            {name:'Roast river perch ',quantity:'100 g' ,energy:103,protein:'6,8',fat:'4,7',sugar:'8,4',categoryId:8},
            {name:'Salmon ',quantity:'100 g' ,energy:192,protein:'16,5',fat:'12,6',sugar:'3,4',categoryId:8},
            {name:'Salmon sauted ',quantity:'100 g' ,energy:379,protein:'21,1',fat:'31,4',sugar:'4,1',categoryId:8},
            {name:'Salted herring ',quantity:'100 g' ,energy:217,protein:'19,8',fat:'15,4',sugar:0,categoryId:8},
            {name:'Salty chum salmon ',quantity:'100 g' ,energy:184,protein:'24,3',fat:'9,6',sugar:0,categoryId:8},
            {name:'Salty cod ',quantity:'100 g' ,energy:98,protein:'23,1',fat:'0,6',sugar:0,categoryId:8},
            {name:'Salty pink salmon ',quantity:'100 g' ,energy:147,protein:21,fat:7,sugar:0,categoryId:8},
            {name:'Salty salmon ',quantity:'100 g' ,energy:269,protein:21,fat:'20,5',sugar:0,categoryId:8},
            {name:'Salty sprat ',quantity:'100 g' ,energy:137,protein:'17,1',fat:'7,6',sugar:0,categoryId:8},
            {name:'Salty sprat with spices ',quantity:'100 g' ,energy:154,protein:'14,8',fat:'10,5',sugar:0,categoryId:8},
            {name:'Salty tuna ',quantity:'100 g' ,energy:225,protein:'19,8',fat:'16,2',sugar:0,categoryId:8},
            {name:'Sardines in oil ',quantity:'100 g' ,energy:221,protein:'24,1',fat:'13,9',sugar:0,categoryId:8},
            {name:'Sardines in tomatoes ',quantity:'100 g' ,energy:162,protein:17,fat:'9,9',sugar:'1,4',categoryId:8},
            {name:'Sea cabbage ',quantity:'100 g' ,energy:5,protein:'0,9',fat:'0,2',sugar:0,categoryId:8},
            {name:'Small octopus ',quantity:'100 g' ,energy:73,protein:'18,2',fat:0,sugar:0,categoryId:8},
            {name:'Smoked Atlantic horse makcerel ',quantity:'100 g' ,energy:94,protein:'17,1',fat:'2,8',sugar:0,categoryId:8},
            {name:'Smoked belica ',quantity:'100 g' ,energy:181,protein:'31,1',fat:'6,3',sugar:0,categoryId:8},
            {name:'Smoked bream ',quantity:'100 g' ,energy:172,protein:'32,8',fat:'4,5',sugar:0,categoryId:8},
            {name:'Smoked bream ',quantity:'100 g' ,energy:105,protein:'17,1',fat:'4,1',sugar:0,categoryId:8},
            {name:'Smoked eel ',quantity:'100 g' ,energy:326,protein:'17,9',fat:'28,6',sugar:0,categoryId:8},
            {name:'Smoked flounder ',quantity:'100 g' ,energy:192,protein:22,fat:'11,6',sugar:0,categoryId:8},
            {name:'Smoked mackerel ',quantity:'100 g' ,energy:221,protein:'20,7',fat:'15,5',sugar:0,categoryId:8},
            {name:'Smoked salmon ',quantity:'100 g' ,energy:162,protein:'21,5',fat:'8,4',sugar:0,categoryId:8},
            {name:'Smoked sprat ',quantity:'100 g' ,energy:162,protein:'21,3',fat:'8,5',sugar:0,categoryId:8},
            {name:'Smoked sprat in oil ',quantity:'100 g' ,energy:363,protein:'17,4',fat:'32,4',sugar:'0,4',categoryId:8},
            {name:'Starry sturgeon in tomato sauce ',quantity:'100 g' ,energy:179,protein:'16,1',fat:'11,5',sugar:'2,8',categoryId:8},
            {name:'Stewed Atlantic horse mackerel ',quantity:'100 g' ,energy:122,protein:'19,6',fat:'4,8',sugar:0,categoryId:8},
            {name:'Stewed catfish ',quantity:'100 g' ,energy:121,protein:'18,2',fat:'5,4',sugar:0,categoryId:8},
            {name:'Stewed cod ',quantity:'100 g' ,energy:101,protein:'9,7',fat:'5,1',sugar:'3,9',categoryId:8},
            {name:'Stewed pike ',quantity:'100 g' ,energy:90,protein:'19,6',fat:'1,2',sugar:0,categoryId:8},
            {name:'Stewed pike-perch ',quantity:'100 g' ,energy:89,protein:'19,6',fat:'1,2',sugar:0,categoryId:8},
            {name:'Stewed river perch ',quantity:'100 g' ,energy:109,protein:'19,5',fat:'3,5',sugar:0,categoryId:8},
            {name:'Stewed sea perch ',quantity:'100 g' ,energy:120,protein:'10,9',fat:'6,6',sugar:'4,2',categoryId:8},
            {name:'Stewed sturgeon ',quantity:'100 g' ,energy:179,protein:'17,8',fat:'11,9',sugar:0,categoryId:8},
            {name:'Stuffed pike ',quantity:'100 g' ,energy:141,protein:'13,3',fat:6,sugar:'8,4',categoryId:8},
            {name:'Stuffed pike-perch ',quantity:'100 g' ,energy:144,protein:'13,7',fat:6,sugar:'8,7',categoryId:8},
            {name:'Stuffed river perch ',quantity:'100 g' ,energy:130,protein:'14,9',fat:'6,1',sugar:'3,9',categoryId:8},
            {name:'Sturgeon in tomato sauce ',quantity:'100 g' ,energy:181,protein:'14,7',fat:12,sugar:'3,4',categoryId:8},
            {name:'Tinned chum salmon ',quantity:'100 g' ,energy:129,protein:'21,5',fat:'4,8',sugar:0,categoryId:8},
            {name:'Tinned crabs ',quantity:'100 g' ,energy:85,protein:'18,7',fat:'1,1',sugar:'0,1',categoryId:8},
            {name:'Tinned mackerel ',quantity:'100 g' ,energy:258,protein:'16,4',fat:'21,4',sugar:0,categoryId:8},
            {name:'Tinned pink salmon ',quantity:'100 g' ,energy:136,protein:'20,9',fat:'5,8',sugar:0,categoryId:8},
            {name:'Tinned prawns ',quantity:'100 g' ,energy:81,protein:'17,8',fat:'1,1',sugar:0,categoryId:8},
            {name:'Tinned sturgeon ',quantity:'100 g' ,energy:163,protein:'16,4',fat:'10,6',sugar:'0,6',categoryId:8},
            {name:'Trout ',quantity:'100 g' ,energy:97,protein:'19,2',fat:'2,1',sugar:0,categoryId:8},
            {name:'Tuna chunks in oil ',quantity:'100 g' ,energy:190,protein:'27,1',fat:9,sugar:0,categoryId:8},
            {name:'Tuna chunks in spring water ',quantity:'100 g' ,energy:96,protein:21,fat:'1,2',sugar:0,categoryId:8},
            {name:'Whale meat ',quantity:'100 g' ,energy:119,protein:'22,5',fat:'3,2',sugar:0,categoryId:8},
            {name:'Wolffish in cream sauce ',quantity:'100 g' ,energy:137,protein:'7,4',fat:'8,8',sugar:'6,8',categoryId:8}
        ],
        8 : [
            {name:'Apple soup',quantity:'100 ml',energy:42,protein:'0,1',fat:'0,1',sugar:'11,8',categoryId:9},
            {name:'Bean soup',quantity:'100 ml',energy:62,protein:4,fat:'1,8',sugar:10,categoryId:9},
            {name:'Beef stock',quantity:'100 ml',energy:4,protein:'0,6',fat:'0,2',sugar:0,categoryId:9},
            {name:'Cabbage and potato soup',quantity:'100 g',energy:38,protein:1,fat:'3,8',sugar:'2,1',categoryId:9},
            {name:'Cabbage soup',quantity:'100 g',energy:31,protein:'0,9',fat:'2,1',sugar:'3,1',categoryId:9},
            {name:'Cauliflower soup',quantity:'100 ml',energy:28,protein:'1,6',fat:'0,5',sugar:'4,9',categoryId:9},
            {name:'Celery soup',quantity:'100 ml',energy:37,protein:'1,6',fat:'1,8',sugar:'4,5',categoryId:9},
            {name:'Chicken broth',quantity:'100 ml',energy:1,protein:'0,1',fat:0,sugar:0,categoryId:9},
            {name:'Ciorbă de orz',quantity:'100 ml',energy:124,protein:'2,2',fat:'3,1',sugar:'23,5',categoryId:9},
            {name:'Cold beet soup',quantity:'100 ml',energy:36,protein:'0,5',fat:2,sugar:'4,2',categoryId:9},
            {name:'Dill pickle soup',quantity:'100 ml',energy:42,protein:'1,4',fat:2,sugar:5,categoryId:9},
            {name:'Fish broth',quantity:'100 ml',energy:2,protein:'0,4',fat:0,sugar:0,categoryId:9},
            {name:'Fish solyanka – Russian soup',quantity:'100 ml',energy:25,protein:'2,4',fat:'1,2',sugar:'1,2',categoryId:9},
            {name:'Fish soup',quantity:'100 ml',energy:46,protein:'3,4',fat:1,sugar:'5,5',categoryId:9},
            {name:'French bean soup',quantity:'100 ml',energy:43,protein:'2,2',fat:'0,6',sugar:'8,9',categoryId:9},
            {name:'Georgian meat soup',quantity:'100 ml',energy:75,protein:'3,1',fat:'4,5',sugar:'5,5',categoryId:9},
            {name:'Green pea soup',quantity:'100 ml',energy:56,protein:'3,2',fat:'1,2',sugar:'11,2',categoryId:9},
            {name:'Leek and noodle soup',quantity:'100 ml',energy:39,protein:'1,4',fat:'1,1',sugar:'6,6',categoryId:9},
            {name:'Lemon soup with rice',quantity:'100 ml',energy:58,protein:'1,4',fat:'2,2',sugar:'8,7',categoryId:9},
            {name:'Meat and rice soup',quantity:'100 ml',energy:34,protein:'0,7',fat:'1,1',sugar:'5,2',categoryId:9},
            {name:'Mushroom bouillon',quantity:'100 ml',energy:3,protein:'0,5',fat:'0,1',sugar:0,categoryId:9},
            {name:'Mushroom soup',quantity:'100 ml',energy:26,protein:'1,3',fat:'1,8',sugar:'1,3',categoryId:9},
            {name:'Okroshka – cold soup with kefir',quantity:'100 ml',energy:47,protein:'3,1',fat:'1,9',sugar:'4,3',categoryId:9},
            {name:'Okroshka – cold soup with kvass',quantity:'100 ml',energy:52,protein:'2,1',fat:'1,7',sugar:'6,3',categoryId:9},
            {name:'Onion soup',quantity:'100 ml',energy:44,protein:'1,4',fat:'2,7',sugar:4,categoryId:9},
            {name:'Pea soup',quantity:'100 ml',energy:66,protein:'4,4',fat:'2,4',sugar:'8,9',categoryId:9},
            {name:'Pearly soup with mushrooms',quantity:'100 ml',energy:43,protein:'1,6',fat:'1,2',sugar:'6,4',categoryId:9},
            {name:'Potato soup',quantity:'100 ml',energy:39,protein:'1,4',fat:'1,1',sugar:'6,6',categoryId:9},
            {name:'Potato soup with barley',quantity:'100 ml',energy:54,protein:'1,3',fat:'1,2',sugar:'9,5',categoryId:9},
            {name:'Potato soup with noodles',quantity:'100 ml',energy:48,protein:'1,3',fat:1,sugar:'8,4',categoryId:9},
            {name:'Rice soup',quantity:'100 ml',energy:48,protein:'1,4',fat:'1,3',sugar:'7,7',categoryId:9},
            {name:'Sauerkraut and potato soup',quantity:'100 g',energy:32,protein:'0,6',fat:'2,1',sugar:'2,7',categoryId:9},
            {name:'Siberian soup',quantity:'100 ml',energy:48,protein:'1,9',fat:'1,5',sugar:'6,8',categoryId:9},
            {name:'Solyanka – with mushrooms',quantity:'100 ml',energy:134,protein:'3,3',fat:'10,5',sugar:'6,6',categoryId:9},
            {name:'Solyanka – with vegetables',quantity:'100 ml',energy:106,protein:'3,6',fat:7,sugar:'7,1',categoryId:9},
            {name:'Sorrel soup',quantity:'100 ml',energy:40,protein:'1,6',fat:'2,5',sugar:'2,9',categoryId:9},
            {name:'Soup with leguminous plants',quantity:'100 ml',energy:66,protein:'3,4',fat:'2,2',sugar:'1,4',categoryId:9},
            {name:'Sour Russian soup',quantity:'100 g',energy:34,protein:'0,6',fat:'2,8',sugar:'1,5',categoryId:9},
            {name:'Spinach soup with potatoes',quantity:'100 ml',energy:40,protein:'2,2',fat:'0,9',sugar:'6,6',categoryId:9},
            {name:'Summer soup',quantity:'100 ml',energy:49,protein:'1,1',fat:'2,1',sugar:'6,4',categoryId:9},
            {name:'Tomato soup',quantity:'100 ml',energy:28,protein:'1,3',fat:'1,8',sugar:'1,9',categoryId:9},
            {name:'Tomato soup with noodles',quantity:'100 ml',energy:35,protein:'1,5',fat:'1,8',sugar:'3,3',categoryId:9},
            {name:'Tomato soup with rice',quantity:'100 ml',energy:37,protein:'1,5',fat:'1,8',sugar:'3,9',categoryId:9},
            {name:'Tripe',quantity:'100 ml',energy:84,protein:16,fat:'2,2',sugar:0,categoryId:9},
            {name:'Ukrainian borsh',quantity:'100 ml',energy:49,protein:'1,1',fat:'2,2',sugar:'6,7',categoryId:9},
            {name:'Vegetable soup',quantity:'100 ml',energy:43,protein:'1,7',fat:'1,8',sugar:'6,2',categoryId:9},
            {name:'Vegetable soup with beans',quantity:'100 ml',energy:46,protein:'1,6',fat:'2,1',sugar:'5,2',categoryId:9},
            {name:'Wheat soup with meat',quantity:'100 ml',energy:57,protein:'2,9',fat:'2,2',sugar:'6,4',categoryId:9}
        ],
        9 : [
            {name:'Belyashi',quantity:'100 g',energy:223,protein:11,fat:10,sugar:'23,2',categoryId:10},
            {name:'Chebureki',quantity:'100 g',energy:264,protein:'8,9',fat:'13,5',sugar:'26,2',categoryId:10},
            {name:'Cheese and cream pancakes',quantity:'100 g',energy:640,protein:'25,8',fat:'33,1',sugar:'55,2',categoryId:10},
            {name:'Frozen Cheese perogys',quantity:'100 g',energy:198,protein:'10,9',fat:1,sugar:'36,4',categoryId:10},
            {name:'Frozen perogys with cabbage and mushrooms',quantity:'100 g',energy:209,protein:5,fat:'5,7',sugar:'34,5',categoryId:10},
            {name:'Frozen perogys with meat',quantity:'100 g',energy:255,protein:'10,5',fat:'8,2',sugar:'34,8',categoryId:10},
            {name:'Frozen perogys with strawberries',quantity:'100 g',energy:194,protein:'4,3',fat:'0,8',sugar:'42,4',categoryId:10},
            {name:'Frozen Russian perogys',quantity:'100 g',energy:215,protein:'7,2',fat:'3,8',sugar:'37,9',categoryId:10},
            {name:'Kulebyak with rice and fish',quantity:'100 g',energy:206,protein:'10,5',fat:'4,1',sugar:'31,8',categoryId:10},
            {name:'Meat and herbs pizza',quantity:'100 g',energy:327,protein:'16,1',fat:'13,4',sugar:'36,8',categoryId:10},
            {name:'Mushroom and onion pizza',quantity:'100 g',energy:289,protein:12,fat:'13,3',sugar:'32,1',categoryId:10},
            {name:'Pancakes',quantity:'100 g',energy:186,protein:'5,1',fat:'3,1',sugar:'34,3',categoryId:10},
            {name:'Pancakes with cabbage filling',quantity:'100 g',energy:147,protein:'3,2',fat:'9,2',sugar:'15,2',categoryId:10},
            {name:'Pancakes with cheese filling',quantity:'100 g',energy:242,protein:'10,1',fat:'10,3',sugar:'27,4',categoryId:10},
            {name:'Patties fried with cabbage',quantity:'100 g',energy:230,protein:5,fat:'10,5',sugar:'28,8',categoryId:10},
            {name:'Potato dumplings',quantity:'100 g',energy:173,protein:'13,2',fat:7,sugar:'13,8',categoryId:10},
            {name:'Tortellini',quantity:'100 g',energy:224,protein:10,fat:14,sugar:'14,5',categoryId:10},
            {name:'Ukrainian Pampushky (Garlic Rolls)',quantity:'100 g',energy:299,protein:'8,6',fat:'3,3',sugar:'58,8',categoryId:10}
        ],
        10 : [
            {name:'Chicken egg white',quantity:'100 g',energy:49,protein:'10,9',fat:'0,2',sugar:'0,7',categoryId:11},
            {name:'Chicken egg yolk',quantity:'100 g',energy:314,protein:'15,5',fat:'28,2',sugar:'0,3',categoryId:11},
            {name:'Dry egg white',quantity:'100 g',energy:375,protein:'82,4',fat:'1,8',sugar:'7,2',categoryId:11},
            {name:'Dry egg yolk',quantity:'100 g',energy:613,protein:'51,1',fat:'52,2',sugar:'4,7',categoryId:11},
            {name:'Hard-boiled chicken eggs',quantity:'100 g',energy:160,protein:'12,9',fat:'11,6',sugar:'0,8',categoryId:11},
            {name:'Powdered eggs',quantity:'100 g',energy:542,protein:44,fat:'42,4',sugar:'1,8',categoryId:11},
            {name:'Quail eggs',quantity:'100 g',energy:180,protein:'11,9',fat:'13,1',sugar:'0,6',categoryId:11},
            {name:'Scrumbled eggs',quantity:'100 g',energy:119,protein:'9,8',fat:'8,7',sugar:'0,5',categoryId:11},
            {name:'Soft-boiled chicken eggs',quantity:'100 g',energy:159,protein:'12,8',fat:'11,6',sugar:'0,8',categoryId:11},
            {name:'Sunny side up eggs',quantity:'100 g',energy:168,protein:'9,9',fat:'14,2',sugar:'0,6',categoryId:11},
            {name:'Whole chicken eggs',quantity:'100 g',energy:139,protein:'12,5',fat:'9,7',sugar:'0,6',categoryId:11}
        ],
        11 : [
            {name:'Armillaria',quantity:'100 g',energy:17,protein:'2,2',fat:'1,2',sugar:'0,5',categoryId:12},
            {name:'Boletus luteus',quantity:'100 g',energy:9,protein:'2,4',fat:'0,7',sugar:'0,5',categoryId:12},
            {name:'Button mushrooms',quantity:'100 g',energy:15,protein:'2,1',fat:'0,5',sugar:'0,5',categoryId:12},
            {name:'Chantarelle',quantity:'100 g',energy:20,protein:'1,6',fat:'1,1',sugar:'1,5',categoryId:12},
            {name:'Dolmati',quantity:'100 g',energy:15,protein:'1,7',fat:'0,7',sugar:'1,5',categoryId:12},
            {name:'Dried porcini',quantity:'100 g',energy:211,protein:'27,6',fat:'6,8',sugar:10,categoryId:12},
            {name:'Leccinum aurantiacum, dried',quantity:'100 g',energy:32,protein:'2,3',fat:'0,9',sugar:'3,7',categoryId:12},
            {name:'Leccinum aurantiacum, fresh',quantity:'100 g',energy:231,protein:'23,5',fat:'9,2',sugar:'14,3',categoryId:12},
            {name:'Leccinum, fresh',quantity:'100 g',energy:31,protein:'3,3',fat:'0,5',sugar:'3,4',categoryId:12},
            {name:'Milk-agaric',quantity:'100 g',energy:16,protein:'1,8',fat:'0,5',sugar:'0,8',categoryId:12},
            {name:'Porcini (Boletus edulis) fresh',quantity:'100 g',energy:25,protein:'3,2',fat:'0,7',sugar:'1,6',categoryId:12},
            {name:'Red-cap boletus dried',quantity:'100 g',energy:239,protein:'35,4',fat:'5,4',sugar:'12,9',categoryId:12}
        ],
        12 : [
            {name:'Beef melted',quantity:'100 ml',energy:902,protein:0,fat:100,sugar:0,categoryId:13},
            {name:'Butter pop-corn',quantity:'100 g',energy:518,protein:9,fat:'28,1',sugar:'57,1',categoryId:13},
            {name:'Chips',quantity:'100 g',energy:549,protein:6,fat:40,sugar:'50,4',categoryId:13},
            {name:'Corn oil',quantity:'100 ml',energy:884,protein:0,fat:100,sugar:0,categoryId:13},
            {name:'Corn puffs',quantity:'100 g',energy:352,protein:'8,9',fat:3,sugar:'78,9',categoryId:13},
            {name:'Cream rusks',quantity:'100 g',energy:399,protein:'8,5',fat:'10,8',sugar:'66,7',categoryId:13},
            {name:'Dry fruit',quantity:'100 g',energy:317,protein:'10,4',fat:'1,3',sugar:'64,1',categoryId:13},
            {name:'Fat Chicken',quantity:'100 g',energy:897,protein:0,fat:100,sugar:0,categoryId:13},
            {name:'Fat Cod liver',quantity:'100 ml',energy:898,protein:0,fat:100,sugar:0,categoryId:13},
            {name:'Fat melted sheep',quantity:'100 ml',energy:902,protein:0,fat:100,sugar:0,categoryId:13},
            {name:'Fat pig',quantity:'100 g',energy:816,protein:'1,4',fat:90,sugar:0,categoryId:13},
            {name:'Fat salt pork',quantity:'100 g',energy:816,protein:'1,4',fat:90,sugar:0,categoryId:13},
            {name:'Lard',quantity:'100 g',energy:880,protein:0,fat:'99,5',sugar:0,categoryId:13},
            {name:'Low-fat margarine',quantity:'100 g',energy:545,protein:'0,5',fat:60,sugar:'0,7',categoryId:13},
            {name:'Margarine',quantity:'100 g',energy:531,protein:0,fat:60,sugar:0,categoryId:13},
            {name:'Margarine cream',quantity:'100 g',energy:745,protein:'0,5',fat:82,sugar:0,categoryId:13},
            {name:'Margarine Slavic',quantity:'100 g',energy:743,protein:'0,3',fat:82,sugar:21,categoryId:13},
            {name:'Milk margarine',quantity:'100 g',energy:743,protein:'0,3',fat:82,sugar:'17,4',categoryId:13},
            {name:'Non-fat pop-corn',quantity:'100 g',energy:397,protein:12,fat:'4,2',sugar:'77,9',categoryId:13},
            {name:'Olive oil',quantity:'100 ml',energy:882,protein:0,fat:'99,6',sugar:'0,2',categoryId:13},
            {name:'Pretzels',quantity:'100 g',energy:335,protein:'10,9',fat:'1,3',sugar:68,categoryId:13},
            {name:'Salt sticks',quantity:'100 g',energy:385,protein:'9,9',fat:'4,9',sugar:'75,2',categoryId:13},
            {name:'Soya and turnip oli',quantity:'100 ml',energy:884,protein:0,fat:100,sugar:0,categoryId:13},
            {name:'Soya oil',quantity:'100 ml',energy:884,protein:0,fat:100,sugar:0,categoryId:13},
            {name:'Sunflower oil',quantity:'100 ml',energy:884,protein:0,fat:100,sugar:0,categoryId:13},
            {name:'Sweet sticks',quantity:'100 g',energy:373,protein:'9,7',fat:6,sugar:'69,2',categoryId:13},
            {name:'Turnip oil',quantity:'100 ml',energy:900,protein:0,fat:100,sugar:0,categoryId:13}
        ],
        13 : [
            {name:'Advocate',quantity:'100 ml',energy:280,protein:'4,4',fat:6,sugar:'28,4',categoryId:14},
            {name:'Brandy 40%',quantity:'100 ml',energy:225,protein:0,fat:0,sugar:'0,5',categoryId:14},
            {name:'Brown beer',quantity:'100 ml',energy:48,protein:'0,3',fat:0,sugar:'5,7',categoryId:14},
            {name:'Cognac 40%',quantity:'100 ml',energy:239,protein:0,fat:0,sugar:'0,1',categoryId:14},
            {name:'Dry red wine',quantity:'100 ml',energy:75,protein:0,fat:0,sugar:3,categoryId:14},
            {name:'Dry white wine',quantity:'100 ml',energy:73,protein:0,fat:0,sugar:'2,4',categoryId:14},
            {name:'Fruit nalevka',quantity:'100 ml',energy:215,protein:0,fat:0,sugar:28,categoryId:14},
            {name:'Gin 40%',quantity:'100 ml',energy:220,protein:0,fat:0,sugar:0,categoryId:14},
            {name:'Light beer',quantity:'100 ml',energy:42,protein:'0,3',fat:0,sugar:'4,6',categoryId:14},
            {name:'Liqueur 24%',quantity:'100 ml',energy:345,protein:0,fat:0,sugar:53,categoryId:14},
            {name:'Madera 18%',quantity:'100 ml',energy:139,protein:0,fat:0,sugar:10,categoryId:14},
            {name:'Non-alcoholic beer',quantity:'100 ml',energy:27,protein:'0,2',fat:0,sugar:'5,2',categoryId:14},
            {name:'Portwine 20%',quantity:'100 ml',energy:167,protein:0,fat:0,sugar:'13,7',categoryId:14},
            {name:'Punch 26%',quantity:'100 ml',energy:260,protein:0,fat:0,sugar:30,categoryId:14},
            {name:'Rum 40%',quantity:'100 ml',energy:220,protein:0,fat:0,sugar:0,categoryId:14},
            {name:'Semi-dry shampagne',quantity:'100 ml',energy:83,protein:'0,1',fat:0,sugar:'3,4',categoryId:14},
            {name:'Semi-dry wine',quantity:'100 ml',energy:78,protein:0,fat:0,sugar:'3,7',categoryId:14},
            {name:'Semi-sweet red wine',quantity:'100 ml',energy:96,protein:0,fat:0,sugar:'5,5',categoryId:14},
            {name:'Semi-sweet shampagne',quantity:'100 ml',energy:97,protein:'0,2',fat:0,sugar:7,categoryId:14},
            {name:'Semi-sweet white wine',quantity:'100 ml',energy:92,protein:0,fat:0,sugar:'4,4',categoryId:14},
            {name:'Sherry 20%',quantity:'100 ml',energy:152,protein:0,fat:0,sugar:10,categoryId:14},
            {name:'Sweet red wine',quantity:'100 ml',energy:106,protein:0,fat:0,sugar:'8,2',categoryId:14},
            {name:'Sweet shampagne',quantity:'100 ml',energy:117,protein:'0,2',fat:0,sugar:12,categoryId:14},
            {name:'Vermouth 13%',quantity:'100 ml',energy:158,protein:0,fat:0,sugar:'15,9',categoryId:14},
            {name:'Vodka 40%',quantity:'100 ml',energy:235,protein:0,fat:0,sugar:'0,1',categoryId:14},
            {name:'Whisky 40%',quantity:'100 ml',energy:220,protein:0,fat:0,sugar:0,categoryId:14}
        ],
        14 : [
            {name:'Apple compote',quantity:'100 ml',energy:85,protein:'0,2',fat:0,sugar:'22,1',categoryId:15},
            {name:'Apple juice',quantity:'100 ml',energy:42,protein:'0,1',fat:'0,1',sugar:10,categoryId:15},
            {name:'Apricot compote',quantity:'100 ml',energy:85,protein:'0,5',fat:0,sugar:21,categoryId:15},
            {name:'Apricot juice',quantity:'100 ml',energy:56,protein:'0,5',fat:0,sugar:'13,7',categoryId:15},
            {name:'Aronia juice-Ash',quantity:'100 ml',energy:32,protein:'0,1',fat:0,sugar:'7,4',categoryId:15},
            {name:'Beet juice',quantity:'100 ml',energy:42,protein:1,fat:0,sugar:'9,9',categoryId:15},
            {name:'Black tea granules',quantity:'100 ml',energy:0,protein:0,fat:0,sugar:0,categoryId:15},
            {name:'Blackcurrant juice',quantity:'100 ml',energy:40,protein:'0,5',fat:0,sugar:'7,9',categoryId:15},
            {name:'Carrot juice',quantity:'100 ml',energy:43,protein:'0,4',fat:'0,1',sugar:'11,3',categoryId:15},
            {name:'Cereal coffee',quantity:'100 ml',energy:337,protein:6,fat:'4,8',sugar:'71,2',categoryId:15},
            {name:'Cherry juice',quantity:'100 ml',energy:47,protein:'0,7',fat:0,sugar:'10,2',categoryId:15},
            {name:'Cocoa with condensed cream with sugar',quantity:'100 ml',energy:345,protein:'8,2',fat:'15,5',sugar:'48,3',categoryId:15},
            {name:'Cocoa with sweetened condensed milk',quantity:'100 ml',energy:309,protein:'8,2',fat:'7,5',sugar:'54,9',categoryId:15},
            {name:'Coffee beans',quantity:'100 ml',energy:202,protein:'13,9',fat:'14,4',sugar:'2,8',categoryId:15},
            {name:'Coffee with evaporated milk',quantity:'100 ml',energy:55,protein:'0,7',fat:'0,9',sugar:'10,9',categoryId:15},
            {name:'Coffee with evaporated milk and sugar',quantity:'100 ml',energy:324,protein:'8,4',fat:'8,6',sugar:53,categoryId:15},
            {name:'Coffee with milk',quantity:'100 ml',energy:58,protein:'0,7',fat:1,sugar:'11,2',categoryId:15},
            {name:'Coffee with no sugar',quantity:'100 ml',energy:2,protein:'0,2',fat:0,sugar:'0,3',categoryId:15},
            {name:'Coke',quantity:'100 ml',energy:42,protein:0,fat:0,sugar:'10,4',categoryId:15},
            {name:'Coke light',quantity:'100 ml',energy:49,protein:'2,2',fat:0,sugar:'10,1',categoryId:15},
            {name:'Fruit drink, carbonated',quantity:'100 ml',energy:42,protein:0,fat:0,sugar:'10,3',categoryId:15},
            {name:'Gooseberry and blackberry compote',quantity:'100 ml',energy:58,protein:'0,3',fat:'0,1',sugar:'13,9',categoryId:15},
            {name:'Grape compote',quantity:'100 ml',energy:77,protein:'0,5',fat:0,sugar:'19,7',categoryId:15},
            {name:'Grape juice',quantity:'100 ml',energy:54,protein:'0,3',fat:0,sugar:'13,8',categoryId:15},
            {name:'Grapefruit juice',quantity:'100 ml',energy:40,protein:'0,5',fat:'0,1',sugar:'9,2',categoryId:15},
            {name:'Green tea',quantity:'100 ml',energy:28,protein:'0,1',fat:0,sugar:'6,8',categoryId:15},
            {name:'Instant cocoa',quantity:'100 g',energy:381,protein:6,fat:'4,8',sugar:'81,2',categoryId:15},
            {name:'Instant coffee',quantity:'100 g',energy:95,protein:15,fat:'3,6',sugar:0,categoryId:15},
            {name:'Kvass',quantity:'100 ml',energy:27,protein:'0,2',fat:0,sugar:'5,2',categoryId:15},
            {name:'Lemon juice',quantity:'100 ml',energy:30,protein:'0,4',fat:'0,3',sugar:'6,4',categoryId:15},
            {name:'Mandarin juice',quantity:'100 ml',energy:43,protein:'0,8',fat:0,sugar:9,categoryId:15},
            {name:'Multi-vegetable juice',quantity:'100 ml',energy:25,protein:1,fat:'0,3',sugar:'5,7',categoryId:15},
            {name:'Orange juice',quantity:'100 ml',energy:43,protein:'0,6',fat:'0,1',sugar:'9,9',categoryId:15},
            {name:'Peach compote',quantity:'100 ml',energy:78,protein:'0,5',fat:0,sugar:'19,9',categoryId:15},
            {name:'Peach juice',quantity:'100 ml',energy:66,protein:'0,3',fat:0,sugar:17,categoryId:15},
            {name:'Pear compote',quantity:'100 ml',energy:70,protein:'0,2',fat:0,sugar:'18,2',categoryId:15},
            {name:'Pineapple juice',quantity:'100 ml',energy:48,protein:'0,3',fat:'0,1',sugar:'11,4',categoryId:15},
            {name:'Plum compote',quantity:'100 ml',energy:96,protein:'0,5',fat:0,sugar:'23,9',categoryId:15},
            {name:'Plum juice',quantity:'100 ml',energy:66,protein:'0,3',fat:0,sugar:'16,1',categoryId:15},
            {name:'Pomegranate juice',quantity:'100 ml',energy:64,protein:'0,3',fat:0,sugar:'14,5',categoryId:15},
            {name:'Powdered cocoa',quantity:'100 g',energy:448,protein:'18,2',fat:'21,7',sugar:'50,6',categoryId:15},
            {name:'Quince compote',quantity:'100 ml',energy:79,protein:'0,4',fat:0,sugar:20,categoryId:15},
            {name:'Quince juice',quantity:'100 ml',energy:45,protein:'0,5',fat:0,sugar:'10,4',categoryId:15},
            {name:'rose hip',quantity:'100 ml',energy:70,protein:'0,1',fat:0,sugar:'17,6',categoryId:15},
            {name:'Sour cherry compote',quantity:'100 ml',energy:99,protein:'0,6',fat:0,sugar:'24,5',categoryId:15},
            {name:'Sweet cherry compote',quantity:'100 ml',energy:78,protein:'0,5',fat:0,sugar:'19,9',categoryId:15},
            {name:'Tangerine compote',quantity:'100 ml',energy:69,protein:'0,1',fat:0,sugar:'18,1',categoryId:15},
            {name:'Tea with lemon',quantity:'100 ml',energy:43,protein:'0,7',fat:'0,8',sugar:'8,2',categoryId:15},
            {name:'Tea with milk',quantity:'100 ml',energy:146,protein:20,fat:'5,1',sugar:4,categoryId:15},
            {name:'Tea, with no sugar',quantity:'100 ml',energy:0,protein:'0,1',fat:0,sugar:0,categoryId:15},
            {name:'Tomato juice',quantity:'100 ml',energy:13,protein:'0,8',fat:'0,1',sugar:'2,6',categoryId:15}
        ],
        15 : [
            {name:'Apple sauce',quantity:'100 g',energy:275,protein:'0,3',fat:'67,6',sugar:'0,1',categoryId:16},
            {name:'Baker’s yeast',quantity:'100 g',energy:109,protein:'12,7',fat:'8,5',sugar:'2,7',categoryId:16},
            {name:'Bee honey',quantity:'100 ml',energy:324,protein:0,fat:0,sugar:'79,5',categoryId:16},
            {name:'Blackberry sauce',quantity:'100 g',energy:77,protein:'0,4',fat:0,sugar:'19,4',categoryId:16},
            {name:'Breadcrumbs',quantity:'100 g',energy:347,protein:'9,7',fat:'1,9',sugar:'77,6',categoryId:16},
            {name:'Brown sauce',quantity:'100 g',energy:48,protein:'1,1',fat:'6,2',sugar:2,categoryId:16},
            {name:'Chocolate butter',quantity:'100 g',energy:600,protein:'2,5',fat:60,sugar:10,categoryId:16},
            {name:'Coconut',quantity:'100 g',energy:606,protein:'5,6',fat:'63,2',sugar:27,categoryId:16},
            {name:'Cranberry sauce',quantity:'100 g',energy:51,protein:0,fat:'12,6',sugar:0,categoryId:16},
            {name:'Cream sauce',quantity:'100 g',energy:78,protein:'1,9',fat:'5,7',sugar:'5,2',categoryId:16},
            {name:'European mayonnaise',quantity:'100 g',energy:665,protein:'1,4',fat:72,sugar:'2,6',categoryId:16},
            {name:'Gelatine',quantity:'100 g',energy:355,protein:'87,2',fat:'0,4',sugar:'0,7',categoryId:16},
            {name:'Horseradish sauce',quantity:'100 g',energy:27,protein:'0,7',fat:'4,2',sugar:'0,1',categoryId:16},
            {name:'Hot tomato sauce',quantity:'100 g',energy:98,protein:'2,5',fat:0,sugar:'21,8',categoryId:16},
            {name:'Ketchup',quantity:'100 g',energy:93,protein:'1,8',fat:1,sugar:'22,2',categoryId:16},
            {name:'Light mayonnaise',quantity:'100 g',energy:204,protein:'1,4',fat:20,sugar:'4,4',categoryId:16},
            {name:'Mayonnaise',quantity:'100 g',energy:714,protein:'1,3',fat:79,sugar:'2,6',categoryId:16},
            {name:'Mayonnaise and cream sauce',quantity:'100 g',energy:312,protein:'2,8',fat:'3,3',sugar:'31,9',categoryId:16},
            {name:'Milk sauce',quantity:'100 g',energy:84,protein:2,fat:'7,1',sugar:'5,2',categoryId:16},
            {name:'Mushroom sauce',quantity:'100 g',energy:82,protein:'1,2',fat:'4,8',sugar:'6,2',categoryId:16},
            {name:'Mustard',quantity:'100 g',energy:162,protein:'5,7',fat:'6,4',sugar:22,categoryId:16},
            {name:'Mustard powder',quantity:'100 g',energy:378,protein:'37,1',fat:'32,6',sugar:'11,1',categoryId:16},
            {name:'Nutella',quantity:'100 g',energy:249,protein:'4,2',fat:10,sugar:'37,7',categoryId:16},
            {name:'Onion sauce',quantity:'100 g',energy:75,protein:'1,3',fat:'6,1',sugar:'4,8',categoryId:16},
            {name:'Peanut butter',quantity:'100 g',energy:645,protein:21,fat:59,sugar:15,categoryId:16},
            {name:'Potato starch',quantity:'100 g',energy:343,protein:'0,6',fat:'0,1',sugar:'83,9',categoryId:16},
            {name:'Provansal mayonnaise',quantity:'100 g',energy:627,protein:'2,4',fat:67,sugar:'3,9',categoryId:16},
            {name:'Russian mustard',quantity:'100 g',energy:179,protein:0,fat:10,sugar:11,categoryId:16},
            {name:'Salt',quantity:'100 g',energy:0,protein:0,fat:0,sugar:0,categoryId:16},
            {name:'Sugar',quantity:'100 g',energy:405,protein:0,fat:0,sugar:'99,8',categoryId:16},
            {name:'Sugar cubes',quantity:'100 g',energy:379,protein:0,fat:0,sugar:'99,9',categoryId:16},
            {name:'Tomato paste',quantity:'100 g',energy:92,protein:'5,6',fat:'1,5',sugar:'16,7',categoryId:16},
            {name:'Tomato sauce',quantity:'100 g',energy:80,protein:'1,7',fat:'7,8',sugar:'4,5',categoryId:16},
            {name:'White sauce',quantity:'100 g',energy:56,protein:1,fat:'3,8',sugar:'4,1',categoryId:16},
            {name:'Wine vinegar 3%',quantity:'100 ml',energy:9,protein:0,fat:0,sugar:0,categoryId:16}
        ]
    };

    return {
        getCaloriesByCategory: function(categoryId) {
            return caloriesList[categoryId]
        }
    }
});