/**
 * 合成ファイル.
 */
var _BLEND = function() {
	// サムネイルもこの配列にいれるべし。
	this.filters = [];
	/**
	 * initialize
	 * 初期化
	 */
	this.initialize = function() {
		// 11個（最左がクリア）将来はフォルダ名と合わせよう。
		var blendType = ["Marron","Warm","Beauty","Lomo","Normal","Shower","Light02","Shadow","Chain","Balloon","Light04","Gift"];
		for(var i in blendType){
			var recipes = [];

			switch (blendType[i]){
				case "Normal":
					// 合成画像／レシピなし
					break;
				case "Marron":
					// 合成画像（Marronは実はWarm）
					var img1 = document.createElement("img");
					var img2 = document.createElement("img");
					img1.src = "img/filter/warm/filter01.png";
					img2.src = "img/filter/warm/filter02.png";
					// レシピ
					var recipe0 = {type:"level", brightness:30,contrast:0};
					var recipe1 = {type:"blend", amount:1, mode:"screen", image: img1};
					var recipe2 = {type:"blend", amount:1, mode:"normal", image: img2};
					recipes = [ recipe0, recipe1, recipe2 ];
					break;

				case "Shadow":
					// 合成画像（Shadowは実はsilhouette）
					var img1 = document.createElement("img");
					var img2 = document.createElement("img");
					var img3 = document.createElement("img");
					img1.src = "img/filter/silhouette/filter01.png";
					img2.src = "img/filter/silhouette/filter02.png";
					img3.src = "img/filter/silhouette/filter03.png";
					// レシピ
					var recipe0 = {type:"level", brightness:40,contrast:0};
					var recipe1 = {type:"blend", amount:1, mode:"overlay", image: img1};
					var recipe2 = {type:"blend", amount:1, mode:"normal",  image: img2};
					var recipe3 = {type:"blend", amount:1, mode:"screen",  image: img3};
					recipes = [ recipe0, recipe1, recipe2, recipe3];
					break;
				case "Gift":
					// 合成画像（Giftは実はst_valentine）
					var img1 = document.createElement("img");
					var img2 = document.createElement("img");
					var img3 = document.createElement("img");
					var img4 = document.createElement("img");
					img1.src = "img/filter/st_valentine/filter01.png";
					img2.src = "img/filter/st_valentine/filter02.png";
					img3.src = "img/filter/st_valentine/filter03.png";
					img4.src = "img/filter/st_valentine/filter04.png";
					// レシピ
					var recipe0 = {type:"level", brightness:50,contrast:0};
					var recipe1 = {type:"blend", amount:1, mode:"normal",   image: img1};
					var recipe2 = {type:"blend", amount:1, mode:"lighten",  image: img2};
					var recipe3 = {type:"blend", amount:1, mode:"softlight",image: img3};
					var recipe4 = {type:"blend", amount:1, mode:"screen",   image: img4};
					recipes = [ recipe0, recipe1, recipe2, recipe3, recipe4];
					break;
				case "Light02":
					// 合成画像
					var img1 = document.createElement("img");
					img1.src = "img/filter/light02/filter01.png";
					// レシピ
					var recipe0 = {type:"level", brightness:100,contrast:0};
					var recipe1 = {type:"blend", amount:1, mode:"screen",   image: img1};
					recipes = [ recipe0, recipe1];
					break;
				case "Warm":
					// 合成画像（Warmは実はhefe）
					var img1 = document.createElement("img");
					var img2 = document.createElement("img");
					var img3 = document.createElement("img");
					var img4 = document.createElement("img");
					img1.src = "img/filter/hefe/filter01.png";
					img2.src = "img/filter/hefe/filter02.png";
					img3.src = "img/filter/hefe/filter03.png";
					img4.src = "img/filter/hefe/filter04.png";
					// レシピ
					var recipe0 = {type:"level", brightness:50,contrast:0};
					var recipe1 = {type:"blend", amount:1, mode:"linearburn", image: img1};
					var recipe2 = {type:"blend", amount:1, mode:"lighten",  image: img2};
					var recipe3 = {type:"blend", amount:1, mode:"overlay",  image: img3};
					var recipe4 = {type:"blend", amount:1, mode:"normal",   image: img4};
					recipes = [ recipe0, recipe1, recipe2, recipe3, recipe4];
					break;
				case "Chain":
					// 合成画像
					var img1 = document.createElement("img");
					var img2 = document.createElement("img");
					var img3 = document.createElement("img");
					img1.src = "img/filter/chain/filter01.png";
					img2.src = "img/filter/chain/filter02.png";
					img3.src = "img/filter/chain/filter03.png";
					// レシピ
					var recipe0 = {type:"level", brightness:60,contrast:0};
					var recipe1 = {type:"blend", amount:1, mode:"screen",  image: img1};
					var recipe2 = {type:"blend", amount:1, mode:"normal",  image: img2};
					var recipe3 = {type:"blend", amount:1, mode:"screen",  image: img3};
					recipes = [ recipe0, recipe1, recipe2, recipe3];
					break;
				case "Beauty":
					// 合成画像
					var img1 = document.createElement("img");
					img1.src = "img/filter/beauty/filter01.png";
					// レシピ
					var recipe0 = {type:"level", brightness:70,contrast:0};
					var recipe1 = {type:"blend", amount:1, mode:"normal",   image: img1};
					recipes = [ recipe0, recipe1];
					break;
				case "Balloon":
					// 合成画像
					var img1 = document.createElement("img");
					var img2 = document.createElement("img");
					img1.src = "img/filter/balloon/filter01.png";
					img2.src = "img/filter/balloon/filter02.png";
					// レシピ
					var recipe0 = {type:"level", brightness:80,contrast:0};
					var recipe1 = {type:"blend", amount:0.8, mode:"screen", image: img1};
					var recipe2 = {type:"blend", amount:1, mode:"normal", image: img2};
					recipes = [ recipe0, recipe1, recipe2 ];
					break;
				case "Light04":
					// 合成画像
					var img1 = document.createElement("img");
					img1.src = "img/filter/light04/filter01.png";
					// レシピ
					var recipe0 = {type:"level", brightness:80,contrast:0};
					var recipe1 = {type:"blend", amount:1, mode:"screen",   image: img1};
					recipes = [ recipe0, recipe1];
					break;
				case "Lomo":
					// 合成画像
					var img1 = document.createElement("img");
					var img2 = document.createElement("img");
					img1.src = "img/filter/lomo/filter01.png";
					img2.src = "img/filter/lomo/filter02.png";
					// レシピ
					var recipe0 = {type:"level", brightness:40,contrast:0.3};
					var recipe1 = {type:"blend", amount:1, mode:"screen", image: img1};
					var recipe2 = {type:"blend", amount:0.8, mode:"normal", image: img2};
					recipes = [ recipe0, recipe1, recipe2 ];
					break;
				case "Shower":
					var img1 = document.createElement("img");
					var img2 = document.createElement("img");
					var img3 = document.createElement("img");
					var img4 = document.createElement("img");
					img1.src = "img/filter/shower/filter01.png";
					img2.src = "img/filter/shower/filter02.png";
					img3.src = "img/filter/shower/filter03.png";
					img4.src = "img/filter/shower/filter04.png";
					// レシピ
					var recipe0 = {type:"level", brightness:65,contrast:0};
					var recipe1 = {type:"blend", amount:1, mode:"screen",    image: img1};
					var recipe2 = {type:"blend", amount:1, mode:"normal",    image: img2};
					var recipe3 = {type:"blend", amount:1, mode:"softlight", image: img3};
					var recipe4 = {type:"blend", amount:1, mode:"screen",    image: img4};
					recipes = [ recipe0, recipe1, recipe2, recipe3, recipe4];
					break;
			}
			this.filters[i] = {name: blendType[i], filter: recipes};
		}
	}

	this.getFilter = function(idx) {
		return this.filters[idx];
	}

	this.initialize();
	return this;
}