'use strict';

/*************************************************
 *
 *  MODULE : INDEX 
 *
 *************************************************
 */

// アプリかどうかの判別
var IS_APP = 'MozActivity' in window;

// 共通クラス
var COMMON;

//ボタンフラグ
var btnFlag = true;

//ローディング
var　loader = document.getElementById('over');

//window横幅
var winW = window.innerWidth;


/*
 * コンストラクタ
 */
document.addEventListener("DOMContentLoaded", function() {
	// COMMONクラス生成
	COMMON = new _COMMON();

	// スプラッシュ画面
	setTimeout(function () {
		var splash = document.getElementById('splash');
		if (splash){
			splash.className = 'hidden';
		}
	}, 100);

	// GA
	ga('create', 'UA-47970379-3', 'auto');
	ga('send', 'pageview');
});

/**********************
 *
 *  CLASS : _COMMON
 *
 */
var _COMMON = function() {
	var that = this;
	// 写真モジュール
	this.PICTURE;
	this.CAMERA;
	this.ROUTER;

	// UIパーツ
	this.RGBTool   = {};
	this.HSVTool   = {};
	this.Filter    = {};

	// initialize ----------------------------------------
	/**
	 * initialize
	 * 初期化
	 */
	this.initialize = function() {
		// ルータクラスを作成
		this.ROUTER = new _ROUTER();
		// ピクチャークラスを生成
		this.PICTURE = new _PICTURE();
		// カメラクラスを作成
		this.CAMERA = new _CAMERA();
		// カメラ関連を初期化
		this.initCameraAndSave();
		// ツールバーを初期化
		this.initTool();
		// フィルターを初期化
		this.initFilter();

	};

	/**
	 * initCameraAndSave
	 * ヘッダーを初期化
	 */
	this.initCameraAndSave = function() {
		var launchCamera = function() {
			if(IS_APP) {
				that.CAMERA.pick(function() {
					that.PICTURE.reset();
					that.initToolValue();
					that.PICTURE.setImage(window.URL.createObjectURL(this.result.blob));
				});
			} else {
				that.PICTURE.reset();
				var sampleImagePath = "img/deputy_manager_photo.jpg";
				that.PICTURE.setImage(sampleImagePath);
			}
		};
		// カメラボタン(Welcome画面)
		document.getElementById('btn_camera').addEventListener("click",
			function() {
				if(IS_APP) {
					ga('send', 'event', 'welcome', 'click', 'camera', 1);
					launchCamera();
				} else {
					window.location.href = "#edit";
				}
			}			
		);
		// 戻るボタン(カメラ)
		document.getElementById('btn_home').addEventListener("touchend",
			function() {
				ga('send', 'event', 'edit', 'click', 'back', 1);
				launchCamera();
			}
		);
		// 保存ボタン
		document.getElementById('btn_save').addEventListener("touchend",
			function(e) {
				ga('send', 'event', 'edit', 'click', 'save', 1);
				if(IS_APP) {
					e.preventDefault();
					that.PICTURE.save(function() {
						that.PICTURE.reset();
						that.initToolValue();
						window.location.href = "#confirm";
					});
				} else {
					that.PICTURE.reset();
					that.initToolValue();
				}
			}
		);
		document.getElementById('btn_yes').addEventListener("click",
			function() {
				if(IS_APP) {
					var sharingImage = new MozActivity({
						name: "share",
						data: {
							type: "image/*",
							number: 1,
							blobs: [that.PICTURE.blob]
						}
					});
					sharingImage.onsuccess = function() {
						window.location.href = "#welcome";
					}
					sharingImage.onerror = function() {
						window.location.href = "#welcome";
					}
				}
			}
		);
		document.getElementById('btn_no').addEventListener("click",
			function() {
				window.location.href = "#welcome";
			}
		);
	}

	/**
	 * initFilter
	 * フィルターを初期化
	 */
	 
	this.initFilter = function() {
		// フィルタのフリック
		var $slide = this.Filter.$slide = document.getElementById('filter_slide'),
			winW = screen.width,
			transMax = (940-winW),//スクロール最大値
			transVal = -(351-(winW/2));//（フィルター無しまでの距離 - （windowサイズ/2）

		//$slide.flickSimple({snap: "first"});
		//$slide.flickSimple('move', -190, 0);

		$slide.childNodes[1].style.transition = '-webkit-transform 0.3s ease-out';
		$slide.childNodes[1].style.WebkitTransform = 'translate(' + transVal +'px, 0px)';
		$slide.childNodes[1].style.MozTransform = 'translate(' + transVal +'px, 0px)';

		if(window.navigator.userAgent.toLowerCase().match(/firefox/)){
			var transition = '-moz-transform';
			var transform = 'MozTransform';
		} else {
			var transition = '-webkit-transform';
			var transform = 'WebkitTransform';
		}

		var posX = "";
		var relX = "";
		var setX = "";
		var touchFlg = false;
		var touchmouveFlg = false;
		//var 
		//var tmpTime = 0;
		this.touchHandler = function(e){
			switch(e.type){
				case 'touchstart':
					touchFlg = true;
					posX = parseInt($slide.childNodes[1].style[transform].match(/translate\((.*|\-.*)px,/)[1]);

					var touches = e.changedTouches;
						var tlen = touches.length;
						for (var i=0; i < tlen; i++) {
							relX = touches[i].pageX;
						}
					break;
				case 'touchmove':
					touchmouveFlg = true;
					// Flick時の挙動
					if(touchFlg){
						e.preventDefault();
						var touches = e.changedTouches;
						var tlen = touches.length;
						for (var i=0; i < tlen; i++) {
							var deffX = touches[i].pageX - relX;
							setX = posX + deffX;
							$slide.childNodes[1].style.transition = 'none';
							$slide.childNodes[1].style.transform = 'translate('+ setX +'px, 0px)';
							$slide.childNodes[1].style.WebkitTransform = 'translate('+ setX +'px, 0px)';
						}
					}
					break;
				case 'touchend':
					$slide.childNodes[1].style.transition = transition+' 0.6s ease-out';
					if(setX > 0){
						$slide.childNodes[1].style.transform = 'translate(0px, 0px)';
						$slide.childNodes[1].style.WebkitTransform = 'translate(0px, 0px)';
					} else if( setX < -620){
						$slide.childNodes[1].style.transform = 'translate(-'+ transMax +'px, 0px)';
						$slide.childNodes[1].style.WebkitTransform = 'translate(-'+ transMax +'px, 0px)';
					} else {

					}
					touchFlg = false;
					touchmouveFlg = false;

					break;
				default:
					break;
			}
		}

		$slide.addEventListener('touchstart',this.touchHandler.bind(this));
		$slide.addEventListener('touchmove',this.touchHandler.bind(this));
		$slide.addEventListener('touchend',this.touchHandler.bind(this));

		var $items = this.Filter.$items = document.getElementsByClassName('filter_item');
		var cnt = $items.length;
		var $itemsArray = []
		for(var num=0;num<cnt;num++){
			$itemsArray[num] = $items[num];
		}

		// Filterのタッチイベント
		for(var num=0;num<cnt;num++){
			$items[num].addEventListener('click', function(e) {
				if(!touchmouveFlg){
					var $this = this;
					var i = $itemsArray.indexOf($this);

					//loader表示
					if($this.getAttribute('class') != 'filter_item selected'){
						loader.className = 'view';
					}

					// class削除
					var cnt = $items.length;
					for(var itnum=0;itnum<cnt;itnum++){
						var thisClassArr = $items[itnum].getAttribute('class').split(' ');
						delete thisClassArr[ thisClassArr.indexOf('selected') ];
						$items[itnum].className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
					}

					// class追加
					$this.className = $this.getAttribute('class') + ' selected';
					setTimeout(function(){
						that.PICTURE.setBlend(i);
					},1);
				}
			},false);
		}
	}

	/**
	 * initTool
	 * ツールバーを初期化
	 */
	this.initTool = function() {
		// ツールボックスを初期化
		that.initFrameTool();
		that.initRGBTool();
		that.initHSVTool();
		var $toolBox = document.getElementsByClassName('tool_box');
		var $toolBtn = document.getElementsByClassName('btn_tool');
		var $btnFrame = document.getElementById('btn_frame');

		var $toolBoxArray = [];
		var tbxcnt = $toolBox.length;
		for(var num=0;num<tbxcnt;num++){
			$toolBoxArray[num] = $toolBox[num];
		}

		var $toolBtnArray = [];
		var cnt = $toolBtn.length;
		for(var num=0;num<cnt;num++){

			$toolBtnArray[num] = $toolBtn[num];
			$toolBtn[num].addEventListener('touchend', function() {
				var $this   = this;
				
				var i = $toolBtnArray.indexOf($this);
				
				var $target = $toolBox[i];
				
				ga('send', 'event', 'edit', 'click', 'tool', num);
				if($this.getAttribute('class').match(/active/) ) {
					// class追加
					var thisClassArr = $target.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('active') ];
					$target.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
					
					// class削除
					var thisClassArr = $this.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('active') ];
					$this.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				} else {

					// class削除
					for(var tb=0;tb<tbxcnt;tb++){
						var thisClassArr = $toolBox[tb].getAttribute('class').split(' ');
						delete thisClassArr[ thisClassArr.indexOf('active') ];
						$toolBox[tb].className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
					}

					// class追加
					$target.className = $target.getAttribute('class') + ' active';

					// class削除
					for(var tb2=0;tb2<cnt;tb2++){
						var thisClassArr = $toolBtn[tb2].getAttribute('class').split(' ');
						delete thisClassArr[ thisClassArr.indexOf('active') ];
						$toolBtn[tb2].className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
					}

					// class追加
					$this.className = $this.getAttribute('class') + ' active';
				}
			});
		}

		document.addEventListener('touchend', function(e){


			var closeToolBox = function(){
				var cnt = $toolBtn.length;
				for(var num=0;num<cnt;num++){
					// class削除
					var $this = $toolBtn[num];
					var thisClassArr = $this.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('active') ];
					$this.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');

					$this = $toolBox[num];
					var thisClassArr = $this.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('active') ];
					$this.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				}
			}

			var reg = new RegExp(e.target.parentNode.innerHTML);

			var toolBoxes = document.getElementsByClassName('tool_box');
			var cnt = toolBoxes.length;
			for(var i=0;i<cnt;i++){
				var cns = toolBoxes[i].childNodes;
				var cnt2 = cns.length;

				for(var j=0;j<cnt2;j++){
					var cn = cns[j];
					if(typeof cn.innerHTML !== 'undefined'){
						if(cn.innerHTML.match(reg)){
							return;
						} else {
							if(e.target.getAttribute('class') !== null){
								var thisClassArr = e.target.getAttribute('class').split(' ');
								if( thisClassArr.indexOf('btn_tool') !== -1 ){
									return;
								}
							}
						}
					}
				}
			}
			closeToolBox();
			
		});
		
	}

	/**
	 * initToolValue
	 * ツールバーの値を初期化
	 */
	this.initToolValue = function() {
		that.RGBTool.$parts.red.value.textContent = 0;
		that.RGBTool.$parts.green.value.textContent = 0;
		that.RGBTool.$parts.blue.value.textContent = 0;
		that.HSVTool.$parts.brightness.value.textContent = 0;
		that.HSVTool.$parts.contrast.value.textContent = 0;
		that.Filter.$slide.childNodes[1].style.transition = '-webkit-transform 0.3s ease-out';
		that.Filter.$slide.childNodes[1].style.WebkitTransform = 'translate(-190px, 0px)';
		that.Filter.$slide.childNodes[1].style.MozTransform = 'translate(-190px, 0px)';

		// class削除
		var cnt = that.Filter.$items.length;
		for(var itnum=0;itnum<cnt;itnum++){
			var thisClassArr = that.Filter.$items[itnum].getAttribute('class').split(' ');
			delete thisClassArr[ thisClassArr.indexOf('selected') ];
			that.Filter.$items[itnum].className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
		}

		// class追加
		that.Filter.$items[4].className = that.Filter.$items[4].getAttribute('class') + ' selected';
	}

	// FrameToolBox ----------------------------------------

	/**
	 * initFrameTool
	 * フレームツールボックスを初期化
	 */

	this.initFrameTool = function() {
		var frames = {
			"btn_frame_null" : -1,
			"btn_frame_black":  0,
			"btn_frame_gray" :  1,
			"btn_frame_wood" :  2
		};

		for(var frame in frames) {
			(function(f) { // クロージャで渡さないとダメ
				document.getElementById(f).addEventListener('touchend', function() {
						that.PICTURE.setFlame(frames[f]);
				});
			})(frame);
		}
	}

	// RGBToolBox ----------------------------------------

	/**
	 * initRGBTool
	 * RGBツールボックスを初期化
	 */

	this.initRGBTool = function() {
		var $parts = this.RGBTool.$parts = {
			red: {
				value: document.getElementById("lbl_red_value"),
				minus: document.getElementById("btn_rgb_r_minus"),
				plus : document.getElementById("btn_rgb_r_plus"),
			},
			green: {
				value: document.getElementById("lbl_green_value"),
				minus: document.getElementById("btn_rgb_g_minus"),
				plus : document.getElementById("btn_rgb_g_plus"),
			},
			blue: {
				value: document.getElementById("lbl_blue_value"),
				minus: document.getElementById("btn_rgb_b_minus"),
				plus : document.getElementById("btn_rgb_b_plus"),
			}
		};

		// 値のリセット
		$parts.red.value.textContent = 0;
		$parts.green.value.textContent = 0;
		$parts.blue.value.textContent = 0;

		// 赤マイナスボタン
		$parts.red.minus.addEventListener('touchend', function(){
			if(btnFlag){
				btnFlag = false;
				var d = -5; // 増減値
				var val = that.PICTURE.setRgb("red", d);

				$parts.red.value.textContent = val;
				if (val == that.PICTURE.min_value.rgb) {
					// class追加
					var thisClass = $parts.red.minus.getAttribute('class');
					if(thisClass === null){
						$parts.red.minus.className = 'disabled';
					} else if(!thisClass.match(/disabled/)){
						$parts.red.minus.className = $parts.red.minus.getAttribute('class') + ' disabled';
					}
					btnFlag = true;
				} else if (val == that.PICTURE.max_value.rgb + d) {
					// class削除
					var thisClassArr = $parts.red.plus.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('disabled') ];
					$parts.red.plus.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				}
			}
		});

		// 赤プラスボタン
		$parts.red.plus.addEventListener('touchend', function() {
			if(btnFlag){
				btnFlag = false;
				var d = 5; // 増減値
				var val = that.PICTURE.setRgb("red", d);
				$parts.red.value.textContent = val;
				if (val == that.PICTURE.max_value.rgb) {
					// class追加
					var thisClass = $parts.red.plus.getAttribute('class');
					if(thisClass === null){
						$parts.red.plus.className = 'disabled';
					} else if(!thisClass.match(/disabled/)){
						$parts.red.plus.className = $parts.red.plus.getAttribute('class') + ' disabled';
					}
					btnFlag = true;
				} else if (val == that.PICTURE.min_value.rgb + d) {
					// class削除
					var thisClassArr = $parts.red.minus.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('disabled') ];
					$parts.red.minus.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				}
			}
		});

		// 緑マイナスボタン
		$parts.green.minus.addEventListener('touchend', function() {
			if(btnFlag){
				btnFlag = false;
				var d = -5; // 増減値
				var val = that.PICTURE.setRgb("green", d);
				$parts.green.value.textContent = val;
				if (val == that.PICTURE.min_value.rgb) {
					// class追加
					var thisClass = $parts.green.minus.getAttribute('class');
					if(thisClass === null){
						$parts.green.minus.className = 'disabled';
					} else if(!thisClass.match(/disabled/)){
						$parts.green.minus.className = $parts.green.minus.getAttribute('class') + ' disabled';
					}
					btnFlag = true;
				} else if (val == that.PICTURE.max_value.rgb + d) {
					// class削除
					var thisClassArr = $parts.green.plus.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('disabled') ];
					$parts.green.plus.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				}
			}
		});

		// 緑プラスボタン
		$parts.green.plus.addEventListener('touchend', function() {
			if(btnFlag){
				btnFlag = false;
				var d = 5; // 増減値
				var val = that.PICTURE.setRgb("green", d);
				$parts.green.value.textContent = val;
				if (val == that.PICTURE.max_value.rgb) {
					// class追加
					var thisClass = $parts.green.plus.getAttribute('class');
					if(thisClass === null){
						$parts.green.plus.className = 'disabled';
					} else if(!thisClass.match(/disabled/)){
						$parts.green.plus.className = $parts.green.plus.getAttribute('class') + ' disabled';
					}
					btnFlag = true;
				} else if (val == that.PICTURE.min_value.rgb + d) {
					// class削除
					var thisClassArr = $parts.green.minus.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('disabled') ];
					$parts.green.minus.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				}
			}
		});

		// 青マイナスボタン
		$parts.blue.minus.addEventListener('touchend', function() {
			if(btnFlag){
				btnFlag = false;
				var d = -5; // 増減値
				var val = that.PICTURE.setRgb("blue", d);
				$parts.blue.value.textContent = val;
				if (val == that.PICTURE.min_value.rgb) {
					// class追加
					var thisClass = $parts.blue.minus.getAttribute('class');
					if(thisClass === null){
						$parts.blue.minus.className = 'disabled';
					} else if(!thisClass.match(/disabled/)){
						$parts.blue.minus.className = $parts.blue.minus.getAttribute('class') + ' disabled';
					}
					btnFlag = true;
				} else if (val == that.PICTURE.max_value.rgb + d) {
					// class削除
					var thisClassArr = $parts.blue.plus.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('disabled') ];
					$parts.blue.plus.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				}
			}
		});

		// 青プラスボタン
		$parts.blue.plus.addEventListener('touchend', function() {
			if(btnFlag){
				btnFlag = false;
				var d = 5; // 増減値
				var val = that.PICTURE.setRgb("blue", d);
				$parts.blue.value.textContent = val;
				if (val == that.PICTURE.max_value.rgb) {
					// class追加
					var thisClass = $parts.blue.plus.getAttribute('class');
					if(thisClass === null){
						$parts.blue.plus.className = 'disabled';
					} else if(!thisClass.match(/disabled/)){
						$parts.blue.plus.className = $parts.blue.plus.getAttribute('class') + ' disabled';
					}
					btnFlag = true;
				} else if (val == that.PICTURE.min_value.rgb + d) {
					// class削除
					var thisClassArr = $parts.blue.minus.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('disabled') ];
					$parts.blue.minus.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				}
			}
		});
	}

	// HSVToolBox ----------------------------------------

	/**
	 * initHSVTool
	 * HSVツールボックスを初期化
	 */

	this.initHSVTool = function() {
		var $parts = this.HSVTool.$parts = {
			brightness: {
				value: document.getElementById("lbl_brightness_value"),
				minus: document.getElementById("btn_hsv_brightness_minus"),
				plus : document.getElementById("btn_hsv_brightness_plus")
			},
			contrast: {
				value: document.getElementById("lbl_contrast_value"),
				minus: document.getElementById("btn_hsv_contrast_minus"),
				plus : document.getElementById("btn_hsv_contrast_plus")
			}
		};

		$parts.brightness.value.textContent = 0;
		$parts.contrast.value.textContent = 0;

		// 明るさマイナスボタン
		$parts.brightness.minus.addEventListener('touchend', function() {
			if(btnFlag){
				btnFlag = false;
				var d = -5; // 増減値
				var val = that.PICTURE.setBrightness(d);
				$parts.brightness.value.textContent = val;
				if (val == that.PICTURE.min_value.brightness) {
					// class追加
					var thisClass = $parts.brightness.minus.getAttribute('class');
					if(thisClass === null){
						$parts.brightness.minus.className = 'disabled';
					} else if(!thisClass.match(/disabled/)){
						$parts.brightness.minus.className = $parts.brightness.minus.getAttribute('class') + ' disabled';
					}
					btnFlag = true;
				} else if (val == that.PICTURE.max_value.brightness + d) {
					// class削除
					var thisClassArr = $parts.brightness.plus.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('disabled') ];
					$parts.brightness.plus.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				}
			}
		});

		// 明るさプラスボタン
		$parts.brightness.plus.addEventListener('touchend', function() {
			if(btnFlag){
				btnFlag = false;
				var d = 5; // 増減値
				var val = that.PICTURE.setBrightness(d);
				$parts.brightness.value.textContent = val;
				if (val == that.PICTURE.max_value.brightness) {
					// class追加
					var thisClass = $parts.brightness.plus.getAttribute('class');
					if(thisClass === null){
						$parts.brightness.plus.className = 'disabled';
					} else if(!thisClass.match(/disabled/)){
						$parts.brightness.plus.className = $parts.brightness.plus.getAttribute('class') + ' disabled';
					}
					btnFlag = true;
				} else if (val == that.PICTURE.min_value.brightness + d) {
					// class削除
					var thisClassArr = $parts.brightness.minus.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('disabled') ];
					$parts.brightness.minus.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				}
			}
		});

		// コントラストマイナスボタン
		$parts.contrast.minus.addEventListener('touchend', function() {
			if(btnFlag){
				btnFlag = false;
				var d = -0.5; // 増減値
				var val = that.PICTURE.setContrast(d);
				$parts.contrast.value.textContent = val;
				if (val == that.PICTURE.min_value.contrast) {
					// class追加
					var thisClass = $parts.contrast.minus.getAttribute('class');
					if(thisClass === null){
						$parts.contrast.minus.className = 'disabled';
					} else if(!thisClass.match(/disabled/)){
						$parts.contrast.minus.className = $parts.contrast.minus.getAttribute('class') + ' disabled';
					}
					btnFlag = true;
				} else if (val == that.PICTURE.max_value.contrast + d) {
					// class削除
					var thisClassArr = $parts.contrast.plus.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('disabled') ];
					$parts.contrast.plus.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				}
			}
		});

		// コントラストプラスボタン
		$parts.contrast.plus.addEventListener('touchend', function() {
			if(btnFlag){
				btnFlag = false;
				var d = 0.5; // 増減値
				var val = that.PICTURE.setContrast(d);
				$parts.contrast.value.textContent = val;
				if (val == that.PICTURE.max_value.contrast) {
					// class追加
					var thisClass = $parts.contrast.plus.getAttribute('class');
					if(thisClass === null){
						$parts.contrast.plus.className = 'disabled';
					} else if(!thisClass.match(/disabled/)){
						$parts.contrast.plus.className = $parts.contrast.plus.getAttribute('class') + ' disabled';
					}
					btnFlag = true;
				} else if (val == that.PICTURE.min_value.contrast + d) {
					// class削除
					var thisClassArr = $parts.contrast.minus.getAttribute('class').split(' ');
					delete thisClassArr[ thisClassArr.indexOf('disabled') ];
					$parts.contrast.minus.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');
				}
			}
		});
	}

	this.initialize();
	return this;
}
