/**********************
 *
 *  CLASS : _PICTURE
 *
 */

var _PICTURE = function() {
	var that = this;

	// 合成画像モジュール
	this.BLEND;
	this.FRAME;

	// canvas要素
	this.canvas;

	// フィルタの値
	this.blend_idx;
	this.frame_idx;
	this.contrast;
	this.brightness;

	// RGB値
	this.rgb = {
		red   : 0,
		green : 0,
		blue  : 0
	};

	// canvasのサイズ
	this.canvasSize = {
		width  : 320,
		height : 320
	};

	// 限界値(MAX)
	this.max_value = {
		contrast   : 3.0,
		brightness : 140,
		rgb        : 100
	};

	// 限界値(MIN)
	this.min_value = {
		contrast   : -0.5,
		brightness : -140,
		rgb        : -100
	};

	/**
	 * initialize
	 * 初期化
	 */
	this.initialize = function() {
		this.FRAME   = new _FRAME();
		this.BLEND   = new _BLEND();
		this.canvas  = this.getCanvas();
		this.blend_idx  = -1;
		this.frame_idx  = -1;
		this.contrast   =  0;
		this.brightness =  0;
	};

	this.getCanvas = function() {
		this.canvas = document.getElementById('canvas');
		return this.canvas;
	};

	this.clearFilter = function() {
		this.blend_idx    = -1;
		this.frame_idx    = -1;
		this.contrast     =  0;
		this.brightness   =  0;
		this.rgb["red"]   =  0;
		this.rgb["green"] =  0;
		this.rgb["blue"]  =  0;
	};

	this.reset = function() {
		Pixastic.revert(this.getCanvas());
		this.clearFilter();
		var parentNode = this.getCanvas().parentNode;
		var newCanvas  = document.createElement('canvas');
		newCanvas.width  = this.canvasSize.width;
		newCanvas.height = this.canvasSize.height;
		newCanvas.id     = this.canvas.id;
		parentNode.appendChild(newCanvas);
		parentNode.removeChild(this.canvas);
		this.canvas = newCanvas;
	};

	this.base64toBlob = function(_base64) {
		var i;
		var tmp = _base64.split(',');
		var data = atob(tmp[1]);
		var mime = tmp[0].split(':')[1].split(';')[0];
		//var buff = new ArrayBuffer(data.length);
		//var arr = new Uint8Array(buff);
		var arr = new Uint8Array(data.length);
		for (i = 0; i < data.length; i++) {arr[i] = data.charCodeAt(i);}
		var blob = new Blob([arr], { type: mime });
		return blob;
	};

	/**
	 * カメラまたはギャラリーから指定した画像を設定します。
	 * imgタグのsrc属性に指定可能なもの（パスまたはBolb）
	 *
	 */
	this.setImage = function(image) {
		var img = new Image();
		img.onload = function() {
			var edge = (this.width < this.height) ? this.width : this.height;
			that.getCanvas().getContext('2d').drawImage(this, 0, 0, edge, edge,
					0, 0, that.canvasSize.width, that.canvasSize.height);
			Pixastic.process(that.getCanvas(), "coloradjust", {red:0,green:0,blue:0});
		};
		img.src = image;
	};

	/**
	 * plot
	 * 描く、描こう、描かねば。
	 */

	this.plot = function() {
		// 一旦戻す
		Pixastic.revert(this.getCanvas());

		var img = that.originalImage;
		var canvasTmp = document.getElementById('canvasTmp');

		var callbackFlag = function (){
			loader.className = '';
			btnFlag = true;
		}

		// フィルタ合成
		if (that.blend_idx != -1) {
			var fil = that.BLEND.getFilter(that.blend_idx).filter;

			//ローディングが固まる
			for (var i = 0; i < fil.length; i++) {
				if ("blend" == fil[i].type) {
					Pixastic.process(this.getCanvas(), "blend",
						{ amount: fil[i].amount, mode: fil[i].mode, image: fil[i].image });
				} else if ("level" == fil[i].type) {
					Pixastic.process(this.getCanvas(), "brightness",
							{ brightness: fil[i].brightness, contrast: fil[i].contrast });
				}
			}
		} 

		// 明るさ／コントラスト処理
		var option = {
			brightness : that.brightness,
			contrast   : that.contrast
		};
		Pixastic.process(this.getCanvas(), "brightness", option);

		// RGB処理
		var option = {
			red   : that.rgb["red"]   / 100,
			green : that.rgb["green"] / 100,
			blue  : that.rgb["blue"]  / 100
		};
		Pixastic.process(this.getCanvas(), "coloradjust", option);

		// フレーム処理
		if (that.frame_idx != -1) {
			var frame = that.FRAME.getFrame(that.frame_idx);
			// TODO: 単純合成であればPixasticでなくCanvas#drawImageのほうが早い
			Pixastic.process(this.getCanvas(), "blend",
					{ amount: 1, mode: "normal", image: frame });
		}
		setTimeout(callbackFlag,1);
	};


	/**
	 * フレーム合成
	 */
	this.setFlame = function(idx) {
		ga('send', 'event', 'edit', 'set', 'filter', idx);
		that.frame_idx = idx;
		that.plot();
		return that.frame_idx;
	};

	/**
	 * 写真合成
	 */
	this.setBlend = function(idx) {
		ga('send', 'event', 'edit', 'set', 'blend', idx);
		that.blend_idx = idx;
		that.plot();
		return that.blend_idx;
	};

	/**
	 * RGB補正
	 */
	 this.setRgb = function(colorCode, value) {
		ga('send', 'event', 'edit', 'set', 'rgb', value);
	 	var val = that.rgb[colorCode];
	 	// 仮計算
	 	val = val + value;
	 	if (val >= that.min_value.rgb && val <= that.max_value.rgb) {
	 		// 限界値に達してないので処理継続
	 		that.rgb[colorCode] = val;
			that.plot();
		}
		return that.rgb[colorCode];
	};

	/**
	 * 明るさ
	 */
	this.setBrightness = function(value) {
		ga('send', 'event', 'edit', 'set', 'brightness', value);
	 	var val = that.brightness;
	 	// 仮計算
	 	val = val + value;
	 	if (val >= that.min_value.brightness && val <= that.max_value.brightness) {
	 		// 限界値に達してないので処理継続
	 		that.brightness = val;
			that.plot();
		}
		return that.brightness;
	};

	/**
	 * コントラスト
	 */
	this.setContrast = function(value) {
		ga('send', 'event', 'edit', 'set', 'contrast', value);
	 	var val = that.contrast;
	 	// 仮計算
	 	val = val + value;
	 	if (val >= that.min_value.contrast && val <= that.max_value.contrast) {
	 		// 限界値に達してないので処理継続
	 		that.contrast = val;
			that.plot();
		}
		return that.contrast;
	};

	/**
	 * 保存
	 */
	this.save = function(success, error) {
		Pixastic.process(this.getCanvas(), "crop", {
			left: 0, top: 0,
			width: this.canvasSize.width,
			height: this.canvasSize.height
		});
		var base64 = this.getCanvas().toDataURL();
		var blobs = this.base64toBlob(base64);
			this.blob  = this.base64toBlob(base64);
		var deviceStorage = navigator.getDeviceStorage('pictures');
		var fileName = 'cameran_' + new Date().getTime() + '.png';
		var req = deviceStorage.addNamed(blobs, fileName);
		req.onsuccess = function() {
			if($.isFunction(success)) {
				success.apply(this, arguments);
			}
		};
		req.onerror = function(event) {
			alert(req.error.name);
			if($.isFunction(error)) {
				error.apply(this, arguments);
			}
		};
	};
	this.initialize();
	return this;
}