/**
 * ルータ
 */
var _ROUTER = function() {
	var that = this;

	this.$pages = document.getElementsByClassName('page');
	this.routes = {
		"#welcome": document.getElementById('welcome'),
		"#terms"  : document.getElementById('terms'),
		"#edit"   : document.getElementById('edit'),
		"#confirm": document.getElementById('confirm')
	};

	this.$current = this.routes[""] = this.routes["#welcome"];

	this.change = function() {
		var hash = location.hash;

		ga('send', 'pageview', hash.replace('#', '/'));

		if(that.routes[hash]) {
			var $next = that.routes[hash];

			// class削除
			var thisClassArr = that.$current.getAttribute('class').split(' ');
			delete thisClassArr[ thisClassArr.indexOf('current') ];
			that.$current.className = thisClassArr.join(' ').replace(/^\s+|\s+$/,'');

			// class追加
			var thisClass = $next.getAttribute('class');
			if(thisClass === null){
				$next.className = 'current';
			} else if(!thisClass.match(/current/)){
				$next.className = $next.getAttribute('class') + ' current';
			}

			that.$current = $next;
			document.body.scrollLeft = 0;
			document.body.scrollTop  = 0;
		}
	};

	this.change();
	window.onhashchange = this.change;

	return this;
}
