Game = {};
Game.Load = function (game) { };

var level = 0;
var starsArray;
var kills;
var music;
var soundHit;
var soundJump;
var isMusicOn;
var musicInit;
var minButtonPressDelayMillis = 500;
var lastButtonPressDate;
var preloadBar;

loadStarsArray();

function loadStarsArray() {
    // If first run -> init
    if(localStorage['starsArray'] == undefined) {
        starsArray = Array.apply(null, new Array(levelsTotal)).map(Number.prototype.valueOf, 4);
        starsArray[0] =  0;
        saveStarsArray();
    }
    else {
        starsArray = JSON.parse(localStorage['starsArray']);
    }
    
    // Expand array if too short
    if(starsArray.length < levelsTotal) {
       starsArray = starsArray.concat(Array.apply(null, new Array(levelsTotal - starsArray.length)).map(Number.prototype.valueOf, 4));
       saveStarsArray();
    }
    

}

function saveStarsArray() {
    localStorage['starsArray'] = JSON.stringify(starsArray);
}
 

function initMusic() {
    isMusicOn = localStorage["musicOn"] == undefined || localStorage["musicOn"] == "true" ? true : false;

    if(!isCordovaApp) {

         // Music
        music = game.add.audio('music');

        music.onDecoded.addOnce(function() {
            console.log("Backgrond music decoded.")
             music.play('', 0, 0.1, true);
        }, this);

        music.onPlay.addOnce(function() {
            console.log("Background music playback started.")
          if(!isMusicOn) {
              console.log("Music turned off!");
               music.pause();
          }

        }, this);
    }
    else {
        if(!isMusicOn) {
              console.log("Music turned off!");
              music.pause();
        }
        else {
             console.log("Background music playback started.")
             music.play();
        }

    }
}
    

// going fullscreen
function goFullScreen(){
	game.scale.pageAlignHorizontally = true;
	game.scale.pageAlignVertically = true;
	game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
	game.scale.setScreenSize(true);
}

function setBackground() {
    background = game.add.sprite(0, 0, 'background');
    background.scale.x = game.world.width / game.cache.getImage('background').width;
    background.scale.y =  game.world.height / game.cache.getImage('background').height;
}

function retryLevel() {
    game.state.start('Play');
}

function menuClicked() {
    game.state.start('Main');
}

function buttonClickTimeoutExpired() {
    return !(lastButtonPressDate != undefined &&
       new Date().getTime() - lastButtonPressDate.getTime() < minButtonPressDelayMillis);
}

function preload() {
  console.log("Screen: " + game.world.width + "x" + game.world.height);
  console.log("Total levels: " + levelsTotal);    
    
  game.load.image('background', 'assets/images/candyland.png');
  groundAsset = game.load.image('ground', 'assets/images/ground.png');
  game.load.image('pipe', 'assets/images/pipe.png');
  game.load.image('actor', 'assets/images/color_wheel.png');
  game.load.image('pixel', 'assets/images/color_pixel.png');
  game.load.image('logo', 'assets/images/logo.png');
  game.load.image('playButton', 'assets/images/play_button.png');
  game.load.image('menuButton', 'assets/images/menu_button.png');
  game.load.image('nextButton', 'assets/images/next_button.png');
  game.load.image('helpButton', 'assets/images/help_button.png');
  game.load.image('infoButton', 'assets/images/info_button.png');
  game.load.image('retryButton', 'assets/images/retry_button.png');
  game.load.image('audioOnButton', 'assets/images/audio_on_button.png');
  game.load.image('audioOffButton', 'assets/images/audio_off_button.png');
  game.load.spritesheet('candy_cane', 'assets/images/candy_cane.png', 64, 124);
    
  game.load.spritesheet("levels", "assets/images/levels.png", 64, 64);
  game.load.spritesheet("level_arrows", "assets/images/level_arrows.png", 48, 48);
            
  /*
    Phaser sound loading will not work in Cordova,
    so skip it if this is running on Cordava.
  */
  if(!isCordovaApp) {
      game.load.audio('hit', ['assets/sounds/hit_2.mp3', 'hit_2.ogg']);
      game.load.audio('jump', ['assets/sounds/jump_2.mp3', 'jump_2.ogg']);
      game.load.audio('music', ['assets/sounds/puzzle-game-5.ogg']);
  }
  else {
    /* Ugly cordova loop: http://ilee.co.uk/looping-audio-with-phonegap/ */
    music = new Media("file:///android_asset/www/assets/sounds/puzzle-game-5.mp3", null, null, function(status) {
                        if (status === Media.MEDIA_STOPPED) {
                            music.play();
                        }
            });
    soundHit = new Media("file:///android_asset/www/assets/sounds/hit_2.mp3");
    soundJump = new Media("file:///android_asset/www/assets/sounds/jump_2.mp3");
  }
  

  // Progress bar
  preloadBar = game.add.graphics(0, 50);
  preloadBar.lineStyle(3, 0xffffff, 1);
  preloadBar.moveTo(0, 0);
  preloadBar.lineTo(game.width, 0);
    
  preloadBar.scale.x = 0; // set the bar to the beginning position

}

function create() {
  initMusic();
  game.state.start('Splash');
}

function loadUpdate() {
  // every frame during loading, set the scale.x of the bar to the progress (an integer between 0
  // and 100) divided by 100 to give a float between 0 and 1
  preloadBar.scale.x = game.load.progress * 0.01;
}

Game.Load.prototype.preload = preload;
Game.Load.prototype.create = create;
Game.Load.prototype.loadUpdate = loadUpdate;
